/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text;

import com.ibm.icu.text.Bidi;
import java.util.Objects;
import yslelf.cloudpick.graphics.annotation.IntRange;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.text.ShapedText;
import yslelf.cloudpick.graphics.text.MeasuredParagraph;
import yslelf.cloudpick.graphics.text.Spanned;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristic;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristics;
import yslelf.cloudpick.graphics.text.TextLine;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.TextUtils;

public class TextShaper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shapeText(@NonNull CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int count, @NonNull TextDirectionHeuristic dir, @NonNull TextPaint paint, @NonNull GlyphsConsumer consumer) {
        Objects.requireNonNull(text);
        if (!(text instanceof Spanned)) {
            consumer.accept(start, count, TextShaper.shapeText(text, start, count, dir, paint), paint, 0.0f, 0.0f);
            return;
        }
        MeasuredParagraph mp = MeasuredParagraph.buildForBidi(text, start, start + count, dir, null);
        TextLine tl = TextLine.obtain();
        try {
            tl.set(paint, text, start, start + count, mp.getParagraphDir(), mp.getDirections(0, count), false, null, -1, -1);
            tl.shape(consumer);
        }
        finally {
            tl.recycle();
            mp.recycle();
        }
    }

    @NonNull
    public static ShapedText shapeText(@NonNull char[] text, @IntRange(from=0L) int start, @IntRange(from=0L) int count, @NonNull TextDirectionHeuristic dir, @NonNull TextPaint paint) {
        int bidiFlags;
        Objects.requireNonNull(dir);
        Objects.checkFromIndexSize(start, count, text.length);
        if (!(dir != TextDirectionHeuristics.LTR && dir != TextDirectionHeuristics.FIRSTSTRONG_LTR && dir != TextDirectionHeuristics.ANYRTL_LTR || Bidi.requiresBidi((char[])text, (int)start, (int)(start + count)))) {
            bidiFlags = 4;
        } else if (dir == TextDirectionHeuristics.LTR) {
            bidiFlags = 0;
        } else if (dir == TextDirectionHeuristics.RTL) {
            bidiFlags = 1;
        } else if (dir == TextDirectionHeuristics.FIRSTSTRONG_LTR) {
            bidiFlags = 2;
        } else if (dir == TextDirectionHeuristics.FIRSTSTRONG_RTL) {
            bidiFlags = 3;
        } else {
            boolean isRtl = dir.isRtl(text, start, start + count);
            int n2 = bidiFlags = isRtl ? 1 : 0;
        }
        if (bidiFlags == 4 || start == 0 && count == text.length) {
            return new ShapedText(text, start, start + count, start, start + count, bidiFlags, paint.getInternalPaint());
        }
        char[] para = new char[count];
        System.arraycopy(text, start, para, 0, count);
        return new ShapedText(para, 0, count, 0, count, bidiFlags, paint.getInternalPaint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ShapedText shapeText(@NonNull CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int count, @NonNull TextDirectionHeuristic dir, @NonNull TextPaint paint) {
        Objects.checkFromIndexSize(start, count, text.length());
        boolean mayTemp = dir == TextDirectionHeuristics.LTR || dir == TextDirectionHeuristics.FIRSTSTRONG_LTR || dir == TextDirectionHeuristics.ANYRTL_LTR;
        char[] buf = mayTemp ? TextUtils.obtain(count) : new char[count];
        try {
            TextUtils.getChars(text, start, start + count, buf, 0);
            ShapedText shapedText = TextShaper.shapeText(buf, 0, count, dir, paint);
            return shapedText;
        }
        finally {
            if (mayTemp) {
                TextUtils.recycle(buf);
            }
        }
    }

    @NonNull
    public static ShapedText shapeTextRun(@NonNull char[] text, @IntRange(from=0L) int start, @IntRange(from=0L) int count, int contextStart, int contextCount, boolean isRtl, @NonNull TextPaint paint) {
        int bidiFlags = isRtl ? 5 : 4;
        return new ShapedText(text, contextStart, contextStart + contextCount, start, start + count, bidiFlags, paint.getInternalPaint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ShapedText shapeTextRun(@NonNull CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int count, int contextStart, int contextCount, boolean isRtl, @NonNull TextPaint paint) {
        Objects.checkFromIndexSize(contextStart, contextCount, text.length());
        char[] buf = TextUtils.obtain(contextCount);
        try {
            TextUtils.getChars(text, contextStart, contextStart + contextCount, buf, 0);
            ShapedText shapedText = TextShaper.shapeTextRun(buf, start - contextStart, count, 0, contextCount, isRtl, paint);
            return shapedText;
        }
        finally {
            TextUtils.recycle(buf);
        }
    }

    private TextShaper() {
    }

    public static interface GlyphsConsumer {
        public void accept(@IntRange(from=0L) int var1, @IntRange(from=0L) int var2, @NonNull ShapedText var3, @NonNull TextPaint var4, float var5, float var6);
    }
}

