/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.Immutable;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.text.FontCollection;
import yslelf.cloudpick.graphics.graphics.text.FontFamily;

@Immutable
public class Typeface
extends FontCollection {
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    public static final Typeface MONOSPACED;
    private static final ConcurrentHashMap<String, Typeface> sSystemFontMap;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;

    @NonNull
    public static Typeface createTypeface(FontFamily ... families) {
        if (families.length == 0) {
            return SANS_SERIF;
        }
        return new Typeface(families);
    }

    @NonNull
    public static Typeface getSystemFont(@NonNull String familyName) {
        Typeface typeface = sSystemFontMap.get(familyName);
        if (typeface != null) {
            return typeface;
        }
        String name = FontFamily.getSystemFontAliases().getOrDefault(familyName, familyName);
        FontFamily family = FontFamily.getSystemFontMap().get(name);
        if (family != null) {
            Typeface newTypeface = Typeface.createTypeface(family);
            return Objects.requireNonNullElse(sSystemFontMap.putIfAbsent(name, newTypeface), newTypeface);
        }
        return SANS_SERIF;
    }

    private Typeface(FontFamily ... families) {
        super(families);
    }

    static {
        ConcurrentHashMap<String, Typeface> map = new ConcurrentHashMap<String, Typeface>();
        for (Map.Entry<String, FontFamily> entry : FontFamily.getSystemFontMap().entrySet()) {
            map.putIfAbsent(entry.getKey(), Typeface.createTypeface(entry.getValue()));
        }
        SANS_SERIF = Objects.requireNonNull((Typeface)map.get("SansSerif"));
        SERIF = Objects.requireNonNull((Typeface)map.get("Serif"));
        MONOSPACED = Objects.requireNonNull((Typeface)map.get("Monospaced"));
        sSystemFontMap = map;
    }
}

