/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text.method;

import java.util.List;
import yslelf.cloudpick.graphics.text.Layout;
import yslelf.cloudpick.graphics.text.NoCopySpan;
import yslelf.cloudpick.graphics.text.Selection;
import yslelf.cloudpick.graphics.text.Spannable;
import yslelf.cloudpick.graphics.text.method.MovementMethod;
import yslelf.cloudpick.graphics.text.method.ScrollingMovementMethod;
import yslelf.cloudpick.graphics.text.style.ClickableSpan;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.widget.TextView;

public class LinkMovementMethod
extends ScrollingMovementMethod {
    private static final int CLICK = 1;
    private static final int UP = 2;
    private static final int DOWN = 3;
    private static final int HIDE_FLOATING_TOOLBAR_DELAY_MS = 200;
    private static LinkMovementMethod sInstance;
    private static final Object FROM_BELOW;

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new LinkMovementMethod();
        }
        return sInstance;
    }

    @Override
    public boolean canSelectArbitrarily() {
        return true;
    }

    @Override
    protected boolean up(TextView widget, Spannable buffer) {
        if (this.action(2, widget, buffer)) {
            return true;
        }
        return super.up(widget, buffer);
    }

    @Override
    protected boolean down(TextView widget, Spannable buffer) {
        if (this.action(3, widget, buffer)) {
            return true;
        }
        return super.down(widget, buffer);
    }

    @Override
    protected boolean left(TextView widget, Spannable buffer) {
        if (this.action(2, widget, buffer)) {
            return true;
        }
        return super.left(widget, buffer);
    }

    @Override
    protected boolean right(TextView widget, Spannable buffer) {
        if (this.action(3, widget, buffer)) {
            return true;
        }
        return super.right(widget, buffer);
    }

    private boolean action(int what, TextView widget, Spannable buffer) {
        Layout layout = widget.getLayout();
        int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
        int areaTop = widget.getScrollY();
        int areaBot = areaTop + widget.getHeight() - padding;
        int lineTop = layout.getLineForVertical(areaTop);
        int lineBot = layout.getLineForVertical(areaBot);
        int first = layout.getLineStart(lineTop);
        int last = layout.getLineEnd(lineBot);
        List<ClickableSpan> candidates = buffer.getSpans(first, last, ClickableSpan.class);
        int a = Selection.getSelectionStart(buffer);
        int b = Selection.getSelectionEnd(buffer);
        int selStart = Math.min(a, b);
        int selEnd = Math.max(a, b);
        if (selStart < 0 && buffer.getSpanStart(FROM_BELOW) >= 0) {
            selStart = selEnd = buffer.length();
        }
        if (selStart > last) {
            selEnd = Integer.MAX_VALUE;
            selStart = Integer.MAX_VALUE;
        }
        if (selEnd < first) {
            selEnd = -1;
            selStart = -1;
        }
        switch (what) {
            case 1: {
                if (selStart == selEnd) {
                    return false;
                }
                List<ClickableSpan> links = buffer.getSpans(selStart, selEnd, ClickableSpan.class);
                if (links.size() != 1) {
                    return false;
                }
                ClickableSpan link = links.get(0);
                link.onClick(widget);
                break;
            }
            case 2: {
                int bestStart = -1;
                int bestEnd = -1;
                for (ClickableSpan candidate : candidates) {
                    int end = buffer.getSpanEnd(candidate);
                    if (end >= selEnd && selStart != selEnd || end <= bestEnd) continue;
                    bestStart = buffer.getSpanStart(candidate);
                    bestEnd = end;
                }
                if (bestStart < 0) break;
                Selection.setSelection(buffer, bestEnd, bestStart);
                return true;
            }
            case 3: {
                int bestStart = Integer.MAX_VALUE;
                int bestEnd = Integer.MAX_VALUE;
                for (ClickableSpan candidate : candidates) {
                    int start = buffer.getSpanStart(candidate);
                    if (start <= selStart && selStart != selEnd || start >= bestStart) continue;
                    bestStart = start;
                    bestEnd = buffer.getSpanEnd(candidate);
                }
                if (bestEnd >= Integer.MAX_VALUE) break;
                Selection.setSelection(buffer, bestStart, bestEnd);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int action = event.getAction();
        if (action == 1 || action == 0) {
            int line;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout = widget.getLayout();
            int off = layout.getOffsetForHorizontal(line = layout.getLineForVertical(y += widget.getScrollY()), x += widget.getScrollX());
            List<ClickableSpan> links = buffer.getSpans(off, off, ClickableSpan.class);
            if (!links.isEmpty()) {
                ClickableSpan link = links.get(0);
                if (action == 1) {
                    link.onClick(widget);
                } else {
                    Selection.setSelection(buffer, buffer.getSpanStart(link), buffer.getSpanEnd(link));
                }
                return true;
            }
            Selection.removeSelection(buffer);
        }
        return super.onTouchEvent(widget, buffer, event);
    }

    @Override
    public void initialize(TextView widget, Spannable text) {
        Selection.removeSelection(text);
        text.removeSpan(FROM_BELOW);
    }

    @Override
    public void onTakeFocus(TextView view, Spannable text, int dir) {
        Selection.removeSelection(text);
        if ((dir & 1) != 0) {
            text.setSpan(FROM_BELOW, 0, 0, 34);
        } else {
            text.removeSpan(FROM_BELOW);
        }
    }

    static {
        FROM_BELOW = new NoCopySpan.Concrete();
    }
}

