/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text.method;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.text.Editable;
import yslelf.cloudpick.graphics.text.GetChars;
import yslelf.cloudpick.graphics.text.Spannable;
import yslelf.cloudpick.graphics.text.Spanned;
import yslelf.cloudpick.graphics.text.SpannedString;
import yslelf.cloudpick.graphics.text.TextUtils;
import yslelf.cloudpick.graphics.text.method.TransformationMethod;
import yslelf.cloudpick.graphics.view.View;

public abstract class ReplacementTransformationMethod
implements TransformationMethod {
    protected ReplacementTransformationMethod() {
    }

    protected abstract char[] getOriginal();

    protected abstract char[] getReplacement();

    @Override
    @Nonnull
    public CharSequence getTransformation(@Nonnull CharSequence source, @Nonnull View v) {
        char[] original = this.getOriginal();
        char[] replacement = this.getReplacement();
        if (!(source instanceof Editable)) {
            boolean doNothing = true;
            for (char c : original) {
                if (TextUtils.indexOf(source, c) < 0) continue;
                doNothing = false;
                break;
            }
            if (doNothing) {
                return source;
            }
            if (!(source instanceof Spannable)) {
                if (source instanceof Spanned) {
                    return new SpannedString(new SpannedReplacementCharSequence((Spanned)source, original, replacement));
                }
                return new ReplacementCharSequence(source, original, replacement).toString();
            }
        }
        return new SpannedReplacementCharSequence((Spanned)source, original, replacement);
    }

    @Override
    public void onFocusChanged(@Nonnull View view, @Nonnull CharSequence sourceText, boolean focused, int direction, @Nullable Rect previouslyFocusedRect) {
    }

    private static class SpannedReplacementCharSequence
    extends ReplacementCharSequence
    implements Spanned {
        private final Spanned mSpanned;

        public SpannedReplacementCharSequence(Spanned source, char[] original, char[] replacement) {
            super(source, original, replacement);
            this.mSpanned = source;
        }

        @Override
        @Nonnull
        public CharSequence subSequence(int start, int end) {
            return new SpannedString(this).subSequence(start, end);
        }

        @Override
        @Nonnull
        public <T> List<T> getSpans(int start, int end, Class<? extends T> type, @Nullable List<T> out) {
            return this.mSpanned.getSpans(start, end, type, out);
        }

        @Override
        public int getSpanStart(@Nonnull Object tag) {
            return this.mSpanned.getSpanStart(tag);
        }

        @Override
        public int getSpanEnd(@Nonnull Object tag) {
            return this.mSpanned.getSpanEnd(tag);
        }

        @Override
        public int getSpanFlags(@Nonnull Object tag) {
            return this.mSpanned.getSpanFlags(tag);
        }

        @Override
        public int nextSpanTransition(int start, int end, Class<?> type) {
            return this.mSpanned.nextSpanTransition(start, end, type);
        }
    }

    private static class ReplacementCharSequence
    implements CharSequence,
    GetChars {
        private final CharSequence mSource;
        private final char[] mOriginal;
        private final char[] mReplacement;

        public ReplacementCharSequence(CharSequence source, char[] original, char[] replacement) {
            this.mSource = source;
            this.mOriginal = original;
            this.mReplacement = replacement;
        }

        @Override
        public int length() {
            return this.mSource.length();
        }

        @Override
        public char charAt(int i) {
            char c = this.mSource.charAt(i);
            int n2 = this.mOriginal.length;
            for (int j = 0; j < n2; ++j) {
                if (c != this.mOriginal[j]) continue;
                c = this.mReplacement[j];
            }
            return c;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            char[] c = new char[end - start];
            this.getChars(start, end, c, 0);
            return new String(c);
        }

        @Override
        public String toString() {
            char[] c = new char[this.length()];
            this.getChars(0, this.length(), c, 0);
            return new String(c);
        }

        @Override
        public void getChars(int start, int end, char[] dest, int off) {
            TextUtils.getChars(this.mSource, start, end, dest, off);
            int offend = end - start + off;
            int n2 = this.mOriginal.length;
            for (int i = off; i < offend; ++i) {
                char c = dest[i];
                for (int j = 0; j < n2; ++j) {
                    if (c != this.mOriginal[j]) continue;
                    dest[i] = this.mReplacement[j];
                }
            }
        }
    }
}

