/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text.method;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import yslelf.cloudpick.graphics.text.Layout;
import yslelf.cloudpick.graphics.text.NoCopySpan;
import yslelf.cloudpick.graphics.text.Spannable;
import yslelf.cloudpick.graphics.text.method.TextKeyListener;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.view.ViewConfiguration;
import yslelf.cloudpick.graphics.widget.TextView;

@ParametersAreNonnullByDefault
public class Touch {
    private Touch() {
    }

    public static void scrollTo(TextView widget, Layout layout, int x, int y) {
        int actualWidth;
        int right;
        int left;
        boolean ltr;
        int horizontalPadding = widget.getTotalPaddingLeft() + widget.getTotalPaddingRight();
        int availableWidth = widget.getWidth() - horizontalPadding;
        int top = layout.getLineForVertical(y);
        Layout.Alignment a = layout.getParagraphAlignment(top);
        boolean bl = ltr = layout.getParagraphDirection(top) > 0;
        if (widget.isHorizontallyScrollable()) {
            int verticalPadding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
            int bottom = layout.getLineForVertical(y + widget.getHeight() - verticalPadding);
            left = Integer.MAX_VALUE;
            right = 0;
            for (int i = top; i <= bottom; ++i) {
                left = (int)Math.min((float)left, layout.getLineLeft(i));
                right = (int)Math.max((float)right, layout.getLineRight(i));
            }
        } else {
            left = 0;
            right = availableWidth;
        }
        if ((actualWidth = right - left) < availableWidth) {
            x = a == Layout.Alignment.ALIGN_CENTER ? left - (availableWidth - actualWidth) / 2 : (ltr && a == Layout.Alignment.ALIGN_OPPOSITE || !ltr && a == Layout.Alignment.ALIGN_NORMAL || a == Layout.Alignment.ALIGN_RIGHT ? left - (availableWidth - actualWidth) : left);
        } else {
            x = Math.min(x, right - availableWidth);
            x = Math.max(x, left);
        }
        widget.scrollTo(x, y);
    }

    public static boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                List<DragState> ds = buffer.getSpans(0, buffer.length(), DragState.class);
                for (DragState d2 : ds) {
                    buffer.removeSpan(d2);
                }
                buffer.setSpan(new DragState(event.getX(), event.getY(), widget.getScrollX(), widget.getScrollY()), 0, 0, 17);
                return true;
            }
            case 1: {
                List<DragState> ds = buffer.getSpans(0, buffer.length(), DragState.class);
                for (DragState d3 : ds) {
                    buffer.removeSpan(d3);
                }
                return !ds.isEmpty() && ds.get((int)0).mUsed;
            }
            case 2: {
                float dy;
                float dx;
                boolean cap;
                List<DragState> ds = buffer.getSpans(0, buffer.length(), DragState.class);
                if (ds.isEmpty()) break;
                if (!ds.get((int)0).mFarEnough) {
                    int slop = ViewConfiguration.get(widget.getContext()).getScaledTouchSlop();
                    if (Math.abs(event.getX() - ds.get((int)0).mX) >= (float)slop || Math.abs(event.getY() - ds.get((int)0).mY) >= (float)slop) {
                        ds.get((int)0).mFarEnough = true;
                    }
                }
                if (!ds.get((int)0).mFarEnough) break;
                ds.get((int)0).mUsed = true;
                boolean bl = cap = event.isShiftPressed() || event.isButtonPressed(1) || TextKeyListener.getMetaState(buffer, 1) == 1;
                if (cap) {
                    dx = event.getX() - ds.get((int)0).mX;
                    dy = event.getY() - ds.get((int)0).mY;
                } else {
                    dx = ds.get((int)0).mX - event.getX();
                    dy = ds.get((int)0).mY - event.getY();
                }
                ds.get((int)0).mX = event.getX();
                ds.get((int)0).mY = event.getY();
                int nx = widget.getScrollX() + (int)dx;
                int ny = widget.getScrollY() + (int)dy;
                int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
                Layout layout = widget.getLayout();
                ny = Math.min(ny, layout.getHeight() - (widget.getHeight() - padding));
                ny = Math.max(ny, 0);
                int oldX = widget.getScrollX();
                int oldY = widget.getScrollY();
                Touch.scrollTo(widget, layout, nx, ny);
                if (oldX != widget.getScrollX() || oldY != widget.getScrollY()) {
                    widget.cancelLongPress();
                }
                return true;
            }
        }
        return false;
    }

    public static int getInitialScrollX(Spannable buffer) {
        List<DragState> ds = buffer.getSpans(0, buffer.length(), DragState.class);
        return !ds.isEmpty() ? ds.get((int)0).mScrollX : -1;
    }

    public static int getInitialScrollY(Spannable buffer) {
        List<DragState> ds = buffer.getSpans(0, buffer.length(), DragState.class);
        return !ds.isEmpty() ? ds.get((int)0).mScrollY : -1;
    }

    private static class DragState
    implements NoCopySpan {
        private float mX;
        private float mY;
        private final int mScrollX;
        private final int mScrollY;
        private boolean mFarEnough;
        private boolean mUsed;

        private DragState(float x, float y, int scrollX, int scrollY) {
            this.mX = x;
            this.mY = y;
            this.mScrollX = scrollX;
            this.mScrollY = scrollY;
        }
    }
}

