/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text.style;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.text.ParcelableSpan;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.style.MetricAffectingSpan;
import yslelf.cloudpick.graphics.util.Parcel;

public class AbsoluteSizeSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final int mSize;
    private final boolean mScaled;

    public AbsoluteSizeSpan(int size) {
        this(size, false);
    }

    public AbsoluteSizeSpan(int size, boolean scaled) {
        this.mSize = size;
        this.mScaled = scaled;
    }

    public AbsoluteSizeSpan(@NonNull Parcel src) {
        this.mSize = src.readInt();
        this.mScaled = src.readBoolean();
    }

    @Override
    public int getSpanTypeId() {
        return 16;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mSize);
        dest.writeBoolean(this.mScaled);
    }

    public int getSize() {
        return this.mSize;
    }

    public boolean isScaled() {
        return this.mScaled;
    }

    @Override
    public void updateMeasureState(@NonNull TextPaint paint) {
        if (this.mScaled) {
            paint.setTextSize((float)this.mSize * paint.density);
        } else {
            paint.setTextSize(this.mSize);
        }
    }
}

