/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text.style;

import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.text.Layout;
import yslelf.cloudpick.graphics.text.Spanned;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.style.LeadingMarginSpan;

public class BulletSpan
implements LeadingMarginSpan {
    public static final int STYLE_DISC = 0;
    public static final int STYLE_CIRCLE = 1;
    public static final int STYLE_SQUARE = 2;
    private final int mBlockMargin;
    private final int mBulletWidth;
    private final int mColor;
    private final int mStyle;

    public BulletSpan(int blockMargin, int bulletWidth, int color, int style2) {
        this.mBlockMargin = blockMargin;
        this.mBulletWidth = bulletWidth;
        this.mColor = color;
        this.mStyle = style2;
    }

    @Override
    public int getLeadingMargin(boolean first) {
        return this.mBlockMargin;
    }

    @Override
    public void drawLeadingMargin(Canvas c, TextPaint p2, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        if (first && ((Spanned)text).getSpanStart(this) == start) {
            float r;
            float l2;
            int oldStyle = p2.getStyle();
            boolean restoreStrokeWidth = false;
            float oldStrokeWidth = 0.0f;
            boolean restoreColor = this.mColor != 0;
            int oldColor = restoreColor ? p2.getColor() : 0;
            int width = this.mBlockMargin;
            int height = bottom - top;
            int bulletWidth = Math.min(height, width) / 2;
            bulletWidth = this.mBulletWidth != 0 ? Math.min(this.mBulletWidth, bulletWidth) : (bulletWidth /= 2);
            if (dir > 0) {
                l2 = (float)x + (float)width / 2.0f;
                r = l2 + (float)bulletWidth;
            } else {
                r = (float)x - (float)width / 2.0f;
                l2 = r - (float)bulletWidth;
            }
            float cy = (float)(top + bottom) / 2.0f;
            if (restoreColor) {
                p2.setColor(this.mColor);
            }
            float radius = (float)bulletWidth / 2.0f;
            if (this.mStyle == 0 || this.mStyle == 1) {
                if (this.mStyle == 0) {
                    p2.setStyle(0);
                } else {
                    p2.setStyle(1);
                    restoreStrokeWidth = true;
                    oldStrokeWidth = p2.getStrokeWidth();
                    float sw = Math.max(1.0f, p2.getTextSize() / 16.0f);
                    p2.setStrokeWidth(sw);
                    radius -= sw / 2.0f;
                }
                c.drawCircle((l2 + r) / 2.0f, cy, radius, p2);
            } else {
                p2.setStyle(0);
                c.drawRect(l2, cy - radius, r, cy + radius, p2);
            }
            p2.setStyle(oldStyle);
            if (restoreStrokeWidth) {
                p2.setStrokeWidth(oldStrokeWidth);
            }
            if (restoreColor) {
                p2.setColor(oldColor);
            }
        }
    }
}

