/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text.style;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.style.ReplacementSpan;

public abstract class DynamicDrawableSpan
extends ReplacementSpan {
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_CENTER = 2;
    protected final int mVerticalAlignment;
    private WeakReference<Drawable> mDrawableRef;

    public DynamicDrawableSpan() {
        this.mVerticalAlignment = 0;
    }

    protected DynamicDrawableSpan(int verticalAlignment) {
        this.mVerticalAlignment = verticalAlignment;
    }

    public int getVerticalAlignment() {
        return this.mVerticalAlignment;
    }

    public abstract Drawable getDrawable();

    @Override
    public int getSize(@Nonnull TextPaint paint, CharSequence text, int start, int end, @Nullable FontMetricsInt fm) {
        Drawable d2 = this.getCachedDrawable();
        Rect rect = d2.getBounds();
        if (fm != null) {
            fm.ascent = -rect.bottom;
            fm.descent = 0;
        }
        return rect.right;
    }

    @Override
    public void draw(@Nonnull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @Nonnull TextPaint paint) {
        Drawable b = this.getCachedDrawable();
        canvas.save();
        int transY = bottom - b.getBounds().bottom;
        if (this.mVerticalAlignment == 1) {
            transY -= paint.getFontMetricsInt().descent;
        } else if (this.mVerticalAlignment == 2) {
            transY = top + (bottom - top) / 2 - b.getBounds().height() / 2;
        }
        canvas.translate(x, transY);
        b.draw(canvas);
        canvas.restore();
    }

    private Drawable getCachedDrawable() {
        WeakReference<Drawable> wr = this.mDrawableRef;
        Drawable d2 = null;
        if (wr != null) {
            d2 = (Drawable)wr.get();
        }
        if (d2 == null) {
            d2 = this.getDrawable();
            this.mDrawableRef = new WeakReference<Drawable>(d2);
        }
        return d2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlignmentType {
    }
}

