/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text.style;

import java.util.Locale;
import java.util.Objects;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.text.ParcelableSpan;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.style.MetricAffectingSpan;
import yslelf.cloudpick.graphics.util.Parcel;

public class LocaleSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    @Nullable
    private final Locale mLocale;

    public LocaleSpan(@Nullable Locale locale) {
        this.mLocale = locale;
    }

    public LocaleSpan(@NonNull Parcel source) {
        String tag = source.readString8();
        this.mLocale = tag == null || tag.isEmpty() ? null : Locale.forLanguageTag(tag);
    }

    @Override
    public int getSpanTypeId() {
        return 23;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mLocale != null ? this.mLocale.toLanguageTag() : "");
    }

    @Override
    public void updateMeasureState(@NonNull TextPaint paint) {
        paint.setTextLocale(Objects.requireNonNull(this.mLocale, "locale cannot be null"));
    }

    @Nullable
    public Locale getLocale() {
        return this.mLocale;
    }
}

