/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.transition;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.transition.Transition;
import yslelf.cloudpick.graphics.transition.TransitionValues;
import yslelf.cloudpick.graphics.transition.VisibilityPropagation;
import yslelf.cloudpick.graphics.view.ViewGroup;

public class CircularPropagation
extends VisibilityPropagation {
    private float mPropagationSpeed = 3.0f;

    public void setPropagationSpeed(float propagationSpeed) {
        if (propagationSpeed == 0.0f) {
            throw new IllegalArgumentException("propagationSpeed may not be 0");
        }
        this.mPropagationSpeed = propagationSpeed;
    }

    @Override
    public long getStartDelay(@Nonnull ViewGroup sceneRoot, @Nonnull Transition transition, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        int epicenterY;
        int epicenterX;
        TransitionValues positionValues;
        if (startValues == null && endValues == null) {
            return 0L;
        }
        int directionMultiplier = 1;
        if (endValues == null || this.getViewVisibility(startValues) == 0) {
            positionValues = startValues;
            directionMultiplier = -1;
        } else {
            positionValues = endValues;
        }
        int viewCenterX = this.getViewX(positionValues);
        int viewCenterY = this.getViewY(positionValues);
        Rect epicenter = transition.getEpicenter();
        if (epicenter != null) {
            epicenterX = epicenter.centerX();
            epicenterY = epicenter.centerY();
        } else {
            int[] loc = new int[2];
            sceneRoot.getLocationInWindow(loc);
            int w = sceneRoot.getWidth() / 2;
            epicenterX = Math.round((float)(loc[0] + w) + sceneRoot.getTranslationX());
            int h2 = sceneRoot.getHeight() / 2;
            epicenterY = Math.round((float)(loc[1] + h2) + sceneRoot.getTranslationY());
        }
        float distance = CircularPropagation.distance(viewCenterX, viewCenterY, epicenterX, epicenterY);
        float maxDistance = CircularPropagation.distance(0.0f, 0.0f, sceneRoot.getWidth(), sceneRoot.getHeight());
        float distanceFraction = distance / maxDistance;
        long duration = transition.getDuration();
        if (duration < 0L) {
            duration = 300L;
        }
        return Math.round((float)(duration * (long)directionMultiplier) / this.mPropagationSpeed * distanceFraction);
    }

    private static float distance(float x1, float y1, float x2, float y2) {
        float x = x2 - x1;
        float y = y2 - y1;
        return (float)Math.sqrt(x * x + y * y);
    }
}

