/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.transition;

import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorListener;
import yslelf.cloudpick.graphics.animation.AnimatorSet;
import yslelf.cloudpick.graphics.animation.ObjectAnimator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.animation.TypeEvaluator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.transition.TransitionValues;
import yslelf.cloudpick.graphics.transition.Visibility;
import yslelf.cloudpick.graphics.util.Property;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;

public class EpicenterTranslateClipReveal
extends Visibility {
    private static final String PROPNAME_CLIP = "modernui:epicenterReveal:clip";
    private static final String PROPNAME_BOUNDS = "modernui:epicenterReveal:bounds";
    private static final String PROPNAME_TRANSLATE_X = "modernui:epicenterReveal:translateX";
    private static final String PROPNAME_TRANSLATE_Y = "modernui:epicenterReveal:translateY";
    private static final String PROPNAME_TRANSLATE_Z = "modernui:epicenterReveal:translateZ";
    private static final String PROPNAME_Z = "modernui:epicenterReveal:z";
    private final TimeInterpolator mInterpolatorX = TimeInterpolator.LINEAR_OUT_SLOW_IN;
    private final TimeInterpolator mInterpolatorY = TimeInterpolator.FAST_OUT_SLOW_IN;
    private final TimeInterpolator mInterpolatorZ = TimeInterpolator.FAST_OUT_SLOW_IN;

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(@NonNull TransitionValues transitionValues) {
        super.captureEndValues(transitionValues);
        this.captureValues(transitionValues);
    }

    private void captureValues(@NonNull TransitionValues values) {
        View view = values.view;
        if (view.getVisibility() == 8) {
            return;
        }
        Rect bounds = new Rect(0, 0, view.getWidth(), view.getHeight());
        values.values.put(PROPNAME_BOUNDS, bounds);
        values.values.put(PROPNAME_TRANSLATE_X, Float.valueOf(view.getTranslationX()));
        values.values.put(PROPNAME_TRANSLATE_Y, Float.valueOf(view.getTranslationY()));
        values.values.put(PROPNAME_TRANSLATE_Z, Float.valueOf(view.getTranslationZ()));
        values.values.put(PROPNAME_Z, Float.valueOf(view.getZ()));
        Rect clip = view.getClipBounds();
        values.values.put(PROPNAME_CLIP, clip);
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (endValues == null) {
            return null;
        }
        Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
        Rect startBounds = this.getEpicenterOrCenter(endBounds);
        float startX = startBounds.centerX() - endBounds.centerX();
        float startY = startBounds.centerY() - endBounds.centerY();
        float startZ = 0.0f - ((Float)endValues.values.get(PROPNAME_Z)).floatValue();
        view.setTranslationX(startX);
        view.setTranslationY(startY);
        view.setTranslationZ(startZ);
        float endX = ((Float)endValues.values.get(PROPNAME_TRANSLATE_X)).floatValue();
        float endY = ((Float)endValues.values.get(PROPNAME_TRANSLATE_Y)).floatValue();
        float endZ = ((Float)endValues.values.get(PROPNAME_TRANSLATE_Z)).floatValue();
        Rect endClip = this.getBestRect(endValues);
        Rect startClip = this.getEpicenterOrCenter(endClip);
        view.setClipBounds(startClip);
        State startStateX = new State(startClip.left, startClip.right, startX);
        State endStateX = new State(endClip.left, endClip.right, endX);
        State startStateY = new State(startClip.top, startClip.bottom, startY);
        State endStateY = new State(endClip.top, endClip.bottom, endY);
        return EpicenterTranslateClipReveal.createRectAnimator(view, startStateX, startStateY, startZ, endStateX, endStateY, endZ, endValues, this.mInterpolatorX, this.mInterpolatorY, this.mInterpolatorZ);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null) {
            return null;
        }
        Rect startBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
        Rect endBounds = this.getEpicenterOrCenter(startBounds);
        float endX = endBounds.centerX() - startBounds.centerX();
        float endY = endBounds.centerY() - startBounds.centerY();
        float endZ = 0.0f - ((Float)startValues.values.get(PROPNAME_Z)).floatValue();
        float startX = ((Float)endValues.values.get(PROPNAME_TRANSLATE_X)).floatValue();
        float startY = ((Float)endValues.values.get(PROPNAME_TRANSLATE_Y)).floatValue();
        float startZ = ((Float)endValues.values.get(PROPNAME_TRANSLATE_Z)).floatValue();
        Rect startClip = this.getBestRect(startValues);
        Rect endClip = this.getEpicenterOrCenter(startClip);
        view.setClipBounds(startClip);
        State startStateX = new State(startClip.left, startClip.right, startX);
        State endStateX = new State(endClip.left, endClip.right, endX);
        State startStateY = new State(startClip.top, startClip.bottom, startY);
        State endStateY = new State(endClip.top, endClip.bottom, endY);
        return EpicenterTranslateClipReveal.createRectAnimator(view, startStateX, startStateY, startZ, endStateX, endStateY, endZ, endValues, this.mInterpolatorX, this.mInterpolatorY, this.mInterpolatorZ);
    }

    private Rect getEpicenterOrCenter(Rect bestRect) {
        Rect epicenter = this.getEpicenter();
        if (epicenter != null) {
            return epicenter;
        }
        int centerX = bestRect.centerX();
        int centerY = bestRect.centerY();
        return new Rect(centerX, centerY, centerX, centerY);
    }

    private Rect getBestRect(TransitionValues values) {
        Rect clipRect = (Rect)values.values.get(PROPNAME_CLIP);
        if (clipRect == null) {
            return (Rect)values.values.get(PROPNAME_BOUNDS);
        }
        return clipRect;
    }

    private static Animator createRectAnimator(final View view, State startX, State startY, float startZ, State endX, State endY, float endZ, TransitionValues endValues, TimeInterpolator interpolatorX, TimeInterpolator interpolatorY, TimeInterpolator interpolatorZ) {
        StateEvaluator evaluator = new StateEvaluator();
        ObjectAnimator animZ = ObjectAnimator.ofFloat(view, View.TRANSLATION_Z, startZ, endZ);
        if (interpolatorZ != null) {
            animZ.setInterpolator(interpolatorZ);
        }
        StateProperty propX = new StateProperty('x');
        ObjectAnimator animX = ObjectAnimator.ofObject(view, propX, evaluator, startX, endX);
        if (interpolatorX != null) {
            animX.setInterpolator(interpolatorX);
        }
        StateProperty propY = new StateProperty('y');
        ObjectAnimator animY = ObjectAnimator.ofObject(view, propY, evaluator, startY, endY);
        if (interpolatorY != null) {
            animY.setInterpolator(interpolatorY);
        }
        final Rect terminalClip = (Rect)endValues.values.get(PROPNAME_CLIP);
        AnimatorListener animatorListener = new AnimatorListener(){

            @Override
            public void onAnimationEnd(@NonNull Animator animation) {
                view.setClipBounds(terminalClip);
            }
        };
        AnimatorSet animSet = new AnimatorSet();
        animSet.playTogether(animX, animY, animZ);
        animSet.addListener(animatorListener);
        return animSet;
    }

    private static class State {
        int lower;
        int upper;
        float trans;

        public State() {
        }

        public State(int lower, int upper, float trans) {
            this.lower = lower;
            this.upper = upper;
            this.trans = trans;
        }
    }

    private static class StateEvaluator
    implements TypeEvaluator<State> {
        private final State mTemp = new State();

        private StateEvaluator() {
        }

        @Override
        public State evaluate(float fraction, State startValue, State endValue) {
            this.mTemp.upper = startValue.upper + (int)((float)(endValue.upper - startValue.upper) * fraction);
            this.mTemp.lower = startValue.lower + (int)((float)(endValue.lower - startValue.lower) * fraction);
            this.mTemp.trans = startValue.trans + (float)((int)((endValue.trans - startValue.trans) * fraction));
            return this.mTemp;
        }
    }

    private static class StateProperty
    extends Property<View, State> {
        public static final char TARGET_X = 'x';
        public static final char TARGET_Y = 'y';
        private final Rect mTempRect = new Rect();
        private final State mTempState = new State();
        private final int mTargetDimension;

        public StateProperty(char targetDimension) {
            super(State.class, "state_" + targetDimension);
            this.mTargetDimension = targetDimension;
        }

        @Override
        public State get(View object) {
            Rect tempRect = this.mTempRect;
            if (!object.getClipBounds(tempRect)) {
                tempRect.setEmpty();
            }
            State tempState = this.mTempState;
            if (this.mTargetDimension == 120) {
                tempState.trans = object.getTranslationX();
                tempState.lower = tempRect.left + (int)tempState.trans;
                tempState.upper = tempRect.right + (int)tempState.trans;
            } else {
                tempState.trans = object.getTranslationY();
                tempState.lower = tempRect.top + (int)tempState.trans;
                tempState.upper = tempRect.bottom + (int)tempState.trans;
            }
            return tempState;
        }

        @Override
        public void set(View object, State value) {
            Rect tempRect = this.mTempRect;
            if (object.getClipBounds(tempRect)) {
                if (this.mTargetDimension == 120) {
                    tempRect.left = value.lower - (int)value.trans;
                    tempRect.right = value.upper - (int)value.trans;
                } else {
                    tempRect.top = value.lower - (int)value.trans;
                    tempRect.bottom = value.upper - (int)value.trans;
                }
                object.setClipBounds(tempRect);
            }
            if (this.mTargetDimension == 120) {
                object.setTranslationX(value.trans);
            } else {
                object.setTranslationY(value.trans);
            }
        }
    }
}

