/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.transition;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.transition.CircularPropagation;
import yslelf.cloudpick.graphics.transition.TransitionValues;
import yslelf.cloudpick.graphics.transition.TranslationAnimationCreator;
import yslelf.cloudpick.graphics.transition.Visibility;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;

public class Explode
extends Visibility {
    private static final String PROPNAME_SCREEN_BOUNDS = "modernui:explode:screenBounds";
    private final int[] mTempLoc = new int[2];

    public Explode() {
        this.setPropagation(new CircularPropagation());
    }

    private void captureValues(@Nonnull TransitionValues transitionValues) {
        View view = transitionValues.view;
        view.getLocationInWindow(this.mTempLoc);
        int left = this.mTempLoc[0];
        int top = this.mTempLoc[1];
        int right = left + view.getWidth();
        int bottom = top + view.getHeight();
        transitionValues.values.put(PROPNAME_SCREEN_BOUNDS, new Rect(left, top, right, bottom));
    }

    @Override
    public void captureStartValues(@Nonnull TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(@Nonnull TransitionValues transitionValues) {
        super.captureEndValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    @Nullable
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (endValues == null) {
            return null;
        }
        Rect bounds = (Rect)endValues.values.get(PROPNAME_SCREEN_BOUNDS);
        float endX = view.getTranslationX();
        float endY = view.getTranslationY();
        this.calculateOut(sceneRoot, bounds, this.mTempLoc);
        float startX = endX + (float)this.mTempLoc[0];
        float startY = endY + (float)this.mTempLoc[1];
        return TranslationAnimationCreator.createAnimation(view, endValues, bounds.left, bounds.top, startX, startY, endX, endY, TimeInterpolator.DECELERATE, this);
    }

    @Override
    @Nullable
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null) {
            return null;
        }
        Rect bounds = (Rect)startValues.values.get(PROPNAME_SCREEN_BOUNDS);
        int viewPosX = bounds.left;
        int viewPosY = bounds.top;
        float startX = view.getTranslationX();
        float startY = view.getTranslationY();
        float endX = startX;
        float endY = startY;
        int[] interruptedPosition = (int[])startValues.view.getTag(67239939);
        if (interruptedPosition != null) {
            endX += (float)(interruptedPosition[0] - bounds.left);
            endY += (float)(interruptedPosition[1] - bounds.top);
            bounds.offsetTo(interruptedPosition[0], interruptedPosition[1]);
        }
        this.calculateOut(sceneRoot, bounds, this.mTempLoc);
        return TranslationAnimationCreator.createAnimation(view, startValues, viewPosX, viewPosY, startX, startY, endX += (float)this.mTempLoc[0], endY += (float)this.mTempLoc[1], TimeInterpolator.ACCELERATE, this);
    }

    private void calculateOut(@Nonnull View sceneRoot, Rect bounds, int[] outVector) {
        int focalY;
        int focalX;
        sceneRoot.getLocationInWindow(this.mTempLoc);
        int sceneRootX = this.mTempLoc[0];
        int sceneRootY = this.mTempLoc[1];
        Rect epicenter = this.getEpicenter();
        if (epicenter == null) {
            focalX = sceneRootX + sceneRoot.getWidth() / 2 + Math.round(sceneRoot.getTranslationX());
            focalY = sceneRootY + sceneRoot.getHeight() / 2 + Math.round(sceneRoot.getTranslationY());
        } else {
            focalX = epicenter.centerX();
            focalY = epicenter.centerY();
        }
        int centerX = bounds.centerX();
        int centerY = bounds.centerY();
        float xVector = centerX - focalX;
        float yVector = centerY - focalY;
        if (xVector == 0.0f && yVector == 0.0f) {
            xVector = (float)(Math.random() * 2.0) - 1.0f;
            yVector = (float)(Math.random() * 2.0) - 1.0f;
        }
        float vectorSize = Explode.calculateDistance(xVector, yVector);
        float maxDistance = Explode.calculateMaxDistance(sceneRoot, focalX - sceneRootX, focalY - sceneRootY);
        outVector[0] = Math.round(maxDistance * (xVector /= vectorSize));
        outVector[1] = Math.round(maxDistance * (yVector /= vectorSize));
    }

    private static float calculateMaxDistance(@Nonnull View sceneRoot, int focalX, int focalY) {
        int maxX = Math.max(focalX, sceneRoot.getWidth() - focalX);
        int maxY = Math.max(focalY, sceneRoot.getHeight() - focalY);
        return Explode.calculateDistance(maxX, maxY);
    }

    private static float calculateDistance(float x, float y) {
        return (float)Math.sqrt(x * x + y * y);
    }
}

