/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.transition;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorListener;
import yslelf.cloudpick.graphics.animation.ObjectAnimator;
import yslelf.cloudpick.graphics.transition.Transition;
import yslelf.cloudpick.graphics.transition.TransitionListener;
import yslelf.cloudpick.graphics.transition.TransitionValues;
import yslelf.cloudpick.graphics.transition.Visibility;
import yslelf.cloudpick.graphics.util.FloatProperty;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;

public class Fade
extends Visibility {
    private static final String PROPNAME_TRANSITION_ALPHA = "modernui:fade:transitionAlpha";
    public static final int IN = 1;
    public static final int OUT = 2;
    private static final FloatProperty<View> TRANSITION_ALPHA = new FloatProperty<View>("transitionAlpha"){

        @Override
        public void setValue(View view, float alpha) {
            view.setTransitionAlpha(alpha);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getTransitionAlpha());
        }
    };

    public Fade() {
    }

    public Fade(int fadingMode) {
        this.setMode(fadingMode);
    }

    @Override
    public void captureStartValues(@Nonnull TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        transitionValues.values.put(PROPNAME_TRANSITION_ALPHA, Float.valueOf(transitionValues.view.getTransitionAlpha()));
    }

    @Nullable
    private Animator createAnimation(final View view, float startAlpha, float endAlpha) {
        if (startAlpha == endAlpha) {
            return null;
        }
        view.setTransitionAlpha(startAlpha);
        ObjectAnimator anim = ObjectAnimator.ofFloat(view, TRANSITION_ALPHA, endAlpha);
        FadeAnimatorListener listener = new FadeAnimatorListener(view);
        anim.addListener(listener);
        this.addListener(new TransitionListener(){

            @Override
            public void onTransitionEnd(@Nonnull Transition transition) {
                view.setTransitionAlpha(1.0f);
                transition.removeListener(this);
            }
        });
        return anim;
    }

    @Override
    @Nullable
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        float startAlpha = Fade.getStartAlpha(startValues, 0.0f);
        if (startAlpha == 1.0f) {
            startAlpha = 0.0f;
        }
        return this.createAnimation(view, startAlpha, 1.0f);
    }

    @Override
    @Nullable
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        float startAlpha = Fade.getStartAlpha(startValues, 1.0f);
        return this.createAnimation(view, startAlpha, 0.0f);
    }

    private static float getStartAlpha(TransitionValues startValues, float fallbackValue) {
        Float startAlphaFloat;
        float startAlpha = fallbackValue;
        if (startValues != null && (startAlphaFloat = (Float)startValues.values.get(PROPNAME_TRANSITION_ALPHA)) != null) {
            startAlpha = startAlphaFloat.floatValue();
        }
        return startAlpha;
    }

    private static class FadeAnimatorListener
    implements AnimatorListener {
        private final View mView;
        private boolean mLayerTypeChanged = false;

        FadeAnimatorListener(View view) {
            this.mView = view;
        }

        @Override
        public void onAnimationStart(@Nonnull Animator animation) {
        }

        @Override
        public void onAnimationEnd(@Nonnull Animator animation) {
            this.mView.setTransitionAlpha(1.0f);
        }
    }
}

