/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.transition;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.transition.SidePropagation;
import yslelf.cloudpick.graphics.transition.TransitionValues;
import yslelf.cloudpick.graphics.transition.TranslationAnimationCreator;
import yslelf.cloudpick.graphics.transition.Visibility;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;

public class Slide
extends Visibility {
    private static final String PROPNAME_SCREEN_POSITION = "modernui:slide:screenPosition";
    private CalculateSlide mSlideCalculator = sCalculateBottom;
    private int mSlideEdge = 80;
    private static final CalculateSlide sCalculateLeft = new CalculateSlideHorizontal(){

        @Override
        public float getGoneX(@Nonnull ViewGroup sceneRoot, @Nonnull View view) {
            return view.getTranslationX() - (float)sceneRoot.getWidth();
        }
    };
    private static final CalculateSlide sCalculateStart = new CalculateSlideHorizontal(){

        @Override
        public float getGoneX(@Nonnull ViewGroup sceneRoot, @Nonnull View view) {
            boolean isRtl = sceneRoot.isLayoutRtl();
            float x = isRtl ? view.getTranslationX() + (float)sceneRoot.getWidth() : view.getTranslationX() - (float)sceneRoot.getWidth();
            return x;
        }
    };
    private static final CalculateSlide sCalculateTop = new CalculateSlideVertical(){

        @Override
        public float getGoneY(@Nonnull ViewGroup sceneRoot, @Nonnull View view) {
            return view.getTranslationY() - (float)sceneRoot.getHeight();
        }
    };
    private static final CalculateSlide sCalculateRight = new CalculateSlideHorizontal(){

        @Override
        public float getGoneX(@Nonnull ViewGroup sceneRoot, @Nonnull View view) {
            return view.getTranslationX() + (float)sceneRoot.getWidth();
        }
    };
    private static final CalculateSlide sCalculateEnd = new CalculateSlideHorizontal(){

        @Override
        public float getGoneX(@Nonnull ViewGroup sceneRoot, @Nonnull View view) {
            boolean isRtl = sceneRoot.isLayoutRtl();
            float x = isRtl ? view.getTranslationX() - (float)sceneRoot.getWidth() : view.getTranslationX() + (float)sceneRoot.getWidth();
            return x;
        }
    };
    private static final CalculateSlide sCalculateBottom = new CalculateSlideVertical(){

        @Override
        public float getGoneY(@Nonnull ViewGroup sceneRoot, @Nonnull View view) {
            return view.getTranslationY() + (float)sceneRoot.getHeight();
        }
    };

    public Slide() {
        this.setSlideEdge(80);
    }

    public Slide(int slideEdge) {
        this.setSlideEdge(slideEdge);
    }

    private void captureValues(TransitionValues transitionValues) {
        View view = transitionValues.view;
        int[] position = new int[2];
        view.getLocationInWindow(position);
        transitionValues.values.put(PROPNAME_SCREEN_POSITION, position);
    }

    @Override
    public void captureStartValues(@Nonnull TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(@Nonnull TransitionValues transitionValues) {
        super.captureEndValues(transitionValues);
        this.captureValues(transitionValues);
    }

    public void setSlideEdge(int slideEdge) {
        switch (slideEdge) {
            case 3: {
                this.mSlideCalculator = sCalculateLeft;
                break;
            }
            case 48: {
                this.mSlideCalculator = sCalculateTop;
                break;
            }
            case 5: {
                this.mSlideCalculator = sCalculateRight;
                break;
            }
            case 80: {
                this.mSlideCalculator = sCalculateBottom;
                break;
            }
            case 0x800003: {
                this.mSlideCalculator = sCalculateStart;
                break;
            }
            case 0x800005: {
                this.mSlideCalculator = sCalculateEnd;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid slide direction");
            }
        }
        this.mSlideEdge = slideEdge;
        SidePropagation propagation = new SidePropagation();
        propagation.setSide(slideEdge);
        this.setPropagation(propagation);
    }

    public int getSlideEdge() {
        return this.mSlideEdge;
    }

    @Override
    @Nullable
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (endValues == null) {
            return null;
        }
        int[] position = (int[])endValues.values.get(PROPNAME_SCREEN_POSITION);
        float endX = view.getTranslationX();
        float endY = view.getTranslationY();
        float startX = this.mSlideCalculator.getGoneX(sceneRoot, view);
        float startY = this.mSlideCalculator.getGoneY(sceneRoot, view);
        return TranslationAnimationCreator.createAnimation(view, endValues, position[0], position[1], startX, startY, endX, endY, TimeInterpolator.DECELERATE, this);
    }

    @Override
    @Nullable
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null) {
            return null;
        }
        int[] position = (int[])startValues.values.get(PROPNAME_SCREEN_POSITION);
        float startX = view.getTranslationX();
        float startY = view.getTranslationY();
        float endX = this.mSlideCalculator.getGoneX(sceneRoot, view);
        float endY = this.mSlideCalculator.getGoneY(sceneRoot, view);
        return TranslationAnimationCreator.createAnimation(view, startValues, position[0], position[1], startX, startY, endX, endY, TimeInterpolator.ACCELERATE, this);
    }

    private static interface CalculateSlide {
        public float getGoneX(@Nonnull ViewGroup var1, @Nonnull View var2);

        public float getGoneY(@Nonnull ViewGroup var1, @Nonnull View var2);
    }

    private static abstract class CalculateSlideVertical
    implements CalculateSlide {
        private CalculateSlideVertical() {
        }

        @Override
        public float getGoneX(@Nonnull ViewGroup sceneRoot, @Nonnull View view) {
            return view.getTranslationX();
        }
    }

    private static abstract class CalculateSlideHorizontal
    implements CalculateSlide {
        private CalculateSlideHorizontal() {
        }

        @Override
        public float getGoneY(@Nonnull ViewGroup sceneRoot, @Nonnull View view) {
            return view.getTranslationY();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GravityFlag {
    }
}

