/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.transition;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.transition.AutoTransition;
import yslelf.cloudpick.graphics.transition.Scene;
import yslelf.cloudpick.graphics.transition.Transition;
import yslelf.cloudpick.graphics.transition.TransitionListener;
import yslelf.cloudpick.graphics.util.ArrayMap;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.view.ViewTreeObserver;

public class TransitionManager {
    private static final Transition sDefaultTransition = new AutoTransition();
    private final ArrayMap<Scene, Transition> mSceneTransitions = new ArrayMap();
    private final ArrayMap<Scene, ArrayMap<Scene, Transition>> mScenePairTransitions = new ArrayMap();
    private static final ThreadLocal<WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>>> sRunningTransitions = new ThreadLocal();
    private static final ArrayList<ViewGroup> sPendingTransitions = new ArrayList();

    public void setTransition(@Nonnull Scene scene, @Nullable Transition transition) {
        this.mSceneTransitions.put(scene, transition);
    }

    public void setTransition(@Nonnull Scene fromScene, @Nonnull Scene toScene, @Nullable Transition transition) {
        ArrayMap<Scene, Transition> sceneTransitionMap = this.mScenePairTransitions.get(toScene);
        if (sceneTransitionMap == null) {
            sceneTransitionMap = new ArrayMap();
            this.mScenePairTransitions.put(toScene, sceneTransitionMap);
        }
        sceneTransitionMap.put(fromScene, transition);
    }

    private Transition getTransition(@Nonnull Scene scene) {
        Transition transition;
        ArrayMap<Scene, Transition> sceneTransitionMap;
        ViewGroup sceneRoot = scene.getSceneRoot();
        Scene currScene = Scene.getCurrentScene(sceneRoot);
        if (currScene != null && (sceneTransitionMap = this.mScenePairTransitions.get(scene)) != null && (transition = sceneTransitionMap.get(currScene)) != null) {
            return transition;
        }
        transition = this.mSceneTransitions.get(scene);
        return transition != null ? transition : sDefaultTransition;
    }

    private static void changeScene(@Nonnull Scene scene, @Nullable Transition transition) {
        ViewGroup sceneRoot = scene.getSceneRoot();
        if (!sPendingTransitions.contains(sceneRoot)) {
            Scene oldScene = Scene.getCurrentScene(sceneRoot);
            if (transition == null) {
                if (oldScene != null) {
                    oldScene.exit();
                }
                scene.enter();
            } else {
                sPendingTransitions.add(sceneRoot);
                Transition transitionClone = transition.clone();
                TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
                scene.enter();
                TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
            }
        }
    }

    @Nonnull
    static ArrayMap<ViewGroup, ArrayList<Transition>> getRunningTransitions() {
        ArrayMap<ViewGroup, ArrayList<Transition>> transitions;
        WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>> runningTransitions = sRunningTransitions.get();
        if (runningTransitions != null && (transitions = (ArrayMap<ViewGroup, ArrayList<Transition>>)runningTransitions.get()) != null) {
            return transitions;
        }
        transitions = new ArrayMap<ViewGroup, ArrayList<Transition>>();
        runningTransitions = new WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>>(transitions);
        sRunningTransitions.set(runningTransitions);
        return transitions;
    }

    private static void sceneChangeRunTransition(ViewGroup sceneRoot, Transition transition) {
        if (transition != null && sceneRoot != null) {
            MultiListener listener = new MultiListener(transition, sceneRoot);
            sceneRoot.addOnAttachStateChangeListener(listener);
            sceneRoot.getViewTreeObserver().addOnPreDrawListener(listener);
        }
    }

    private static void sceneChangeSetup(ViewGroup sceneRoot, Transition transition) {
        Scene previousScene;
        ArrayList<Transition> runningTransitions = TransitionManager.getRunningTransitions().get(sceneRoot);
        if (runningTransitions != null && runningTransitions.size() > 0) {
            for (Transition runningTransition : runningTransitions) {
                runningTransition.pause(sceneRoot);
            }
        }
        if (transition != null) {
            transition.captureValues(sceneRoot, true);
        }
        if ((previousScene = Scene.getCurrentScene(sceneRoot)) != null) {
            previousScene.exit();
        }
    }

    public void transitionTo(@Nonnull Scene scene) {
        TransitionManager.changeScene(scene, this.getTransition(scene));
    }

    public static void go(@Nonnull Scene scene) {
        TransitionManager.changeScene(scene, sDefaultTransition);
    }

    public static void go(@Nonnull Scene scene, @Nullable Transition transition) {
        TransitionManager.changeScene(scene, transition);
    }

    public static void beginDelayedTransition(@Nonnull ViewGroup sceneRoot) {
        TransitionManager.beginDelayedTransition(sceneRoot, null);
    }

    public static void beginDelayedTransition(@Nonnull ViewGroup sceneRoot, @Nullable Transition transition) {
        if (!sPendingTransitions.contains(sceneRoot) && sceneRoot.isLaidOut()) {
            sPendingTransitions.add(sceneRoot);
            if (transition == null) {
                transition = sDefaultTransition;
            }
            Transition transitionClone = transition.clone();
            TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
            Scene.setCurrentScene(sceneRoot, null);
            TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
        }
    }

    public static void endTransitions(ViewGroup sceneRoot) {
        sPendingTransitions.remove(sceneRoot);
        ArrayList<Transition> runningTransitions = TransitionManager.getRunningTransitions().get(sceneRoot);
        if (runningTransitions != null && !runningTransitions.isEmpty()) {
            ArrayList<Transition> copy = new ArrayList<Transition>(runningTransitions);
            for (int i = copy.size() - 1; i >= 0; --i) {
                Transition transition = copy.get(i);
                transition.forceToEnd(sceneRoot);
            }
        }
    }

    private static class MultiListener
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener {
        Transition mTransition;
        ViewGroup mSceneRoot;

        MultiListener(Transition transition, ViewGroup sceneRoot) {
            this.mTransition = transition;
            this.mSceneRoot = sceneRoot;
        }

        private void removeListeners() {
            this.mSceneRoot.getViewTreeObserver().removeOnPreDrawListener(this);
            this.mSceneRoot.removeOnAttachStateChangeListener(this);
        }

        @Override
        public void onViewAttachedToWindow(View v) {
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
            this.removeListeners();
            sPendingTransitions.remove(this.mSceneRoot);
            ArrayList<Transition> runningTransitions = TransitionManager.getRunningTransitions().get(this.mSceneRoot);
            if (runningTransitions != null && runningTransitions.size() > 0) {
                for (Transition runningTransition : runningTransitions) {
                    runningTransition.resume(this.mSceneRoot);
                }
            }
            this.mTransition.clearValues(true);
        }

        @Override
        public boolean onPreDraw() {
            this.removeListeners();
            if (!sPendingTransitions.remove(this.mSceneRoot)) {
                return true;
            }
            final ArrayMap<ViewGroup, ArrayList<Transition>> runningTransitions = TransitionManager.getRunningTransitions();
            ArrayList<Transition> currentTransitions = runningTransitions.get(this.mSceneRoot);
            ArrayList<Transition> previousRunningTransitions = null;
            if (currentTransitions == null) {
                currentTransitions = new ArrayList();
                runningTransitions.put(this.mSceneRoot, currentTransitions);
            } else if (currentTransitions.size() > 0) {
                previousRunningTransitions = new ArrayList<Transition>(currentTransitions);
            }
            currentTransitions.add(this.mTransition);
            this.mTransition.addListener(new TransitionListener(){

                @Override
                public void onTransitionEnd(@Nonnull Transition transition) {
                    ArrayList currentTransitions = (ArrayList)runningTransitions.get(mSceneRoot);
                    currentTransitions.remove(transition);
                    transition.removeListener(this);
                }
            });
            this.mTransition.captureValues(this.mSceneRoot, false);
            if (previousRunningTransitions != null) {
                for (Transition runningTransition : previousRunningTransitions) {
                    runningTransition.resume(this.mSceneRoot);
                }
            }
            this.mTransition.playTransition(this.mSceneRoot);
            return true;
        }
    }
}

