/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.util;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.ColorInt;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Color;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.util.SparseArray;
import yslelf.cloudpick.graphics.util.StateSet;

public class ColorStateList {
    private static final int DEFAULT_COLOR = -65536;
    private static final int[][] EMPTY = new int[][]{new int[0]};
    @GuardedBy(value="itself")
    private static final SparseArray<WeakReference<ColorStateList>> sCache = new SparseArray();
    private final int[][] mStateSpecs;
    private final int[] mColors;
    private int mDefaultColor;
    private boolean mIsOpaque;

    public ColorStateList(@NonNull int[][] states, @NonNull int[] colors) {
        this.mStateSpecs = states;
        this.mColors = colors;
        this.onColorsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ColorStateList valueOf(@ColorInt int color) {
        SparseArray<WeakReference<ColorStateList>> sparseArray = sCache;
        synchronized (sparseArray) {
            int index = sCache.indexOfKey(color);
            if (index >= 0) {
                ColorStateList cached = (ColorStateList)sCache.valueAt(index).get();
                if (cached != null) {
                    return cached;
                }
                sCache.removeAt(index);
            }
            int N = sCache.size();
            for (int i = N - 1; i >= 0; --i) {
                if (sCache.valueAt(i).get() != null) continue;
                sCache.removeAt(i);
            }
            ColorStateList csl = new ColorStateList(EMPTY, new int[]{color});
            sCache.put(color, new WeakReference<ColorStateList>(csl));
            return csl;
        }
    }

    @NonNull
    public ColorStateList withAlpha(int alpha) {
        int[] colors = new int[this.mColors.length];
        int len = colors.length;
        for (int i = 0; i < len; ++i) {
            colors[i] = this.mColors[i] & 0xFFFFFF | alpha << 24;
        }
        return new ColorStateList(this.mStateSpecs, colors);
    }

    public static int modulateColor(int baseColor, float alphaMod) {
        if (alphaMod == 1.0f) {
            return baseColor;
        }
        int baseAlpha = Color.alpha(baseColor);
        int alpha = MathUtil.clamp((int)((float)baseAlpha * alphaMod + 0.5f), 0, 255);
        return baseColor & 0xFFFFFF | alpha << 24;
    }

    public boolean isStateful() {
        return this.mStateSpecs.length >= 1 && this.mStateSpecs[0].length > 0;
    }

    @ApiStatus.Internal
    public boolean hasFocusStateSpecified() {
        return StateSet.containsAttribute(this.mStateSpecs, 16844130);
    }

    public boolean isOpaque() {
        return this.mIsOpaque;
    }

    public int getColorForState(int[] stateSet, int defaultColor) {
        int setLength = this.mStateSpecs.length;
        for (int i = 0; i < setLength; ++i) {
            int[] stateSpec = this.mStateSpecs[i];
            if (!StateSet.stateSetMatches(stateSpec, stateSet)) continue;
            return this.mColors[i];
        }
        return defaultColor;
    }

    @ColorInt
    public int getDefaultColor() {
        return this.mDefaultColor;
    }

    @ApiStatus.Internal
    public int[][] getStates() {
        return this.mStateSpecs;
    }

    @ApiStatus.Internal
    public int[] getColors() {
        return this.mColors;
    }

    @ApiStatus.Internal
    public boolean hasState(int state) {
        int[][] nArray = this.mStateSpecs;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int[] states;
            for (int i2 : states = nArray[i]) {
                if (i2 != state && i2 != ~state) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ColorStateList{mStateSpecs=" + Arrays.deepToString((Object[])this.mStateSpecs) + "mColors=" + Arrays.toString(this.mColors) + "mDefaultColor=" + this.mDefaultColor + "}";
    }

    private void onColorsChanged() {
        int defaultColor = -65536;
        boolean isOpaque = true;
        int[][] states = this.mStateSpecs;
        int[] colors = this.mColors;
        int N = states.length;
        if (N > 0) {
            int i;
            defaultColor = colors[0];
            for (i = N - 1; i > 0; --i) {
                if (states[i].length != 0) continue;
                defaultColor = colors[i];
                break;
            }
            for (i = 0; i < N; ++i) {
                if (colors[i] >>> 24 == 255) continue;
                isOpaque = false;
                break;
            }
        }
        this.mDefaultColor = defaultColor;
        this.mIsOpaque = isOpaque;
    }
}

