/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.util.Parcel;
import yslelf.cloudpick.graphics.util.Parcelable;

public final class DataSet
implements Map<String, Object>,
Parcelable {
    private static final Marker MARKER = MarkerManager.getMarker((String)"DataSet");
    @NonNull
    public static final Parcelable.ClassLoaderCreator<DataSet> CREATOR = Parcel::readDataSet;
    private static final int DEFAULT_INITIAL_SIZE = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private String[] mKey;
    private Object[] mValue;
    private int mHead = -1;
    private int mTail = -1;
    private long[] mLink;
    private int mSize;
    private int mThreshold;
    private Set<Map.Entry<String, Object>> mEntries;
    private Set<String> mKeys;
    private Collection<Object> mValues;

    public DataSet() {
        this.mKey = new String[16];
        this.mValue = new Object[16];
        this.mLink = new long[16];
        this.mThreshold = 12;
    }

    DataSet(int n2) {
        n2 = (int)Math.ceil((float)n2 / 0.75f);
        n2 = Math.max(n2, 16);
        if (n2 > 0x40000000) {
            throw new AssertionError(n2);
        }
        n2 = MathUtil.ceilPow2(n2);
        this.mKey = new String[n2];
        this.mValue = new Object[n2];
        this.mLink = new long[n2];
        this.mThreshold = (int)((float)n2 * 0.75f);
    }

    static int hash(@NonNull Object key) {
        int h2 = key.hashCode() * -1640531535;
        return h2 ^ h2 >>> 16;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean isEmpty() {
        return this.mSize == 0;
    }

    private int find(String key) {
        Objects.requireNonNull(key);
        String[] keys = this.mKey;
        int mask = keys.length - 1;
        int pos = DataSet.hash(key) & mask;
        String k = keys[pos];
        if (k == null) {
            return -pos - 1;
        }
        if (key.equals(k)) {
            return pos;
        }
        do {
            if ((k = keys[pos = pos + 1 & mask]) != null) continue;
            return -pos - 1;
        } while (!key.equals(k));
        return pos;
    }

    @Override
    public boolean containsKey(Object key) {
        Objects.requireNonNull(key);
        String[] keys = this.mKey;
        int mask = keys.length - 1;
        int pos = DataSet.hash(key) & mask;
        String k = keys[pos];
        if (k == null) {
            return false;
        }
        if (k == key || key.equals(k)) {
            return true;
        }
        do {
            if ((k = keys[pos = pos + 1 & mask]) != null) continue;
            return false;
        } while (k != key && !key.equals(k));
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        Object[] v = this.mValue;
        String[] k = this.mKey;
        int i = k.length;
        while (i-- != 0) {
            if (k[i] == null || !Objects.equals(value, v[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        Objects.requireNonNull(key);
        String[] keys = this.mKey;
        int mask = keys.length - 1;
        int pos = DataSet.hash(key) & mask;
        String k = keys[pos];
        if (k == null) {
            return null;
        }
        if (k == key || key.equals(k)) {
            return this.mValue[pos];
        }
        do {
            if ((k = keys[pos = pos + 1 & mask]) != null) continue;
            return null;
        } while (k != key && !key.equals(k));
        return this.mValue[pos];
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    @Override
    @Nullable
    public Object putIfAbsent(String key, Object value) {
        int pos = this.find(key);
        if (pos >= 0) {
            return this.mValue[pos];
        }
        this.insert(-pos - 1, key, value);
        return null;
    }

    public <T> T getValue(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (T)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "<T>", e);
            return null;
        }
    }

    public <T> T getValue(String key, Class<T> clazz) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (T)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, clazz.getName(), e);
            return null;
        }
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Boolean)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "Boolean", (Object)defaultValue, e);
            return defaultValue;
        }
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Byte)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "Byte", (Object)defaultValue, e);
            return defaultValue;
        }
    }

    public char getChar(String key) {
        return this.getChar(key, '0');
    }

    public char getChar(String key, char defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Character)o).charValue();
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "Character", (Object)Character.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Short)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "Short", (Object)defaultValue, e);
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Integer)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "Integer", (Object)defaultValue, e);
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Long)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "Long", (Object)defaultValue, e);
            return defaultValue;
        }
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Float)o).floatValue();
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "Float", (Object)Float.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Double)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "Double", (Object)defaultValue, e);
            return defaultValue;
        }
    }

    public byte[] getByteArray(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (byte[])o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    public short[] getShortArray(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (short[])o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "short[]", e);
            return null;
        }
    }

    public int[] getIntArray(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (int[])o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "int[]", e);
            return null;
        }
    }

    public long[] getLongArray(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (long[])o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "long[]", e);
            return null;
        }
    }

    public float[] getFloatArray(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (float[])o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "float[]", e);
            return null;
        }
    }

    public double[] getDoubleArray(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (double[])o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "double[]", e);
            return null;
        }
    }

    public String getString(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "String", e);
            return null;
        }
    }

    @NonNull
    public String getString(String key, String defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "String", (Object)defaultValue, e);
            return defaultValue;
        }
    }

    public UUID getUUID(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (UUID)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "UUID", e);
            return null;
        }
    }

    @NonNull
    public UUID getUUID(String key, UUID defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (UUID)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "UUID", (Object)defaultValue, e);
            return defaultValue;
        }
    }

    public <T> List<T> getList(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (List)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "List<T>", e);
            return null;
        }
    }

    public DataSet getDataSet(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (DataSet)o;
        }
        catch (ClassCastException e) {
            DataSet.typeWarning(key, o, "DataSet", e);
            return null;
        }
    }

    private void insert(int pos, String key, Object value) {
        this.mKey[pos] = key;
        this.mValue[pos] = value;
        if (this.mSize == 0) {
            this.mHead = this.mTail = pos;
            this.mLink[pos] = -1L;
        } else {
            int n2 = this.mTail;
            this.mLink[n2] = this.mLink[n2] ^ (this.mLink[this.mTail] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.mLink[pos] = ((long)this.mTail & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.mTail = pos;
        }
        if (this.mSize++ >= this.mThreshold) {
            int cap = this.mKey.length;
            if (cap > 0x40000000) {
                throw new IllegalStateException("hashtable is too large");
            }
            this.rehash(cap << 1);
        }
    }

    private void rehash(int cap) {
        String[] key = this.mKey;
        Object[] value = this.mValue;
        int mask = cap - 1;
        String[] newKey = new String[cap];
        Object[] newValue = new Object[cap];
        int i = this.mHead;
        int prev = -1;
        int newPrev = -1;
        long[] link = this.mLink;
        long[] newLink = new long[cap];
        this.mHead = -1;
        int j = this.mSize;
        while (j-- != 0) {
            int pos;
            if (key[i] == null) {
                pos = cap;
            } else {
                pos = DataSet.hash(key[i]) & mask;
                while (newKey[pos] != null) {
                    pos = pos + 1 & mask;
                }
            }
            newKey[pos] = key[i];
            newValue[pos] = value[i];
            if (prev != -1) {
                int n2 = newPrev;
                newLink[n2] = newLink[n2] ^ (newLink[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n3 = pos;
                newLink[n3] = newLink[n3] ^ (newLink[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos;
            } else {
                newPrev = this.mHead = pos;
                newLink[pos] = -1L;
            }
            int t2 = i;
            i = (int)link[i];
            prev = t2;
        }
        this.mLink = newLink;
        this.mTail = newPrev;
        if (newPrev != -1) {
            int n4 = newPrev;
            newLink[n4] = newLink[n4] | 0xFFFFFFFFL;
        }
        this.mThreshold = (int)((float)cap * 0.75f);
        this.mKey = newKey;
        this.mValue = newValue;
    }

    @Override
    @Nullable
    public Object put(String key, Object value) {
        if (value == this) {
            throw new IllegalArgumentException("closed loop");
        }
        int pos = this.find(key);
        if (pos < 0) {
            this.insert(-pos - 1, key, value);
            return null;
        }
        Object oldValue = this.mValue[pos];
        this.mValue[pos] = value;
        return oldValue;
    }

    public void putByte(String key, byte value) {
        this.put(key, (Object)value);
    }

    public void putShort(String key, short value) {
        this.put(key, (Object)value);
    }

    public void putInt(String key, int value) {
        this.put(key, (Object)value);
    }

    public void putLong(String key, long value) {
        this.put(key, (Object)value);
    }

    public void putFloat(String key, float value) {
        this.put(key, (Object)Float.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.put(key, (Object)value);
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, (Object)value);
    }

    public void putString(String key, String value) {
        this.put(key, (Object)value);
    }

    public void putUUID(String key, UUID value) {
        this.put(key, (Object)value);
    }

    public void putList(String key, List<?> value) {
        this.put(key, (Object)value);
    }

    public void putDataSet(String key, DataSet value) {
        this.put(key, (Object)value);
    }

    public void putByteArray(String key, byte[] value) {
        this.put(key, (Object)value);
    }

    public void putShortArray(String key, short[] value) {
        this.put(key, (Object)value);
    }

    public void putIntArray(String key, int[] value) {
        this.put(key, (Object)value);
    }

    public void putLongArray(String key, long[] value) {
        this.put(key, (Object)value);
    }

    public void putFloatArray(String key, float[] value) {
        this.put(key, (Object)value);
    }

    public void putDoubleArray(String key, double[] value) {
        this.put(key, (Object)value);
    }

    private void updateLinks(int i) {
        if (this.mSize == 0) {
            this.mTail = -1;
            this.mHead = -1;
            return;
        }
        if (this.mHead == i) {
            this.mHead = (int)this.mLink[i];
            if (this.mHead >= 0) {
                int n2 = this.mHead;
                this.mLink[n2] = this.mLink[n2] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.mTail == i) {
            this.mTail = (int)(this.mLink[i] >>> 32);
            if (this.mTail >= 0) {
                int n3 = this.mTail;
                this.mLink[n3] = this.mLink[n3] | 0xFFFFFFFFL;
            }
            return;
        }
        long link = this.mLink[i];
        int prev = (int)(link >>> 32);
        int next = (int)link;
        int n4 = prev;
        this.mLink[n4] = this.mLink[n4] ^ (this.mLink[prev] ^ link & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n5 = next;
        this.mLink[n5] = this.mLink[n5] ^ (this.mLink[next] ^ link & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    private void updateLinks(int x, int y) {
        if (this.mSize == 1) {
            this.mHead = this.mTail = y;
            this.mLink[y] = -1L;
        } else if (this.mHead == x) {
            int next;
            this.mHead = y;
            int n2 = next = (int)this.mLink[x];
            this.mLink[n2] = this.mLink[n2] ^ (this.mLink[next] ^ ((long)y & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.mLink[y] = this.mLink[x];
        } else if (this.mTail == x) {
            int prev;
            this.mTail = y;
            int n3 = prev = (int)(this.mLink[x] >>> 32);
            this.mLink[n3] = this.mLink[n3] ^ (this.mLink[prev] ^ (long)y & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.mLink[y] = this.mLink[x];
        } else {
            long link = this.mLink[x];
            int prev = (int)(link >>> 32);
            int next = (int)link;
            int n4 = prev;
            this.mLink[n4] = this.mLink[n4] ^ (this.mLink[prev] ^ (long)y & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n5 = next;
            this.mLink[n5] = this.mLink[n5] ^ (this.mLink[next] ^ ((long)y & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.mLink[y] = link;
        }
    }

    private Object removeEntry(int pos) {
        Object value = this.mValue[pos];
        this.mValue[pos] = null;
        --this.mSize;
        this.updateLinks(pos);
        this.shiftKeys(pos);
        if (this.mSize < this.mThreshold / 4 && this.mKey.length > 16) {
            this.rehash(this.mKey.length / 2);
        }
        return value;
    }

    private void shiftKeys(int pos) {
        String[] key = this.mKey;
        int mask = key.length - 1;
        while (true) {
            String k;
            int prev = pos;
            pos = prev + 1 & mask;
            while (true) {
                if ((k = key[pos]) == null) {
                    key[prev] = null;
                    this.mValue[prev] = null;
                    return;
                }
                int i = DataSet.hash(k) & mask;
                if (prev <= pos ? prev >= i || i > pos : prev >= i && i > pos) break;
                pos = pos + 1 & mask;
            }
            key[prev] = k;
            this.mValue[prev] = this.mValue[pos];
            this.updateLinks(pos, prev);
        }
    }

    @Override
    public Object remove(Object key) {
        Objects.requireNonNull(key);
        String[] keys = this.mKey;
        int mask = keys.length - 1;
        int pos = DataSet.hash(key) & mask;
        String k = keys[pos];
        if (k == null) {
            return null;
        }
        if (k == key || key.equals(k)) {
            return this.removeEntry(pos);
        }
        do {
            if ((k = keys[pos = pos + 1 & mask]) != null) continue;
            return null;
        } while (k != key && !key.equals(k));
        return this.removeEntry(pos);
    }

    public Object removeFirst() {
        if (this.mSize == 0) {
            throw new NoSuchElementException();
        }
        int pos = this.mHead;
        this.mHead = (int)this.mLink[pos];
        if (this.mHead >= 0) {
            int n2 = this.mHead;
            this.mLink[n2] = this.mLink[n2] | 0xFFFFFFFF00000000L;
        }
        --this.mSize;
        Object v = this.mValue[pos];
        this.shiftKeys(pos);
        if (this.mSize < this.mThreshold / 4 && this.mKey.length > 16) {
            this.rehash(this.mKey.length / 2);
        }
        return v;
    }

    public Object removeLast() {
        if (this.mSize == 0) {
            throw new NoSuchElementException();
        }
        int pos = this.mTail;
        this.mTail = (int)(this.mLink[pos] >>> 32);
        if (this.mTail >= 0) {
            int n2 = this.mTail;
            this.mLink[n2] = this.mLink[n2] | 0xFFFFFFFFL;
        }
        --this.mSize;
        Object v = this.mValue[pos];
        this.shiftKeys(pos);
        if (this.mSize < this.mThreshold / 4 && this.mKey.length > 16) {
            this.rehash(this.mKey.length / 2);
        }
        return v;
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ?> map) {
        int capacity = (int)Math.min(0x40000000L, 1L << -Long.numberOfLeadingZeros((long)Math.ceil((float)(this.mSize + map.size()) / 0.75f) - 1L));
        if (capacity > this.mKey.length) {
            this.rehash(capacity);
        }
        for (Map.Entry<String, ?> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        if (this.mSize == 0) {
            return;
        }
        this.mSize = 0;
        Arrays.fill(this.mKey, null);
        Arrays.fill(this.mValue, null);
        this.mTail = -1;
        this.mHead = -1;
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        if (this.mKeys == null) {
            this.mKeys = new KeySet();
        }
        return this.mKeys;
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        if (this.mValues == null) {
            this.mValues = new Values();
        }
        return this.mValues;
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.mEntries == null) {
            this.mEntries = new MapEntrySet();
        }
        return this.mEntries;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeDataSet(this);
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int j = this.mSize;
        int i = 0;
        while (j-- != 0) {
            while (this.mKey[i] == null) {
                ++i;
            }
            h2 += this.mKey[i].hashCode() ^ Objects.hashCode(this.mValue[i]);
            ++i;
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            FastEntryIterator it = new FastEntryIterator();
            while (it.hasNext()) {
                Object e = it.next();
                String key = (String)e.getKey();
                Object value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder s = new StringBuilder();
        s.append('{');
        FastEntryIterator it = new FastEntryIterator();
        while (true) {
            s.append(it.next());
            if (!it.hasNext()) {
                return s.append('}').toString();
            }
            s.append(',').append(' ');
        }
    }

    static void typeWarning(int key, Object value, String className, ClassCastException e) {
        DataSet.typeWarning(key, value, className, (Object)"<null>", e);
    }

    static void typeWarning(int key, Object value, String className, Object defaultValue, ClassCastException e) {
        CloudPick.LOGGER.warn(MARKER, "Key {} expected {} but value was a {}. The default value {} was returned.", (Object)key, (Object)className, (Object)value.getClass().getName(), defaultValue);
        CloudPick.LOGGER.warn(MARKER, "Attempt to cast generated internal exception", (Throwable)e);
    }

    static void typeWarning(String key, Object value, String className, ClassCastException e) {
        DataSet.typeWarning(key, value, className, (Object)"<null>", e);
    }

    static void typeWarning(String key, Object value, String className, Object defaultValue, ClassCastException e) {
        CloudPick.LOGGER.warn(MARKER, "Key {} expected {} but value was a {}. The default value {} was returned.", (Object)key, (Object)className, (Object)value.getClass().getName(), defaultValue);
        CloudPick.LOGGER.warn(MARKER, "Attempt to cast generated internal exception", (Throwable)e);
    }

    private final class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        @NonNull
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return DataSet.this.mSize;
        }

        @Override
        public void forEach(Consumer<? super String> action) {
            int i = DataSet.this.mSize;
            int next = DataSet.this.mHead;
            while (i-- != 0) {
                int curr = next;
                next = (int)DataSet.this.mLink[curr];
                action.accept(DataSet.this.mKey[curr]);
            }
        }

        @Override
        public boolean contains(Object o) {
            return DataSet.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return DataSet.this.remove(o) != null;
        }

        @Override
        public void clear() {
            DataSet.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<Object> {
        private Values() {
        }

        @Override
        @NonNull
        public Iterator<Object> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return DataSet.this.mSize;
        }

        @Override
        public void forEach(Consumer<? super Object> action) {
            int i = DataSet.this.mSize;
            int next = DataSet.this.mHead;
            while (i-- != 0) {
                int curr = next;
                next = (int)DataSet.this.mLink[curr];
                action.accept(DataSet.this.mValue[curr]);
            }
        }

        @Override
        public boolean contains(Object o) {
            return DataSet.this.containsValue(o);
        }

        @Override
        public void clear() {
            DataSet.this.clear();
        }
    }

    private final class MapEntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private MapEntrySet() {
        }

        @Override
        @NonNull
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return DataSet.this.mSize;
        }

        @Override
        public void clear() {
            DataSet.this.clear();
        }
    }

    final class FastEntryIterator
    extends MapIterator<Consumer<? super Map.Entry<String, Object>>>
    implements ListIterator<Map.Entry<String, Object>> {
        private final MapEntry mEntry;

        public FastEntryIterator() {
            this.mEntry = new MapEntry();
        }

        public FastEntryIterator(String from) {
            super(from);
            this.mEntry = new MapEntry();
        }

        @Override
        void accept(Consumer<? super Map.Entry<String, Object>> action, int index) {
            this.mEntry.index = index;
            action.accept(this.mEntry);
        }

        @Override
        public Map.Entry<String, Object> next() {
            this.mEntry.index = this.nextEntry();
            return this.mEntry;
        }

        @Override
        public Map.Entry<String, Object> previous() {
            this.mEntry.index = this.previousEntry();
            return this.mEntry;
        }

        @Override
        public void set(Map.Entry<String, Object> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<String, Object> e) {
            throw new UnsupportedOperationException();
        }
    }

    private final class EntryIterator
    extends MapIterator<Consumer<? super Map.Entry<String, Object>>>
    implements ListIterator<Map.Entry<String, Object>> {
        private MapEntry mEntry;

        public EntryIterator() {
        }

        public EntryIterator(String from) {
            super(from);
        }

        @Override
        void accept(Consumer<? super Map.Entry<String, Object>> action, int index) {
            action.accept(new MapEntry(index));
        }

        @Override
        public MapEntry next() {
            this.mEntry = new MapEntry(this.nextEntry());
            return this.mEntry;
        }

        @Override
        public MapEntry previous() {
            this.mEntry = new MapEntry(this.previousEntry());
            return this.mEntry;
        }

        @Override
        public void remove() {
            super.remove();
            this.mEntry.index = -1;
        }

        @Override
        public void set(Map.Entry<String, Object> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<String, Object> e) {
            throw new UnsupportedOperationException();
        }
    }

    private final class MapEntry
    implements Map.Entry<String, Object> {
        int index;

        MapEntry() {
        }

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public String getKey() {
            return DataSet.this.mKey[this.index];
        }

        @Override
        public Object getValue() {
            return DataSet.this.mValue[this.index];
        }

        @Override
        public Object setValue(Object newValue) {
            Object oldValue = DataSet.this.mValue[this.index];
            DataSet.this.mValue[this.index] = newValue;
            return oldValue;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(DataSet.this.mKey[this.index]) ^ Objects.hashCode(DataSet.this.mValue[this.index]);
        }

        @Override
        public boolean equals(Object o) {
            Map.Entry e;
            return o instanceof Map.Entry && Objects.equals(DataSet.this.mKey[this.index], (e = (Map.Entry)o).getKey()) && Objects.equals(DataSet.this.mValue[this.index], e.getValue());
        }

        @NonNull
        public String toString() {
            return DataSet.this.mKey[this.index] + "=" + DataSet.this.mValue[this.index];
        }
    }

    private final class ValueIterator
    extends MapIterator<Consumer<? super Object>>
    implements ListIterator<Object> {
        @Override
        void accept(Consumer<? super Object> action, int index) {
            action.accept(DataSet.this.mValue[index]);
        }

        @Override
        public Object previous() {
            return DataSet.this.mValue[this.previousEntry()];
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            return DataSet.this.mValue[this.nextEntry()];
        }
    }

    private final class KeyIterator
    extends MapIterator<Consumer<? super String>>
    implements ListIterator<String> {
        public KeyIterator() {
        }

        public KeyIterator(String k) {
            super(k);
        }

        @Override
        void accept(Consumer<? super String> action, int index) {
            action.accept(DataSet.this.mKey[index]);
        }

        @Override
        public String previous() {
            return DataSet.this.mKey[this.previousEntry()];
        }

        @Override
        public void set(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String next() {
            return DataSet.this.mKey[this.nextEntry()];
        }
    }

    private abstract class MapIterator<ACTION> {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = -1;

        MapIterator() {
            this.next = DataSet.this.mHead;
            this.index = 0;
        }

        MapIterator(String key) {
            String k;
            Objects.requireNonNull(key);
            if (Objects.equals(key, DataSet.this.mKey[DataSet.this.mTail])) {
                this.prev = DataSet.this.mTail;
                this.index = DataSet.this.mSize;
                return;
            }
            String[] keys = DataSet.this.mKey;
            int mask = keys.length - 1;
            int pos = DataSet.hash(key) & mask;
            while ((k = keys[pos]) != null) {
                if (key.equals(k)) {
                    this.next = (int)DataSet.this.mLink[pos];
                    this.prev = pos;
                    return;
                }
                pos = pos + 1 & mask;
            }
            throw new NoSuchElementException("The key " + key + " does not belong to this map.");
        }

        abstract void accept(ACTION var1, int var2);

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        private void forward0() {
            if (this.index >= 0) {
                return;
            }
            if (this.prev == -1) {
                this.index = 0;
                return;
            }
            if (this.next == -1) {
                this.index = DataSet.this.mSize;
                return;
            }
            int pos = DataSet.this.mTail;
            this.index = 1;
            while (pos != this.prev) {
                pos = (int)DataSet.this.mLink[pos];
                ++this.index;
            }
        }

        public int nextIndex() {
            this.forward0();
            return this.index;
        }

        public int previousIndex() {
            this.forward0();
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = (int)DataSet.this.mLink[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = (int)(DataSet.this.mLink[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return this.curr;
        }

        public void forEachRemaining(ACTION action) {
            while (this.hasNext()) {
                this.curr = this.next;
                this.next = (int)DataSet.this.mLink[this.curr];
                this.prev = this.curr;
                if (this.index >= 0) {
                    ++this.index;
                }
                this.accept(action, this.curr);
            }
        }

        public void remove() {
            this.forward0();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(DataSet.this.mLink[this.curr] >>> 32);
            } else {
                this.next = (int)DataSet.this.mLink[this.curr];
            }
            --DataSet.this.mSize;
            if (this.prev == -1) {
                DataSet.this.mHead = this.next;
            } else {
                int n2 = this.prev;
                DataSet.this.mLink[n2] = DataSet.this.mLink[n2] ^ (DataSet.this.mLink[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                DataSet.this.mTail = this.prev;
            } else {
                int n3 = this.next;
                DataSet.this.mLink[n3] = DataSet.this.mLink[n3] ^ (DataSet.this.mLink[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int pos = this.curr;
            this.curr = -1;
            String[] keys = DataSet.this.mKey;
            int mask = keys.length - 1;
            while (true) {
                String k;
                int last = pos;
                pos = last + 1 & mask;
                while (true) {
                    if ((k = keys[pos]) == null) {
                        keys[last] = null;
                        DataSet.this.mValue[last] = null;
                        return;
                    }
                    int slot = DataSet.hash(k) & mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & mask;
                }
                keys[last] = k;
                DataSet.this.mValue[last] = DataSet.this.mValue[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                DataSet.this.updateLinks(pos, last);
            }
        }

        public int skip(int n2) {
            int i = n2;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n2 - i - 1;
        }

        public int back(int n2) {
            int i = n2;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n2 - i - 1;
        }
    }
}

