/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.util.HeadPadding;
import yslelf.cloudpick.graphics.util.L2Padding;
import yslelf.cloudpick.graphics.util.Pools;
import yslelf.cloudpick.graphics.util.TailPadding;

@ThreadSafe
public class MpmcArrayQueue<E>
extends L2Padding<E>
implements Pools.Pool<E> {
    private static final VarHandle HEAD;
    private static final VarHandle TAIL;
    private static final VarHandle SEQ;
    private static final long MAX_SEQ = 0x4000000000000000L;
    private final long mask;
    private final E[] buf;
    private final long[] seq;

    public MpmcArrayQueue(int capacity) {
        if (capacity <= 0 || capacity > 0x40000000) {
            throw new IllegalArgumentException();
        }
        int n2 = MathUtil.ceilPow2(capacity);
        this.mask = n2 - 1;
        this.buf = new Object[n2];
        this.seq = new long[n2];
        for (int i = 0; i < n2; ++i) {
            SEQ.setVolatile(this.seq, i, i);
        }
    }

    public int size() {
        long currentTail;
        long before;
        long after = HEAD.getVolatile(this);
        do {
            before = after;
            currentTail = TAIL.getVolatile(this);
        } while (before != (after = HEAD.getVolatile(this)));
        long size = MpmcArrayQueue.safeDiff(currentTail, after);
        return (int)MathUtil.clamp(size, 0L, 0x80000000L);
    }

    public boolean isEmpty() {
        long currentTail;
        long before;
        long after = HEAD.getVolatile(this);
        do {
            before = after;
            currentTail = TAIL.getVolatile(this);
        } while (before != (after = HEAD.getVolatile(this)));
        return currentTail == after;
    }

    public boolean isFull() {
        long currentTail;
        long before;
        long after = HEAD.getVolatile(this);
        do {
            before = after;
            currentTail = TAIL.getVolatile(this);
        } while (before != (after = HEAD.getVolatile(this)));
        return currentTail == MpmcArrayQueue.safeNext(after + this.mask);
    }

    @Override
    @Nullable
    public E acquire() {
        int curPos;
        long mask = this.mask;
        long[] seq = this.seq;
        long curHead = HEAD.getVolatile(this);
        while (true) {
            long curSeq;
            long diff;
            if ((diff = MpmcArrayQueue.safeDiff(curSeq = SEQ.getVolatile(seq, curPos = (int)(curHead & mask)), curHead)) <= 0L) {
                long curTail = TAIL.getVolatile(this);
                if (MpmcArrayQueue.safeDiff(curHead, curTail) < 0L) continue;
                return null;
            }
            if (diff == 1L) {
                if (HEAD.compareAndSet(this, curHead, MpmcArrayQueue.safeNext(curHead))) break;
                curHead = MpmcArrayQueue.safeNext(curHead);
                continue;
            }
            curHead = HEAD.getVolatile(this);
        }
        E instance = this.buf[curPos];
        this.buf[curPos] = null;
        SEQ.setRelease(seq, curPos, MpmcArrayQueue.safeNext(curHead + mask));
        return instance;
    }

    @Override
    public boolean release(@NonNull E instance) {
        int curPos;
        Objects.requireNonNull(instance);
        long mask = this.mask;
        long[] seq = this.seq;
        long curTail = TAIL.getVolatile(this);
        while (true) {
            long curSeq;
            long diff;
            if ((diff = MpmcArrayQueue.safeDiff(curSeq = SEQ.getVolatile(seq, curPos = (int)(curTail & mask)), curTail)) < 0L) {
                long curHead = HEAD.getVolatile(this);
                if (MpmcArrayQueue.safeDiff(curTail, MpmcArrayQueue.safeNext(curHead + mask)) < 0L) continue;
                return false;
            }
            if (diff == 0L) {
                if (TAIL.compareAndSet(this, curTail, MpmcArrayQueue.safeNext(curTail))) break;
                curTail = MpmcArrayQueue.safeNext(curTail);
                continue;
            }
            curTail = TAIL.getVolatile(this);
        }
        this.buf[curPos] = instance;
        SEQ.setRelease(seq, curPos, MpmcArrayQueue.safeNext(curTail));
        return true;
    }

    private static long safeNext(long v) {
        return v + 1L & 0x3FFFFFFFFFFFFFFFL;
    }

    private static long safeDiff(long a, long b) {
        long d2 = a - b;
        if (d2 >= 0x2000000000000000L) {
            return d2 - 0x4000000000000000L;
        }
        if (d2 <= -2305843009213693952L) {
            return d2 + 0x4000000000000000L;
        }
        return d2;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            HEAD = lookup.findVarHandle(HeadPadding.class, "head", Long.TYPE);
            TAIL = lookup.findVarHandle(TailPadding.class, "tail", Long.TYPE);
            SEQ = MethodHandles.arrayElementVarHandle(long[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

