/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.text.TextUtils;
import yslelf.cloudpick.graphics.util.BadParcelableException;
import yslelf.cloudpick.graphics.util.DataSet;
import yslelf.cloudpick.graphics.util.IOStreamParcel;
import yslelf.cloudpick.graphics.util.Parcelable;

public class Parcel {
    private static final byte VAL_NULL = 0;
    private static final byte VAL_BYTE = 1;
    private static final byte VAL_SHORT = 2;
    private static final byte VAL_INT = 3;
    private static final byte VAL_LONG = 4;
    private static final byte VAL_FLOAT = 5;
    private static final byte VAL_DOUBLE = 6;
    private static final byte VAL_BOOLEAN = 7;
    private static final byte VAL_CHAR = 8;
    private static final byte VAL_BYTE_ARRAY = 9;
    private static final byte VAL_SHORT_ARRAY = 10;
    private static final byte VAL_INT_ARRAY = 11;
    private static final byte VAL_LONG_ARRAY = 12;
    private static final byte VAL_FLOAT_ARRAY = 13;
    private static final byte VAL_DOUBLE_ARRAY = 14;
    private static final byte VAL_BOOLEAN_ARRAY = 15;
    private static final byte VAL_CHAR_ARRAY = 16;
    private static final byte VAL_STRING = 17;
    private static final byte VAL_UUID = 19;
    private static final byte VAL_INSTANT = 20;
    private static final byte VAL_DATA_SET = 64;
    private static final byte VAL_PARCELABLE = 65;
    private static final byte VAL_CHAR_SEQUENCE = 66;
    private static final byte VAL_LIST = 68;
    private static final byte VAL_OBJECT_ARRAY = 118;
    private static final byte VAL_SERIALIZABLE = 127;
    private static final ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, Parcelable.Creator<?>>> gCreators = new ConcurrentHashMap();
    protected ByteBuffer mNativeBuffer;

    @ApiStatus.Internal
    public Parcel() {
    }

    @NonNull
    private static DataSet inflate(@NonNull InputStream stream, @Nullable ClassLoader loader) throws IOException {
        DataSet dataSet;
        IOStreamParcel in = new IOStreamParcel(new GZIPInputStream(new BufferedInputStream(stream, 4096)), null);
        try {
            DataSet res = in.readDataSet(loader);
            if (res == null) {
                throw new IOException("Insufficient data");
            }
            dataSet = res;
        }
        catch (Throwable res) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable) {
                    res.addSuppressed(throwable);
                }
                throw res;
            }
            catch (RuntimeException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof IOException) {
                    IOException ioe = (IOException)throwable;
                    throw ioe;
                }
                throw e;
            }
        }
        in.close();
        return dataSet;
    }

    private static void deflate(@NonNull OutputStream stream, @NonNull DataSet source) throws IOException {
        try (IOStreamParcel out = new IOStreamParcel(null, new GZIPOutputStream(new BufferedOutputStream(stream, 4096)));){
            out.writeDataSet(source);
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException ioe = (IOException)throwable;
                throw ioe;
            }
            throw e;
        }
    }

    protected void ensureCapacity(int len) {
        if (this.mNativeBuffer != null && this.mNativeBuffer.remaining() >= len) {
            return;
        }
        long size = (this.mNativeBuffer == null ? 0 : this.mNativeBuffer.limit()) + len;
        if ((size += size >> 1) > Integer.MAX_VALUE) {
            throw new BufferOverflowException();
        }
        this.setCapacity((int)Math.max(size, 128L));
    }

    protected void setCapacity(int size) {
        if (this.mNativeBuffer != null && this.mNativeBuffer.capacity() >= size) {
            this.mNativeBuffer.limit(size);
        } else {
            this.mNativeBuffer = this.mNativeBuffer == null ? MemoryUtil.memAlloc((int)size) : MemoryUtil.memRealloc((ByteBuffer)this.mNativeBuffer, (int)size);
        }
    }

    public int position() {
        return this.mNativeBuffer == null ? 0 : this.mNativeBuffer.position();
    }

    public void position(int newPosition) {
        this.ensureCapacity(0);
        this.mNativeBuffer.position(newPosition);
    }

    public int limit() {
        return this.mNativeBuffer == null ? 0 : this.mNativeBuffer.limit();
    }

    public void limit(int newLimit) {
        this.ensureCapacity(0);
        this.mNativeBuffer.limit(newLimit);
    }

    public int capacity() {
        return this.mNativeBuffer == null ? 0 : this.mNativeBuffer.capacity();
    }

    public void writeBytes(byte[] src) {
        this.writeBytes(src, 0, src.length);
    }

    public void writeBytes(byte[] src, int off, int len) {
        this.ensureCapacity(len);
        this.mNativeBuffer.put(src, off, len);
    }

    public void writeBoolean(boolean b) {
        this.writeByte(b ? 1 : 0);
    }

    public void writeChar(int v) {
        this.writeShort(v);
    }

    public void writeByte(int v) {
        this.ensureCapacity(1);
        this.mNativeBuffer.put((byte)v);
    }

    public void writeShort(int v) {
        this.ensureCapacity(2);
        this.mNativeBuffer.putShort((short)v);
    }

    public void writeInt(int v) {
        this.ensureCapacity(4);
        this.mNativeBuffer.putInt(v);
    }

    public void writeLong(long v) {
        this.ensureCapacity(8);
        this.mNativeBuffer.putLong(v);
    }

    public void writeFloat(float v) {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    public void writeDouble(double v) {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    public void readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
    }

    public void readBytes(byte[] dst, int off, int len) {
        if (this.mNativeBuffer == null) {
            throw new BufferUnderflowException();
        }
        this.mNativeBuffer.get(dst, off, len);
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public char readChar() {
        return (char)this.readShort();
    }

    public byte readByte() {
        if (this.mNativeBuffer == null) {
            throw new BufferUnderflowException();
        }
        return this.mNativeBuffer.get();
    }

    public short readShort() {
        if (this.mNativeBuffer == null) {
            throw new BufferUnderflowException();
        }
        return this.mNativeBuffer.getShort();
    }

    public int readInt() {
        if (this.mNativeBuffer == null) {
            throw new BufferUnderflowException();
        }
        return this.mNativeBuffer.getInt();
    }

    public long readLong() {
        if (this.mNativeBuffer == null) {
            throw new BufferUnderflowException();
        }
        return this.mNativeBuffer.getLong();
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public void writeValue(@Nullable Object v) {
        if (v == null) {
            this.writeByte(0);
        } else if (v instanceof String) {
            this.writeByte(17);
            this.writeString((String)v);
        } else if (v instanceof Integer) {
            this.writeByte(3);
            this.writeInt((Integer)v);
        } else if (v instanceof Long) {
            this.writeByte(4);
            this.writeLong((Long)v);
        } else if (v instanceof Float) {
            this.writeByte(5);
            this.writeFloat(((Float)v).floatValue());
        } else if (v instanceof Double) {
            this.writeByte(6);
            this.writeDouble((Double)v);
        } else if (v instanceof Byte) {
            this.writeByte(1);
            this.writeByte(((Byte)v).byteValue());
        } else if (v instanceof Short) {
            this.writeByte(2);
            this.writeShort(((Short)v).shortValue());
        } else if (v instanceof Character) {
            this.writeByte(8);
            this.writeChar(((Character)v).charValue());
        } else if (v instanceof Boolean) {
            this.writeByte(7);
            this.writeBoolean((Boolean)v);
        } else if (v instanceof UUID) {
            this.writeByte(19);
            this.writeUUID((UUID)v);
        } else if (v instanceof Instant) {
            this.writeByte(20);
            this.writeInstant((Instant)v);
        } else if (v instanceof int[]) {
            this.writeByte(11);
            this.writeIntArray((int[])v);
        } else if (v instanceof byte[]) {
            this.writeByte(9);
            this.writeByteArray((byte[])v);
        } else if (v instanceof char[]) {
            this.writeByte(16);
            this.writeCharArray((char[])v);
        } else if (v instanceof DataSet) {
            this.writeByte(64);
            this.writeDataSet((DataSet)v);
        } else if (v instanceof Parcelable) {
            this.writeByte(65);
            this.writeParcelable((Parcelable)v, 0);
        } else if (v instanceof CharSequence) {
            this.writeByte(66);
            this.writeCharSequence((CharSequence)v);
        } else if (v instanceof List) {
            this.writeByte(68);
            this.writeList((List)v);
        } else if (v instanceof long[]) {
            this.writeByte(12);
            this.writeLongArray((long[])v);
        } else if (v instanceof short[]) {
            this.writeByte(10);
            this.writeShortArray((short[])v);
        } else if (v instanceof float[]) {
            this.writeByte(13);
            this.writeFloatArray((float[])v);
        } else if (v instanceof double[]) {
            this.writeByte(14);
            this.writeDoubleArray((double[])v);
        } else if (v instanceof boolean[]) {
            this.writeByte(15);
            this.writeBooleanArray((boolean[])v);
        } else {
            Class<?> clazz = v.getClass();
            if (clazz.isArray() && clazz.getComponentType() == Object.class) {
                this.writeByte(118);
                this.writeArray((Object[])v);
            } else if (v instanceof Serializable) {
                Serializable value = (Serializable)v;
                this.writeByte(127);
                String name = value.getClass().getName();
                this.writeString(name);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(value);
                    oos.close();
                    this.writeByteArray(baos.toByteArray());
                }
                catch (IOException ioe) {
                    throw new BadParcelableException("Parcelable encountered IOException writing serializable object (name = " + name + ")", ioe);
                }
            }
        }
    }

    @Nullable
    public <T> T readValue(@Nullable ClassLoader loader, @Nullable Class<T> clazz, @Nullable Class<?> elemType) {
        byte type = this.readByte();
        Object object = switch (type) {
            case 0 -> null;
            case 1 -> (Object)this.readByte();
            case 2 -> (Object)this.readShort();
            case 3 -> (Object)this.readInt();
            case 4 -> (Object)this.readLong();
            case 5 -> (Object)Float.valueOf(this.readFloat());
            case 6 -> (Object)this.readDouble();
            case 7 -> (Object)this.readBoolean();
            case 8 -> (Object)Character.valueOf(this.readChar());
            case 9 -> this.readByteArray();
            case 10 -> (Object)this.readShortArray();
            case 11 -> (Object)this.readIntArray();
            case 12 -> (Object)this.readLongArray();
            case 13 -> (Object)this.readFloatArray();
            case 14 -> (Object)this.readDoubleArray();
            case 15 -> (Object)this.readBooleanArray();
            case 16 -> (Object)this.readCharArray();
            case 17 -> (Object)this.readString();
            case 19 -> (Object)this.readUUID();
            case 20 -> (Object)this.readInstant();
            case 64 -> (Object)this.readDataSet(loader);
            case 65 -> (Object)this.readParcelable0(loader, clazz);
            case 66 -> (Object)this.readCharSequence();
            case 68 -> (Object)this.readList(loader, elemType);
            case 118 -> {
                if (elemType == null) {
                    elemType = Object.class;
                }
                if (clazz != null) {
                    if (!clazz.isArray()) {
                        throw new BadParcelableException("About to read an array but type " + clazz.getCanonicalName() + " required by caller is not an array.");
                    }
                    TypeDescriptor.OfField itemArrayType = elemType.arrayType();
                    if (!clazz.isAssignableFrom((Class<?>)itemArrayType)) {
                        throw new BadParcelableException("About to read a " + ((Class)itemArrayType).getCanonicalName() + ", which is not a subtype of type " + clazz.getCanonicalName() + " required by caller.");
                    }
                }
                yield (Object)this.readArray(loader, elemType);
            }
            default -> throw new BadParcelableException("Unknown value type identifier: " + type);
        };
        if (object != null && clazz != null && !clazz.isInstance(object)) {
            throw new BadParcelableException("Deserialized object " + object + " is not an instance of required class " + clazz.getName() + " provided in the parameter");
        }
        return (T)object;
    }

    public final void writeParcelable(@Nullable Parcelable p2, int parcelableFlags) {
        if (p2 == null) {
            this.writeString(null);
            return;
        }
        this.writeParcelableCreator(p2);
        p2.writeToParcel(this, parcelableFlags);
    }

    public final void writeParcelableCreator(@NonNull Parcelable p2) {
        String name = p2.getClass().getName();
        this.writeString(name);
    }

    @Nullable
    public <T> T readParcelable(@Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        return this.readParcelable0(loader, Objects.requireNonNull(clazz));
    }

    @Nullable
    public <T> T readParcelable0(@Nullable ClassLoader loader, @Nullable Class<T> clazz) {
        Parcelable.Creator<T> creator = this.readParcelableCreator0(loader, clazz);
        if (creator == null) {
            return null;
        }
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            return ((Parcelable.ClassLoaderCreator)creator).createFromParcel(this, loader);
        }
        return creator.createFromParcel(this);
    }

    @Nullable
    public <T> Parcelable.Creator<T> readParcelableCreator(@Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        return this.readParcelableCreator0(loader, Objects.requireNonNull(clazz));
    }

    @Nullable
    private <T> Parcelable.Creator<T> readParcelableCreator0(@Nullable ClassLoader loader, @Nullable Class<T> clazz) {
        String name = this.readString();
        if (name == null) {
            return null;
        }
        ConcurrentHashMap map = gCreators.computeIfAbsent(loader, __ -> new ConcurrentHashMap());
        Parcelable.Creator creator = (Parcelable.Creator)map.get(name);
        if (creator != null) {
            Class<?> target;
            if (clazz != null && !clazz.isAssignableFrom(target = creator.getClass().getEnclosingClass())) {
                throw new BadParcelableException("Parcelable creator " + name + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
            }
            return creator;
        }
        try {
            Class<?> target = (loader == null ? Parcel.class.getClassLoader() : loader).loadClass(name);
            if (!Parcelable.class.isAssignableFrom(target)) {
                throw new BadParcelableException("Parcelable protocol requires subclassing from Parcelable on class " + name);
            }
            if (clazz != null && !clazz.isAssignableFrom(target)) {
                throw new BadParcelableException("Parcelable creator " + name + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
            }
            Field f2 = target.getField("CREATOR");
            if ((f2.getModifiers() & 8) == 0) {
                throw new BadParcelableException("Parcelable protocol requires the CREATOR object to be static on class " + name);
            }
            if (!Parcelable.Creator.class.isAssignableFrom(f2.getType())) {
                throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
            }
            creator = (Parcelable.Creator)f2.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name, e);
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (creator == null) {
            throw new BadParcelableException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + name);
        }
        map.put(name, creator);
        return creator;
    }

    public void writeByteArray(@Nullable byte[] b) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(b.length);
        this.writeBytes(b);
    }

    public void writeByteArray(@Nullable byte[] b, int off, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(len);
        this.writeBytes(b, off, len);
    }

    @Nullable
    public byte[] readByteArray() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        byte[] b = new byte[n2];
        this.readBytes(b, 0, n2);
        return b;
    }

    public void writeShortArray(@Nullable short[] value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(value.length);
        for (short e : value) {
            this.writeShort(e);
        }
    }

    @Nullable
    public short[] readShortArray() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        short[] value = new short[n2];
        for (int i = 0; i < n2; ++i) {
            value[i] = this.readShort();
        }
        return value;
    }

    public void writeIntArray(@Nullable int[] value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(value.length);
        for (int e : value) {
            this.writeInt(e);
        }
    }

    @Nullable
    public int[] readIntArray() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        int[] value = new int[n2];
        for (int i = 0; i < n2; ++i) {
            value[i] = this.readInt();
        }
        return value;
    }

    public void writeLongArray(@Nullable long[] value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(value.length);
        for (long e : value) {
            this.writeLong(e);
        }
    }

    @Nullable
    public long[] readLongArray() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        long[] value = new long[n2];
        for (int i = 0; i < n2; ++i) {
            value[i] = this.readLong();
        }
        return value;
    }

    public void writeFloatArray(@Nullable float[] value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(value.length);
        for (float e : value) {
            this.writeFloat(e);
        }
    }

    @Nullable
    public float[] readFloatArray() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        float[] value = new float[n2];
        for (int i = 0; i < n2; ++i) {
            value[i] = this.readFloat();
        }
        return value;
    }

    public void writeDoubleArray(@Nullable double[] value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(value.length);
        for (double e : value) {
            this.writeDouble(e);
        }
    }

    @Nullable
    public double[] readDoubleArray() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        double[] value = new double[n2];
        for (int i = 0; i < n2; ++i) {
            value[i] = this.readDouble();
        }
        return value;
    }

    public void writeBooleanArray(@Nullable boolean[] value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(value.length);
        for (boolean e : value) {
            this.writeBoolean(e);
        }
    }

    @Nullable
    public boolean[] readBooleanArray() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        boolean[] value = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            value[i] = this.readBoolean();
        }
        return value;
    }

    public void writeCharArray(@Nullable char[] value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(value.length);
        for (char e : value) {
            this.writeChar(e);
        }
    }

    @Nullable
    public char[] readCharArray() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        char[] value = new char[n2];
        for (int i = 0; i < n2; ++i) {
            value[i] = this.readChar();
        }
        return value;
    }

    public void writeArray(@Nullable Object[] a) {
        if (a == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(a.length);
        for (Object e : a) {
            this.writeValue(e);
        }
    }

    @Nullable
    public <T> T[] readArray(@Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        Object a = clazz == Object.class ? new Object[n2] : Array.newInstance(clazz, n2);
        for (int i = 0; i < n2; ++i) {
            T value = this.readValue(loader, clazz, null);
            a[i] = value;
        }
        return a;
    }

    public void writeString(@Nullable String s) {
        this.writeString16(s);
    }

    public void writeString8(@Nullable String s) {
        if (s == null) {
            this.writeInt(-1);
        } else {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            this.writeInt(bytes.length);
            this.writeBytes(bytes);
        }
    }

    public void writeString16(@Nullable String s) {
        if (s == null) {
            this.writeInt(-1);
        } else {
            int len = s.length();
            this.writeInt(len);
            for (int i = 0; i < len; ++i) {
                this.writeChar(s.charAt(i));
            }
        }
    }

    @Nullable
    public String readString() {
        return this.readString16();
    }

    @Nullable
    public String readString8() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        byte[] bytes = new byte[n2];
        this.readBytes(bytes, 0, n2);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Nullable
    public String readString16() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        char[] value = new char[n2];
        for (int i = 0; i < n2; ++i) {
            value[i] = this.readChar();
        }
        return new String(value);
    }

    public void writeCharSequence(@Nullable CharSequence cs) {
        TextUtils.writeToParcel(cs, this, 0);
    }

    @Nullable
    public CharSequence readCharSequence() {
        return TextUtils.createFromParcel(this);
    }

    public void writeList(@Nullable List<?> list) {
        if (list == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(list.size());
        for (Object e : list) {
            this.writeValue(e);
        }
    }

    @Nullable
    private <T> List<T> readList(@Nullable ClassLoader loader, @Nullable Class<? extends T> clazz) {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        ArrayList<T> res = new ArrayList<T>(n2);
        while (n2-- != 0) {
            res.add(this.readValue(loader, clazz, null));
        }
        return res;
    }

    public void writeDataSet(@Nullable DataSet source) {
        if (source == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(source.size());
        DataSet.FastEntryIterator it = source.new DataSet.FastEntryIterator();
        while (it.hasNext()) {
            Object e = it.next();
            this.writeString((String)e.getKey());
            this.writeValue(e.getValue());
        }
    }

    @Nullable
    public DataSet readDataSet(@Nullable ClassLoader loader) {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        DataSet res = new DataSet(n2);
        while (n2-- != 0) {
            res.put(this.readString(), this.readValue(loader, null, null));
        }
        return res;
    }

    public void writeUUID(@NonNull UUID value) {
        this.writeLong(value.getMostSignificantBits());
        this.writeLong(value.getLeastSignificantBits());
    }

    @NonNull
    public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    public void writeInstant(@NonNull Instant value) {
        this.writeLong(value.getEpochSecond());
        this.writeInt(value.getNano());
    }

    @NonNull
    public Instant readInstant() {
        return Instant.ofEpochSecond(this.readLong(), this.readInt());
    }

    @ApiStatus.Internal
    public void freeData() {
        if (this.mNativeBuffer != null) {
            MemoryUtil.memFree((Buffer)this.mNativeBuffer);
            this.mNativeBuffer = null;
        }
    }
}

