/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.util;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.text.GetChars;

@ApiStatus.Experimental
public record StringView(@NonNull String string, int offset, int length) implements Comparable<CharSequence>,
CharSequence,
GetChars
{
    public StringView(@NonNull String string, int offset, int length) {
        this.offset = Objects.checkFromIndexSize(offset, length, string.length());
        this.string = string;
        this.length = length;
    }

    @Override
    public char charAt(int index) {
        assert (index < this.length);
        return this.string.charAt(index + this.offset);
    }

    @Override
    @NonNull
    public CharSequence subSequence(int start, int end) {
        Objects.checkFromToIndex(start, end, this.length);
        if (start == 0 && end == this.length) {
            return this;
        }
        return new StringView(this.string, this.offset + start, end - start);
    }

    @Override
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        Objects.checkFromToIndex(srcBegin, srcEnd, this.length);
        this.string.getChars(this.offset + srcBegin, this.offset + srcEnd, dst, dstBegin);
    }

    @Override
    public int hashCode() {
        int i;
        int h2 = 0;
        int e = i + this.length;
        for (i = this.offset; i < e; ++i) {
            h2 = 31 * h2 + this.string.charAt(i);
        }
        return h2;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof String) {
            String s = (String)obj;
            return this.length == s.length() && this.string.startsWith(s, this.offset);
        }
        if (obj instanceof StringView) {
            StringView sv = (StringView)obj;
            return this.length == sv.length && this.string.regionMatches(this.offset, sv.string, sv.offset, this.length);
        }
        if (obj instanceof CharSequence) {
            CharSequence csq = (CharSequence)obj;
            if (this.length != csq.length()) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.charAt(i) == csq.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public String toString() {
        return this.string.substring(this.offset, this.offset + this.length);
    }

    @Override
    public int compareTo(@NonNull CharSequence o) {
        if (this == o) {
            return 0;
        }
        int s = Math.min(this.length, o.length());
        for (int i = 0; i < s; ++i) {
            char b;
            char a = this.charAt(i);
            if (a == (b = o.charAt(i))) continue;
            return a - b;
        }
        return this.length - o.length();
    }
}

