/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view;

import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.view.MenuItem;
import yslelf.cloudpick.graphics.view.SubMenu;
import yslelf.cloudpick.graphics.view.View;

public abstract class ActionProvider {
    private static final Marker MARKER = MarkerManager.getMarker((String)"ActionProvider");
    private SubUiVisibilityListener mSubUiVisibilityListener;
    private VisibilityListener mVisibilityListener;

    public abstract View onCreateActionView(MenuItem var1);

    public boolean overridesItemVisibility() {
        return false;
    }

    public boolean isVisible() {
        return true;
    }

    public void refreshVisibility() {
        if (this.mVisibilityListener != null && this.overridesItemVisibility()) {
            this.mVisibilityListener.onActionProviderVisibilityChanged(this.isVisible());
        }
    }

    public boolean onPerformDefaultAction() {
        return false;
    }

    public boolean hasSubMenu() {
        return false;
    }

    public void onPrepareSubMenu(SubMenu subMenu) {
    }

    public void subUiVisibilityChanged(boolean isVisible) {
        if (this.mSubUiVisibilityListener != null) {
            this.mSubUiVisibilityListener.onSubUiVisibilityChanged(isVisible);
        }
    }

    @ApiStatus.Internal
    public void setSubUiVisibilityListener(SubUiVisibilityListener listener) {
        this.mSubUiVisibilityListener = listener;
    }

    public void setVisibilityListener(VisibilityListener listener) {
        if (this.mVisibilityListener != null) {
            CloudPick.LOGGER.warn(MARKER, "setVisibilityListener: Setting a new ActionProvider.VisibilityListener when one is already set. Are you reusing this {} instance while it is still in use somewhere else?", (Object)this.getClass().getSimpleName());
        }
        this.mVisibilityListener = listener;
    }

    @ApiStatus.Internal
    public void reset() {
        this.mVisibilityListener = null;
        this.mSubUiVisibilityListener = null;
    }

    @FunctionalInterface
    public static interface VisibilityListener {
        public void onActionProviderVisibilityChanged(boolean var1);
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface SubUiVisibilityListener {
        public void onSubUiVisibilityChanged(boolean var1);
    }
}

