/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view;

import yslelf.cloudpick.graphics.annotation.NonNull;

public class MeasureSpec {
    private static final int MODE_SHIFT = 30;
    private static final int MODE_MASK = -1073741824;
    public static final int UNSPECIFIED = 0;
    public static final int EXACTLY = 0x40000000;
    public static final int AT_MOST = Integer.MIN_VALUE;

    public static int makeMeasureSpec(int size, int mode) {
        return size & 0x3FFFFFFF | mode & 0xC0000000;
    }

    public static int getSize(int measureSpec) {
        return measureSpec & 0x3FFFFFFF;
    }

    public static int getMode(int measureSpec) {
        return measureSpec & 0xC0000000;
    }

    @NonNull
    public static String toString(int measureSpec) {
        int mode = MeasureSpec.getMode(measureSpec);
        int size = MeasureSpec.getSize(measureSpec);
        StringBuilder sb = new StringBuilder("MeasureSpec: ");
        switch (mode) {
            case 0: {
                sb.append("UNSPECIFIED ");
                break;
            }
            case 0x40000000: {
                sb.append("EXACTLY ");
                break;
            }
            case -2147483648: {
                sb.append("AT_MOST ");
                break;
            }
            default: {
                sb.append(mode).append(" ");
            }
        }
        sb.append(size);
        return sb.toString();
    }
}

