/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.util.ColorStateList;
import yslelf.cloudpick.graphics.view.ActionProvider;
import yslelf.cloudpick.graphics.view.ContextMenu;
import yslelf.cloudpick.graphics.view.KeyEvent;
import yslelf.cloudpick.graphics.view.Menu;
import yslelf.cloudpick.graphics.view.SubMenu;
import yslelf.cloudpick.graphics.view.View;

public interface MenuItem {
    public static final int SHOW_AS_ACTION_NEVER = 0;
    public static final int SHOW_AS_ACTION_IF_ROOM = 1;
    public static final int SHOW_AS_ACTION_ALWAYS = 2;
    public static final int SHOW_AS_ACTION_WITH_TEXT = 4;
    public static final int SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW = 8;

    public int getItemId();

    public int getGroupId();

    public int getOrder();

    public MenuItem setTitle(CharSequence var1);

    public CharSequence getTitle();

    public MenuItem setTitleCondensed(CharSequence var1);

    public CharSequence getTitleCondensed();

    public MenuItem setIcon(Drawable var1);

    public Drawable getIcon();

    default public MenuItem setIconTintList(@Nullable ColorStateList tint) {
        return this;
    }

    @Nullable
    default public ColorStateList getIconTintList() {
        return null;
    }

    public MenuItem setShortcut(char var1, char var2);

    default public MenuItem setShortcut(char numericChar, char alphaChar, int numericModifiers, int alphaModifiers) {
        if ((alphaModifiers & Menu.SUPPORTED_MODIFIERS_MASK) == KeyEvent.META_CTRL_ON && (numericModifiers & Menu.SUPPORTED_MODIFIERS_MASK) == KeyEvent.META_CTRL_ON) {
            return this.setShortcut(numericChar, alphaChar);
        }
        return this;
    }

    public MenuItem setNumericShortcut(char var1);

    default public MenuItem setNumericShortcut(char numericChar, int numericModifiers) {
        if ((numericModifiers & Menu.SUPPORTED_MODIFIERS_MASK) == KeyEvent.META_CTRL_ON) {
            return this.setNumericShortcut(numericChar);
        }
        return this;
    }

    public char getNumericShortcut();

    default public int getNumericModifiers() {
        return KeyEvent.META_CTRL_ON;
    }

    public MenuItem setAlphabeticShortcut(char var1);

    default public MenuItem setAlphabeticShortcut(char alphaChar, int alphaModifiers) {
        if ((alphaModifiers & Menu.SUPPORTED_MODIFIERS_MASK) == KeyEvent.META_CTRL_ON) {
            return this.setAlphabeticShortcut(alphaChar);
        }
        return this;
    }

    public char getAlphabeticShortcut();

    default public int getAlphabeticModifiers() {
        return KeyEvent.META_CTRL_ON;
    }

    public MenuItem setCheckable(boolean var1);

    public boolean isCheckable();

    public MenuItem setChecked(boolean var1);

    public boolean isChecked();

    public MenuItem setVisible(boolean var1);

    public boolean isVisible();

    public MenuItem setEnabled(boolean var1);

    public boolean isEnabled();

    public boolean hasSubMenu();

    public SubMenu getSubMenu();

    public MenuItem setOnMenuItemClickListener(OnMenuItemClickListener var1);

    @Nullable
    public ContextMenu.ContextMenuInfo getMenuInfo();

    public void setShowAsAction(int var1);

    public MenuItem setShowAsActionFlags(int var1);

    public MenuItem setActionView(View var1);

    public View getActionView();

    public MenuItem setActionProvider(ActionProvider var1);

    public ActionProvider getActionProvider();

    public boolean expandActionView();

    public boolean collapseActionView();

    public boolean isActionViewExpanded();

    public MenuItem setOnActionExpandListener(OnActionExpandListener var1);

    default public MenuItem setContentDescription(CharSequence contentDescription) {
        return this;
    }

    default public CharSequence getContentDescription() {
        return null;
    }

    default public MenuItem setTooltipText(CharSequence tooltipText) {
        return this;
    }

    default public CharSequence getTooltipText() {
        return null;
    }

    @ApiStatus.Internal
    default public boolean requiresActionButton() {
        return false;
    }

    @ApiStatus.Internal
    default public boolean requiresOverflow() {
        return true;
    }

    public static interface OnActionExpandListener {
        public boolean onMenuItemActionExpand(@NonNull MenuItem var1);

        public boolean onMenuItemActionCollapse(@NonNull MenuItem var1);
    }

    @FunctionalInterface
    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(@NonNull MenuItem var1);
    }
}

