/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.view.MeasureSpec;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.WindowManager;
import yslelf.cloudpick.graphics.widget.TextView;

@ApiStatus.Internal
public class TooltipPopup {
    private final Context mContext;
    private final TextView mTextView;
    private final WindowManager.LayoutParams mParams;
    private final int[] mTmpAnchorPos = new int[2];

    public TooltipPopup(Context context) {
        this.mContext = context;
        this.mTextView = new TextView(context);
        TypedValue value = new TypedValue();
        if (context.getTheme().resolveAttribute("modernui", "textAppearanceBodySmall", value, true)) {
            this.mTextView.setTextAppearance(value.getResourceId());
        }
        if (context.getTheme().resolveAttribute("modernui", "colorOnSurfaceInverse", value, true)) {
            this.mTextView.setTextColor(value.data);
        }
        this.mTextView.setGravity(16);
        this.mParams = new WindowManager.LayoutParams();
        this.mParams.width = -2;
        this.mParams.height = -2;
        this.mParams.flags = 8;
        this.mParams.type = 1005;
        ShapeDrawable background = new ShapeDrawable();
        background.setShape(0);
        if (context.getTheme().resolveAttribute("modernui", "colorSurfaceInverse", value, true)) {
            background.setColor(value.data);
        }
        background.setCornerRadius(this.mTextView.dp(4.0f));
        this.mTextView.setBackground(background);
    }

    public void show(View anchorView, int anchorX, int anchorY, boolean fromTouch, CharSequence tooltipText) {
        if (this.isShowing()) {
            this.hide();
        }
        this.mTextView.setText(tooltipText);
        this.mTextView.setMaxWidth(Math.min(anchorView.getRootView().getMeasuredWidth() / 2, this.mTextView.dp(512.0f)));
        this.mTextView.setMinHeight(this.mTextView.dp(24.0f));
        this.mTextView.setPadding(this.mTextView.dp(8.0f), this.mTextView.dp(4.0f), this.mTextView.dp(8.0f), this.mTextView.dp(4.0f));
        this.computePosition(anchorView, anchorX, anchorY, fromTouch, this.mParams);
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        assert (wm != null);
        wm.addView(this.mTextView, this.mParams);
    }

    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        assert (wm != null);
        wm.removeView(this.mTextView);
    }

    public View getContentView() {
        return this.mTextView;
    }

    public boolean isShowing() {
        return this.mTextView.getParent() != null;
    }

    private void computePosition(View anchorView, int anchorX, int anchorY, boolean fromTouch, WindowManager.LayoutParams outParams) {
        int offsetAbove;
        int offsetBelow;
        int tooltipPreciseAnchorThreshold = this.mTextView.dp(96.0f);
        int offsetX = anchorView.getWidth() >= tooltipPreciseAnchorThreshold ? anchorX : anchorView.getWidth() / 2;
        if (anchorView.getHeight() >= tooltipPreciseAnchorThreshold) {
            int offsetExtra = this.mTextView.dp(8.0f);
            offsetBelow = anchorY + offsetExtra;
            offsetAbove = anchorY - offsetExtra;
        } else {
            offsetBelow = anchorView.getHeight();
            offsetAbove = 0;
        }
        outParams.gravity = 49;
        int tooltipOffset = fromTouch ? this.mTextView.dp(16.0f) : 0;
        View appView = anchorView.getRootView();
        anchorView.getLocationOnScreen(this.mTmpAnchorPos);
        outParams.x = this.mTmpAnchorPos[0] + offsetX - appView.getMeasuredWidth() / 2;
        int spec = MeasureSpec.makeMeasureSpec(0, 0);
        this.mTextView.measure(spec, spec);
        int tooltipHeight = this.mTextView.getMeasuredHeight();
        int yAbove = this.mTmpAnchorPos[1] + offsetAbove - tooltipOffset - tooltipHeight;
        int yBelow = this.mTmpAnchorPos[1] + offsetBelow + tooltipOffset;
        outParams.y = fromTouch ? (yAbove >= 0 ? yAbove : yBelow) : (yBelow + tooltipHeight <= appView.getMeasuredHeight() ? yBelow : yAbove);
    }
}

