/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.view.View;

public final class ViewTreeObserver {
    private CopyOnWriteArrayList<OnGlobalFocusChangeListener> mOnGlobalFocusListeners;
    private CopyOnWriteArray<OnGlobalLayoutListener> mOnGlobalLayoutListeners;
    private CopyOnWriteArray<OnPreDrawListener> mOnPreDrawListeners;
    private CopyOnWriteArray<OnScrollChangedListener> mOnScrollChangedListeners;
    private boolean mAlive = true;

    ViewTreeObserver() {
    }

    void merge(@NonNull ViewTreeObserver observer) {
        if (observer.mOnGlobalFocusListeners != null) {
            if (this.mOnGlobalFocusListeners != null) {
                this.mOnGlobalFocusListeners.addAll(observer.mOnGlobalFocusListeners);
            } else {
                this.mOnGlobalFocusListeners = observer.mOnGlobalFocusListeners;
            }
        }
        if (observer.mOnGlobalLayoutListeners != null) {
            if (this.mOnGlobalLayoutListeners != null) {
                this.mOnGlobalLayoutListeners.addAll(observer.mOnGlobalLayoutListeners);
            } else {
                this.mOnGlobalLayoutListeners = observer.mOnGlobalLayoutListeners;
            }
        }
        if (observer.mOnPreDrawListeners != null) {
            if (this.mOnPreDrawListeners != null) {
                this.mOnPreDrawListeners.addAll(observer.mOnPreDrawListeners);
            } else {
                this.mOnPreDrawListeners = observer.mOnPreDrawListeners;
            }
        }
        if (observer.mOnScrollChangedListeners != null) {
            if (this.mOnScrollChangedListeners != null) {
                this.mOnScrollChangedListeners.addAll(observer.mOnScrollChangedListeners);
            } else {
                this.mOnScrollChangedListeners = observer.mOnScrollChangedListeners;
            }
        }
        observer.kill();
    }

    public void addOnGlobalFocusChangeListener(@NonNull OnGlobalFocusChangeListener listener) {
        this.checkIsAlive();
        if (this.mOnGlobalFocusListeners == null) {
            this.mOnGlobalFocusListeners = new CopyOnWriteArrayList();
        }
        this.mOnGlobalFocusListeners.add(listener);
    }

    public void removeOnGlobalFocusChangeListener(@NonNull OnGlobalFocusChangeListener victim) {
        this.checkIsAlive();
        if (this.mOnGlobalFocusListeners == null) {
            return;
        }
        this.mOnGlobalFocusListeners.remove(victim);
    }

    public void addOnGlobalLayoutListener(@NonNull OnGlobalLayoutListener listener) {
        this.checkIsAlive();
        if (this.mOnGlobalLayoutListeners == null) {
            this.mOnGlobalLayoutListeners = new CopyOnWriteArray();
        }
        this.mOnGlobalLayoutListeners.add(listener);
    }

    public void removeOnGlobalLayoutListener(@NonNull OnGlobalLayoutListener victim) {
        this.checkIsAlive();
        if (this.mOnGlobalLayoutListeners == null) {
            return;
        }
        this.mOnGlobalLayoutListeners.remove(victim);
    }

    public void addOnPreDrawListener(@NonNull OnPreDrawListener listener) {
        this.checkIsAlive();
        if (this.mOnPreDrawListeners == null) {
            this.mOnPreDrawListeners = new CopyOnWriteArray();
        }
        this.mOnPreDrawListeners.add(listener);
    }

    public void removeOnPreDrawListener(@NonNull OnPreDrawListener victim) {
        this.checkIsAlive();
        if (this.mOnPreDrawListeners == null) {
            return;
        }
        this.mOnPreDrawListeners.remove(victim);
    }

    public void addOnScrollChangedListener(@NonNull OnScrollChangedListener listener) {
        this.checkIsAlive();
        if (this.mOnScrollChangedListeners == null) {
            this.mOnScrollChangedListeners = new CopyOnWriteArray();
        }
        this.mOnScrollChangedListeners.add(listener);
    }

    public void removeOnScrollChangedListener(@NonNull OnScrollChangedListener victim) {
        this.checkIsAlive();
        if (this.mOnScrollChangedListeners == null) {
            return;
        }
        this.mOnScrollChangedListeners.remove(victim);
    }

    private void checkIsAlive() {
        if (!this.mAlive) {
            throw new IllegalStateException("This ViewTreeObserver is not alive, call getViewTreeObserver() again");
        }
    }

    public boolean isAlive() {
        return this.mAlive;
    }

    private void kill() {
        this.mAlive = false;
    }

    void dispatchOnGlobalFocusChange(@Nullable View oldFocus, @Nullable View newFocus) {
        CopyOnWriteArrayList<OnGlobalFocusChangeListener> listeners = this.mOnGlobalFocusListeners;
        if (listeners != null && listeners.size() > 0) {
            for (OnGlobalFocusChangeListener listener : listeners) {
                listener.onGlobalFocusChanged(oldFocus, newFocus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchOnGlobalLayout() {
        CopyOnWriteArray<OnGlobalLayoutListener> listeners = this.mOnGlobalLayoutListeners;
        if (listeners != null && listeners.size() > 0) {
            CopyOnWriteArray.Access<OnGlobalLayoutListener> access = listeners.start();
            try {
                int count = access.size();
                for (int i = 0; i < count; ++i) {
                    access.get(i).onGlobalLayout();
                }
            }
            finally {
                listeners.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchOnPreDraw() {
        boolean cancelDraw = false;
        CopyOnWriteArray<OnPreDrawListener> listeners = this.mOnPreDrawListeners;
        if (listeners != null && listeners.size() > 0) {
            CopyOnWriteArray.Access<OnPreDrawListener> access = listeners.start();
            try {
                int count = access.size();
                for (int i = 0; i < count; ++i) {
                    cancelDraw |= !access.get(i).onPreDraw();
                }
            }
            finally {
                listeners.end();
            }
        }
        return cancelDraw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchOnScrollChanged() {
        CopyOnWriteArray<OnScrollChangedListener> listeners = this.mOnScrollChangedListeners;
        if (listeners != null && listeners.size() > 0) {
            CopyOnWriteArray.Access<OnScrollChangedListener> access = listeners.start();
            try {
                int count = access.size();
                for (int i = 0; i < count; ++i) {
                    access.get(i).onScrollChanged();
                }
            }
            finally {
                listeners.end();
            }
        }
    }

    static class CopyOnWriteArray<T> {
        private ArrayList<T> mData = new ArrayList();
        private ArrayList<T> mDataCopy;
        private final Access<T> mAccess = new Access();
        private boolean mStart;

        CopyOnWriteArray() {
        }

        private ArrayList<T> getArray() {
            if (this.mStart) {
                if (this.mDataCopy == null) {
                    this.mDataCopy = new ArrayList<T>(this.mData);
                }
                return this.mDataCopy;
            }
            return this.mData;
        }

        Access<T> start() {
            if (this.mStart) {
                throw new IllegalStateException("Iteration already started");
            }
            this.mStart = true;
            this.mDataCopy = null;
            this.mAccess.mData = this.mData;
            this.mAccess.mSize = this.mData.size();
            return this.mAccess;
        }

        void end() {
            if (!this.mStart) {
                throw new IllegalStateException("Iteration not started");
            }
            this.mStart = false;
            if (this.mDataCopy != null) {
                this.mData = this.mDataCopy;
                this.mAccess.mData.clear();
                this.mAccess.mSize = 0;
            }
            this.mDataCopy = null;
        }

        int size() {
            return this.getArray().size();
        }

        void add(T item) {
            this.getArray().add(item);
        }

        void addAll(@NonNull CopyOnWriteArray<T> array) {
            this.getArray().addAll(array.mData);
        }

        void remove(T item) {
            this.getArray().remove(item);
        }

        void clear() {
            this.getArray().clear();
        }

        static class Access<T> {
            private ArrayList<T> mData;
            private int mSize;

            Access() {
            }

            T get(int index) {
                return this.mData.get(index);
            }

            int size() {
                return this.mSize;
            }
        }
    }

    @FunctionalInterface
    public static interface OnGlobalFocusChangeListener {
        public void onGlobalFocusChanged(@Nullable View var1, @Nullable View var2);
    }

    @FunctionalInterface
    public static interface OnGlobalLayoutListener {
        public void onGlobalLayout();
    }

    @FunctionalInterface
    public static interface OnPreDrawListener {
        public boolean onPreDraw();
    }

    @FunctionalInterface
    public static interface OnScrollChangedListener {
        public void onScrollChanged();
    }
}

