/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.view.Gravity;
import yslelf.cloudpick.graphics.view.MeasureSpec;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.view.PointerIcon;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.view.WindowManager;

@ApiStatus.Internal
public final class WindowGroup
extends ViewGroup
implements WindowManager {
    public WindowGroup(@NonNull Context context) {
        super(context);
        this.setDescendantFocusability(262144);
    }

    @Override
    public boolean dispatchTouchEvent(@NonNull MotionEvent ev) {
        WindowManager.LayoutParams attrs;
        if (this.mFocused != null && (attrs = (WindowManager.LayoutParams)this.mFocused.getLayoutParams()).isModal()) {
            return this.dispatchTransformedTouchEvent(ev, this.mFocused, false);
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    protected boolean dispatchHoverEvent(@NonNull MotionEvent event) {
        WindowManager.LayoutParams attrs;
        if (this.mFocused != null && (attrs = (WindowManager.LayoutParams)this.mFocused.getLayoutParams()).isModal()) {
            return this.dispatchTransformedGenericPointerEvent(event, this.mFocused);
        }
        return super.dispatchHoverEvent(event);
    }

    @Override
    protected boolean dispatchGenericPointerEvent(@NonNull MotionEvent event) {
        WindowManager.LayoutParams attrs;
        if (this.mFocused != null && (attrs = (WindowManager.LayoutParams)this.mFocused.getLayoutParams()).isModal()) {
            return this.dispatchTransformedGenericPointerEvent(event, this.mFocused);
        }
        return super.dispatchGenericPointerEvent(event);
    }

    @Override
    boolean dispatchTooltipHoverEvent(@NonNull MotionEvent event) {
        WindowManager.LayoutParams attrs;
        if (this.mFocused != null && (attrs = (WindowManager.LayoutParams)this.mFocused.getLayoutParams()).isModal()) {
            return this.dispatchTransformedTooltipHoverEvent(event, this.mFocused);
        }
        return super.dispatchTooltipHoverEvent(event);
    }

    @Override
    public PointerIcon onResolvePointerIcon(@NonNull MotionEvent event) {
        WindowManager.LayoutParams attrs;
        if (this.mFocused != null && (attrs = (WindowManager.LayoutParams)this.mFocused.getLayoutParams()).isModal()) {
            return this.dispatchResolvePointerIcon(event, this.mFocused);
        }
        return super.onResolvePointerIcon(event);
    }

    @Override
    public void addView(@NonNull View child, int index, @NonNull ViewGroup.LayoutParams params) {
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams lhs = (WindowManager.LayoutParams)params;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            WindowManager.LayoutParams rhs = (WindowManager.LayoutParams)this.getChildAt(i).getLayoutParams();
            if (lhs.type >= rhs.type) continue;
            index = i;
            break;
        }
        super.addView(child, index, params);
    }

    @Override
    protected void onViewAdded(View child) {
        super.onViewAdded(child);
        WindowManager.LayoutParams attrs = (WindowManager.LayoutParams)child.getLayoutParams();
        if ((attrs.flags & 8) == 0) {
            this.requestChildFocus(child, child);
        }
    }

    @Override
    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        return super.onRequestFocusInDescendants(1, previouslyFocusedRect);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            WindowManager.LayoutParams attrs = (WindowManager.LayoutParams)child.getLayoutParams();
            int childWidthSpec = WindowGroup.getChildMeasureSpec(widthMeasureSpec, 0, attrs.width);
            int childHeightSpec = WindowGroup.getChildMeasureSpec(heightMeasureSpec, 0, attrs.height);
            child.measure(childWidthSpec, childHeightSpec);
        }
        int windowWidth = MeasureSpec.getSize(widthMeasureSpec);
        int windowHeight = MeasureSpec.getSize(heightMeasureSpec);
        this.setMeasuredDimension(windowWidth, windowHeight);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        Rect outParentFrame = new Rect(left, top, right, bottom);
        Rect outFrame = new Rect();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            WindowManager.LayoutParams attrs = (WindowManager.LayoutParams)child.getLayoutParams();
            int pw = outParentFrame.width();
            int ph = outParentFrame.height();
            int w = child.getMeasuredWidth();
            int h2 = child.getMeasuredHeight();
            Gravity.apply(attrs.gravity, w, h2, outParentFrame, (int)((float)attrs.x + attrs.horizontalMargin * (float)pw), (int)((float)attrs.y + attrs.verticalMargin * (float)ph), outFrame);
            Gravity.applyDisplay(attrs.gravity, outParentFrame, outFrame);
            child.layout(outFrame.left, outFrame.top, outFrame.right, outFrame.bottom);
        }
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        this.mFocused = null;
        super.unFocus(focused);
        this.mFocused = child;
        if (this.mParent != null) {
            this.mParent.requestChildFocus(this, focused);
        }
    }

    @Override
    public void clearChildFocus(View child) {
        super.clearChildFocus(child);
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View c = this.getChildAt(i);
            if (!c.hasFocus()) continue;
            this.mFocused = c;
            break;
        }
    }

    @Override
    public void clearFocus() {
    }
}

