/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view.menu;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.view.ContextMenu;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.menu.MenuBuilder;
import yslelf.cloudpick.graphics.view.menu.MenuPopupHelper;

public class ContextMenuBuilder
extends MenuBuilder
implements ContextMenu {
    public ContextMenuBuilder(Context context) {
        super(context);
    }

    @Override
    @NonNull
    public ContextMenu setHeaderIcon(Drawable icon) {
        super.setHeaderIconInt(icon);
        return this;
    }

    @Override
    @NonNull
    public ContextMenu setHeaderTitle(CharSequence title) {
        super.setHeaderTitleInt(title);
        return this;
    }

    @Override
    @NonNull
    public ContextMenu setHeaderView(View view) {
        super.setHeaderViewInt(view);
        return this;
    }

    public MenuPopupHelper showPopup(Context context, View originalView, float x, float y) {
        if (originalView != null) {
            originalView.createContextMenu(this);
        }
        if (this.getVisibleItems().size() > 0) {
            int[] location = new int[2];
            assert (originalView != null);
            originalView.getLocationInWindow(location);
            MenuPopupHelper helper = new MenuPopupHelper(context, this, originalView, false, ResourceId.attr("modernui", "contextPopupMenuStyle"));
            helper.show(Math.round(x), Math.round(y));
            return helper;
        }
        return null;
    }
}

