/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view.menu;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.material.MaterialCheckBox;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.view.menu.MenuItemImpl;
import yslelf.cloudpick.graphics.view.menu.MenuView;
import yslelf.cloudpick.graphics.view.menu.SubMenuArrowDrawable;
import yslelf.cloudpick.graphics.widget.AbsListView;
import yslelf.cloudpick.graphics.widget.CheckBox;
import yslelf.cloudpick.graphics.widget.CompoundButton;
import yslelf.cloudpick.graphics.widget.ImageView;
import yslelf.cloudpick.graphics.widget.LinearLayout;
import yslelf.cloudpick.graphics.widget.RadioButton;
import yslelf.cloudpick.graphics.widget.TextView;

@ApiStatus.Internal
public class ListMenuItemView
extends LinearLayout
implements MenuView.ItemView,
AbsListView.SelectionBoundsAdjuster {
    private MenuItemImpl mItemData;
    private ImageView mIconView;
    private RadioButton mRadioButton;
    private CheckBox mCheckBox;
    private final TextView mTitleView;
    private final TextView mShortcutView;
    private final ImageView mSubMenuArrowView;
    private final LinearLayout mContent;
    private boolean mForceShowIcon;

    public ListMenuItemView(Context context) {
        super(context);
        this.setMinimumWidth(this.dp(196.0f));
        this.setOrientation(1);
        ShapeDrawable divider = new ShapeDrawable();
        divider.setShape(3);
        divider.setSize(-1, this.dp(1.0f));
        TypedValue value = new TypedValue();
        if (context.getTheme().resolveAttribute("modernui", "colorOutlineVariant", value, true)) {
            divider.setColor(value.data);
        }
        this.setDividerDrawable(divider);
        this.setDividerPadding(this.dp(2.0f));
        this.mContent = new LinearLayout(this.getContext());
        this.mContent.setDuplicateParentStateEnabled(true);
        this.mContent.setPaddingRelative(this.dp(4.0f), this.dp(2.0f), this.dp(16.0f), this.dp(2.0f));
        this.mTitleView = new TextView(this.getContext());
        this.mTitleView.setId(16908310);
        this.mTitleView.setTextAppearance(ResourceId.attr("modernui", "textAppearanceBodyMedium"));
        this.mTitleView.setSingleLine();
        this.mTitleView.setDuplicateParentStateEnabled(true);
        this.mTitleView.setTextAlignment(5);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -2, 1.0f);
        params.gravity = 16;
        params.setMarginStart(this.dp(16.0f));
        this.mContent.addView((View)this.mTitleView, params);
        this.mShortcutView = new TextView(this.getContext());
        this.mShortcutView.setTextAppearance(ResourceId.attr("modernui", "textAppearanceBodySmall"));
        this.mShortcutView.setSingleLine();
        this.mShortcutView.setDuplicateParentStateEnabled(true);
        this.mShortcutView.setTextAlignment(5);
        params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 16;
        params.setMarginStart(this.dp(16.0f));
        this.mContent.addView((View)this.mShortcutView, params);
        this.mSubMenuArrowView = new ImageView(this.getContext());
        this.mSubMenuArrowView.setScaleType(ImageView.ScaleType.CENTER);
        this.mSubMenuArrowView.setVisibility(8);
        this.mSubMenuArrowView.setImageDrawable(new SubMenuArrowDrawable(context));
        if (context.getTheme().resolveAttribute("modernui", "textColorSecondary", value, true)) {
            this.mSubMenuArrowView.setImageTintList(context.getResources().loadColorStateList(value, context.getTheme()));
        }
        params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        params.setMarginStart(this.dp(8.0f));
        this.mContent.addView((View)this.mSubMenuArrowView, params);
        this.addView((View)this.mContent, -1, -2);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
    }

    @Override
    public void initialize(@NonNull MenuItemImpl itemData, int menuType) {
        this.mItemData = itemData;
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        this.setTitle(itemData.getTitleForItemView(this));
        this.setCheckable(itemData.isCheckable());
        this.setShortcut(itemData.shouldShowShortcut(), itemData.getShortcut());
        this.setIcon(itemData.getIcon());
        this.setEnabled(itemData.isEnabled());
        this.setSubMenuArrowVisible(itemData.hasSubMenu());
    }

    private void addContentView(View v) {
        this.addContentView(v, -1);
    }

    private void addContentView(View v, int index) {
        if (this.mContent != null) {
            this.mContent.addView(v, index);
        } else {
            this.addView(v, index);
        }
    }

    public void setForceShowIcon(boolean forceShow) {
        this.mForceShowIcon = forceShow;
    }

    @Override
    public void setTitle(@Nullable CharSequence title) {
        if (title != null) {
            this.mTitleView.setText(title);
            if (this.mTitleView.getVisibility() != 0) {
                this.mTitleView.setVisibility(0);
            }
        } else if (this.mTitleView.getVisibility() != 8) {
            this.mTitleView.setVisibility(8);
        }
    }

    @Override
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    @Override
    public void setCheckable(boolean checkable) {
        CompoundButton otherCompoundButton;
        CompoundButton compoundButton;
        if (!checkable && this.mRadioButton == null && this.mCheckBox == null) {
            return;
        }
        if (this.mItemData.isExclusiveCheckable()) {
            if (this.mRadioButton == null) {
                this.insertRadioButton();
            }
            compoundButton = this.mRadioButton;
            otherCompoundButton = this.mCheckBox;
        } else {
            if (this.mCheckBox == null) {
                this.insertCheckBox();
            }
            compoundButton = this.mCheckBox;
            otherCompoundButton = this.mRadioButton;
        }
        if (checkable) {
            compoundButton.setChecked(this.mItemData.isChecked());
            if (compoundButton.getVisibility() != 0) {
                compoundButton.setVisibility(0);
            }
            if (otherCompoundButton != null && otherCompoundButton.getVisibility() != 8) {
                otherCompoundButton.setVisibility(8);
            }
        } else {
            if (this.mCheckBox != null) {
                this.mCheckBox.setVisibility(8);
            }
            if (this.mRadioButton != null) {
                this.mRadioButton.setVisibility(8);
            }
        }
    }

    @Override
    public void setChecked(boolean checked) {
        CompoundButton compoundButton;
        if (this.mItemData.isExclusiveCheckable()) {
            if (this.mRadioButton == null) {
                this.insertRadioButton();
            }
            compoundButton = this.mRadioButton;
        } else {
            if (this.mCheckBox == null) {
                this.insertCheckBox();
            }
            compoundButton = this.mCheckBox;
        }
        compoundButton.setChecked(checked);
    }

    private void setSubMenuArrowVisible(boolean hasSubmenu) {
        if (this.mSubMenuArrowView != null) {
            this.mSubMenuArrowView.setVisibility(hasSubmenu ? 0 : 8);
        }
    }

    @Override
    public void setShortcut(boolean showShortcut, char shortcutKey) {
        int newVisibility;
        int n2 = newVisibility = showShortcut && this.mItemData.shouldShowShortcut() ? 0 : 8;
        if (newVisibility == 0) {
            this.mShortcutView.setText(this.mItemData.getShortcutLabel());
        }
        if (this.mShortcutView.getVisibility() != newVisibility) {
            this.mShortcutView.setVisibility(newVisibility);
        }
    }

    @Override
    public void setIcon(Drawable icon) {
        boolean showIcon;
        boolean bl = showIcon = this.mItemData.shouldShowIcon() || this.mForceShowIcon;
        if (!showIcon) {
            return;
        }
        if (this.mIconView == null && icon == null && !this.mForceShowIcon) {
            return;
        }
        if (this.mIconView == null) {
            this.insertIconView();
        }
        if (icon != null || this.mForceShowIcon) {
            this.mIconView.setImageDrawable(icon);
            if (this.mIconView.getVisibility() != 0) {
                this.mIconView.setVisibility(0);
            }
        } else {
            this.mIconView.setVisibility(8);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIconView != null && this.mForceShowIcon) {
            ViewGroup.LayoutParams lp = this.getLayoutParams();
            LinearLayout.LayoutParams iconLp = (LinearLayout.LayoutParams)this.mIconView.getLayoutParams();
            if (lp.height > 0 && iconLp.width <= 0) {
                iconLp.width = lp.height;
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void insertIconView() {
        this.mIconView = new ImageView(this.getContext());
        this.mIconView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mIconView.setDuplicateParentStateEnabled(true);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 16;
        params.setMarginsRelative(this.dp(8.0f), this.dp(8.0f), this.dp(-8.0f), this.dp(8.0f));
        this.mIconView.setLayoutParams(params);
        if (this.mRadioButton != null || this.mCheckBox != null) {
            this.addContentView(this.mIconView, 1);
        } else {
            this.addContentView(this.mIconView, 0);
        }
    }

    private void insertRadioButton() {
        this.mRadioButton = new RadioButton(this.getContext(), null, ResourceId.attr("modernui", "radioButtonStyleMenuItem"));
        this.mRadioButton.setFocusable(false);
        this.mRadioButton.setClickable(false);
        this.mRadioButton.setDuplicateParentStateEnabled(true);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 16;
        this.mRadioButton.setLayoutParams(params);
        this.addContentView(this.mRadioButton, 0);
    }

    private void insertCheckBox() {
        this.mCheckBox = new MaterialCheckBox(this.getContext());
        this.mCheckBox.setFocusable(false);
        this.mCheckBox.setClickable(false);
        this.mCheckBox.setDuplicateParentStateEnabled(true);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 16;
        this.mCheckBox.setLayoutParams(params);
        this.addContentView(this.mCheckBox, 0);
    }

    @Override
    public boolean prefersCondensedTitle() {
        return false;
    }

    @Override
    public boolean showsIcon() {
        return this.mForceShowIcon;
    }

    public void setGroupDividerEnabled(boolean groupDividerEnabled) {
        if (this.getShowDividers() == 0 == groupDividerEnabled) {
            if (groupDividerEnabled) {
                this.setShowDividers(1);
                this.setPadding(0, this.dp(2.0f), 0, 0);
            } else {
                this.setShowDividers(0);
                this.setPadding(0, 0, 0, 0);
            }
        }
    }

    @Override
    public void adjustListItemSelectionBounds(@NonNull Rect rect) {
        rect.inset(this.dp(4.0f), this.dp(2.0f));
        if (this.getShowDividers() != 0) {
            rect.top += this.dp(5.0f);
        }
    }
}

