/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view.menu;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.view.MeasureSpec;
import yslelf.cloudpick.graphics.view.MenuItem;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.view.menu.MenuAdapter;
import yslelf.cloudpick.graphics.view.menu.MenuBuilder;
import yslelf.cloudpick.graphics.view.menu.MenuItemImpl;
import yslelf.cloudpick.graphics.view.menu.MenuPresenter;
import yslelf.cloudpick.graphics.view.menu.MenuView;
import yslelf.cloudpick.graphics.view.menu.ShowableListMenu;
import yslelf.cloudpick.graphics.widget.AdapterView;
import yslelf.cloudpick.graphics.widget.FrameLayout;
import yslelf.cloudpick.graphics.widget.HeaderViewListAdapter;
import yslelf.cloudpick.graphics.widget.ListAdapter;
import yslelf.cloudpick.graphics.widget.PopupWindow;

public abstract class MenuPopup
implements ShowableListMenu,
MenuPresenter,
AdapterView.OnItemClickListener {
    private Rect mEpicenterBounds;

    public abstract void setForceShowIcon(boolean var1);

    public abstract void addMenu(MenuBuilder var1);

    public abstract void setGravity(int var1);

    public abstract void setAnchorView(View var1);

    public abstract void setHorizontalOffset(int var1);

    public abstract void setVerticalOffset(int var1);

    public void setEpicenterBounds(Rect bounds) {
        this.mEpicenterBounds = bounds;
    }

    public Rect getEpicenterBounds() {
        return this.mEpicenterBounds;
    }

    public abstract void setShowTitle(boolean var1);

    public abstract void setOnDismissListener(PopupWindow.OnDismissListener var1);

    @Override
    public void initForMenu(@NonNull Context context, @Nullable MenuBuilder menu) {
    }

    @Override
    public MenuView getMenuView(ViewGroup root) {
        throw new UnsupportedOperationException("MenuPopups manage their own views");
    }

    @Override
    public boolean expandItemActionView(MenuBuilder menu, MenuItemImpl item) {
        return false;
    }

    @Override
    public boolean collapseItemActionView(MenuBuilder menu, MenuItemImpl item) {
        return false;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void onItemClick(@NonNull AdapterView<?> parent, View view, int position, long id2) {
        ListAdapter outerAdapter = (ListAdapter)parent.getAdapter();
        MenuAdapter wrappedAdapter = MenuPopup.toMenuAdapter(outerAdapter);
        wrappedAdapter.mAdapterMenu.performItemAction((MenuItem)outerAdapter.getItem(position), 0);
    }

    protected static int measureIndividualMenuWidth(@NonNull ListAdapter adapter, @Nullable ViewGroup parent, Context context, int maxAllowedWidth) {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = MeasureSpec.makeMeasureSpec(0, 0);
        int heightMeasureSpec = MeasureSpec.makeMeasureSpec(0, 0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if (parent == null) {
                parent = new FrameLayout(context);
            }
            itemView = adapter.getView(i, itemView, parent);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            if (itemWidth >= maxAllowedWidth) {
                return maxAllowedWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    protected static MenuAdapter toMenuAdapter(ListAdapter adapter) {
        if (adapter instanceof HeaderViewListAdapter) {
            return (MenuAdapter)((HeaderViewListAdapter)adapter).getWrappedAdapter();
        }
        return (MenuAdapter)adapter;
    }

    protected static boolean shouldPreserveIconSpacing(@NonNull MenuBuilder menu) {
        boolean preserveIconSpacing = false;
        int count = menu.size();
        for (int i = 0; i < count; ++i) {
            MenuItem childItem = menu.getItem(i);
            if (!childItem.isVisible() || childItem.getIcon() == null) continue;
            preserveIconSpacing = true;
            break;
        }
        return preserveIconSpacing;
    }
}

