/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view.menu;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.view.Gravity;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.menu.CascadingMenuPopup;
import yslelf.cloudpick.graphics.view.menu.MenuBuilder;
import yslelf.cloudpick.graphics.view.menu.MenuHelper;
import yslelf.cloudpick.graphics.view.menu.MenuPopup;
import yslelf.cloudpick.graphics.view.menu.MenuPresenter;
import yslelf.cloudpick.graphics.widget.PopupWindow;

@ApiStatus.Internal
public class MenuPopupHelper
implements MenuHelper {
    private static final int TOUCH_EPICENTER_SIZE_DP = 48;
    private final Context mContext;
    private final MenuBuilder mMenu;
    private final boolean mOverflowOnly;
    private final ResourceId mPopupStyleAttr;
    private final ResourceId mPopupStyleRes;
    private View mAnchorView;
    private int mDropDownGravity = 0x800003;
    private boolean mForceShowIcon;
    private MenuPresenter.Callback mPresenterCallback;
    private MenuPopup mPopup;
    private PopupWindow.OnDismissListener mOnDismissListener;
    private final PopupWindow.OnDismissListener mInternalOnDismissListener = this::onDismiss;
    public static final ResourceId DEF_STYLE_ATTR = ResourceId.attr("modernui", "popupMenuStyle");

    public MenuPopupHelper(@NonNull Context context, @NonNull MenuBuilder menu) {
        this(context, menu, null, false, DEF_STYLE_ATTR, null);
    }

    public MenuPopupHelper(@NonNull Context context, @NonNull MenuBuilder menu, View anchorView) {
        this(context, menu, anchorView, false, DEF_STYLE_ATTR, null);
    }

    public MenuPopupHelper(@NonNull Context context, @NonNull MenuBuilder menu, View anchorView, boolean overflowOnly, ResourceId popupStyleAttr) {
        this(context, menu, anchorView, overflowOnly, popupStyleAttr, null);
    }

    public MenuPopupHelper(@NonNull Context context, @NonNull MenuBuilder menu, View anchorView, boolean overflowOnly, ResourceId popupStyleAttr, ResourceId popupStyleRes) {
        this.mContext = context;
        this.mMenu = menu;
        this.mAnchorView = anchorView;
        this.mOverflowOnly = overflowOnly;
        this.mPopupStyleAttr = popupStyleAttr;
        this.mPopupStyleRes = popupStyleRes;
    }

    public void setOnDismissListener(@Nullable PopupWindow.OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    public void setAnchorView(@NonNull View anchor) {
        this.mAnchorView = anchor;
    }

    public void setForceShowIcon(boolean forceShowIcon) {
        this.mForceShowIcon = forceShowIcon;
        if (this.mPopup != null) {
            this.mPopup.setForceShowIcon(forceShowIcon);
        }
    }

    public void setGravity(int gravity) {
        this.mDropDownGravity = gravity;
    }

    public int getGravity() {
        return this.mDropDownGravity;
    }

    public void show() {
        if (!this.tryShow()) {
            throw new IllegalStateException("MenuPopupHelper cannot be used without an anchor");
        }
    }

    public void show(int x, int y) {
        if (!this.tryShow(x, y)) {
            throw new IllegalStateException("MenuPopupHelper cannot be used without an anchor");
        }
    }

    @NonNull
    public MenuPopup getPopup() {
        if (this.mPopup == null) {
            this.mPopup = this.createPopup();
        }
        return this.mPopup;
    }

    public boolean tryShow() {
        if (this.isShowing()) {
            return true;
        }
        if (this.mAnchorView == null) {
            return false;
        }
        this.showPopup(0, 0, false, false);
        return true;
    }

    public boolean tryShow(int x, int y) {
        if (this.isShowing()) {
            return true;
        }
        if (this.mAnchorView == null) {
            return false;
        }
        this.showPopup(x, y, true, true);
        return true;
    }

    @NonNull
    private MenuPopup createPopup() {
        boolean enableCascadingSubmenus = true;
        CascadingMenuPopup popup = new CascadingMenuPopup(this.mContext, this.mAnchorView, this.mPopupStyleAttr, this.mPopupStyleRes, this.mOverflowOnly);
        ((MenuPopup)popup).addMenu(this.mMenu);
        ((MenuPopup)popup).setOnDismissListener(this.mInternalOnDismissListener);
        ((MenuPopup)popup).setAnchorView(this.mAnchorView);
        popup.setCallback(this.mPresenterCallback);
        ((MenuPopup)popup).setForceShowIcon(this.mForceShowIcon);
        ((MenuPopup)popup).setGravity(this.mDropDownGravity);
        return popup;
    }

    private void showPopup(int xOffset, int yOffset, boolean useOffsets, boolean showTitle) {
        MenuPopup popup = this.getPopup();
        popup.setShowTitle(showTitle);
        if (useOffsets) {
            int hgrav = Gravity.getAbsoluteGravity(this.mDropDownGravity, this.mAnchorView.getLayoutDirection()) & 7;
            if (hgrav == 5) {
                xOffset -= this.mAnchorView.getWidth();
            }
            popup.setHorizontalOffset(xOffset);
            popup.setVerticalOffset(yOffset);
            float density = this.mContext.getResources().getDisplayMetrics().density;
            int halfSize = (int)(48.0f * density / 2.0f);
            Rect epicenter = new Rect(xOffset - halfSize, yOffset - halfSize, xOffset + halfSize, yOffset + halfSize);
            popup.setEpicenterBounds(epicenter);
        }
        popup.show();
    }

    @Override
    public void dismiss() {
        if (this.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    protected void onDismiss() {
        this.mPopup = null;
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
    }

    public boolean isShowing() {
        return this.mPopup != null && this.mPopup.isShowing();
    }

    @Override
    public void setPresenterCallback(@Nullable MenuPresenter.Callback cb) {
        this.mPresenterCallback = cb;
        if (this.mPopup != null) {
            this.mPopup.setCallback(cb);
        }
    }
}

