/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.view.menu;

import java.nio.FloatBuffer;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.material.MaterialDrawable;
import yslelf.cloudpick.graphics.resources.TypedValue;

public class SubMenuArrowDrawable
extends MaterialDrawable {
    private final int mSize;
    private final FloatBuffer mPoints;

    public SubMenuArrowDrawable(Context context) {
        this.mSize = (int)TypedValue.applyDimension(1, 24.0f, context.getResources().getDisplayMetrics());
        this.mPoints = FloatBuffer.allocate(6);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Paint paint = Paint.obtain();
        paint.setColor(this.mColor);
        paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
        if (paint.getAlpha() != 0) {
            canvas.drawTriangleListMesh(this.mPoints, null, paint);
        }
        paint.recycle();
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        this.buildArrowPoints(bounds.width(), bounds.height(), this.getLayoutDirection());
    }

    @Override
    protected boolean onLayoutDirectionChanged(int layoutDirection) {
        Rect bounds = this.getBounds();
        this.buildArrowPoints(bounds.width(), bounds.height(), layoutDirection);
        return true;
    }

    private void buildArrowPoints(float w, float h2, int layoutDirection) {
        boolean mirror;
        boolean bl = mirror = layoutDirection == 1;
        if (mirror) {
            this.mPoints.put(0.6666667f * w).put(0.29166666f * h2).put(0.33333334f * w).put(0.5f * h2).put(0.6666667f * w).put(0.7083333f * h2).flip();
        } else {
            this.mPoints.put(0.33333334f * w).put(0.7083333f * h2).put(0.6666667f * w).put(0.5f * h2).put(0.33333334f * w).put(0.29166666f * h2).flip();
        }
    }

    @Override
    public boolean isAutoMirrored() {
        return true;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mSize;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mSize;
    }
}

