/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ColorDrawable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.util.LongSparseArray;
import yslelf.cloudpick.graphics.util.SparseArray;
import yslelf.cloudpick.graphics.util.SparseBooleanArray;
import yslelf.cloudpick.graphics.util.StateSet;
import yslelf.cloudpick.graphics.view.ActionMode;
import yslelf.cloudpick.graphics.view.ContextMenu;
import yslelf.cloudpick.graphics.view.KeyEvent;
import yslelf.cloudpick.graphics.view.Menu;
import yslelf.cloudpick.graphics.view.MenuItem;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.view.VelocityTracker;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewConfiguration;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.view.ViewParent;
import yslelf.cloudpick.graphics.widget.AdapterView;
import yslelf.cloudpick.graphics.widget.Checkable;
import yslelf.cloudpick.graphics.widget.EdgeEffect;
import yslelf.cloudpick.graphics.widget.Filter;
import yslelf.cloudpick.graphics.widget.ListAdapter;
import yslelf.cloudpick.graphics.widget.OverScroller;

public abstract class AbsListView
extends AdapterView<ListAdapter>
implements Filter.FilterListener {
    private static final Marker MARKER = MarkerManager.getMarker((String)"AbsListView");
    public static final int TRANSCRIPT_MODE_DISABLED = 0;
    public static final int TRANSCRIPT_MODE_NORMAL = 1;
    public static final int TRANSCRIPT_MODE_ALWAYS_SCROLL = 2;
    static final int TOUCH_MODE_REST = -1;
    static final int TOUCH_MODE_DOWN = 0;
    static final int TOUCH_MODE_TAP = 1;
    static final int TOUCH_MODE_DONE_WAITING = 2;
    static final int TOUCH_MODE_SCROLL = 3;
    static final int TOUCH_MODE_FLING = 4;
    static final int TOUCH_MODE_OVERSCROLL = 5;
    static final int TOUCH_MODE_OVERFLING = 6;
    static final int LAYOUT_NORMAL = 0;
    static final int LAYOUT_FORCE_TOP = 1;
    static final int LAYOUT_SET_SELECTION = 2;
    static final int LAYOUT_FORCE_BOTTOM = 3;
    static final int LAYOUT_SPECIFIC = 4;
    static final int LAYOUT_SYNC = 5;
    static final int LAYOUT_MOVE_SELECTION = 6;
    public static final int CHOICE_MODE_NONE = 0;
    public static final int CHOICE_MODE_SINGLE = 1;
    public static final int CHOICE_MODE_MULTIPLE = 2;
    public static final int CHOICE_MODE_MULTIPLE_MODAL = 3;
    int mChoiceMode = 0;
    ActionMode mChoiceActionMode;
    MultiChoiceModeWrapper mMultiChoiceModeCallback;
    int mCheckedItemCount;
    SparseBooleanArray mCheckStates;
    Long2IntOpenHashMap mCheckedIdStates;
    int mLayoutMode = 0;
    AdapterView.AdapterDataSetObserver mDataSetObserver;
    ListAdapter mAdapter;
    boolean mAdapterHasStableIds;
    boolean mDrawSelectorOnTop = false;
    Drawable mSelector;
    int mSelectorPosition = -1;
    Rect mSelectorRect = new Rect();
    final RecycleBin mRecycler = new RecycleBin();
    int mSelectionLeftPadding = 0;
    int mSelectionTopPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionBottomPadding = 0;
    Rect mListPadding = new Rect();
    int mWidthMeasureSpec = 0;
    View mScrollUp;
    View mScrollDown;
    int mMotionPosition;
    int mMotionViewOriginalTop;
    int mMotionViewNewTop;
    int mMotionX;
    int mMotionY;
    int mTouchMode = -1;
    int mLastY;
    int mMotionCorrection;
    private VelocityTracker mVelocityTracker;
    private FlingRunnable mFlingRunnable;
    PositionScroller mPositionScroller;
    int mSelectedTop = 0;
    boolean mStackFromBottom;
    private OnScrollListener mOnScrollListener;
    private boolean mSmoothScrollbarEnabled = true;
    private Rect mTouchFrame;
    int mResurrectToPosition = -1;
    private ContextMenu.ContextMenuInfo mContextMenuInfo = null;
    int mOverscrollMax;
    static final int OVERSCROLL_LIMIT_DIVISOR = 3;
    private static final int CHECK_POSITION_SEARCH_DISTANCE = 20;
    private static final int TOUCH_MODE_UNKNOWN = -1;
    private static final int TOUCH_MODE_ON = 0;
    private static final int TOUCH_MODE_OFF = 1;
    private int mLastTouchMode = -1;
    private CheckForLongPress mPendingCheckForLongPress;
    private CheckForTap mPendingCheckForTap;
    private CheckForKeyLongPress mPendingCheckForKeyLongPress;
    private PerformClick mPerformClick;
    private Runnable mTouchModeReset;
    private boolean mHasPerformedLongPress;
    private int mTranscriptMode = 0;
    private boolean mIsChildViewEnabled;
    private int[] mSelectorState;
    private int mLastScrollState = 0;
    private int mTouchSlop;
    private float mDensityScale;
    private final float mVerticalScrollFactor;
    Runnable mPositionScrollAfterLayout;
    private final int mMinimumVelocity;
    private final int mMaximumVelocity;
    private float mVelocityScale = 1.0f;
    final boolean[] mIsScrap = new boolean[1];
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private final float[] mTmpPoint = new float[2];
    private int mNestedYOffset = 0;
    int mOverscrollDistance;
    int mOverflingDistance;
    @NonNull
    private final EdgeEffect mEdgeGlowTop;
    @NonNull
    private final EdgeEffect mEdgeGlowBottom;
    private int mFirstPositionDistanceGuess;
    private int mLastPositionDistanceGuess;
    private int mDirection = 0;
    private boolean mForceTranscriptScroll;
    private int mLastHandledItemCount;
    private boolean mIsDetaching;

    public AbsListView(Context context) {
        super(context);
        this.mEdgeGlowBottom = new EdgeEffect(context);
        this.mEdgeGlowTop = new EdgeEffect(context);
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        ViewConfiguration configuration = ViewConfiguration.get(context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mVerticalScrollFactor = configuration.getScaledVerticalScrollFactor();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
    }

    @Override
    public void setAdapter(@Nullable ListAdapter adapter) {
        if (adapter != null) {
            this.mAdapterHasStableIds = this.mAdapter.hasStableIds();
            if (this.mChoiceMode != 0 && this.mAdapterHasStableIds && this.mCheckedIdStates == null) {
                this.mCheckedIdStates = new Long2IntOpenHashMap();
            }
        }
        this.clearChoices();
    }

    public int getCheckedItemCount() {
        return this.mCheckedItemCount;
    }

    public boolean isItemChecked(int position) {
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            return this.mCheckStates.get(position);
        }
        return false;
    }

    public int getCheckedItemPosition() {
        if (this.mChoiceMode == 1 && this.mCheckStates != null && this.mCheckStates.size() == 1) {
            return this.mCheckStates.keyAt(0);
        }
        return -1;
    }

    public SparseBooleanArray getCheckedItemPositions() {
        if (this.mChoiceMode != 0) {
            return this.mCheckStates;
        }
        return null;
    }

    public long[] getCheckedItemIds() {
        if (this.mChoiceMode == 0 || this.mCheckedIdStates == null || this.mAdapter == null) {
            return new long[0];
        }
        return this.mCheckedIdStates.keySet().toLongArray();
    }

    public void clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.mCheckedItemCount = 0;
    }

    public void setItemChecked(int position, boolean value) {
        boolean itemCheckChanged;
        if (this.mChoiceMode == 0) {
            return;
        }
        if (value && this.mChoiceMode == 3 && this.mChoiceActionMode == null) {
            if (this.mMultiChoiceModeCallback == null || !this.mMultiChoiceModeCallback.hasWrappedCallback()) {
                throw new IllegalStateException("AbsListView: attempted to start selection mode for CHOICE_MODE_MULTIPLE_MODAL but no choice mode callback was supplied. Call setMultiChoiceModeListener to set a callback.");
            }
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        if (this.mChoiceMode == 2 || this.mChoiceMode == 3) {
            boolean oldValue = this.mCheckStates.get(position);
            this.mCheckStates.put(position, value);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (value) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                } else {
                    this.mCheckedIdStates.remove(this.mAdapter.getItemId(position));
                }
            }
            boolean bl = itemCheckChanged = oldValue != value;
            if (itemCheckChanged) {
                this.mCheckedItemCount = value ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
            }
            if (this.mChoiceActionMode != null) {
                long id2 = this.mAdapter.getItemId(position);
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, value);
            }
        } else {
            boolean updateIds = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
            boolean bl = itemCheckChanged = this.isItemChecked(position) != value;
            if (value || this.isItemChecked(position)) {
                this.mCheckStates.clear();
                if (updateIds) {
                    this.mCheckedIdStates.clear();
                }
            }
            if (value) {
                this.mCheckStates.put(position, true);
                if (updateIds) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                }
                this.mCheckedItemCount = 1;
            } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                this.mCheckedItemCount = 0;
            }
        }
        if (!this.mInLayout && !this.mBlockLayoutRequests && itemCheckChanged) {
            this.mDataChanged = true;
            this.rememberSyncState();
            this.requestLayout();
        }
    }

    @Override
    public boolean performItemClick(View view, int position, long id2) {
        boolean handled = false;
        boolean dispatchItemClick = true;
        if (this.mChoiceMode != 0) {
            handled = true;
            boolean checkedStateChanged = false;
            if (this.mChoiceMode == 2 || this.mChoiceMode == 3 && this.mChoiceActionMode != null) {
                boolean checked = !this.mCheckStates.get(position, false);
                this.mCheckStates.put(position, checked);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    if (checked) {
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                    } else {
                        this.mCheckedIdStates.remove(this.mAdapter.getItemId(position));
                    }
                }
                this.mCheckedItemCount = checked ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
                if (this.mChoiceActionMode != null) {
                    this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, checked);
                    dispatchItemClick = false;
                }
                checkedStateChanged = true;
            } else if (this.mChoiceMode == 1) {
                boolean checked;
                boolean bl = checked = !this.mCheckStates.get(position, false);
                if (checked) {
                    this.mCheckStates.clear();
                    this.mCheckStates.put(position, true);
                    if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                        this.mCheckedIdStates.clear();
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), position);
                    }
                    this.mCheckedItemCount = 1;
                } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                    this.mCheckedItemCount = 0;
                }
                checkedStateChanged = true;
            }
            if (checkedStateChanged) {
                this.updateOnScreenCheckedViews();
            }
        }
        if (dispatchItemClick) {
            handled |= super.performItemClick(view, position, id2);
        }
        return handled;
    }

    private void updateOnScreenCheckedViews() {
        int firstPos = this.mFirstPosition;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int position = firstPos + i;
            if (child instanceof Checkable) {
                ((Checkable)((Object)child)).setChecked(this.mCheckStates.get(position));
                continue;
            }
            child.setActivated(this.mCheckStates.get(position));
        }
    }

    public int getChoiceMode() {
        return this.mChoiceMode;
    }

    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
        if (this.mChoiceActionMode != null) {
            this.mChoiceActionMode.finish();
            this.mChoiceActionMode = null;
        }
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SparseBooleanArray(0);
            }
            if (this.mCheckedIdStates == null && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                this.mCheckedIdStates = new Long2IntOpenHashMap();
            }
            if (this.mChoiceMode == 3) {
                this.clearChoices();
                this.setLongClickable(true);
            }
        }
    }

    public void setMultiChoiceModeListener(MultiChoiceModeListener listener) {
        if (this.mMultiChoiceModeCallback == null) {
            this.mMultiChoiceModeCallback = new MultiChoiceModeWrapper();
        }
        this.mMultiChoiceModeCallback.setWrapped(listener);
    }

    private boolean contentFits() {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        if (childCount != this.mItemCount) {
            return false;
        }
        return this.getChildAt(0).getTop() >= this.mListPadding.top && this.getChildAt(childCount - 1).getBottom() <= this.getHeight() - this.mListPadding.bottom;
    }

    public void setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    public void setOnScrollListener(@Nullable OnScrollListener l2) {
        this.mOnScrollListener = l2;
        this.invokeOnItemScrollListener();
    }

    void invokeOnItemScrollListener() {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        this.onScrollChanged(0, 0, 0, 0);
    }

    @Override
    public void getFocusedRect(@NonNull Rect r) {
        View view = this.getSelectedView();
        if (view != null && view.getParent() == this) {
            view.getFocusedRect(r);
            this.offsetDescendantRectToMyCoords(view, r);
        } else {
            super.getFocusedRect(r);
        }
    }

    private void useDefaultSelector() {
        this.setSelector(new ColorDrawable(0x33808080));
    }

    public boolean isStackFromBottom() {
        return this.mStackFromBottom;
    }

    public void setStackFromBottom(boolean stackFromBottom) {
        if (this.mStackFromBottom != stackFromBottom) {
            this.mStackFromBottom = stackFromBottom;
            this.requestLayoutIfNecessary();
        }
    }

    void requestLayoutIfNecessary() {
        if (this.getChildCount() > 0) {
            this.resetList();
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    protected void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mSelectedPosition < 0 && !this.isInTouchMode()) {
            if (!this.isAttachedToWindow() && this.mAdapter != null) {
                this.mDataChanged = true;
                this.mOldItemCount = this.mItemCount;
                this.mItemCount = this.mAdapter.getCount();
            }
            this.resurrectSelection();
        }
    }

    @Override
    public void requestLayout() {
        if (!this.mBlockLayoutRequests && !this.mInLayout) {
            super.requestLayout();
        }
    }

    void resetList() {
        this.removeAllViewsInLayout();
        this.mFirstPosition = 0;
        this.mDataChanged = false;
        this.mPositionScrollAfterLayout = null;
        this.mNeedSync = false;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.mSelectedTop = 0;
        this.mSelectorPosition = -1;
        this.mSelectorRect.setEmpty();
        this.invalidate();
    }

    @Override
    protected int computeVerticalScrollExtent() {
        int count = this.getChildCount();
        if (count > 0) {
            if (this.mSmoothScrollbarEnabled) {
                int extent = count * 100;
                View view = this.getChildAt(0);
                int top = view.getTop();
                int height = view.getHeight();
                if (height > 0) {
                    extent += top * 100 / height;
                }
                view = this.getChildAt(count - 1);
                int bottom = view.getBottom();
                height = view.getHeight();
                if (height > 0) {
                    extent -= (bottom - this.getHeight()) * 100 / height;
                }
                return extent;
            }
            return 1;
        }
        return 0;
    }

    @Override
    protected int computeVerticalScrollOffset() {
        int firstPosition = this.mFirstPosition;
        int childCount = this.getChildCount();
        if (firstPosition >= 0 && childCount > 0) {
            if (this.mSmoothScrollbarEnabled) {
                View view = this.getChildAt(0);
                int top = view.getTop();
                int height = view.getHeight();
                if (height > 0) {
                    return Math.max(firstPosition * 100 - top * 100 / height + (int)((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount * 100.0f), 0);
                }
            } else {
                int count = this.mItemCount;
                int index = firstPosition == 0 ? 0 : (firstPosition + childCount == count ? count : firstPosition + childCount / 2);
                return (int)((float)firstPosition + (float)childCount * ((float)index / (float)count));
            }
        }
        return 0;
    }

    @Override
    protected int computeVerticalScrollRange() {
        int result;
        if (this.mSmoothScrollbarEnabled) {
            result = Math.max(this.mItemCount * 100, 0);
            if (this.mScrollY != 0) {
                result += Math.abs((int)((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount * 100.0f));
            }
        } else {
            result = this.mItemCount;
        }
        return result;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mSelector == null) {
            this.useDefaultSelector();
        }
        Rect listPadding = this.mListPadding;
        listPadding.left = this.mSelectionLeftPadding + this.mPaddingLeft;
        listPadding.top = this.mSelectionTopPadding + this.mPaddingTop;
        listPadding.right = this.mSelectionRightPadding + this.mPaddingRight;
        listPadding.bottom = this.mSelectionBottomPadding + this.mPaddingBottom;
        if (this.mTranscriptMode == 1) {
            int childCount = this.getChildCount();
            int listBottom = this.getHeight() - this.getPaddingBottom();
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild != null ? lastChild.getBottom() : listBottom;
            this.mForceTranscriptScroll = this.mFirstPosition + childCount >= this.mLastHandledItemCount && lastBottom <= listBottom;
        }
    }

    @Override
    protected void onLayout(boolean changed, int l2, int t2, int r, int b) {
        super.onLayout(changed, l2, t2, r, b);
        this.mInLayout = true;
        int childCount = this.getChildCount();
        if (changed) {
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).forceLayout();
            }
            this.mRecycler.markChildrenDirty();
        }
        this.layoutChildren();
        this.mOverscrollMax = (b - t2) / 3;
        this.mInLayout = false;
    }

    protected void layoutChildren() {
    }

    void updateScrollIndicators() {
        if (this.mScrollUp != null) {
            this.mScrollUp.setVisibility(this.canScrollUp() ? 0 : 4);
        }
        if (this.mScrollDown != null) {
            this.mScrollDown.setVisibility(this.canScrollDown() ? 0 : 4);
        }
    }

    private boolean canScrollUp() {
        boolean canScrollUp;
        boolean bl = canScrollUp = this.mFirstPosition > 0;
        if (!canScrollUp && this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            canScrollUp = child.getTop() < this.mListPadding.top;
        }
        return canScrollUp;
    }

    private boolean canScrollDown() {
        boolean canScrollDown;
        int count = this.getChildCount();
        boolean bl = canScrollDown = this.mFirstPosition + count < this.mItemCount;
        if (!canScrollDown && count > 0) {
            View child = this.getChildAt(count - 1);
            canScrollDown = child.getBottom() > this.getBottom() - this.mListPadding.bottom;
        }
        return canScrollDown;
    }

    @Override
    public View getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    public int getListPaddingTop() {
        return this.mListPadding.top;
    }

    public int getListPaddingBottom() {
        return this.mListPadding.bottom;
    }

    public int getListPaddingLeft() {
        return this.mListPadding.left;
    }

    public int getListPaddingRight() {
        return this.mListPadding.right;
    }

    View obtainView(int position, boolean[] outMetadata) {
        outMetadata[0] = false;
        View transientView = this.mRecycler.getTransientStateView(position);
        if (transientView != null) {
            View updatedView;
            LayoutParams params = (LayoutParams)transientView.getLayoutParams();
            if (params.viewType == this.mAdapter.getItemViewType(position) && (updatedView = this.mAdapter.getView(position, transientView, this)) != transientView) {
                this.setItemViewLayoutParams(updatedView, position);
                this.mRecycler.addScrapView(updatedView, position);
            }
            outMetadata[0] = true;
            transientView.dispatchFinishTemporaryDetach();
            return transientView;
        }
        View scrapView = this.mRecycler.getScrapView(position);
        View child = this.mAdapter.getView(position, scrapView, this);
        if (scrapView != null) {
            if (child != scrapView) {
                this.mRecycler.addScrapView(scrapView, position);
            } else if (child.isTemporarilyDetached()) {
                outMetadata[0] = true;
                child.dispatchFinishTemporaryDetach();
            }
        }
        this.setItemViewLayoutParams(child, position);
        return child;
    }

    private void setItemViewLayoutParams(View child, int position) {
        ViewGroup.LayoutParams vlp = child.getLayoutParams();
        LayoutParams lp = vlp == null ? (LayoutParams)this.generateDefaultLayoutParams() : (!this.checkLayoutParams(vlp) ? (LayoutParams)this.generateLayoutParams(vlp) : (LayoutParams)vlp);
        if (this.mAdapterHasStableIds) {
            lp.itemId = this.mAdapter.getItemId(position);
        }
        lp.viewType = this.mAdapter.getItemViewType(position);
        lp.isEnabled = this.mAdapter.isEnabled(position);
        if (lp != vlp) {
            child.setLayoutParams(lp);
        }
    }

    private boolean isItemClickable(@NonNull View view) {
        return !view.hasExplicitFocusable();
    }

    void positionSelectorLikeTouch(int position, View sel, float x, float y) {
        this.positionSelector(position, sel, true, x, y);
    }

    void positionSelectorLikeFocus(int position, View sel) {
        if (this.mSelector != null && this.mSelectorPosition != position && position != -1) {
            Rect bounds = this.mSelectorRect;
            float x = bounds.exactCenterX();
            float y = bounds.exactCenterY();
            this.positionSelector(position, sel, true, x, y);
        } else {
            this.positionSelector(position, sel);
        }
    }

    void positionSelector(int position, View sel) {
        this.positionSelector(position, sel, false, -1.0f, -1.0f);
    }

    private void positionSelector(int position, View sel, boolean manageHotspot, float x, float y) {
        Drawable selector;
        boolean positionChanged;
        boolean bl = positionChanged = position != this.mSelectorPosition;
        if (position != -1) {
            this.mSelectorPosition = position;
        }
        Rect selectorRect = this.mSelectorRect;
        selectorRect.set(sel.getLeft(), sel.getTop(), sel.getRight(), sel.getBottom());
        if (sel instanceof SelectionBoundsAdjuster) {
            ((SelectionBoundsAdjuster)((Object)sel)).adjustListItemSelectionBounds(selectorRect);
        }
        selectorRect.left -= this.mSelectionLeftPadding;
        selectorRect.top -= this.mSelectionTopPadding;
        selectorRect.right += this.mSelectionRightPadding;
        selectorRect.bottom += this.mSelectionBottomPadding;
        boolean isChildViewEnabled = sel.isEnabled();
        if (this.mIsChildViewEnabled != isChildViewEnabled) {
            this.mIsChildViewEnabled = isChildViewEnabled;
        }
        if ((selector = this.mSelector) != null) {
            if (positionChanged) {
                selector.setVisible(false, false);
                selector.setState(StateSet.WILD_CARD);
            }
            selector.setBounds(selectorRect);
            if (positionChanged) {
                if (this.getVisibility() == 0) {
                    selector.setVisible(true, false);
                }
                this.updateSelectorState();
            }
            if (manageHotspot) {
                selector.setHotspot(x, y);
            }
        }
    }

    @Override
    protected void dispatchDraw(@NonNull Canvas canvas) {
        boolean drawSelectorOnTop;
        boolean clipToPadding = this.hasBooleanFlag(34);
        if (clipToPadding) {
            canvas.save();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.getWidth() - this.mPaddingRight, scrollY + this.getHeight() - this.mPaddingBottom);
            this.setBooleanFlag(34, false);
        }
        if (!(drawSelectorOnTop = this.mDrawSelectorOnTop)) {
            this.drawSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (drawSelectorOnTop) {
            this.drawSelector(canvas);
        }
        if (clipToPadding) {
            canvas.restore();
            this.setBooleanFlag(34, true);
        }
    }

    @Override
    protected void internalSetPadding(int left, int top, int right, int bottom) {
        super.internalSetPadding(left, top, right, bottom);
        if (this.isLayoutRequested()) {
            this.handleBoundsChange();
        }
    }

    @Override
    protected void onSizeChanged(int w, int h2, int oldw, int oldh) {
        super.onSizeChanged(w, h2, oldw, oldh);
        this.handleBoundsChange();
    }

    void handleBoundsChange() {
        if (this.mInLayout) {
            return;
        }
        int childCount = this.getChildCount();
        if (childCount > 0) {
            this.mDataChanged = true;
            this.rememberSyncState();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                if (lp != null && lp.width >= 1 && lp.height >= 1) continue;
                child.forceLayout();
            }
        }
    }

    boolean touchModeDrawsInPressedState() {
        return switch (this.mTouchMode) {
            case 1, 2 -> true;
            default -> false;
        };
    }

    boolean shouldShowSelector() {
        return this.isFocused() && !this.isInTouchMode() || this.touchModeDrawsInPressedState() && this.isPressed();
    }

    private void drawSelector(Canvas canvas) {
        if (this.shouldDrawSelector()) {
            Drawable selector = this.mSelector;
            selector.setBounds(this.mSelectorRect);
            selector.draw(canvas);
        }
    }

    @ApiStatus.Internal
    public final boolean shouldDrawSelector() {
        return !this.mSelectorRect.isEmpty();
    }

    public void setDrawSelectorOnTop(boolean onTop) {
        this.mDrawSelectorOnTop = onTop;
    }

    public boolean isDrawSelectorOnTop() {
        return this.mDrawSelectorOnTop;
    }

    public void setSelector(Drawable sel) {
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = sel;
        Rect padding = new Rect();
        sel.getPadding(padding);
        this.mSelectionLeftPadding = padding.left;
        this.mSelectionTopPadding = padding.top;
        this.mSelectionRightPadding = padding.right;
        this.mSelectionBottomPadding = padding.bottom;
        sel.setCallback(this);
        this.updateSelectorState();
    }

    public Drawable getSelector() {
        return this.mSelector;
    }

    void keyPressed() {
        if (!this.isEnabled() || !this.isClickable()) {
            return;
        }
        Drawable selector = this.mSelector;
        Rect selectorRect = this.mSelectorRect;
        if (selector != null && (this.isFocused() || this.touchModeDrawsInPressedState()) && !selectorRect.isEmpty()) {
            View v = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
            if (v != null) {
                if (v.hasExplicitFocusable()) {
                    return;
                }
                v.setPressed(true);
            }
            this.setPressed(true);
            boolean longClickable = this.isLongClickable();
            Drawable d2 = selector.getCurrent();
            if (longClickable && !this.mDataChanged) {
                if (this.mPendingCheckForKeyLongPress == null) {
                    this.mPendingCheckForKeyLongPress = new CheckForKeyLongPress();
                }
                this.mPendingCheckForKeyLongPress.rememberWindowAttachCount();
                this.postDelayed(this.mPendingCheckForKeyLongPress, ViewConfiguration.getLongPressTimeout());
            }
        }
    }

    public void setScrollIndicators(View up, View down) {
        this.mScrollUp = up;
        this.mScrollDown = down;
    }

    void updateSelectorState() {
        Drawable selector = this.mSelector;
        if (selector != null && selector.isStateful()) {
            if (this.shouldShowSelector()) {
                if (selector.setState(this.getDrawableStateForSelector())) {
                    this.invalidateDrawable(selector);
                }
            } else {
                selector.setState(StateSet.WILD_CARD);
            }
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateSelectorState();
    }

    private int[] getDrawableStateForSelector() {
        if (this.mIsChildViewEnabled) {
            return super.getDrawableState();
        }
        int enabledState = ENABLED_STATE_SET[0];
        int[] state = this.onCreateDrawableState(1);
        int enabledPos = -1;
        for (int i = state.length - 1; i >= 0; --i) {
            if (state[i] != enabledState) continue;
            enabledPos = i;
            break;
        }
        if (enabledPos >= 0) {
            System.arraycopy(state, enabledPos + 1, state, enabledPos, state.length - enabledPos - 1);
        }
        return state;
    }

    @Override
    public boolean verifyDrawable(@NonNull Drawable dr) {
        return this.mSelector == dr || super.verifyDrawable(dr);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mDataChanged = true;
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsDetaching = true;
        this.mRecycler.clear();
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        if (this.mFlingRunnable != null) {
            this.removeCallbacks(this.mFlingRunnable);
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mTouchModeReset != null) {
            this.removeCallbacks(this.mTouchModeReset);
            this.mTouchModeReset.run();
        }
        this.mIsDetaching = false;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        int touchMode;
        super.onWindowFocusChanged(hasWindowFocus);
        int n2 = touchMode = this.isInTouchMode() ? 0 : 1;
        if (!hasWindowFocus) {
            if (this.mFlingRunnable != null) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlingRunnable.mSuppressIdleStateChangeCall = false;
                this.mFlingRunnable.endFling();
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.finishGlows();
                    this.invalidate();
                }
            }
            if (touchMode == 1) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
        } else if (touchMode != this.mLastTouchMode && this.mLastTouchMode != -1) {
            if (touchMode == 1) {
                this.resurrectSelection();
            } else {
                this.hideSelector();
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
        }
        this.mLastTouchMode = touchMode;
    }

    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int position, long id2) {
        return new AdapterView.AdapterContextMenuInfo(view, position, id2);
    }

    @Override
    public void onCancelPendingInputEvents() {
        super.onCancelPendingInputEvents();
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mPendingCheckForTap != null) {
            this.removeCallbacks(this.mPendingCheckForTap);
        }
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
        }
        if (this.mPendingCheckForKeyLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForKeyLongPress);
        }
    }

    private boolean performStylusButtonPressAction(MotionEvent ev) {
        long longPressId;
        int longPressPosition;
        View child;
        if (this.mChoiceMode == 3 && this.mChoiceActionMode == null && (child = this.getChildAt(this.mMotionPosition - this.mFirstPosition)) != null && this.performLongPress(child, longPressPosition = this.mMotionPosition, longPressId = this.mAdapter.getItemId(this.mMotionPosition))) {
            this.mTouchMode = -1;
            this.setPressed(false);
            child.setPressed(false);
            return true;
        }
        return false;
    }

    boolean performLongPress(View child, int longPressPosition, long longPressId) {
        return this.performLongPress(child, longPressPosition, longPressId, Float.NaN, Float.NaN);
    }

    boolean performLongPress(View child, int longPressPosition, long longPressId, float x, float y) {
        if (this.mChoiceMode == 3) {
            if (this.mChoiceActionMode == null && (this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback)) != null) {
                this.setItemChecked(longPressPosition, true);
                this.performHapticFeedback(0);
            }
            return true;
        }
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, child, longPressPosition, longPressId);
        }
        if (!handled) {
            this.mContextMenuInfo = this.createContextMenuInfo(child, longPressPosition, longPressId);
            handled = !Float.isNaN(x) && !Float.isNaN(y) ? super.showContextMenuForChild(this, x, y) : super.showContextMenuForChild(this, Float.NaN, Float.NaN);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    @Override
    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    @Override
    public boolean showContextMenu(float x, float y) {
        int position = this.pointToPosition((int)x, (int)y);
        if (position != -1) {
            long id2 = this.mAdapter.getItemId(position);
            View child = this.getChildAt(position - this.mFirstPosition);
            if (child != null) {
                this.mContextMenuInfo = this.createContextMenuInfo(child, position, id2);
                return super.showContextMenuForChild(this, x, y);
            }
        }
        return super.showContextMenu(x, y);
    }

    @Override
    public boolean showContextMenuForChild(View originalView, float x, float y) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition < 0) {
            return false;
        }
        long longPressId = this.mAdapter.getItemId(longPressPosition);
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, originalView, longPressPosition, longPressId);
        }
        if (!handled) {
            View child = this.getChildAt(longPressPosition - this.mFirstPosition);
            this.mContextMenuInfo = this.createContextMenuInfo(child, longPressPosition, longPressId);
            handled = super.showContextMenuForChild(originalView, x, y);
        }
        return handled;
    }

    @Override
    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, @NonNull KeyEvent event) {
        if (keyCode == 257 || keyCode == 335) {
            if (!this.isEnabled()) {
                return true;
            }
            if (this.isClickable() && this.isPressed() && this.mSelectedPosition >= 0 && this.mAdapter != null && this.mSelectedPosition < this.mAdapter.getCount()) {
                View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                if (view != null) {
                    this.performItemClick(view, this.mSelectedPosition, this.mSelectedRowId);
                    view.setPressed(false);
                }
                this.setPressed(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    protected void dispatchSetPressed(boolean pressed) {
    }

    @Override
    public void dispatchDrawableHotspotChanged(float x, float y) {
    }

    public int pointToPosition(int x, int y) {
        Rect frame = this.mTouchFrame;
        if (frame == null) {
            frame = this.mTouchFrame = new Rect();
        }
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            child.getHitRect(frame);
            if (!frame.contains(x, y)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    public long pointToRowId(int x, int y) {
        int position = this.pointToPosition(x, y);
        if (position >= 0) {
            return this.mAdapter.getItemId(position);
        }
        return Long.MIN_VALUE;
    }

    private boolean startScrollIfNeeded(int x, int y, MotionEvent vtev) {
        boolean overscroll;
        int deltaY = y - this.mMotionY;
        int distance = Math.abs(deltaY);
        boolean bl = overscroll = this.mScrollY != 0;
        if ((overscroll || distance > this.mTouchSlop) && (this.getNestedScrollAxes() & 2) == 0) {
            if (overscroll) {
                this.mTouchMode = 5;
                this.mMotionCorrection = 0;
            } else {
                this.mTouchMode = 3;
                this.mMotionCorrection = deltaY > 0 ? this.mTouchSlop : -this.mTouchSlop;
            }
            this.removeCallbacks(this.mPendingCheckForLongPress);
            this.setPressed(false);
            View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
            if (motionView != null) {
                motionView.setPressed(false);
            }
            this.reportScrollStateChange(1);
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            this.scrollIfNeeded(x, y, vtev);
            return true;
        }
        return false;
    }

    private void scrollIfNeeded(int x, int y, MotionEvent vtev) {
        int rawDeltaY = y - this.mMotionY;
        int scrollOffsetCorrection = 0;
        if (this.mLastY == Integer.MIN_VALUE) {
            rawDeltaY -= this.mMotionCorrection;
        }
        int incrementalDeltaY = this.mLastY != Integer.MIN_VALUE ? y - this.mLastY : rawDeltaY;
        if (this.dispatchNestedPreScroll(0, -(incrementalDeltaY = this.releaseGlow(incrementalDeltaY, x)), this.mScrollConsumed, this.mScrollOffset, 0)) {
            rawDeltaY += this.mScrollConsumed[1];
            scrollOffsetCorrection = -this.mScrollOffset[1];
            incrementalDeltaY += this.mScrollConsumed[1];
            if (vtev != null) {
                vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                this.mNestedYOffset += this.mScrollOffset[1];
            }
        }
        int deltaY = rawDeltaY;
        int lastYCorrection = 0;
        if (this.mTouchMode == 3) {
            if (y != this.mLastY) {
                ViewParent parent;
                if (!this.hasBooleanFlag(524288) && Math.abs(rawDeltaY) > this.mTouchSlop && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                int motionIndex = this.mMotionPosition >= 0 ? this.mMotionPosition - this.mFirstPosition : this.getChildCount() / 2;
                int motionViewPrevTop = 0;
                View motionView = this.getChildAt(motionIndex);
                if (motionView != null) {
                    motionViewPrevTop = motionView.getTop();
                }
                boolean atEdge = false;
                if (incrementalDeltaY != 0) {
                    atEdge = this.trackMotionScroll(deltaY, incrementalDeltaY);
                }
                if ((motionView = this.getChildAt(motionIndex)) != null) {
                    int motionViewRealTop = motionView.getTop();
                    if (atEdge) {
                        int overscroll = -incrementalDeltaY - (motionViewRealTop - motionViewPrevTop);
                        if (this.dispatchNestedScroll(0, overscroll - incrementalDeltaY, 0, overscroll, this.mScrollOffset, 0, this.mScrollConsumed)) {
                            lastYCorrection -= this.mScrollOffset[1];
                            if (vtev != null) {
                                vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                                this.mNestedYOffset += this.mScrollOffset[1];
                            }
                        } else {
                            int overscrollMode;
                            boolean atOverscrollEdge = this.overScrollBy(0, overscroll, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
                            if (atOverscrollEdge && this.mVelocityTracker != null) {
                                this.mVelocityTracker.clear();
                            }
                            if ((overscrollMode = this.getOverScrollMode()) == 0 || overscrollMode == 1 && !this.contentFits()) {
                                if (!atOverscrollEdge) {
                                    this.mDirection = 0;
                                    this.mTouchMode = 5;
                                }
                                if (incrementalDeltaY > 0) {
                                    this.mEdgeGlowTop.onPullDistance((float)(-overscroll) / (float)this.getHeight(), (float)x / (float)this.getWidth());
                                    if (!this.mEdgeGlowBottom.isFinished()) {
                                        this.mEdgeGlowBottom.onRelease();
                                    }
                                    this.invalidateTopGlow();
                                } else {
                                    this.mEdgeGlowBottom.onPullDistance((float)overscroll / (float)this.getHeight(), 1.0f - (float)x / (float)this.getWidth());
                                    if (!this.mEdgeGlowTop.isFinished()) {
                                        this.mEdgeGlowTop.onRelease();
                                    }
                                    this.invalidateBottomGlow();
                                }
                            }
                        }
                    }
                    this.mMotionY = y + lastYCorrection + scrollOffsetCorrection;
                }
                this.mLastY = y + lastYCorrection + scrollOffsetCorrection;
            }
        } else if (this.mTouchMode == 5 && y != this.mLastY) {
            int newDirection;
            int oldScroll = this.mScrollY;
            int newScroll = oldScroll - incrementalDeltaY;
            int n2 = newDirection = y > this.mLastY ? 1 : -1;
            if (this.mDirection == 0) {
                this.mDirection = newDirection;
            }
            int overScrollDistance = -incrementalDeltaY;
            if (newScroll < 0 && oldScroll >= 0 || newScroll > 0 && oldScroll <= 0) {
                overScrollDistance = -oldScroll;
                incrementalDeltaY += overScrollDistance;
            } else {
                incrementalDeltaY = 0;
            }
            if (overScrollDistance != 0) {
                this.overScrollBy(0, overScrollDistance, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
                int overscrollMode = this.getOverScrollMode();
                if (overscrollMode == 0 || overscrollMode == 1 && !this.contentFits()) {
                    if (rawDeltaY > 0) {
                        this.mEdgeGlowTop.onPullDistance((float)overScrollDistance / (float)this.getHeight(), (float)x / (float)this.getWidth());
                        if (!this.mEdgeGlowBottom.isFinished()) {
                            this.mEdgeGlowBottom.onRelease();
                        }
                        this.invalidateTopGlow();
                    } else if (rawDeltaY < 0) {
                        this.mEdgeGlowBottom.onPullDistance((float)(-overScrollDistance) / (float)this.getHeight(), 1.0f - (float)x / (float)this.getWidth());
                        if (!this.mEdgeGlowTop.isFinished()) {
                            this.mEdgeGlowTop.onRelease();
                        }
                        this.invalidateBottomGlow();
                    }
                }
            }
            if (incrementalDeltaY != 0) {
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                }
                this.trackMotionScroll(incrementalDeltaY, incrementalDeltaY);
                this.mTouchMode = 3;
                int motionPosition = this.findClosestMotionRow(y);
                this.mMotionCorrection = 0;
                View motionView = this.getChildAt(motionPosition - this.mFirstPosition);
                this.mMotionViewOriginalTop = motionView != null ? motionView.getTop() : 0;
                this.mMotionY = y + scrollOffsetCorrection;
                this.mMotionPosition = motionPosition;
            }
            this.mLastY = y + lastYCorrection + scrollOffsetCorrection;
            this.mDirection = newDirection;
        }
    }

    private int releaseGlow(int deltaY, int x) {
        float consumed = 0.0f;
        if (this.mEdgeGlowTop.getDistance() != 0.0f) {
            consumed = this.mEdgeGlowTop.onPullDistance((float)deltaY / (float)this.getHeight(), (float)x / (float)this.getWidth());
            if (consumed != 0.0f) {
                this.invalidateTopGlow();
            }
        } else if (this.mEdgeGlowBottom.getDistance() != 0.0f && (consumed = -this.mEdgeGlowBottom.onPullDistance((float)(-deltaY) / (float)this.getHeight(), 1.0f - (float)x / (float)this.getWidth())) != 0.0f) {
            this.invalidateBottomGlow();
        }
        int pixelsConsumed = Math.round(consumed * (float)this.getHeight());
        return deltaY - pixelsConsumed;
    }

    private boolean isGlowActive() {
        return this.mEdgeGlowBottom.getDistance() != 0.0f || this.mEdgeGlowTop.getDistance() != 0.0f;
    }

    private void invalidateTopGlow() {
        if (!this.shouldDisplayEdgeEffects()) {
            return;
        }
        this.invalidate();
    }

    private void invalidateBottomGlow() {
        if (!this.shouldDisplayEdgeEffects()) {
            return;
        }
        this.invalidate();
    }

    public void onTouchModeChanged(boolean isInTouchMode) {
        if (isInTouchMode) {
            this.hideSelector();
            if (this.getHeight() > 0 && this.getChildCount() > 0) {
                this.layoutChildren();
            }
            this.updateSelectorState();
        } else {
            int touchMode = this.mTouchMode;
            if (touchMode == 5 || touchMode == 6) {
                if (this.mFlingRunnable != null) {
                    this.mFlingRunnable.endFling();
                }
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.finishGlows();
                    this.invalidate();
                }
            }
        }
    }

    @Override
    protected boolean handleScrollBarDragging(MotionEvent event) {
        return false;
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        if (!this.isEnabled()) {
            return this.isClickable() || this.isLongClickable();
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mIsDetaching || !this.isAttachedToWindow()) {
            return false;
        }
        this.startNestedScroll(2, 0);
        this.initVelocityTrackerIfNotExists();
        MotionEvent vtev = ev.copy();
        int action = ev.getAction();
        if (action == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, this.mNestedYOffset);
        switch (action) {
            case 0: {
                this.onTouchDown(ev);
                break;
            }
            case 2: {
                this.onTouchMove(ev, vtev);
                break;
            }
            case 1: {
                this.onTouchUp(ev);
                break;
            }
            case 3: {
                this.onTouchCancel();
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private void onTouchDown(@NonNull MotionEvent ev) {
        this.mHasPerformedLongPress = false;
        this.hideSelector();
        if (this.mTouchMode == 6) {
            if (this.mFlingRunnable != null) {
                this.mFlingRunnable.endFling();
            }
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            this.mTouchMode = 5;
            this.mMotionX = (int)ev.getX();
            this.mLastY = this.mMotionY = (int)ev.getY();
            this.mMotionCorrection = 0;
            this.mDirection = 0;
            this.stopEdgeGlowRecede(ev.getX());
        } else {
            int x = (int)ev.getX();
            int y = (int)ev.getY();
            int motionPosition = this.pointToPosition(x, y);
            if (!this.mDataChanged) {
                if (this.mTouchMode == 4) {
                    this.mTouchMode = 3;
                    this.mMotionCorrection = 0;
                    motionPosition = this.findMotionRow(y);
                    if (this.mFlingRunnable != null) {
                        this.mFlingRunnable.flywheelTouch();
                    }
                    this.stopEdgeGlowRecede(x);
                } else if (motionPosition >= 0 && ((ListAdapter)this.getAdapter()).isEnabled(motionPosition)) {
                    this.mTouchMode = 0;
                    if (this.mPendingCheckForTap == null) {
                        this.mPendingCheckForTap = new CheckForTap();
                    }
                    this.mPendingCheckForTap.x = ev.getX();
                    this.mPendingCheckForTap.y = ev.getY();
                    this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                }
            }
            if (motionPosition >= 0) {
                View v = this.getChildAt(motionPosition - this.mFirstPosition);
                this.mMotionViewOriginalTop = v.getTop();
            }
            this.mMotionX = x;
            this.mMotionY = y;
            this.mMotionPosition = motionPosition;
            this.mLastY = Integer.MIN_VALUE;
        }
        if (this.mTouchMode == 0 && this.mMotionPosition != -1 && this.performButtonActionOnTouchDown(ev)) {
            this.removeCallbacks(this.mPendingCheckForTap);
        }
    }

    private void stopEdgeGlowRecede(float x) {
        if (this.mEdgeGlowTop.getDistance() != 0.0f) {
            this.mEdgeGlowTop.onPullDistance(0.0f, x / (float)this.getWidth());
        }
        if (this.mEdgeGlowBottom.getDistance() != 0.0f) {
            this.mEdgeGlowBottom.onPullDistance(0.0f, x / (float)this.getWidth());
        }
    }

    private void onTouchMove(@NonNull MotionEvent ev, @NonNull MotionEvent vtev) {
        if (this.mHasPerformedLongPress) {
            return;
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        int y = (int)ev.getY();
        switch (this.mTouchMode) {
            case 0: 
            case 1: 
            case 2: {
                if (this.startScrollIfNeeded((int)ev.getX(), y, vtev)) break;
                View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                float x = ev.getX();
                if (!this.pointInView(x, y, this.mTouchSlop)) {
                    this.setPressed(false);
                    if (motionView != null) {
                        motionView.setPressed(false);
                    }
                    this.removeCallbacks(this.mTouchMode == 0 ? this.mPendingCheckForTap : this.mPendingCheckForLongPress);
                    this.mTouchMode = 2;
                    this.updateSelectorState();
                    break;
                }
                if (motionView == null) break;
                float[] point = this.mTmpPoint;
                point[0] = x;
                point[1] = y;
                this.transformPointToViewLocal(point, motionView);
                motionView.drawableHotspotChanged(point[0], point[1]);
                break;
            }
            case 3: 
            case 5: {
                this.scrollIfNeeded((int)ev.getX(), y, vtev);
            }
        }
    }

    private void onTouchUp(@NonNull MotionEvent ev) {
        switch (this.mTouchMode) {
            case 0: 
            case 1: 
            case 2: {
                int motionPosition = this.mMotionPosition;
                View child = this.getChildAt(motionPosition - this.mFirstPosition);
                if (child != null) {
                    float x;
                    boolean inList;
                    if (this.mTouchMode != 0) {
                        child.setPressed(false);
                    }
                    boolean bl = inList = (x = ev.getX()) > (float)this.mListPadding.left && x < (float)(this.getWidth() - this.mListPadding.right);
                    if (inList && !child.hasExplicitFocusable()) {
                        if (this.mPerformClick == null) {
                            this.mPerformClick = new PerformClick();
                        }
                        PerformClick performClick = this.mPerformClick;
                        performClick.mClickMotionPosition = motionPosition;
                        performClick.rememberWindowAttachCount();
                        this.mResurrectToPosition = motionPosition;
                        if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                            this.removeCallbacks(this.mTouchMode == 0 ? this.mPendingCheckForTap : this.mPendingCheckForLongPress);
                            this.mLayoutMode = 0;
                            if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                                this.mTouchMode = 1;
                                this.setSelectedPositionInt(this.mMotionPosition);
                                this.layoutChildren();
                                child.setPressed(true);
                                this.positionSelector(this.mMotionPosition, child);
                                this.setPressed(true);
                                if (this.mSelector != null) {
                                    Drawable d2 = this.mSelector.getCurrent();
                                    this.mSelector.setHotspot(x, ev.getY());
                                }
                                if (this.mTouchModeReset != null) {
                                    this.removeCallbacks(this.mTouchModeReset);
                                }
                                this.mTouchModeReset = () -> {
                                    this.mTouchModeReset = null;
                                    this.mTouchMode = -1;
                                    child.setPressed(false);
                                    this.setPressed(false);
                                    if (!this.mDataChanged && !this.mIsDetaching && this.isAttachedToWindow()) {
                                        performClick.run();
                                    }
                                };
                                this.postDelayed(this.mTouchModeReset, ViewConfiguration.getPressedStateDuration());
                            } else {
                                this.mTouchMode = -1;
                                this.updateSelectorState();
                            }
                            return;
                        }
                        if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                            performClick.run();
                        }
                    }
                }
                this.mTouchMode = -1;
                this.updateSelectorState();
                break;
            }
            case 3: {
                int childCount = this.getChildCount();
                if (childCount > 0) {
                    boolean flingVelocity;
                    int firstChildTop = this.getChildAt(0).getTop();
                    int lastChildBottom = this.getChildAt(childCount - 1).getBottom();
                    int contentTop = this.mListPadding.top;
                    int contentBottom = this.getHeight() - this.mListPadding.bottom;
                    if (this.mFirstPosition == 0 && firstChildTop >= contentTop && this.mFirstPosition + childCount < this.mItemCount && lastChildBottom <= this.getHeight() - contentBottom) {
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                    int initialVelocity = (int)(velocityTracker.getYVelocity() * this.mVelocityScale);
                    boolean bl = flingVelocity = Math.abs(initialVelocity) > this.mMinimumVelocity;
                    if (flingVelocity && !this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onAbsorb(initialVelocity);
                        break;
                    }
                    if (flingVelocity && !this.mEdgeGlowBottom.isFinished()) {
                        this.mEdgeGlowBottom.onAbsorb(-initialVelocity);
                        break;
                    }
                    if (!(!flingVelocity || this.mFirstPosition == 0 && firstChildTop == contentTop - this.mOverscrollDistance || this.mFirstPosition + childCount == this.mItemCount && lastChildBottom == contentBottom + this.mOverscrollDistance)) {
                        if (!this.dispatchNestedPreFling(0.0f, -initialVelocity)) {
                            if (this.mFlingRunnable == null) {
                                this.mFlingRunnable = new FlingRunnable();
                            }
                            this.reportScrollStateChange(2);
                            this.mFlingRunnable.start(-initialVelocity);
                            this.dispatchNestedFling(0.0f, -initialVelocity, true);
                            break;
                        }
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    this.mTouchMode = -1;
                    this.reportScrollStateChange(0);
                    if (this.mFlingRunnable != null) {
                        this.mFlingRunnable.endFling();
                    }
                    if (this.mPositionScroller != null) {
                        this.mPositionScroller.stop();
                    }
                    if (!flingVelocity || this.dispatchNestedPreFling(0.0f, -initialVelocity)) break;
                    this.dispatchNestedFling(0.0f, -initialVelocity, false);
                    break;
                }
                this.mTouchMode = -1;
                this.reportScrollStateChange(0);
                break;
            }
            case 5: {
                if (this.mFlingRunnable == null) {
                    this.mFlingRunnable = new FlingRunnable();
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity();
                this.reportScrollStateChange(2);
                if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                    this.mFlingRunnable.startOverfling(-initialVelocity);
                    break;
                }
                this.mFlingRunnable.startSpringback();
            }
        }
        this.setPressed(false);
        if (this.shouldDisplayEdgeEffects()) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        this.invalidate();
        this.removeCallbacks(this.mPendingCheckForLongPress);
        this.recycleVelocityTracker();
    }

    private boolean shouldDisplayEdgeEffects() {
        return this.getOverScrollMode() != 2;
    }

    private void onTouchCancel() {
        switch (this.mTouchMode) {
            case 5: {
                if (this.mFlingRunnable == null) {
                    this.mFlingRunnable = new FlingRunnable();
                }
                this.mFlingRunnable.startSpringback();
                break;
            }
            case 6: {
                break;
            }
            default: {
                this.mTouchMode = -1;
                this.setPressed(false);
                View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (motionView != null) {
                    motionView.setPressed(false);
                }
                this.removeCallbacks(this.mPendingCheckForLongPress);
                this.recycleVelocityTracker();
            }
        }
        if (this.shouldDisplayEdgeEffects()) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
    }

    @Override
    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (this.mScrollY != scrollY) {
            this.onScrollChanged(this.mScrollX, scrollY, this.mScrollX, this.mScrollY);
            this.mScrollY = scrollY;
            this.awakenScrollBars();
        }
    }

    @Override
    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        switch (event.getAction()) {
            case 8: {
                float axisValue = event.getAxisValue(9);
                int delta = Math.round(axisValue * this.mVerticalScrollFactor);
                if (delta == 0 || this.trackMotionScroll(delta, delta)) break;
                return true;
            }
            case 11: {
                int actionButton = event.getActionButton();
                if (actionButton != 2 || this.mTouchMode != 0 && this.mTouchMode != 1 || !this.performStylusButtonPressAction(event)) break;
                this.removeCallbacks(this.mPendingCheckForLongPress);
                this.removeCallbacks(this.mPendingCheckForTap);
            }
        }
        return super.onGenericMotionEvent(event);
    }

    public void fling(int velocityY) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        this.reportScrollStateChange(2);
        this.mFlingRunnable.start(velocityY);
    }

    @Override
    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int axes, int type) {
        return (axes & 2) != 0;
    }

    @Override
    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int axes, int type) {
        super.onNestedScrollAccepted(child, target, axes, type);
        this.startNestedScroll(2, type);
    }

    @Override
    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NonNull int[] consumed) {
        int oldTop;
        int motionIndex = this.getChildCount() / 2;
        View motionView = this.getChildAt(motionIndex);
        int n2 = oldTop = motionView != null ? motionView.getTop() : 0;
        if (motionView == null || this.trackMotionScroll(-dyUnconsumed, -dyUnconsumed)) {
            int myUnconsumed = dyUnconsumed;
            int myConsumed = 0;
            if (motionView != null) {
                myConsumed = motionView.getTop() - oldTop;
                myUnconsumed -= myConsumed;
            }
            consumed[1] = consumed[1] + myConsumed;
            this.dispatchNestedScroll(0, myConsumed, 0, myUnconsumed, null, type, consumed);
        }
    }

    @Override
    public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
        int childCount = this.getChildCount();
        if (!consumed && childCount > 0 && this.canScrollList((int)velocityY) && Math.abs(velocityY) > (float)this.mMinimumVelocity) {
            this.reportScrollStateChange(2);
            if (this.mFlingRunnable == null) {
                this.mFlingRunnable = new FlingRunnable();
            }
            if (!this.dispatchNestedPreFling(0.0f, velocityY)) {
                this.mFlingRunnable.start((int)velocityY);
            }
            return true;
        }
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    @Override
    public void onDrawForeground(@NonNull Canvas canvas) {
        super.onDrawForeground(canvas);
        if (this.shouldDisplayEdgeEffects()) {
            int restoreCount;
            int translateY;
            int translateX;
            int height;
            int width;
            int scrollY = this.mScrollY;
            boolean clipToPadding = this.getClipToPadding();
            if (clipToPadding) {
                width = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                translateX = this.mPaddingLeft;
                translateY = this.mPaddingTop;
            } else {
                width = this.getWidth();
                height = this.getHeight();
                translateX = 0;
                translateY = 0;
            }
            this.mEdgeGlowTop.setSize(width, height);
            this.mEdgeGlowBottom.setSize(width, height);
            if (!this.mEdgeGlowTop.isFinished()) {
                restoreCount = canvas.save();
                canvas.clipRect(translateX, translateY, translateX + width, translateY + this.mEdgeGlowTop.getMaxHeight());
                int edgeY = Math.min(0, scrollY + this.mFirstPositionDistanceGuess) + translateY;
                canvas.translate(translateX, edgeY);
                if (this.mEdgeGlowTop.draw(canvas)) {
                    this.invalidateTopGlow();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                restoreCount = canvas.save();
                canvas.clipRect(translateX, translateY + height - this.mEdgeGlowBottom.getMaxHeight(), translateX + width, translateY + height);
                int edgeX = -width + translateX;
                int edgeY = Math.max(this.getHeight(), scrollY + this.mLastPositionDistanceGuess) - (clipToPadding ? this.mPaddingBottom : 0);
                canvas.translate(edgeX, edgeY);
                canvas.rotate(180.0f, width, 0.0f);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    this.invalidateBottomGlow();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    @Override
    public boolean onInterceptTouchEvent(@NonNull MotionEvent ev) {
        int action = ev.getAction();
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mIsDetaching || !this.isAttachedToWindow()) {
            return false;
        }
        switch (action) {
            case 0: {
                int touchMode = this.mTouchMode;
                if (touchMode == 6 || touchMode == 5) {
                    this.mMotionCorrection = 0;
                    return true;
                }
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                int motionPosition = this.findMotionRow(y);
                if (this.isGlowActive()) {
                    this.mTouchMode = 4;
                    touchMode = 4;
                } else if (touchMode != 4 && motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = v.getTop();
                    this.mMotionX = x;
                    this.mMotionY = y;
                    this.mMotionPosition = motionPosition;
                    this.mTouchMode = 0;
                }
                this.mLastY = Integer.MIN_VALUE;
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mNestedYOffset = 0;
                this.startNestedScroll(2, 0);
                if (touchMode != 4) break;
                return true;
            }
            case 2: {
                if (this.mTouchMode != 0) break;
                int y = (int)ev.getY();
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(ev);
                if (!this.startScrollIfNeeded((int)ev.getX(), y, null)) break;
                return true;
            }
            case 1: 
            case 3: {
                this.mTouchMode = -1;
                this.recycleVelocityTracker();
                this.reportScrollStateChange(0);
                this.stopNestedScroll(0);
            }
        }
        return false;
    }

    @Override
    public void addTouchables(@NonNull ArrayList<View> views) {
        int count = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (adapter.isEnabled(firstPosition + i)) {
                views.add(child);
            }
            child.addTouchables(views);
        }
    }

    void reportScrollStateChange(int newState) {
        if (newState != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mLastScrollState = newState;
            this.mOnScrollListener.onScrollStateChanged(this, newState);
        }
    }

    public void setFriction(float friction) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        this.mFlingRunnable.mScroller.setFriction(friction);
    }

    public void setVelocityScale(float scale) {
        this.mVelocityScale = scale;
    }

    PositionScroller createPositionScroller() {
        return new DefaultPositionScroller();
    }

    public void smoothScrollToPosition(int position) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.start(position);
    }

    public void smoothScrollToPositionFromTop(int position, int offset, int duration) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset, duration);
    }

    public void smoothScrollToPositionFromTop(int position, int offset) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset);
    }

    public void smoothScrollToPosition(int position, int boundPosition) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.start(position, boundPosition);
    }

    public void smoothScrollBy(int distance, int duration) {
        this.smoothScrollBy(distance, duration, false, false);
    }

    void smoothScrollBy(int distance, int duration, boolean linear, boolean suppressEndFlingStateChangeCall) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        int firstPos = this.mFirstPosition;
        int childCount = this.getChildCount();
        int lastPos = firstPos + childCount;
        int topLimit = this.getPaddingTop();
        int bottomLimit = this.getHeight() - this.getPaddingBottom();
        if (distance == 0 || this.mItemCount == 0 || childCount == 0 || firstPos == 0 && this.getChildAt(0).getTop() == topLimit && distance < 0 || lastPos == this.mItemCount && this.getChildAt(childCount - 1).getBottom() == bottomLimit && distance > 0) {
            this.mFlingRunnable.endFling();
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
        } else {
            this.reportScrollStateChange(2);
            this.mFlingRunnable.startScroll(distance, duration, linear, suppressEndFlingStateChangeCall);
        }
    }

    void smoothScrollByOffset(int position) {
        View child;
        int index = -1;
        if (position < 0) {
            index = this.getFirstVisiblePosition();
        } else if (position > 0) {
            index = this.getLastVisiblePosition();
        }
        if (index > -1 && (child = this.getChildAt(index - this.getFirstVisiblePosition())) != null) {
            Rect visibleRect = new Rect();
            if (child.getGlobalVisibleRect(visibleRect)) {
                int childRectArea = child.getWidth() * child.getHeight();
                int visibleRectArea = visibleRect.width() * visibleRect.height();
                float visibleArea = (float)visibleRectArea / (float)childRectArea;
                float visibleThreshold = 0.75f;
                if (position < 0 && visibleArea < 0.75f) {
                    ++index;
                } else if (position > 0 && visibleArea < 0.75f) {
                    --index;
                }
            }
            this.smoothScrollToPosition(Math.max(0, Math.min(this.getCount(), index + position)));
        }
    }

    public void scrollListBy(int y) {
        this.trackMotionScroll(-y, -y);
    }

    public boolean canScrollList(int direction) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return false;
        }
        int firstPosition = this.mFirstPosition;
        Rect listPadding = this.mListPadding;
        if (direction > 0) {
            int lastBottom = this.getChildAt(childCount - 1).getBottom();
            int lastPosition = firstPosition + childCount;
            return lastPosition < this.mItemCount || lastBottom > this.getHeight() - listPadding.bottom;
        }
        int firstTop = this.getChildAt(0).getTop();
        return firstPosition > 0 || firstTop < listPadding.top;
    }

    boolean trackMotionScroll(int deltaY, int incrementalDeltaY) {
        int childIndex;
        int absIncrementalDeltaY;
        boolean cannotScrollUp;
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        int firstTop = this.getChildAt(0).getTop();
        int lastBottom = this.getChildAt(childCount - 1).getBottom();
        Rect listPadding = this.mListPadding;
        int effectivePaddingTop = 0;
        int effectivePaddingBottom = 0;
        if (this.hasBooleanFlag(34)) {
            effectivePaddingTop = listPadding.top;
            effectivePaddingBottom = listPadding.bottom;
        }
        int spaceAbove = effectivePaddingTop - firstTop;
        int end = this.getHeight() - effectivePaddingBottom;
        int spaceBelow = lastBottom - end;
        int height = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
        deltaY = deltaY < 0 ? Math.max(-(height - 1), deltaY) : Math.min(height - 1, deltaY);
        incrementalDeltaY = incrementalDeltaY < 0 ? Math.max(-(height - 1), incrementalDeltaY) : Math.min(height - 1, incrementalDeltaY);
        int firstPosition = this.mFirstPosition;
        this.mFirstPositionDistanceGuess = firstPosition == 0 ? firstTop - listPadding.top : (this.mFirstPositionDistanceGuess += incrementalDeltaY);
        this.mLastPositionDistanceGuess = firstPosition + childCount == this.mItemCount ? lastBottom + listPadding.bottom : (this.mLastPositionDistanceGuess += incrementalDeltaY);
        boolean cannotScrollDown = firstPosition == 0 && firstTop >= listPadding.top && incrementalDeltaY >= 0;
        boolean bl = cannotScrollUp = firstPosition + childCount == this.mItemCount && lastBottom <= this.getHeight() - listPadding.bottom && incrementalDeltaY <= 0;
        if (cannotScrollDown || cannotScrollUp) {
            return incrementalDeltaY != 0;
        }
        boolean down = incrementalDeltaY < 0;
        boolean inTouchMode = this.isInTouchMode();
        if (inTouchMode) {
            this.hideSelector();
        }
        int headerViewsCount = this.getHeaderViewsCount();
        int footerViewsStart = this.mItemCount - this.getFooterViewsCount();
        int start = 0;
        int count = 0;
        if (down) {
            int top = -incrementalDeltaY;
            if (this.hasBooleanFlag(34)) {
                top += listPadding.top;
            }
            for (i = 0; i < childCount && (child = this.getChildAt(i)).getBottom() < top; ++i) {
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                this.mRecycler.addScrapView(child, position);
            }
        } else {
            int bottom = this.getHeight() - incrementalDeltaY;
            if (this.hasBooleanFlag(34)) {
                bottom -= listPadding.bottom;
            }
            for (i = childCount - 1; i >= 0 && (child = this.getChildAt(i)).getTop() > bottom; --i) {
                start = i;
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                this.mRecycler.addScrapView(child, position);
            }
        }
        this.mMotionViewNewTop = this.mMotionViewOriginalTop + deltaY;
        this.mBlockLayoutRequests = true;
        if (count > 0) {
            this.detachViewsFromParent(start, count);
            this.mRecycler.removeSkippedScrap();
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        this.offsetChildrenTopAndBottom(incrementalDeltaY);
        if (down) {
            this.mFirstPosition += count;
        }
        if (spaceAbove < (absIncrementalDeltaY = Math.abs(incrementalDeltaY)) || spaceBelow < absIncrementalDeltaY) {
            this.fillGap(down);
        }
        this.mRecycler.fullyDetachScrapViews();
        boolean selectorOnScreen = false;
        if (!inTouchMode && this.mSelectedPosition != -1) {
            int childIndex2 = this.mSelectedPosition - this.mFirstPosition;
            if (childIndex2 >= 0 && childIndex2 < this.getChildCount()) {
                this.positionSelector(this.mSelectedPosition, this.getChildAt(childIndex2));
                selectorOnScreen = true;
            }
        } else if (this.mSelectorPosition != -1 && (childIndex = this.mSelectorPosition - this.mFirstPosition) >= 0 && childIndex < this.getChildCount()) {
            this.positionSelector(this.mSelectorPosition, this.getChildAt(childIndex));
            selectorOnScreen = true;
        }
        if (!selectorOnScreen) {
            this.mSelectorRect.setEmpty();
        }
        this.mBlockLayoutRequests = false;
        this.invokeOnItemScrollListener();
        return false;
    }

    int getHeaderViewsCount() {
        return 0;
    }

    int getFooterViewsCount() {
        return 0;
    }

    abstract void fillGap(boolean var1);

    void hideSelector() {
        if (this.mSelectedPosition != -1) {
            if (this.mLayoutMode != 4) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
            if (this.mNextSelectedPosition >= 0 && this.mNextSelectedPosition != this.mSelectedPosition) {
                this.mResurrectToPosition = this.mNextSelectedPosition;
            }
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectedTop = 0;
        }
    }

    int reconcileSelectedPosition() {
        int position = this.mSelectedPosition;
        if (position < 0) {
            position = this.mResurrectToPosition;
        }
        position = Math.max(0, position);
        position = Math.min(position, this.mItemCount - 1);
        return position;
    }

    abstract int findMotionRow(int var1);

    int findClosestMotionRow(int y) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return -1;
        }
        int motionRow = this.findMotionRow(y);
        return motionRow != -1 ? motionRow : this.mFirstPosition + childCount - 1;
    }

    public void invalidateViews() {
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
        this.invalidate();
    }

    boolean resurrectSelectionIfNeeded() {
        if (this.mSelectedPosition < 0 && this.resurrectSelection()) {
            this.updateSelectorState();
            return true;
        }
        return false;
    }

    abstract void setSelectionInt(int var1);

    boolean resurrectSelection() {
        int selectedPos;
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            return false;
        }
        int selectedTop = 0;
        int childrenTop = this.mListPadding.top;
        int childrenBottom = this.getHeight() - this.mListPadding.bottom;
        int firstPosition = this.mFirstPosition;
        int toPosition = this.mResurrectToPosition;
        boolean down = true;
        if (toPosition >= firstPosition && toPosition < firstPosition + childCount) {
            selectedPos = toPosition;
            View selected = this.getChildAt(selectedPos - this.mFirstPosition);
            selectedTop = selected.getTop();
            int selectedBottom = selected.getBottom();
            if (selectedTop < childrenTop) {
                selectedTop = childrenTop;
            } else if (selectedBottom > childrenBottom) {
                selectedTop = childrenBottom - selected.getMeasuredHeight();
            }
        } else if (toPosition < firstPosition) {
            selectedPos = firstPosition;
            for (int i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                int top = v.getTop();
                if (i == 0) {
                    selectedTop = top;
                }
                if (top < childrenTop) continue;
                selectedPos = firstPosition + i;
                selectedTop = top;
                break;
            }
        } else {
            int itemCount = this.mItemCount;
            down = false;
            selectedPos = firstPosition + childCount - 1;
            for (int i = childCount - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                int top = v.getTop();
                int bottom = v.getBottom();
                if (i == childCount - 1) {
                    selectedTop = top;
                }
                if (bottom > childrenBottom) continue;
                selectedPos = firstPosition + i;
                selectedTop = top;
                break;
            }
        }
        this.mResurrectToPosition = -1;
        this.removeCallbacks(this.mFlingRunnable);
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.mTouchMode = -1;
        this.mSpecificTop = selectedTop;
        if ((selectedPos = this.lookForSelectablePosition(selectedPos, down)) >= firstPosition && selectedPos <= this.getLastVisiblePosition()) {
            this.mLayoutMode = 4;
            this.updateSelectorState();
            this.setSelectionInt(selectedPos);
            this.invokeOnItemScrollListener();
        } else {
            selectedPos = -1;
        }
        this.reportScrollStateChange(0);
        return selectedPos >= 0;
    }

    void confirmCheckedPositionsById() {
        this.mCheckStates.clear();
        boolean checkedCountChanged = false;
        ObjectIterator it = Long2IntMaps.fastIterator((Long2IntMap)this.mCheckedIdStates);
        while (it.hasNext()) {
            int lastPos;
            long lastPosId;
            Long2IntMap.Entry entry = (Long2IntMap.Entry)it.next();
            long id2 = entry.getLongKey();
            if (id2 != (lastPosId = this.mAdapter.getItemId(lastPos = entry.getIntValue()))) {
                int start = Math.max(0, lastPos - 20);
                int end = Math.min(lastPos + 20, this.mItemCount);
                boolean found = false;
                for (int searchPos = start; searchPos < end; ++searchPos) {
                    long searchId = this.mAdapter.getItemId(searchPos);
                    if (id2 != searchId) continue;
                    found = true;
                    this.mCheckStates.put(searchPos, true);
                    entry.setValue(searchPos);
                    break;
                }
                if (found) continue;
                it.remove();
                --this.mCheckedItemCount;
                checkedCountChanged = true;
                if (this.mChoiceActionMode == null || this.mMultiChoiceModeCallback == null) continue;
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, lastPos, id2, false);
                continue;
            }
            this.mCheckStates.put(lastPos, true);
        }
        if (checkedCountChanged && this.mChoiceActionMode != null) {
            this.mChoiceActionMode.invalidate();
        }
    }

    @Override
    protected void handleDataChanged() {
        int count = this.mItemCount;
        int lastHandledItemCount = this.mLastHandledItemCount;
        this.mLastHandledItemCount = this.mItemCount;
        if (this.mChoiceMode != 0 && this.mAdapter != null && this.mAdapter.hasStableIds()) {
            this.confirmCheckedPositionsById();
        }
        this.mRecycler.clearTransientStateViews();
        if (count > 0) {
            int selectablePos;
            int newPos;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                if (this.mTranscriptMode == 2) {
                    this.mLayoutMode = 3;
                    return;
                }
                if (this.mTranscriptMode == 1) {
                    int lastBottom;
                    if (this.mForceTranscriptScroll) {
                        this.mForceTranscriptScroll = false;
                        this.mLayoutMode = 3;
                        return;
                    }
                    int childCount = this.getChildCount();
                    int listBottom = this.getHeight() - this.getPaddingBottom();
                    View lastChild = this.getChildAt(childCount - 1);
                    int n2 = lastBottom = lastChild != null ? lastChild.getBottom() : listBottom;
                    if (this.mFirstPosition + childCount >= lastHandledItemCount && lastBottom <= listBottom) {
                        this.mLayoutMode = 3;
                        return;
                    }
                    this.awakenScrollBars();
                }
                switch (this.mSyncMode) {
                    case 0: {
                        if (this.isInTouchMode()) {
                            this.mLayoutMode = 5;
                            this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                            return;
                        }
                        newPos = this.findSyncPosition();
                        if (newPos < 0 || (selectablePos = this.lookForSelectablePosition(newPos, true)) != newPos) break;
                        this.mSyncPosition = newPos;
                        this.mLayoutMode = this.mSyncHeight == (long)this.getHeight() ? 5 : 2;
                        this.setNextSelectedPositionInt(newPos);
                        return;
                    }
                    case 1: {
                        this.mLayoutMode = 5;
                        this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                        return;
                    }
                }
            }
            if (!this.isInTouchMode()) {
                newPos = this.getSelectedItemPosition();
                if (newPos >= count) {
                    newPos = count - 1;
                }
                if (newPos < 0) {
                    newPos = 0;
                }
                if ((selectablePos = this.lookForSelectablePosition(newPos, true)) >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
                selectablePos = this.lookForSelectablePosition(newPos, false);
                if (selectablePos >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
            } else if (this.mResurrectToPosition >= 0) {
                return;
            }
        }
        this.mLayoutMode = this.mStackFromBottom ? 3 : 1;
        this.mSelectedPosition = -1;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mNextSelectedPosition = -1;
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mNeedSync = false;
        this.mSelectorPosition = -1;
        this.checkSelectionChanged();
    }

    static int getDistance(@NonNull Rect source, @NonNull Rect dest, int direction) {
        int dX;
        int sY;
        int sX;
        int dY = switch (direction) {
            case 66 -> {
                sX = source.right;
                sY = source.top + source.height() / 2;
                dX = dest.left;
                yield dest.top + dest.height() / 2;
            }
            case 130 -> {
                sX = source.left + source.width() / 2;
                sY = source.bottom;
                dX = dest.left + dest.width() / 2;
                yield dest.top;
            }
            case 17 -> {
                sX = source.left;
                sY = source.top + source.height() / 2;
                dX = dest.right;
                yield dest.top + dest.height() / 2;
            }
            case 33 -> {
                sX = source.left + source.width() / 2;
                sY = source.top;
                dX = dest.left + dest.width() / 2;
                yield dest.bottom;
            }
            case 1, 2 -> {
                sX = source.right + source.width() / 2;
                sY = source.top + source.height() / 2;
                dX = dest.left + dest.width() / 2;
                yield dest.top + dest.height() / 2;
            }
            default -> throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT, FOCUS_FORWARD, FOCUS_BACKWARD}.");
        };
        int deltaX = dX - sX;
        int deltaY = dY - sY;
        return deltaY * deltaY + deltaX * deltaX;
    }

    @Override
    public void onFilterComplete(int count) {
        if (this.mSelectedPosition < 0 && count > 0) {
            this.mResurrectToPosition = -1;
            this.resurrectSelection();
        }
    }

    @Override
    @NonNull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2, 0);
    }

    @Override
    @NonNull
    protected ViewGroup.LayoutParams generateLayoutParams(@NonNull ViewGroup.LayoutParams p2) {
        return new LayoutParams(p2);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p2) {
        return p2 instanceof LayoutParams;
    }

    public void setTranscriptMode(int mode) {
        this.mTranscriptMode = mode;
    }

    public int getTranscriptMode() {
        return this.mTranscriptMode;
    }

    public void reclaimViews(@NonNull List<View> views) {
        int childCount = this.getChildCount();
        RecyclerListener listener = this.mRecycler.mRecyclerListener;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp == null || !this.mRecycler.shouldRecycleViewType(lp.viewType)) continue;
            views.add(child);
            if (listener == null) continue;
            listener.onMovedToScrapHeap(child);
        }
        this.mRecycler.reclaimScrapViews(views);
        this.removeAllViewsInLayout();
    }

    private void finishGlows() {
        if (this.shouldDisplayEdgeEffects()) {
            this.mEdgeGlowTop.finish();
            this.mEdgeGlowBottom.finish();
        }
    }

    public void setEdgeEffectColor(int color) {
        this.setTopEdgeEffectColor(color);
        this.setBottomEdgeEffectColor(color);
    }

    public void setBottomEdgeEffectColor(int color) {
        this.mEdgeGlowBottom.setColor(color);
        this.invalidateBottomGlow();
    }

    public void setTopEdgeEffectColor(int color) {
        this.mEdgeGlowTop.setColor(color);
        this.invalidateTopGlow();
    }

    public int getTopEdgeEffectColor() {
        return this.mEdgeGlowTop.getColor();
    }

    public int getBottomEdgeEffectColor() {
        return this.mEdgeGlowBottom.getColor();
    }

    public void setRecyclerListener(@Nullable RecyclerListener listener) {
        this.mRecycler.mRecyclerListener = listener;
    }

    int getHeightForPosition(int position) {
        int firstVisiblePosition = this.getFirstVisiblePosition();
        int childCount = this.getChildCount();
        int index = position - firstVisiblePosition;
        if (index >= 0 && index < childCount) {
            View view = this.getChildAt(index);
            return view.getHeight();
        }
        View view = this.obtainView(position, this.mIsScrap);
        view.measure(this.mWidthMeasureSpec, 0);
        int height = view.getMeasuredHeight();
        this.mRecycler.addScrapView(view, position);
        return height;
    }

    public void setSelectionFromTop(int position, int y) {
        if (this.mAdapter == null) {
            return;
        }
        if (!this.isInTouchMode()) {
            if ((position = this.lookForSelectablePosition(position, true)) >= 0) {
                this.setNextSelectedPositionInt(position);
            }
        } else {
            this.mResurrectToPosition = position;
        }
        if (position >= 0) {
            this.mLayoutMode = 4;
            this.mSpecificTop = this.mListPadding.top + y;
            if (this.mNeedSync) {
                this.mSyncPosition = position;
                this.mSyncRowId = this.mAdapter.getItemId(position);
            }
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            this.requestLayout();
        }
    }

    class RecycleBin {
        @Nullable
        private RecyclerListener mRecyclerListener;
        private int mFirstActivePosition;
        private View[] mActiveViews = new View[0];
        private ArrayList<View>[] mScrapViews;
        private int mViewTypeCount;
        private ArrayList<View> mCurrentScrap;
        private ArrayList<View> mSkippedScrap;
        private SparseArray<View> mTransientStateViews;
        private LongSparseArray<View> mTransientStateViewsById;

        RecycleBin() {
        }

        public void setViewTypeCount(int viewTypeCount) {
            if (viewTypeCount < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            ArrayList[] scrapViews = new ArrayList[viewTypeCount];
            for (int i = 0; i < viewTypeCount; ++i) {
                scrapViews[i] = new ArrayList();
            }
            this.mViewTypeCount = viewTypeCount;
            this.mCurrentScrap = scrapViews[0];
            this.mScrapViews = scrapViews;
        }

        public void markChildrenDirty() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                for (View view : scrap) {
                    view.forceLayout();
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    for (View view : scrap) {
                        view.forceLayout();
                    }
                }
            }
            if (this.mTransientStateViews != null) {
                int count = this.mTransientStateViews.size();
                for (int i = 0; i < count; ++i) {
                    this.mTransientStateViews.valueAt(i).forceLayout();
                }
            }
            if (this.mTransientStateViewsById != null) {
                int count = this.mTransientStateViewsById.size();
                for (int i = 0; i < count; ++i) {
                    this.mTransientStateViewsById.valueAt(i).forceLayout();
                }
            }
        }

        public boolean shouldRecycleViewType(int viewType) {
            return viewType >= 0;
        }

        void clear() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                this.clearScrap(scrap);
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    this.clearScrap(scrap);
                }
            }
            this.clearTransientStateViews();
        }

        void fillActiveViews(int childCount, int firstActivePosition) {
            if (this.mActiveViews.length < childCount) {
                this.mActiveViews = new View[childCount];
            }
            this.mFirstActivePosition = firstActivePosition;
            View[] activeViews = this.mActiveViews;
            for (int i = 0; i < childCount; ++i) {
                View child = AbsListView.this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp == null || lp.viewType == -2) continue;
                activeViews[i] = child;
                lp.scrappedFromPosition = firstActivePosition + i;
            }
        }

        @Nullable
        View getActiveView(int position) {
            int index = position - this.mFirstActivePosition;
            View[] activeViews = this.mActiveViews;
            if (index >= 0 && index < activeViews.length) {
                View match = activeViews[index];
                activeViews[index] = null;
                return match;
            }
            return null;
        }

        @Nullable
        View getTransientStateView(int position) {
            int index;
            if (AbsListView.this.mAdapter != null && AbsListView.this.mAdapterHasStableIds && this.mTransientStateViewsById != null) {
                long id2 = AbsListView.this.mAdapter.getItemId(position);
                View result = this.mTransientStateViewsById.get(id2);
                this.mTransientStateViewsById.remove(id2);
                return result;
            }
            if (this.mTransientStateViews != null && (index = this.mTransientStateViews.indexOfKey(position)) >= 0) {
                View result = this.mTransientStateViews.valueAt(index);
                this.mTransientStateViews.removeAt(index);
                return result;
            }
            return null;
        }

        void clearTransientStateViews() {
            LongSparseArray<View> viewsById;
            SparseArray<View> viewsByPos = this.mTransientStateViews;
            if (viewsByPos != null) {
                int N = viewsByPos.size();
                for (int i = 0; i < N; ++i) {
                    this.removeDetachedView(viewsByPos.valueAt(i));
                }
                viewsByPos.clear();
            }
            if ((viewsById = this.mTransientStateViewsById) != null) {
                int N = viewsById.size();
                for (int i = 0; i < N; ++i) {
                    this.removeDetachedView(viewsById.valueAt(i));
                }
                viewsById.clear();
            }
        }

        @Nullable
        View getScrapView(int position) {
            int whichScrap = AbsListView.this.mAdapter.getItemViewType(position);
            if (whichScrap < 0) {
                return null;
            }
            if (this.mViewTypeCount == 1) {
                return this.retrieveFromScrap(this.mCurrentScrap, position);
            }
            if (whichScrap < this.mScrapViews.length) {
                return this.retrieveFromScrap(this.mScrapViews[whichScrap], position);
            }
            return null;
        }

        void addScrapView(@NonNull View scrap, int position) {
            LayoutParams lp = (LayoutParams)scrap.getLayoutParams();
            if (lp == null) {
                return;
            }
            lp.scrappedFromPosition = position;
            int viewType = lp.viewType;
            if (!this.shouldRecycleViewType(viewType)) {
                if (viewType != -2) {
                    this.getSkippedScrap().add(scrap);
                }
                return;
            }
            scrap.dispatchStartTemporaryDetach();
            boolean scrapHasTransientState = scrap.hasTransientState();
            if (scrapHasTransientState) {
                if (AbsListView.this.mAdapter != null && AbsListView.this.mAdapterHasStableIds) {
                    if (this.mTransientStateViewsById == null) {
                        this.mTransientStateViewsById = new LongSparseArray();
                    }
                    this.mTransientStateViewsById.put(lp.itemId, scrap);
                } else if (!AbsListView.this.mDataChanged) {
                    if (this.mTransientStateViews == null) {
                        this.mTransientStateViews = new SparseArray();
                    }
                    this.mTransientStateViews.put(position, scrap);
                } else {
                    this.clearScrapForRebind(scrap);
                    this.getSkippedScrap().add(scrap);
                }
            } else {
                this.clearScrapForRebind(scrap);
                if (this.mViewTypeCount == 1) {
                    this.mCurrentScrap.add(scrap);
                } else {
                    this.mScrapViews[viewType].add(scrap);
                }
                if (this.mRecyclerListener != null) {
                    this.mRecyclerListener.onMovedToScrapHeap(scrap);
                }
            }
        }

        @NonNull
        private ArrayList<View> getSkippedScrap() {
            if (this.mSkippedScrap == null) {
                this.mSkippedScrap = new ArrayList();
            }
            return this.mSkippedScrap;
        }

        void removeSkippedScrap() {
            if (this.mSkippedScrap == null) {
                return;
            }
            int count = this.mSkippedScrap.size();
            for (int i = 0; i < count; ++i) {
                this.removeDetachedView(this.mSkippedScrap.get(i));
            }
            this.mSkippedScrap.clear();
        }

        void scrapActiveViews() {
            View[] activeViews = this.mActiveViews;
            boolean hasListener = this.mRecyclerListener != null;
            boolean multipleScraps = this.mViewTypeCount > 1;
            ArrayList<View> scrapViews = this.mCurrentScrap;
            int count = activeViews.length;
            for (int i = count - 1; i >= 0; --i) {
                View victim = activeViews[i];
                if (victim == null) continue;
                LayoutParams lp = (LayoutParams)victim.getLayoutParams();
                int whichScrap = lp.viewType;
                activeViews[i] = null;
                if (victim.hasTransientState()) {
                    victim.dispatchStartTemporaryDetach();
                    if (AbsListView.this.mAdapter != null && AbsListView.this.mAdapterHasStableIds) {
                        if (this.mTransientStateViewsById == null) {
                            this.mTransientStateViewsById = new LongSparseArray();
                        }
                        long id2 = AbsListView.this.mAdapter.getItemId(this.mFirstActivePosition + i);
                        this.mTransientStateViewsById.put(id2, victim);
                        continue;
                    }
                    if (!AbsListView.this.mDataChanged) {
                        if (this.mTransientStateViews == null) {
                            this.mTransientStateViews = new SparseArray();
                        }
                        this.mTransientStateViews.put(this.mFirstActivePosition + i, victim);
                        continue;
                    }
                    if (whichScrap == -2) continue;
                    this.removeDetachedView(victim);
                    continue;
                }
                if (!this.shouldRecycleViewType(whichScrap)) {
                    if (whichScrap == -2) continue;
                    this.removeDetachedView(victim);
                    continue;
                }
                if (multipleScraps) {
                    scrapViews = this.mScrapViews[whichScrap];
                }
                lp.scrappedFromPosition = this.mFirstActivePosition + i;
                this.removeDetachedView(victim);
                scrapViews.add(victim);
                if (!hasListener) continue;
                this.mRecyclerListener.onMovedToScrapHeap(victim);
            }
            this.pruneScrapViews();
        }

        void fullyDetachScrapViews() {
            int viewTypeCount = this.mViewTypeCount;
            ArrayList<View>[] scrapViews = this.mScrapViews;
            for (int i = 0; i < viewTypeCount; ++i) {
                ArrayList<View> scrapPile = scrapViews[i];
                for (int j = scrapPile.size() - 1; j >= 0; --j) {
                    View view = scrapPile.get(j);
                    if (!view.isTemporarilyDetached()) continue;
                    this.removeDetachedView(view);
                }
            }
        }

        private void pruneScrapViews() {
            LongSparseArray<View> transViewsById;
            int maxViews = this.mActiveViews.length;
            int viewTypeCount = this.mViewTypeCount;
            ArrayList<View>[] scrapViews = this.mScrapViews;
            for (int i = 0; i < viewTypeCount; ++i) {
                ArrayList<View> scrapPile = scrapViews[i];
                int size = scrapPile.size();
                while (size > maxViews) {
                    scrapPile.remove(--size);
                }
            }
            SparseArray<View> transViewsByPos = this.mTransientStateViews;
            if (transViewsByPos != null) {
                for (int i = 0; i < transViewsByPos.size(); ++i) {
                    View v = transViewsByPos.valueAt(i);
                    if (v.hasTransientState()) continue;
                    this.removeDetachedView(v);
                    transViewsByPos.removeAt(i);
                    --i;
                }
            }
            if ((transViewsById = this.mTransientStateViewsById) != null) {
                for (int i = 0; i < transViewsById.size(); ++i) {
                    View v = transViewsById.valueAt(i);
                    if (v.hasTransientState()) continue;
                    this.removeDetachedView(v);
                    transViewsById.removeAt(i);
                    --i;
                }
            }
        }

        void reclaimScrapViews(@NonNull List<View> views) {
            if (this.mViewTypeCount == 1) {
                views.addAll(this.mCurrentScrap);
            } else {
                int viewTypeCount = this.mViewTypeCount;
                ArrayList<View>[] scrapViews = this.mScrapViews;
                for (int i = 0; i < viewTypeCount; ++i) {
                    ArrayList<View> scrapPile = scrapViews[i];
                    views.addAll(scrapPile);
                }
            }
        }

        @Nullable
        private View retrieveFromScrap(@NonNull ArrayList<View> scrapViews, int position) {
            int size = scrapViews.size();
            if (size > 0) {
                for (int i = size - 1; i >= 0; --i) {
                    View view = scrapViews.get(i);
                    LayoutParams params = (LayoutParams)view.getLayoutParams();
                    if (AbsListView.this.mAdapterHasStableIds) {
                        long id2 = AbsListView.this.mAdapter.getItemId(position);
                        if (id2 != params.itemId) continue;
                        return scrapViews.remove(i);
                    }
                    if (params.scrappedFromPosition != position) continue;
                    View scrap = scrapViews.remove(i);
                    this.clearScrapForRebind(scrap);
                    return scrap;
                }
                View scrap = scrapViews.remove(size - 1);
                this.clearScrapForRebind(scrap);
                return scrap;
            }
            return null;
        }

        private void clearScrap(@NonNull ArrayList<View> scrap) {
            int scrapCount = scrap.size();
            for (int j = 0; j < scrapCount; ++j) {
                this.removeDetachedView(scrap.remove(scrapCount - 1 - j));
            }
        }

        private void clearScrapForRebind(@NonNull View view) {
        }

        private void removeDetachedView(View child) {
            AbsListView.this.removeDetachedView(child, false);
        }
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(AbsListView var1, int var2);

        public void onScroll(AbsListView var1, int var2, int var3, int var4);
    }

    class MultiChoiceModeWrapper
    implements MultiChoiceModeListener {
        private MultiChoiceModeListener mWrapped;

        MultiChoiceModeWrapper() {
        }

        public void setWrapped(MultiChoiceModeListener wrapped) {
            this.mWrapped = wrapped;
        }

        public boolean hasWrappedCallback() {
            return this.mWrapped != null;
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            if (this.mWrapped.onCreateActionMode(mode, menu)) {
                AbsListView.this.setLongClickable(false);
                return true;
            }
            return false;
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            return this.mWrapped.onPrepareActionMode(mode, menu);
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            AbsListView.this.mChoiceActionMode = null;
            AbsListView.this.clearChoices();
            AbsListView.this.mDataChanged = true;
            AbsListView.this.rememberSyncState();
            AbsListView.this.requestLayout();
            AbsListView.this.setLongClickable(true);
        }

        @Override
        public void onItemCheckedStateChanged(@NonNull ActionMode mode, int position, long id2, boolean checked) {
            this.mWrapped.onItemCheckedStateChanged(mode, position, id2, checked);
            if (AbsListView.this.getCheckedItemCount() == 0) {
                mode.finish();
            }
        }
    }

    public static interface MultiChoiceModeListener
    extends ActionMode.Callback {
        public void onItemCheckedStateChanged(@NonNull ActionMode var1, int var2, long var3, boolean var5);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        int viewType;
        boolean recycledHeaderFooter;
        boolean forceAdd;
        int scrappedFromPosition;
        long itemId = -1L;
        boolean isEnabled;

        public LayoutParams(int w, int h2) {
            super(w, h2);
        }

        public LayoutParams(int w, int h2, int viewType) {
            super(w, h2);
            this.viewType = viewType;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public static interface SelectionBoundsAdjuster {
        public void adjustListItemSelectionBounds(Rect var1);
    }

    private class CheckForKeyLongPress
    extends WindowRunnable
    implements Runnable {
        private CheckForKeyLongPress() {
        }

        @Override
        public void run() {
            if (AbsListView.this.isPressed() && AbsListView.this.mSelectedPosition >= 0) {
                int index = AbsListView.this.mSelectedPosition - AbsListView.this.mFirstPosition;
                View v = AbsListView.this.getChildAt(index);
                if (!AbsListView.this.mDataChanged) {
                    boolean handled = false;
                    if (this.sameWindow()) {
                        handled = AbsListView.this.performLongPress(v, AbsListView.this.mSelectedPosition, AbsListView.this.mSelectedRowId);
                    }
                    if (handled) {
                        AbsListView.this.setPressed(false);
                        v.setPressed(false);
                    }
                } else {
                    AbsListView.this.setPressed(false);
                    if (v != null) {
                        v.setPressed(false);
                    }
                }
            }
        }
    }

    private class FlingRunnable
    implements Runnable {
        private final OverScroller mScroller;
        private int mLastFlingY;
        private boolean mSuppressIdleStateChangeCall;
        private final Runnable mCheckFlywheel = new Runnable(){

            @Override
            public void run() {
                VelocityTracker vt = AbsListView.this.mVelocityTracker;
                if (vt == null) {
                    return;
                }
                vt.computeCurrentVelocity(1000, AbsListView.this.mMaximumVelocity);
                float yvel = -vt.getYVelocity();
                if (Math.abs(yvel) >= (float)AbsListView.this.mMinimumVelocity && FlingRunnable.this.mScroller.isScrollingInDirection(0.0f, yvel)) {
                    AbsListView.this.postDelayed(this, 40L);
                } else {
                    FlingRunnable.this.endFling();
                    AbsListView.this.mTouchMode = 3;
                    AbsListView.this.reportScrollStateChange(1);
                }
            }
        };
        private static final int FLYWHEEL_TIMEOUT = 40;

        FlingRunnable() {
            this.mScroller = new OverScroller();
        }

        void start(int initialVelocity) {
            int initialY;
            this.mLastFlingY = initialY = initialVelocity < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.setInterpolator(null);
            this.mScroller.fling(0, initialY, 0, initialVelocity, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            AbsListView.this.mTouchMode = 4;
            this.mSuppressIdleStateChangeCall = false;
            AbsListView.this.removeCallbacks(this);
            AbsListView.this.postOnAnimation(this);
        }

        void startSpringback() {
            this.mSuppressIdleStateChangeCall = false;
            if (this.mScroller.springBack(0, AbsListView.this.mScrollY, 0, 0, 0, 0)) {
                AbsListView.this.mTouchMode = 6;
                AbsListView.this.invalidate();
                AbsListView.this.postOnAnimation(this);
            } else {
                AbsListView.this.mTouchMode = -1;
                AbsListView.this.reportScrollStateChange(0);
            }
        }

        void startOverfling(int initialVelocity) {
            this.mScroller.fling(0, AbsListView.this.mScrollY, 0, initialVelocity, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, AbsListView.this.getHeight());
            AbsListView.this.mTouchMode = 6;
            this.mSuppressIdleStateChangeCall = false;
            AbsListView.this.invalidate();
            AbsListView.this.postOnAnimation(this);
        }

        void edgeReached(int delta) {
            this.mScroller.notifyVerticalEdgeReached(AbsListView.this.mScrollY, 0, AbsListView.this.mOverflingDistance);
            int overscrollMode = AbsListView.this.getOverScrollMode();
            if (overscrollMode == 0 || overscrollMode == 1 && !AbsListView.this.contentFits()) {
                AbsListView.this.mTouchMode = 6;
                int vel = (int)this.mScroller.getCurrVelocity();
                if (delta > 0) {
                    AbsListView.this.mEdgeGlowTop.onAbsorb(vel);
                } else {
                    AbsListView.this.mEdgeGlowBottom.onAbsorb(vel);
                }
            } else {
                AbsListView.this.mTouchMode = -1;
                if (AbsListView.this.mPositionScroller != null) {
                    AbsListView.this.mPositionScroller.stop();
                }
            }
            AbsListView.this.invalidate();
            AbsListView.this.postOnAnimation(this);
        }

        void startScroll(int distance, int duration, boolean linear, boolean suppressEndFlingStateChangeCall) {
            int initialY;
            this.mLastFlingY = initialY = distance < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.setInterpolator(linear ? TimeInterpolator.LINEAR : null);
            this.mScroller.startScroll(0, initialY, 0, distance, duration);
            AbsListView.this.mTouchMode = 4;
            this.mSuppressIdleStateChangeCall = suppressEndFlingStateChangeCall;
            AbsListView.this.postOnAnimation(this);
        }

        void endFling() {
            AbsListView.this.mTouchMode = -1;
            AbsListView.this.removeCallbacks(this);
            AbsListView.this.removeCallbacks(this.mCheckFlywheel);
            if (!this.mSuppressIdleStateChangeCall) {
                AbsListView.this.reportScrollStateChange(0);
            }
            this.mScroller.abortAnimation();
        }

        void flywheelTouch() {
            AbsListView.this.postDelayed(this.mCheckFlywheel, 40L);
        }

        @Override
        public void run() {
            switch (AbsListView.this.mTouchMode) {
                default: {
                    this.endFling();
                    return;
                }
                case 3: {
                    if (this.mScroller.isFinished()) {
                        return;
                    }
                }
                case 4: {
                    boolean atEdge;
                    boolean atEnd;
                    if (AbsListView.this.mDataChanged) {
                        AbsListView.this.layoutChildren();
                    }
                    if (AbsListView.this.mItemCount == 0 || AbsListView.this.getChildCount() == 0) {
                        this.endFling();
                        return;
                    }
                    OverScroller scroller = this.mScroller;
                    boolean more = scroller.computeScrollOffset();
                    int y = scroller.getCurrY();
                    int delta = this.mLastFlingY - y;
                    if (delta > 0) {
                        AbsListView.this.mMotionPosition = AbsListView.this.mFirstPosition;
                        View firstView = AbsListView.this.getChildAt(0);
                        AbsListView.this.mMotionViewOriginalTop = firstView.getTop();
                        delta = Math.min(AbsListView.this.getHeight() - AbsListView.this.mPaddingBottom - AbsListView.this.mPaddingTop - 1, delta);
                    } else {
                        int offsetToLast = AbsListView.this.getChildCount() - 1;
                        AbsListView.this.mMotionPosition = AbsListView.this.mFirstPosition + offsetToLast;
                        View lastView = AbsListView.this.getChildAt(offsetToLast);
                        AbsListView.this.mMotionViewOriginalTop = lastView.getTop();
                        delta = Math.max(-(AbsListView.this.getHeight() - AbsListView.this.mPaddingBottom - AbsListView.this.mPaddingTop - 1), delta);
                    }
                    View motionView = AbsListView.this.getChildAt(AbsListView.this.mMotionPosition - AbsListView.this.mFirstPosition);
                    int oldTop = 0;
                    if (motionView != null) {
                        oldTop = motionView.getTop();
                    }
                    boolean bl = atEnd = (atEdge = AbsListView.this.trackMotionScroll(delta, delta)) && delta != 0;
                    if (atEnd) {
                        if (motionView != null) {
                            int overshoot = -(delta - (motionView.getTop() - oldTop));
                            AbsListView.this.overScrollBy(0, overshoot, 0, AbsListView.this.mScrollY, 0, 0, 0, AbsListView.this.mOverflingDistance, false);
                        }
                        if (!more) break;
                        this.edgeReached(delta);
                        break;
                    }
                    if (more) {
                        if (atEdge) {
                            AbsListView.this.invalidate();
                        }
                        this.mLastFlingY = y;
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
                case 6: {
                    OverScroller scroller = this.mScroller;
                    if (scroller.computeScrollOffset()) {
                        int scrollY = AbsListView.this.mScrollY;
                        int currY = scroller.getCurrY();
                        int deltaY = currY - scrollY;
                        if (AbsListView.this.overScrollBy(0, deltaY, 0, scrollY, 0, 0, 0, AbsListView.this.mOverflingDistance, false)) {
                            boolean crossUp;
                            boolean crossDown = scrollY <= 0 && currY > 0;
                            boolean bl = crossUp = scrollY >= 0 && currY < 0;
                            if (crossDown || crossUp) {
                                int velocity = (int)scroller.getCurrVelocity();
                                if (crossUp) {
                                    velocity = -velocity;
                                }
                                scroller.abortAnimation();
                                this.start(velocity);
                                break;
                            }
                            this.startSpringback();
                            break;
                        }
                        AbsListView.this.invalidate();
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
            }
        }
    }

    static interface PositionScroller {
        public void start(int var1);

        public void start(int var1, int var2);

        public void startWithOffset(int var1, int var2);

        public void startWithOffset(int var1, int var2, int var3);

        public void stop();
    }

    private class PerformClick
    extends WindowRunnable
    implements Runnable {
        int mClickMotionPosition;

        private PerformClick() {
        }

        @Override
        public void run() {
            View view;
            if (AbsListView.this.mDataChanged) {
                return;
            }
            ListAdapter adapter = AbsListView.this.mAdapter;
            int motionPosition = this.mClickMotionPosition;
            if (adapter != null && AbsListView.this.mItemCount > 0 && motionPosition != -1 && motionPosition < adapter.getCount() && this.sameWindow() && adapter.isEnabled(motionPosition) && (view = AbsListView.this.getChildAt(motionPosition - AbsListView.this.mFirstPosition)) != null) {
                AbsListView.this.performItemClick(view, motionPosition, adapter.getItemId(motionPosition));
            }
        }
    }

    private final class CheckForTap
    implements Runnable {
        float x;
        float y;

        private CheckForTap() {
        }

        @Override
        public void run() {
            if (AbsListView.this.mTouchMode == 0) {
                AbsListView.this.mTouchMode = 1;
                View child = AbsListView.this.getChildAt(AbsListView.this.mMotionPosition - AbsListView.this.mFirstPosition);
                if (child != null && !child.hasExplicitFocusable()) {
                    AbsListView.this.mLayoutMode = 0;
                    if (!AbsListView.this.mDataChanged) {
                        float[] point = AbsListView.this.mTmpPoint;
                        point[0] = this.x;
                        point[1] = this.y;
                        AbsListView.this.transformPointToViewLocal(point, child);
                        child.drawableHotspotChanged(point[0], point[1]);
                        child.setPressed(true);
                        AbsListView.this.setPressed(true);
                        AbsListView.this.layoutChildren();
                        AbsListView.this.positionSelector(AbsListView.this.mMotionPosition, child);
                        AbsListView.this.refreshDrawableState();
                        int longPressTimeout = ViewConfiguration.getLongPressTimeout();
                        boolean longClickable = AbsListView.this.isLongClickable();
                        if (AbsListView.this.mSelector != null) {
                            Drawable d2 = AbsListView.this.mSelector.getCurrent();
                            AbsListView.this.mSelector.setHotspot(this.x, this.y);
                        }
                        if (longClickable) {
                            if (AbsListView.this.mPendingCheckForLongPress == null) {
                                AbsListView.this.mPendingCheckForLongPress = new CheckForLongPress();
                            }
                            AbsListView.this.mPendingCheckForLongPress.setCoords(this.x, this.y);
                            AbsListView.this.mPendingCheckForLongPress.rememberWindowAttachCount();
                            AbsListView.this.postDelayed(AbsListView.this.mPendingCheckForLongPress, longPressTimeout);
                        } else {
                            AbsListView.this.mTouchMode = 2;
                        }
                    } else {
                        AbsListView.this.mTouchMode = 2;
                    }
                }
            }
        }
    }

    private class CheckForLongPress
    extends WindowRunnable
    implements Runnable {
        private float mX;
        private float mY;

        private CheckForLongPress() {
            this.mX = Float.NaN;
            this.mY = Float.NaN;
        }

        private void setCoords(float x, float y) {
            this.mX = x;
            this.mY = y;
        }

        @Override
        public void run() {
            int motionPosition = AbsListView.this.mMotionPosition;
            View child = AbsListView.this.getChildAt(motionPosition - AbsListView.this.mFirstPosition);
            if (child != null) {
                int longPressPosition = AbsListView.this.mMotionPosition;
                long longPressId = AbsListView.this.mAdapter.getItemId(AbsListView.this.mMotionPosition);
                boolean handled = false;
                if (this.sameWindow() && !AbsListView.this.mDataChanged) {
                    handled = !Float.isNaN(this.mX) && !Float.isNaN(this.mY) ? AbsListView.this.performLongPress(child, longPressPosition, longPressId, this.mX, this.mY) : AbsListView.this.performLongPress(child, longPressPosition, longPressId);
                }
                if (handled) {
                    AbsListView.this.mHasPerformedLongPress = true;
                    AbsListView.this.mTouchMode = -1;
                    AbsListView.this.setPressed(false);
                    child.setPressed(false);
                } else {
                    AbsListView.this.mTouchMode = 2;
                }
            }
        }
    }

    class DefaultPositionScroller
    implements PositionScroller,
    Runnable {
        private static final int SCROLL_DURATION = 200;
        private static final int MOVE_DOWN_POS = 1;
        private static final int MOVE_UP_POS = 2;
        private static final int MOVE_DOWN_BOUND = 3;
        private static final int MOVE_UP_BOUND = 4;
        private static final int MOVE_OFFSET = 5;
        private int mMode;
        private int mTargetPos;
        private int mBoundPos;
        private int mLastSeenPos;
        private int mScrollDuration;
        private final int mExtraScroll;
        private int mOffsetFromTop;

        DefaultPositionScroller() {
            this.mExtraScroll = 0;
        }

        @Override
        public void start(int position) {
            int viewTravelCount;
            this.stop();
            if (AbsListView.this.mDataChanged) {
                AbsListView.this.mPositionScrollAfterLayout = () -> this.start(position);
                return;
            }
            int childCount = AbsListView.this.getChildCount();
            if (childCount == 0) {
                return;
            }
            int firstPos = AbsListView.this.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            int clampedPosition = Math.max(0, Math.min(AbsListView.this.getCount() - 1, position));
            if (clampedPosition < firstPos) {
                viewTravelCount = firstPos - clampedPosition + 1;
                this.mMode = 2;
            } else if (clampedPosition > lastPos) {
                viewTravelCount = clampedPosition - lastPos + 1;
                this.mMode = 1;
            } else {
                this.scrollToVisible(clampedPosition, -1);
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 200 / viewTravelCount : 200;
            this.mTargetPos = clampedPosition;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            AbsListView.this.postOnAnimation(this);
        }

        @Override
        public void start(int position, int boundPosition) {
            int viewTravelCount;
            this.stop();
            if (boundPosition == -1) {
                this.start(position);
                return;
            }
            if (AbsListView.this.mDataChanged) {
                AbsListView.this.mPositionScrollAfterLayout = () -> this.start(position, boundPosition);
                return;
            }
            int childCount = AbsListView.this.getChildCount();
            if (childCount == 0) {
                return;
            }
            int firstPos = AbsListView.this.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            int clampedPosition = Math.max(0, Math.min(AbsListView.this.getCount() - 1, position));
            if (clampedPosition < firstPos) {
                int boundPosFromLast = lastPos - boundPosition;
                if (boundPosFromLast < 1) {
                    return;
                }
                int boundTravel = boundPosFromLast - 1;
                int posTravel = firstPos - clampedPosition + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 4;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 2;
                }
            } else if (clampedPosition > lastPos) {
                int boundPosFromFirst = boundPosition - firstPos;
                if (boundPosFromFirst < 1) {
                    return;
                }
                int boundTravel = boundPosFromFirst - 1;
                int posTravel = clampedPosition - lastPos + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 3;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 1;
                }
            } else {
                this.scrollToVisible(clampedPosition, boundPosition);
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 200 / viewTravelCount : 200;
            this.mTargetPos = clampedPosition;
            this.mBoundPos = boundPosition;
            this.mLastSeenPos = -1;
            AbsListView.this.postOnAnimation(this);
        }

        @Override
        public void startWithOffset(int position, int offset) {
            this.startWithOffset(position, offset, 200);
        }

        @Override
        public void startWithOffset(int position, int offset, int duration) {
            int viewTravelCount;
            this.stop();
            if (AbsListView.this.mDataChanged) {
                int postOffset = offset;
                AbsListView.this.mPositionScrollAfterLayout = () -> this.startWithOffset(position, postOffset, duration);
                return;
            }
            int childCount = AbsListView.this.getChildCount();
            if (childCount == 0) {
                return;
            }
            this.mTargetPos = Math.max(0, Math.min(AbsListView.this.getCount() - 1, position));
            this.mOffsetFromTop = offset += AbsListView.this.getPaddingTop();
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            this.mMode = 5;
            int firstPos = AbsListView.this.mFirstPosition;
            int lastPos = firstPos + childCount - 1;
            if (this.mTargetPos < firstPos) {
                viewTravelCount = firstPos - this.mTargetPos;
            } else if (this.mTargetPos > lastPos) {
                viewTravelCount = this.mTargetPos - lastPos;
            } else {
                int targetTop = AbsListView.this.getChildAt(this.mTargetPos - firstPos).getTop();
                AbsListView.this.smoothScrollBy(targetTop - offset, duration, true, false);
                return;
            }
            float screenTravelCount = (float)viewTravelCount / (float)childCount;
            this.mScrollDuration = screenTravelCount < 1.0f ? duration : (int)((float)duration / screenTravelCount);
            AbsListView.this.postOnAnimation(this);
        }

        private void scrollToVisible(int targetPos, int boundPos) {
            int firstPos = AbsListView.this.mFirstPosition;
            int childCount = AbsListView.this.getChildCount();
            int lastPos = firstPos + childCount - 1;
            int paddedTop = AbsListView.this.mListPadding.top;
            int paddedBottom = AbsListView.this.getHeight() - AbsListView.this.mListPadding.bottom;
            if (targetPos < firstPos || targetPos > lastPos) {
                CloudPick.LOGGER.warn(MARKER, "scrollToVisible called with targetPos " + targetPos + " not visible [" + firstPos + ", " + lastPos + "]");
            }
            if (boundPos < firstPos || boundPos > lastPos) {
                boundPos = -1;
            }
            View targetChild = AbsListView.this.getChildAt(targetPos - firstPos);
            int targetTop = targetChild.getTop();
            int targetBottom = targetChild.getBottom();
            int scrollBy = 0;
            if (targetBottom > paddedBottom) {
                scrollBy = targetBottom - paddedBottom;
            }
            if (targetTop < paddedTop) {
                scrollBy = targetTop - paddedTop;
            }
            if (scrollBy == 0) {
                return;
            }
            if (boundPos >= 0) {
                View boundChild = AbsListView.this.getChildAt(boundPos - firstPos);
                int boundTop = boundChild.getTop();
                int boundBottom = boundChild.getBottom();
                int absScroll = Math.abs(scrollBy);
                if (scrollBy < 0 && boundBottom + absScroll > paddedBottom) {
                    scrollBy = Math.max(0, boundBottom - paddedBottom);
                } else if (scrollBy > 0 && boundTop - absScroll < paddedTop) {
                    scrollBy = Math.min(0, boundTop - paddedTop);
                }
            }
            AbsListView.this.smoothScrollBy(scrollBy, 200);
        }

        @Override
        public void stop() {
            AbsListView.this.removeCallbacks(this);
        }

        @Override
        public void run() {
            int listHeight = AbsListView.this.getHeight();
            int firstPos = AbsListView.this.mFirstPosition;
            switch (this.mMode) {
                case 1: {
                    int lastViewIndex = AbsListView.this.getChildCount() - 1;
                    int lastPos = firstPos + lastViewIndex;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    if (lastPos == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View lastView = AbsListView.this.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    int extraScroll = lastPos < AbsListView.this.mItemCount - 1 ? Math.max(AbsListView.this.mListPadding.bottom, this.mExtraScroll) : AbsListView.this.mListPadding.bottom;
                    int scrollBy = lastViewHeight - lastViewPixelsShowing + extraScroll;
                    AbsListView.this.smoothScrollBy(scrollBy, this.mScrollDuration, true, lastPos < this.mTargetPos);
                    this.mLastSeenPos = lastPos;
                    if (lastPos >= this.mTargetPos) break;
                    AbsListView.this.postOnAnimation(this);
                    break;
                }
                case 3: {
                    boolean nextViewIndex = true;
                    int childCount = AbsListView.this.getChildCount();
                    if (firstPos == this.mBoundPos || childCount <= 1 || firstPos + childCount >= AbsListView.this.mItemCount) {
                        AbsListView.this.reportScrollStateChange(0);
                        return;
                    }
                    int nextPos = firstPos + 1;
                    if (nextPos == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View nextView = AbsListView.this.getChildAt(1);
                    int nextViewHeight = nextView.getHeight();
                    int nextViewTop = nextView.getTop();
                    int extraScroll = Math.max(AbsListView.this.mListPadding.bottom, this.mExtraScroll);
                    if (nextPos < this.mBoundPos) {
                        AbsListView.this.smoothScrollBy(Math.max(0, nextViewHeight + nextViewTop - extraScroll), this.mScrollDuration, true, true);
                        this.mLastSeenPos = nextPos;
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    if (nextViewTop > extraScroll) {
                        AbsListView.this.smoothScrollBy(nextViewTop - extraScroll, this.mScrollDuration, true, false);
                        break;
                    }
                    AbsListView.this.reportScrollStateChange(0);
                    break;
                }
                case 2: {
                    if (firstPos == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View firstView = AbsListView.this.getChildAt(0);
                    if (firstView == null) {
                        return;
                    }
                    int firstViewTop = firstView.getTop();
                    int extraScroll = firstPos > 0 ? Math.max(this.mExtraScroll, AbsListView.this.mListPadding.top) : AbsListView.this.mListPadding.top;
                    AbsListView.this.smoothScrollBy(firstViewTop - extraScroll, this.mScrollDuration, true, firstPos > this.mTargetPos);
                    this.mLastSeenPos = firstPos;
                    if (firstPos <= this.mTargetPos) break;
                    AbsListView.this.postOnAnimation(this);
                    break;
                }
                case 4: {
                    int lastViewIndex = AbsListView.this.getChildCount() - 2;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    int lastPos = firstPos + lastViewIndex;
                    if (lastPos == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View lastView = AbsListView.this.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    int extraScroll = Math.max(AbsListView.this.mListPadding.top, this.mExtraScroll);
                    this.mLastSeenPos = lastPos;
                    if (lastPos > this.mBoundPos) {
                        AbsListView.this.smoothScrollBy(-(lastViewPixelsShowing - extraScroll), this.mScrollDuration, true, true);
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    int bottom = listHeight - extraScroll;
                    int lastViewBottom = lastViewTop + lastViewHeight;
                    if (bottom > lastViewBottom) {
                        AbsListView.this.smoothScrollBy(-(bottom - lastViewBottom), this.mScrollDuration, true, false);
                        break;
                    }
                    AbsListView.this.reportScrollStateChange(0);
                    break;
                }
                case 5: {
                    if (this.mLastSeenPos == firstPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    this.mLastSeenPos = firstPos;
                    int childCount = AbsListView.this.getChildCount();
                    if (childCount <= 0) {
                        return;
                    }
                    int position = this.mTargetPos;
                    int lastPos = firstPos + childCount - 1;
                    View firstChild = AbsListView.this.getChildAt(0);
                    int firstChildHeight = firstChild.getHeight();
                    View lastChild = AbsListView.this.getChildAt(childCount - 1);
                    int lastChildHeight = lastChild.getHeight();
                    float firstPositionVisiblePart = (float)firstChildHeight == 0.0f ? 1.0f : (float)(firstChildHeight + firstChild.getTop()) / (float)firstChildHeight;
                    float lastPositionVisiblePart = (float)lastChildHeight == 0.0f ? 1.0f : (float)(lastChildHeight + AbsListView.this.getHeight() - lastChild.getBottom()) / (float)lastChildHeight;
                    float viewTravelCount = 0.0f;
                    if (position < firstPos) {
                        viewTravelCount = (float)(firstPos - position) + (1.0f - firstPositionVisiblePart) + 1.0f;
                    } else if (position > lastPos) {
                        viewTravelCount = (float)(position - lastPos) + (1.0f - lastPositionVisiblePart);
                    }
                    float screenTravelCount = viewTravelCount / (float)childCount;
                    float modifier = Math.min(Math.abs(screenTravelCount), 1.0f);
                    if (position < firstPos) {
                        int distance = (int)((float)(-AbsListView.this.getHeight()) * modifier);
                        int duration = (int)((float)this.mScrollDuration * modifier);
                        AbsListView.this.smoothScrollBy(distance, duration, true, true);
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    if (position > lastPos) {
                        int distance = (int)((float)AbsListView.this.getHeight() * modifier);
                        int duration = (int)((float)this.mScrollDuration * modifier);
                        AbsListView.this.smoothScrollBy(distance, duration, true, true);
                        AbsListView.this.postOnAnimation(this);
                        break;
                    }
                    int targetTop = AbsListView.this.getChildAt(position - firstPos).getTop();
                    int distance = targetTop - this.mOffsetFromTop;
                    int duration = (int)((float)this.mScrollDuration * ((float)Math.abs(distance) / (float)AbsListView.this.getHeight()));
                    AbsListView.this.smoothScrollBy(distance, duration, true, false);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface RecyclerListener {
        public void onMovedToScrapHeap(@NonNull View var1);
    }

    private class WindowRunnable {
        private int mOriginalAttachCount;

        private WindowRunnable() {
        }

        public void rememberWindowAttachCount() {
            this.mOriginalAttachCount = AbsListView.this.getWindowAttachCount();
        }

        public boolean sameWindow() {
            return AbsListView.this.getWindowAttachCount() == this.mOriginalAttachCount;
        }
    }
}

