/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.widget.BaseAdapter;
import yslelf.cloudpick.graphics.widget.Filter;
import yslelf.cloudpick.graphics.widget.Filterable;
import yslelf.cloudpick.graphics.widget.TextView;

public class ArrayAdapter<T>
extends BaseAdapter
implements Filterable {
    private final Object mLock = new Object();
    private final Context mContext;
    private List<T> mObjects;
    private boolean mNotifyOnChange = true;
    private ArrayList<T> mOriginalValues;
    private ArrayFilter mFilter;

    public ArrayAdapter(Context context, @NonNull T[] objects) {
        this(context, Arrays.asList(objects));
    }

    public ArrayAdapter(Context context, @NonNull List<T> objects) {
        this.mContext = context;
        this.mObjects = objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@Nullable T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.add(object);
            } else {
                this.mObjects.add(object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@NonNull Collection<? extends T> collection) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.addAll(collection);
            } else {
                this.mObjects.addAll(collection);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@NonNull T[] items) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                Collections.addAll(this.mOriginalValues, items);
            } else {
                Collections.addAll(this.mObjects, items);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@Nullable T object, int index) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.add(index, object);
            } else {
                this.mObjects.add(index, object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nullable T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.remove(object);
            } else {
                this.mObjects.remove(object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.clear();
            } else {
                this.mObjects.clear();
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(@Nullable Comparator<? super T> comparator) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.sort(comparator);
            } else {
                this.mObjects.sort(comparator);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mNotifyOnChange = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.mNotifyOnChange = notifyOnChange;
    }

    @Override
    public int getCount() {
        return this.mObjects.size();
    }

    public T getItem(int position) {
        return this.mObjects.get(position);
    }

    public int getPosition(@Nullable T item) {
        return this.mObjects.indexOf(item);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        return this.createViewInner(position, convertView, false);
    }

    @NonNull
    private View createViewInner(int position, @Nullable View convertView, boolean dropdown) {
        TextView tv = convertView == null ? new TextView(this.mContext) : (TextView)convertView;
        T item = this.getItem(position);
        if (item instanceof CharSequence) {
            tv.setText((CharSequence)item);
        } else {
            tv.setText(String.valueOf(item));
        }
        Resources.Theme theme = this.mContext.getTheme();
        tv.setTextSize(14.0f);
        TypedValue value = new TypedValue();
        if (dropdown) {
            theme.resolveAttribute("modernui", "textColorPrimaryDisableOnly", value, true);
        } else {
            theme.resolveAttribute("modernui", "textColorPrimary", value, true);
        }
        tv.setTextColor(theme.getResources().loadColorStateList(value, theme));
        if (!dropdown) {
            tv.setTextAlignment(0);
        }
        int dp8 = tv.dp(8.0f);
        tv.setPadding(dp8, 0, dp8, 0);
        if (dropdown) {
            tv.setGravity(8388627);
            tv.setLayoutParams(new ViewGroup.LayoutParams(-1, tv.dp(32.0f)));
        }
        return tv;
    }

    @Override
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        return this.createViewInner(position, convertView, true);
    }

    @Override
    @NonNull
    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ArrayFilter();
        }
        return this.mFilter;
    }

    private class ArrayFilter
    extends Filter {
        private ArrayFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Filter.FilterResults results = new Filter.FilterResults();
            if (ArrayAdapter.this.mOriginalValues == null) {
                Object object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    ArrayAdapter.this.mOriginalValues = new ArrayList(ArrayAdapter.this.mObjects);
                }
            }
            if (prefix == null || prefix.length() == 0) {
                ArrayList list;
                Object object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    list = new ArrayList(ArrayAdapter.this.mOriginalValues);
                }
                results.values = list;
                results.count = list.size();
            } else {
                ArrayList values;
                String prefixString = prefix.toString().toLowerCase();
                Object object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    values = new ArrayList(ArrayAdapter.this.mOriginalValues);
                }
                ArrayList newValues = new ArrayList();
                block9: for (Object value : values) {
                    String[] words;
                    String valueText = value.toString().toLowerCase();
                    if (valueText.startsWith(prefixString)) {
                        newValues.add(value);
                        continue;
                    }
                    for (String word : words = valueText.split(" ")) {
                        if (!word.startsWith(prefixString)) continue;
                        newValues.add(value);
                        continue block9;
                    }
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        @Override
        protected void publishResults(CharSequence constraint, @NonNull Filter.FilterResults results) {
            ArrayAdapter.this.mObjects = (List)results.values;
            if (results.count > 0) {
                ArrayAdapter.this.notifyDataSetChanged();
            } else {
                ArrayAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

