/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import javax.annotation.Nonnull;
import yslelf.cloudpick.graphics.animation.AnimationUtils;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.annotation.ColorInt;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.BlendMode;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.resources.TypedArray;

public class EdgeEffect {
    public static final BlendMode DEFAULT_BLEND_MODE = BlendMode.SRC_ATOP;
    private static final int RECEDE_TIME = 600;
    private static final int PULL_TIME = 167;
    private static final int PULL_DECAY_TIME = 2000;
    private static final float MAX_ALPHA = 0.15f;
    private static final float GLOW_ALPHA_START = 0.09f;
    private static final int MIN_VELOCITY = 100;
    private static final int MAX_VELOCITY = 10000;
    private static final float EPSILON = 0.001f;
    private static final double ANGLE = 0.5235987755982988;
    private static final float SIN = (float)Math.sin(0.5235987755982988);
    private static final float COS = (float)Math.cos(0.5235987755982988);
    private static final float RADIUS_FACTOR = 0.6f;
    private float mGlowAlpha;
    private float mGlowScaleY;
    private float mDistance;
    private float mGlowAlphaStart;
    private float mGlowAlphaFinish;
    private float mGlowScaleYStart;
    private float mGlowScaleYFinish;
    private long mStartTime;
    private float mDuration;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PULL = 1;
    private static final int STATE_ABSORB = 2;
    private static final int STATE_RECEDE = 3;
    private static final int STATE_PULL_DECAY = 4;
    private static final float PULL_DISTANCE_ALPHA_GLOW_FACTOR = 0.8f;
    private static final int VELOCITY_GLOW_FACTOR = 6;
    private int mState = 0;
    private float mPullDistance;
    private float mWidth;
    private float mHeight;
    private final Paint mPaint = new Paint();
    private float mRadius;
    private float mBaseGlowScale;
    private float mDisplacement = 0.5f;
    private float mTargetDisplacement = 0.5f;
    private static final String[] STYLEABLE = new String[]{"modernui", "colorEdgeEffect"};

    public EdgeEffect(Context context) {
        TypedArray a = context.getTheme().obtainStyledAttributes(STYLEABLE);
        int themeColor = a.getColor(0, -10066330);
        a.recycle();
        this.mPaint.setColor(themeColor & 0xFFFFFF | 0x33000000);
        this.mPaint.setStyle(0);
        this.mPaint.setBlendMode(DEFAULT_BLEND_MODE);
    }

    public void setSize(int width, int height) {
        float r = (float)width * 0.6f / SIN;
        float y = COS * r;
        float h2 = r - y;
        float or = (float)height * 0.6f / SIN;
        float oy = COS * or;
        float oh = or - oy;
        this.mRadius = r;
        this.mBaseGlowScale = h2 > 0.0f ? Math.min(oh / h2, 1.0f) : 1.0f;
        this.mWidth = width;
        this.mHeight = (int)Math.min((float)height, h2);
    }

    public boolean isFinished() {
        return this.mState == 0;
    }

    public void finish() {
        this.mState = 0;
        this.mDistance = 0.0f;
    }

    public void onPull(float deltaDistance) {
        this.onPull(deltaDistance, 0.5f);
    }

    public void onPull(float deltaDistance, float displacement) {
        long now = AnimationUtils.currentAnimationTimeMillis();
        this.mTargetDisplacement = displacement;
        if (this.mState == 4 && (float)(now - this.mStartTime) < this.mDuration) {
            return;
        }
        this.mState = 1;
        this.mStartTime = now;
        this.mDuration = 167.0f;
        this.mPullDistance += deltaDistance;
        this.mDistance = Math.max(0.0f, this.mPullDistance);
        if (this.mPullDistance == 0.0f) {
            this.mGlowScaleYStart = 0.0f;
            this.mGlowScaleY = 0.0f;
            this.mGlowAlphaStart = 0.0f;
            this.mGlowAlpha = 0.0f;
        } else {
            float scale;
            float absDeltaDis = Math.abs(deltaDistance);
            this.mGlowAlpha = this.mGlowAlphaStart = Math.min(0.15f, this.mGlowAlpha + absDeltaDis * 0.8f);
            this.mGlowScaleY = this.mGlowScaleYStart = (scale = (float)(Math.max(0.0, 1.0 - 1.0 / Math.sqrt(Math.abs(this.mPullDistance) * this.mHeight) - 0.3) / 0.7));
        }
        this.mGlowAlphaFinish = this.mGlowAlpha;
        this.mGlowScaleYFinish = this.mGlowScaleY;
    }

    public float onPullDistance(float deltaDistance, float displacement) {
        float finalDistance = Math.max(0.0f, deltaDistance + this.mDistance);
        float delta = finalDistance - this.mDistance;
        if (delta == 0.0f && this.mDistance == 0.0f) {
            return 0.0f;
        }
        if (this.mState != 1 && this.mState != 4) {
            this.mPullDistance = this.mDistance;
            this.mState = 1;
        }
        this.onPull(delta, displacement);
        return delta;
    }

    public float getDistance() {
        return this.mDistance;
    }

    public void onRelease() {
        this.mPullDistance = 0.0f;
        if (this.mState != 1 && this.mState != 4) {
            return;
        }
        this.mState = 3;
        this.mGlowAlphaStart = this.mGlowAlpha;
        this.mGlowScaleYStart = this.mGlowScaleY;
        this.mGlowAlphaFinish = 0.0f;
        this.mGlowScaleYFinish = 0.0f;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 600.0f;
    }

    public void onAbsorb(int velocity) {
        this.mState = 2;
        velocity = Math.min(Math.max(100, Math.abs(velocity)), 10000);
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 0.15f + (float)velocity * 0.02f;
        this.mGlowAlphaStart = 0.09f;
        this.mGlowScaleYStart = Math.max(this.mGlowScaleY, 0.0f);
        int f2 = velocity / 100;
        this.mGlowScaleYFinish = Math.min(0.025f + (float)(velocity * f2) * 1.5E-4f / 2.0f, 1.0f);
        this.mGlowAlphaFinish = Math.max(this.mGlowAlphaStart, Math.min((float)(velocity * 6) * 1.0E-5f, 0.15f));
        this.mTargetDisplacement = 0.5f;
    }

    public void setColor(@ColorInt int color) {
        this.mPaint.setColor(color);
    }

    public void setBlendMode(@Nullable BlendMode blendMode) {
        this.mPaint.setBlendMode(blendMode);
    }

    @ColorInt
    public int getColor() {
        return this.mPaint.getColor();
    }

    @Nullable
    public BlendMode getBlendMode() {
        return this.mPaint.getBlendMode();
    }

    public boolean draw(@Nonnull Canvas canvas) {
        this.update();
        canvas.save();
        float centerX = this.mWidth * 0.5f;
        float centerY = this.mHeight - this.mRadius;
        canvas.scale(1.0f, Math.min(this.mGlowScaleY, 1.0f) * this.mBaseGlowScale, centerX, 0.0f);
        float displacement = Math.max(0.0f, Math.min(this.mDisplacement, 1.0f)) - 0.5f;
        float translateX = this.mWidth * displacement / 2.0f;
        canvas.translate(translateX, 0.0f);
        this.mPaint.setAlpha((int)(255.0f * this.mGlowAlpha));
        canvas.drawCircle(centerX, centerY, this.mRadius, this.mPaint);
        canvas.restore();
        boolean oneLastFrame = false;
        if (this.mState == 3 && this.mDistance == 0.0f) {
            this.mState = 0;
            oneLastFrame = true;
        }
        return this.mState != 0 || oneLastFrame;
    }

    public int getMaxHeight() {
        return (int)this.mHeight;
    }

    private void update() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        float t2 = Math.min((float)(time - this.mStartTime) / this.mDuration, 1.0f);
        float p2 = TimeInterpolator.DECELERATE.getInterpolation(t2);
        this.mGlowAlpha = this.mGlowAlphaStart + (this.mGlowAlphaFinish - this.mGlowAlphaStart) * p2;
        this.mGlowScaleY = this.mGlowScaleYStart + (this.mGlowScaleYFinish - this.mGlowScaleYStart) * p2;
        if (this.mState != 1) {
            this.mDistance = this.calculateDistanceFromGlowValues(this.mGlowScaleY, this.mGlowAlpha);
        }
        this.mDisplacement = (this.mDisplacement + this.mTargetDisplacement) / 2.0f;
        if (t2 >= 0.999f) {
            switch (this.mState) {
                case 2: {
                    this.mState = 3;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 600.0f;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 1: {
                    this.mState = 4;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 2000.0f;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 4: {
                    this.mState = 3;
                    break;
                }
                case 3: {
                    this.mState = 0;
                }
            }
        }
    }

    private float calculateDistanceFromGlowValues(float scale, float alpha) {
        if (scale >= 1.0f) {
            return 1.0f;
        }
        if (scale > 0.0f) {
            float v = 1.4285715f / (this.mGlowScaleY - 1.0f);
            return v * v / this.mHeight;
        }
        return alpha / 0.8f;
    }
}

