/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import javax.annotation.Nonnull;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.core.UndoManager;
import yslelf.cloudpick.graphics.core.UndoOperation;
import yslelf.cloudpick.graphics.core.UndoOwner;
import yslelf.cloudpick.graphics.text.Editable;
import yslelf.cloudpick.graphics.text.InputFilter;
import yslelf.cloudpick.graphics.text.Selection;
import yslelf.cloudpick.graphics.text.Spannable;
import yslelf.cloudpick.graphics.text.SpannableStringBuilder;
import yslelf.cloudpick.graphics.text.Spanned;
import yslelf.cloudpick.graphics.text.TextUtils;
import yslelf.cloudpick.graphics.text.method.MovementMethod;
import yslelf.cloudpick.graphics.text.method.WordIterator;
import yslelf.cloudpick.graphics.util.Parcel;
import yslelf.cloudpick.graphics.util.Parcelable;
import yslelf.cloudpick.graphics.view.ContextMenu;
import yslelf.cloudpick.graphics.view.MenuItem;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.widget.TextView;

public class Editor {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Editor");
    static final int BLINK = 500;
    private static final String UNDO_OWNER_TAG = "Editor";
    private static final int MENU_ITEM_ORDER_ASSIST = 0;
    private static final int MENU_ITEM_ORDER_UNDO = 2;
    private static final int MENU_ITEM_ORDER_REDO = 3;
    private static final int MENU_ITEM_ORDER_CUT = 4;
    private static final int MENU_ITEM_ORDER_COPY = 5;
    private static final int MENU_ITEM_ORDER_PASTE = 6;
    private static final int MENU_ITEM_ORDER_SHARE = 7;
    private static final int MENU_ITEM_ORDER_SELECT_ALL = 8;
    private static final int MENU_ITEM_ORDER_REPLACE = 9;
    private static final int MENU_ITEM_ORDER_AUTOFILL = 10;
    private static final int MENU_ITEM_ORDER_PASTE_AS_PLAIN_TEXT = 11;
    private static final int MENU_ITEM_ORDER_SECONDARY_ASSIST_ACTIONS_START = 50;
    private static final int MENU_ITEM_ORDER_PROCESS_TEXT_INTENT_ACTIONS_START = 100;
    private final UndoManager mUndoManager = new UndoManager();
    private UndoOwner mUndoOwner = this.mUndoManager.getOwner("Editor", this);
    final UndoInputFilter mUndoInputFilter = new UndoInputFilter(this);
    boolean mAllowUndo = true;
    private final TextView mTextView;
    boolean mSelectionMoved;
    boolean mTouchFocusSelected;
    boolean mDiscardNextActionUp;
    boolean mIgnoreActionUpEvent;
    private long mShowCursor;
    private Blink mBlink;
    boolean mCursorVisible = true;
    boolean mSelectAllOnFocus;
    boolean mTextIsSelectable;
    boolean mIsBeingLongClicked;
    private float mContextMenuAnchorX;
    private float mContextMenuAnchorY;
    private int mLastButtonState;
    private WordIterator mWordIterator;
    private final MenuItem.OnMenuItemClickListener mOnContextMenuItemClickListener;
    private int mLastTapPosition = -1;

    Editor(TextView textView) {
        this.mTextView = textView;
        this.mOnContextMenuItemClickListener = item -> this.mTextView.onTextContextMenuItem(item.getItemId());
    }

    void forgetUndoRedo() {
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        this.mUndoManager.forgetUndos(owners, -1);
        this.mUndoManager.forgetRedos(owners, -1);
    }

    boolean canUndo() {
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        return this.mAllowUndo && this.mUndoManager.countUndos(owners) > 0;
    }

    boolean canRedo() {
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        return this.mAllowUndo && this.mUndoManager.countRedos(owners) > 0;
    }

    void undo() {
        if (!this.mAllowUndo) {
            return;
        }
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        this.mUndoManager.undo(owners, 1);
    }

    void redo() {
        if (!this.mAllowUndo) {
            return;
        }
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        this.mUndoManager.redo(owners, 1);
    }

    void onAttachedToWindow() {
        this.resumeBlink();
    }

    void onDetachedFromWindow() {
        this.suspendBlink();
    }

    private boolean isCursorVisible() {
        return this.mCursorVisible && this.mTextView.isTextEditable();
    }

    boolean shouldRenderCursor() {
        if (this.isCursorVisible()) {
            long showCursorDelta = Core.timeMillis() - this.mShowCursor;
            return showCursorDelta % 1000L < 500L;
        }
        return false;
    }

    private void suspendBlink() {
        if (this.mBlink != null) {
            this.mBlink.cancel();
        }
    }

    private void resumeBlink() {
        if (this.mBlink != null) {
            this.mBlink.reset();
            this.makeBlink();
        }
    }

    WordIterator getWordIterator() {
        if (this.mWordIterator == null) {
            this.mWordIterator = new WordIterator(this.mTextView.getTextLocale());
        }
        return this.mWordIterator;
    }

    void onFocusChanged(boolean focused, int direction) {
        this.mShowCursor = Core.timeMillis();
        if (focused) {
            boolean isFocusHighlighted;
            int selStart = this.mTextView.getSelectionStart();
            int selEnd = this.mTextView.getSelectionEnd();
            boolean bl = isFocusHighlighted = this.mSelectAllOnFocus && selStart == 0 && selEnd == this.mTextView.getText().length();
            if (this.mLastTapPosition >= 0) {
                Selection.setSelection((Spannable)this.mTextView.getText(), this.mLastTapPosition);
            } else {
                MovementMethod movement = this.mTextView.getMovementMethod();
                if (movement != null) {
                    movement.onTakeFocus(this.mTextView, (Spannable)this.mTextView.getText(), direction);
                }
                if (this.mSelectionMoved && selStart >= 0 && selEnd >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), selStart, selEnd);
                }
            }
            if (this.mSelectAllOnFocus) {
                this.mTextView.selectAllText();
            }
            this.makeBlink();
        } else {
            this.mLastTapPosition = -1;
        }
    }

    void onTouchEvent(@Nonnull MotionEvent event) {
        int action = event.getAction();
        boolean filterOutEvent = (action == 0 || action == 1) && ((this.mLastButtonState ^ event.getButtonState()) & 1) == 0 ? true : action == 2 && !event.isButtonPressed(1);
        this.mLastButtonState = event.getButtonState();
        if (filterOutEvent) {
            if (event.getAction() == 1) {
                this.mDiscardNextActionUp = true;
            }
            return;
        }
        if (event.getAction() == 0) {
            this.mLastTapPosition = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
            this.mTouchFocusSelected = false;
            this.mIgnoreActionUpEvent = false;
        }
    }

    void onTouchUpEvent(@Nonnull MotionEvent event) {
        boolean selectAllGotFocus = this.mSelectAllOnFocus && this.mTextView.didTouchFocusSelect();
        CharSequence text = this.mTextView.getText();
        if (!selectAllGotFocus) {
            int offset = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
            Selection.setSelection((Spannable)text, offset);
        }
    }

    void sendOnTextChanged(int start, int before, int after) {
    }

    void addSpanWatchers(Spannable sp) {
    }

    private boolean shouldBlink() {
        if (!this.isCursorVisible() || !this.mTextView.isFocused()) {
            return false;
        }
        int start = this.mTextView.getSelectionStart();
        if (start < 0) {
            return false;
        }
        int end = this.mTextView.getSelectionEnd();
        if (end < 0) {
            return false;
        }
        return start == end;
    }

    void makeBlink() {
        if (this.shouldBlink()) {
            this.mShowCursor = Core.timeMillis();
            if (this.mBlink == null) {
                this.mBlink = new Blink();
            }
            this.mTextView.removeCallbacks(this.mBlink);
            this.mTextView.postDelayed(this.mBlink, 500L);
        } else if (this.mBlink != null) {
            this.mTextView.removeCallbacks(this.mBlink);
        }
    }

    void setContextMenuAnchor(float x, float y) {
        this.mContextMenuAnchorX = x;
        this.mContextMenuAnchorY = y;
    }

    void onCreateContextMenu(ContextMenu menu) {
        boolean isOnSelection;
        if (this.mIsBeingLongClicked) {
            return;
        }
        int offset = Float.isNaN(this.mContextMenuAnchorX) || Float.isNaN(this.mContextMenuAnchorY) ? this.mTextView.getSelectionEnd() : this.mTextView.getOffsetForPosition(this.mContextMenuAnchorX, this.mContextMenuAnchorY);
        if (offset == -1) {
            return;
        }
        int min = Math.min(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd());
        int max = Math.max(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd());
        boolean bl = isOnSelection = this.mTextView.hasSelection() && offset >= min && offset <= max;
        if (!isOnSelection) {
            Selection.setSelection((Spannable)this.mTextView.getText(), offset);
        }
        menu.add(0, 16908338, 2, "Undo").setAlphabeticShortcut('z').setOnMenuItemClickListener(this.mOnContextMenuItemClickListener).setEnabled(this.mTextView.canUndo());
        menu.add(0, 16908339, 3, "Redo").setAlphabeticShortcut('y').setOnMenuItemClickListener(this.mOnContextMenuItemClickListener).setEnabled(this.mTextView.canRedo());
        menu.add(0, 0x1020020, 4, "Cut").setAlphabeticShortcut('x').setOnMenuItemClickListener(this.mOnContextMenuItemClickListener).setEnabled(this.mTextView.canCut());
        menu.add(0, 0x1020021, 5, "Copy").setAlphabeticShortcut('c').setOnMenuItemClickListener(this.mOnContextMenuItemClickListener).setEnabled(this.mTextView.canCopy());
        menu.add(0, 0x1020022, 6, "Paste").setAlphabeticShortcut('v').setEnabled(this.mTextView.canPaste()).setOnMenuItemClickListener(this.mOnContextMenuItemClickListener);
        menu.add(0, 16908319, 8, "Select all").setAlphabeticShortcut('a').setEnabled(this.mTextView.canSelectAllText()).setOnMenuItemClickListener(this.mOnContextMenuItemClickListener);
        menu.setQwertyMode(true);
    }

    private static boolean isValidRange(CharSequence text, int start, int end) {
        return 0 <= start && start <= end && end <= text.length();
    }

    public static class UndoInputFilter
    implements InputFilter {
        private final Editor mEditor;
        private boolean mIsUserEdit;
        private boolean mPreviousOperationWasInSameBatchEdit;
        private static final int MERGE_EDIT_MODE_FORCE_MERGE = 0;
        private static final int MERGE_EDIT_MODE_NORMAL = 2;

        public UndoInputFilter(Editor editor) {
            this.mEditor = editor;
        }

        public void beginBatchEdit() {
            this.mIsUserEdit = true;
        }

        public void endBatchEdit() {
            this.mIsUserEdit = false;
            this.mPreviousOperationWasInSameBatchEdit = false;
        }

        @Override
        public CharSequence filter(@NonNull CharSequence source, int start, int end, @NonNull Spanned dest, int dstart, int dend) {
            if (!this.canUndoEdit(source, start, end, dest, dstart, dend)) {
                return null;
            }
            this.handleEdit(source, start, end, dest, dstart, dend);
            return null;
        }

        void freezeLastEdit() {
            this.mEditor.mUndoManager.beginUpdate("Edit text");
            EditOperation lastEdit = this.getLastEdit();
            if (lastEdit != null) {
                lastEdit.mFrozen = true;
            }
            this.mEditor.mUndoManager.endUpdate();
        }

        private void handleEdit(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            int mergeMode = this.isInTextWatcher() || this.mPreviousOperationWasInSameBatchEdit ? 0 : 2;
            String newText = TextUtils.substring(source, start, end);
            String oldText = TextUtils.substring(dest, dstart, dend);
            EditOperation edit = new EditOperation(this.mEditor, oldText, dstart, newText);
            this.recordEdit(edit, mergeMode);
        }

        private EditOperation getLastEdit() {
            return this.mEditor.mUndoManager.getLastOperation(EditOperation.class, this.mEditor.mUndoOwner, 1);
        }

        private void recordEdit(EditOperation edit, int mergeMode) {
            UndoManager um = this.mEditor.mUndoManager;
            um.beginUpdate("Edit text");
            EditOperation lastEdit = this.getLastEdit();
            if (lastEdit == null) {
                um.addOperation(edit, 0);
            } else if (mergeMode == 0) {
                lastEdit.forceMergeWith(edit);
            } else if (!this.mIsUserEdit) {
                um.commitState(this.mEditor.mUndoOwner);
                um.addOperation(edit, 0);
            } else if (mergeMode != 2 || !lastEdit.mergeWith(edit)) {
                um.commitState(this.mEditor.mUndoOwner);
                um.addOperation(edit, 0);
            }
            this.mPreviousOperationWasInSameBatchEdit = this.mIsUserEdit;
            um.endUpdate();
        }

        private boolean canUndoEdit(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (!this.mEditor.mAllowUndo) {
                return false;
            }
            if (this.mEditor.mUndoManager.isInUndo()) {
                return false;
            }
            if (!Editor.isValidRange(source, start, end) || !Editor.isValidRange(dest, dstart, dend)) {
                return false;
            }
            return start != end || dstart != dend;
        }

        private boolean isInTextWatcher() {
            CharSequence text = this.mEditor.mTextView.getText();
            return text instanceof SpannableStringBuilder && ((SpannableStringBuilder)text).getTextWatcherDepth() > 0;
        }
    }

    private class Blink
    implements Runnable {
        private boolean mCancelled;

        private Blink() {
        }

        @Override
        public void run() {
            if (this.mCancelled) {
                return;
            }
            if (Editor.this.shouldBlink()) {
                if (Editor.this.mTextView.getLayout() != null) {
                    Editor.this.mTextView.invalidateCursorPath();
                }
                Editor.this.mTextView.postDelayed(this, 500L);
            }
        }

        void cancel() {
            if (!this.mCancelled) {
                Editor.this.mTextView.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        void reset() {
            this.mCancelled = false;
        }
    }

    public static class EditOperation
    extends UndoOperation<Editor> {
        public static final Parcelable.ClassLoaderCreator<EditOperation> CREATOR = EditOperation::new;
        private static final int TYPE_INSERT = 0;
        private static final int TYPE_DELETE = 1;
        private static final int TYPE_REPLACE = 2;
        private int mType;
        private String mOldText;
        private String mNewText;
        private int mStart;
        private int mOldCursorPos;
        private int mNewCursorPos;
        private boolean mFrozen;
        private boolean mIsComposition;

        public EditOperation(Editor editor, String oldText, int dstart, String newText) {
            super(editor.mUndoOwner);
            this.mOldText = oldText;
            this.mNewText = newText;
            this.mType = !this.mNewText.isEmpty() && this.mOldText.isEmpty() ? 0 : (this.mNewText.isEmpty() && !this.mOldText.isEmpty() ? 1 : 2);
            this.mStart = dstart;
            this.mOldCursorPos = editor.mTextView.getSelectionStart();
            this.mNewCursorPos = dstart + this.mNewText.length();
        }

        public EditOperation(Parcel src, ClassLoader loader) {
            super(src, loader);
            this.mType = src.readInt();
            this.mOldText = src.readString();
            this.mNewText = src.readString();
            this.mStart = src.readInt();
            this.mOldCursorPos = src.readInt();
            this.mNewCursorPos = src.readInt();
            this.mFrozen = src.readInt() == 1;
            this.mIsComposition = src.readInt() == 1;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeString(this.mOldText);
            dest.writeString(this.mNewText);
            dest.writeInt(this.mStart);
            dest.writeInt(this.mOldCursorPos);
            dest.writeInt(this.mNewCursorPos);
            dest.writeInt(this.mFrozen ? 1 : 0);
            dest.writeInt(this.mIsComposition ? 1 : 0);
        }

        private int getNewTextEnd() {
            return this.mStart + this.mNewText.length();
        }

        private int getOldTextEnd() {
            return this.mStart + this.mOldText.length();
        }

        @Override
        public void commit() {
        }

        @Override
        public void undo() {
            Editor editor = (Editor)this.getOwnerData();
            Editable text = (Editable)editor.mTextView.getText();
            EditOperation.modifyText(text, this.mStart, this.getNewTextEnd(), this.mOldText, this.mStart, this.mOldCursorPos);
        }

        @Override
        public void redo() {
            Editor editor = (Editor)this.getOwnerData();
            Editable text = (Editable)editor.mTextView.getText();
            EditOperation.modifyText(text, this.mStart, this.getOldTextEnd(), this.mNewText, this.mStart, this.mNewCursorPos);
        }

        private boolean mergeWith(EditOperation edit) {
            if (this.mFrozen) {
                return false;
            }
            switch (this.mType) {
                case 0: {
                    return this.mergeInsertWith(edit);
                }
                case 1: {
                    return this.mergeDeleteWith(edit);
                }
                case 2: {
                    return this.mergeReplaceWith(edit);
                }
            }
            return false;
        }

        private boolean mergeInsertWith(EditOperation edit) {
            if (edit.mType == 0) {
                if (this.getNewTextEnd() != edit.mStart) {
                    return false;
                }
                this.mNewText = this.mNewText + edit.mNewText;
                this.mNewCursorPos = edit.mNewCursorPos;
                this.mFrozen = edit.mFrozen;
                this.mIsComposition = edit.mIsComposition;
                return true;
            }
            if (this.mIsComposition && edit.mType == 2 && this.mStart <= edit.mStart && this.getNewTextEnd() >= edit.getOldTextEnd()) {
                this.mNewText = this.mNewText.substring(0, edit.mStart - this.mStart) + edit.mNewText + this.mNewText.substring(edit.getOldTextEnd() - this.mStart);
                this.mNewCursorPos = edit.mNewCursorPos;
                this.mIsComposition = edit.mIsComposition;
                return true;
            }
            return false;
        }

        private boolean mergeDeleteWith(EditOperation edit) {
            if (edit.mType != 1) {
                return false;
            }
            if (this.mStart != edit.getOldTextEnd()) {
                return false;
            }
            this.mStart = edit.mStart;
            this.mOldText = edit.mOldText + this.mOldText;
            this.mNewCursorPos = edit.mNewCursorPos;
            this.mIsComposition = edit.mIsComposition;
            return true;
        }

        private boolean mergeReplaceWith(EditOperation edit) {
            if (edit.mType == 0 && this.getNewTextEnd() == edit.mStart) {
                this.mNewText = this.mNewText + edit.mNewText;
                this.mNewCursorPos = edit.mNewCursorPos;
                return true;
            }
            if (!this.mIsComposition) {
                return false;
            }
            if (edit.mType == 1 && this.mStart <= edit.mStart && this.getNewTextEnd() >= edit.getOldTextEnd()) {
                this.mNewText = this.mNewText.substring(0, edit.mStart - this.mStart) + this.mNewText.substring(edit.getOldTextEnd() - this.mStart);
                if (this.mNewText.isEmpty()) {
                    this.mType = 1;
                }
                this.mNewCursorPos = edit.mNewCursorPos;
                this.mIsComposition = edit.mIsComposition;
                return true;
            }
            if (edit.mType == 2 && this.mStart == edit.mStart && TextUtils.contentEquals(this.mNewText, edit.mOldText)) {
                this.mNewText = edit.mNewText;
                this.mNewCursorPos = edit.mNewCursorPos;
                this.mIsComposition = edit.mIsComposition;
                return true;
            }
            return false;
        }

        public void forceMergeWith(EditOperation edit) {
            if (this.mergeWith(edit)) {
                return;
            }
            Editor editor = (Editor)this.getOwnerData();
            Editable editable = (Editable)editor.mTextView.getText();
            SpannableStringBuilder originalText = new SpannableStringBuilder(editable.toString());
            EditOperation.modifyText(originalText, this.mStart, this.getNewTextEnd(), this.mOldText, this.mStart, this.mOldCursorPos);
            SpannableStringBuilder finalText = new SpannableStringBuilder(editable.toString());
            EditOperation.modifyText(finalText, edit.mStart, edit.getOldTextEnd(), edit.mNewText, edit.mStart, edit.mNewCursorPos);
            this.mType = 2;
            this.mNewText = ((Object)finalText).toString();
            this.mOldText = ((Object)originalText).toString();
            this.mStart = 0;
            this.mNewCursorPos = edit.mNewCursorPos;
            this.mIsComposition = edit.mIsComposition;
        }

        private static void modifyText(Editable text, int deleteFrom, int deleteTo, CharSequence newText, int newTextInsertAt, int newCursorPos) {
            if (Editor.isValidRange(text, deleteFrom, deleteTo) && newTextInsertAt <= text.length() - (deleteTo - deleteFrom)) {
                if (deleteFrom != deleteTo) {
                    text.delete(deleteFrom, deleteTo);
                }
                if (!newText.isEmpty()) {
                    text.insert(newTextInsertAt, newText);
                }
            }
            if (0 <= newCursorPos && newCursorPos <= text.length()) {
                Selection.setSelection(text, newCursorPos);
            }
        }

        private String getTypeString() {
            switch (this.mType) {
                case 0: {
                    return "insert";
                }
                case 1: {
                    return "delete";
                }
                case 2: {
                    return "replace";
                }
            }
            return "";
        }

        public String toString() {
            return "[mType=" + this.getTypeString() + ", mOldText=" + this.mOldText + ", mNewText=" + this.mNewText + ", mStart=" + this.mStart + ", mOldCursorPos=" + this.mOldCursorPos + ", mNewCursorPos=" + this.mNewCursorPos + ", mFrozen=" + this.mFrozen + ", mIsComposition=" + this.mIsComposition + "]";
        }
    }

    private static interface CursorController {
        public void show();

        public void hide();

        public void onDetached();

        public boolean isCursorBeingModified();

        public boolean isActive();
    }
}

