/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import java.nio.FloatBuffer;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.graphics.drawable.StateListDrawable;
import yslelf.cloudpick.graphics.material.MaterialDrawable;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.util.StateSet;
import yslelf.cloudpick.graphics.view.ContextMenu;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.widget.AdapterView;
import yslelf.cloudpick.graphics.widget.ExpandableListAdapter;
import yslelf.cloudpick.graphics.widget.ExpandableListConnector;
import yslelf.cloudpick.graphics.widget.ExpandableListPosition;
import yslelf.cloudpick.graphics.widget.ListAdapter;
import yslelf.cloudpick.graphics.widget.ListView;

public class ExpandableListView
extends ListView {
    public static final int PACKED_POSITION_TYPE_GROUP = 0;
    public static final int PACKED_POSITION_TYPE_CHILD = 1;
    public static final int PACKED_POSITION_TYPE_NULL = 2;
    public static final long PACKED_POSITION_VALUE_NULL = 0xFFFFFFFFL;
    private static final long PACKED_POSITION_MASK_CHILD = 0xFFFFFFFFL;
    private static final long PACKED_POSITION_MASK_GROUP = 0x7FFFFFFF00000000L;
    private static final long PACKED_POSITION_MASK_TYPE = Long.MIN_VALUE;
    private static final long PACKED_POSITION_SHIFT_GROUP = 32L;
    private static final long PACKED_POSITION_SHIFT_TYPE = 63L;
    private static final long PACKED_POSITION_INT_MASK_CHILD = 0xFFFFFFFFL;
    private static final long PACKED_POSITION_INT_MASK_GROUP = Integer.MAX_VALUE;
    private ExpandableListConnector mConnector;
    private ExpandableListAdapter mAdapter;
    private int mIndicatorLeft;
    private int mIndicatorRight;
    private int mIndicatorStart;
    private int mIndicatorEnd;
    private int mChildIndicatorLeft;
    private int mChildIndicatorRight;
    private int mChildIndicatorStart;
    private int mChildIndicatorEnd;
    public static final int CHILD_INDICATOR_INHERIT = -1;
    private static final int INDICATOR_UNDEFINED = -2;
    private Drawable mGroupIndicator;
    private Drawable mChildIndicator;
    private static final int[] GROUP_EXPANDED_STATE_SET = new int[]{16842920};
    private static final int[] GROUP_EMPTY_STATE_SET = new int[]{16842921};
    private static final int[] GROUP_EXPANDED_EMPTY_STATE_SET = new int[]{16842920, 16842921};
    private static final int[][] GROUP_STATE_SETS = new int[][]{EMPTY_STATE_SET, GROUP_EXPANDED_STATE_SET, GROUP_EMPTY_STATE_SET, GROUP_EXPANDED_EMPTY_STATE_SET};
    private static final int[] CHILD_LAST_STATE_SET = new int[]{16842918};
    private Drawable mChildDivider;
    private final Rect mIndicatorRect = new Rect();
    private OnGroupCollapseListener mOnGroupCollapseListener;
    private OnGroupExpandListener mOnGroupExpandListener;
    private OnGroupClickListener mOnGroupClickListener;
    private OnChildClickListener mOnChildClickListener;

    public ExpandableListView(Context context) {
        super(context);
        Drawable drawable = new StateListDrawable();
        ((StateListDrawable)drawable).addState(GROUP_EXPANDED_STATE_SET, new DefaultGroupIndicator(context, false));
        ((StateListDrawable)drawable).addState(StateSet.WILD_CARD, new DefaultGroupIndicator(context, true));
        this.mGroupIndicator = drawable;
        this.mChildIndicator = null;
        this.mIndicatorLeft = this.dp(3.0f);
        this.mIndicatorRight = 0;
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
        this.mChildIndicatorLeft = -1;
        this.mChildIndicatorRight = -1;
        drawable = new ShapeDrawable();
        ((ShapeDrawable)drawable).setColor(0x20FFFFFF);
        ((ShapeDrawable)drawable).setSize(-1, this.dp(1.0f));
        this.setDivider(drawable);
        drawable = new ShapeDrawable();
        ((ShapeDrawable)drawable).setColor(0x20FFFFFF);
        ((ShapeDrawable)drawable).setSize(-1, this.dp(1.0f));
        this.mChildDivider = drawable;
        this.mIndicatorStart = this.dp(3.0f);
        this.mIndicatorEnd = -2;
        this.mChildIndicatorStart = -1;
        this.mChildIndicatorEnd = -1;
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        this.resolveIndicator();
        this.resolveChildIndicator();
    }

    private void resolveIndicator() {
        boolean isLayoutRtl = this.isLayoutRtl();
        if (isLayoutRtl) {
            if (this.mIndicatorStart >= 0) {
                this.mIndicatorRight = this.mIndicatorStart;
            }
            if (this.mIndicatorEnd >= 0) {
                this.mIndicatorLeft = this.mIndicatorEnd;
            }
        } else {
            if (this.mIndicatorStart >= 0) {
                this.mIndicatorLeft = this.mIndicatorStart;
            }
            if (this.mIndicatorEnd >= 0) {
                this.mIndicatorRight = this.mIndicatorEnd;
            }
        }
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
    }

    private void resolveChildIndicator() {
        boolean isLayoutRtl = this.isLayoutRtl();
        if (isLayoutRtl) {
            if (this.mChildIndicatorStart >= -1) {
                this.mChildIndicatorRight = this.mChildIndicatorStart;
            }
            if (this.mChildIndicatorEnd >= -1) {
                this.mChildIndicatorLeft = this.mChildIndicatorEnd;
            }
        } else {
            if (this.mChildIndicatorStart >= -1) {
                this.mChildIndicatorLeft = this.mChildIndicatorStart;
            }
            if (this.mChildIndicatorEnd >= -1) {
                this.mChildIndicatorRight = this.mChildIndicatorEnd;
            }
        }
    }

    @Override
    protected void dispatchDraw(@NonNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mChildIndicator == null && this.mGroupIndicator == null) {
            return;
        }
        int saveCount = 0;
        boolean clipToPadding = this.hasBooleanFlag(34);
        if (clipToPadding) {
            saveCount = canvas.save();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.getWidth() - this.mPaddingRight, scrollY + this.getHeight() - this.mPaddingBottom);
        }
        int headerViewsCount = this.getHeaderViewsCount();
        int lastChildFlPos = this.mItemCount - this.getFooterViewsCount() - headerViewsCount - 1;
        int myB = this.getBottom();
        int lastItemType = -4;
        Rect indicatorRect = this.mIndicatorRect;
        int childCount = this.getChildCount();
        int i = 0;
        int childFlPos = this.mFirstPosition - headerViewsCount;
        while (i < childCount) {
            if (childFlPos >= 0) {
                if (childFlPos > lastChildFlPos) break;
                View item = this.getChildAt(i);
                int t2 = item.getTop();
                int b = item.getBottom();
                if (b >= 0 && t2 <= myB) {
                    ExpandableListConnector.PositionMetadata pos = this.mConnector.getUnflattenedPos(childFlPos);
                    boolean isLayoutRtl = this.isLayoutRtl();
                    int width = this.getWidth();
                    if (pos.position.type != lastItemType) {
                        if (pos.position.type == 1) {
                            indicatorRect.left = this.mChildIndicatorLeft == -1 ? this.mIndicatorLeft : this.mChildIndicatorLeft;
                            indicatorRect.right = this.mChildIndicatorRight == -1 ? this.mIndicatorRight : this.mChildIndicatorRight;
                        } else {
                            indicatorRect.left = this.mIndicatorLeft;
                            indicatorRect.right = this.mIndicatorRight;
                        }
                        if (isLayoutRtl) {
                            int temp = indicatorRect.left;
                            indicatorRect.left = width - indicatorRect.right;
                            indicatorRect.right = width - temp;
                            indicatorRect.left -= this.mPaddingRight;
                            indicatorRect.right -= this.mPaddingRight;
                        } else {
                            indicatorRect.left += this.mPaddingLeft;
                            indicatorRect.right += this.mPaddingLeft;
                        }
                        lastItemType = pos.position.type;
                    }
                    if (indicatorRect.left != indicatorRect.right) {
                        if (this.mStackFromBottom) {
                            indicatorRect.top = t2;
                            indicatorRect.bottom = b;
                        } else {
                            indicatorRect.top = t2;
                            indicatorRect.bottom = b;
                        }
                        Drawable indicator = this.getIndicator(pos);
                        if (indicator != null) {
                            indicator.setBounds(indicatorRect);
                            indicator.draw(canvas);
                        }
                    }
                    pos.recycle();
                }
            }
            ++i;
            ++childFlPos;
        }
        if (clipToPadding) {
            canvas.restoreToCount(saveCount);
        }
    }

    private Drawable getIndicator(ExpandableListConnector.PositionMetadata pos) {
        Drawable indicator;
        if (pos.position.type == 2) {
            indicator = this.mGroupIndicator;
            if (indicator != null && indicator.isStateful()) {
                boolean isEmpty = pos.groupMetadata == null || pos.groupMetadata.lastChildFlPos == pos.groupMetadata.flPos;
                int stateSetIndex = (pos.isExpanded() ? 1 : 0) | (isEmpty ? 2 : 0);
                indicator.setState(GROUP_STATE_SETS[stateSetIndex]);
            }
        } else {
            indicator = this.mChildIndicator;
            if (indicator != null && indicator.isStateful()) {
                int[] stateSet = pos.position.flatListPos == pos.groupMetadata.lastChildFlPos ? CHILD_LAST_STATE_SET : EMPTY_STATE_SET;
                indicator.setState(stateSet);
            }
        }
        return indicator;
    }

    public void setChildDivider(Drawable childDivider) {
        this.mChildDivider = childDivider;
    }

    @Override
    void drawDivider(Canvas canvas, Rect bounds, int childIndex) {
        int flatListPosition = childIndex + this.mFirstPosition;
        if (flatListPosition >= 0) {
            int adjustedPosition = this.getFlatPositionForConnector(flatListPosition);
            ExpandableListConnector.PositionMetadata pos = this.mConnector.getUnflattenedPos(adjustedPosition);
            if (pos.position.type == 1 || pos.isExpanded() && pos.groupMetadata.lastChildFlPos != pos.groupMetadata.flPos) {
                Drawable divider = this.mChildDivider;
                divider.setBounds(bounds);
                divider.draw(canvas);
                pos.recycle();
                return;
            }
            pos.recycle();
        }
        super.drawDivider(canvas, bounds, flatListPosition);
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        throw new RuntimeException("For ExpandableListView, use setAdapter(ExpandableListAdapter) instead of setAdapter(ListAdapter)");
    }

    @Override
    public ListAdapter getAdapter() {
        return super.getAdapter();
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener l2) {
        super.setOnItemClickListener(l2);
    }

    @Override
    public void setAdapter(ExpandableListAdapter adapter) {
        this.mAdapter = adapter;
        this.mConnector = adapter != null ? new ExpandableListConnector(adapter) : null;
        super.setAdapter(this.mConnector);
    }

    public ExpandableListAdapter getExpandableListAdapter() {
        return this.mAdapter;
    }

    private boolean isHeaderOrFooterPosition(int position) {
        int footerViewsStart = this.mItemCount - this.getFooterViewsCount();
        return position < this.getHeaderViewsCount() || position >= footerViewsStart;
    }

    private int getFlatPositionForConnector(int flatListPosition) {
        return flatListPosition - this.getHeaderViewsCount();
    }

    private int getAbsoluteFlatPosition(int flatListPosition) {
        return flatListPosition + this.getHeaderViewsCount();
    }

    @Override
    public boolean performItemClick(View v, int position, long id2) {
        if (this.isHeaderOrFooterPosition(position)) {
            return super.performItemClick(v, position, id2);
        }
        int adjustedPosition = this.getFlatPositionForConnector(position);
        return this.handleItemClick(v, adjustedPosition, id2);
    }

    boolean handleItemClick(View v, int position, long id2) {
        boolean returnValue;
        ExpandableListConnector.PositionMetadata posMetadata = this.mConnector.getUnflattenedPos(position);
        id2 = this.getChildOrGroupId(posMetadata.position);
        if (posMetadata.position.type == 2) {
            if (this.mOnGroupClickListener != null && this.mOnGroupClickListener.onGroupClick(this, v, posMetadata.position.groupPos, id2)) {
                posMetadata.recycle();
                return true;
            }
            if (posMetadata.isExpanded()) {
                this.mConnector.collapseGroup(posMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupCollapseListener != null) {
                    this.mOnGroupCollapseListener.onGroupCollapse(posMetadata.position.groupPos);
                }
            } else {
                this.mConnector.expandGroup(posMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupExpandListener != null) {
                    this.mOnGroupExpandListener.onGroupExpand(posMetadata.position.groupPos);
                }
                int groupPos = posMetadata.position.groupPos;
                int groupFlatPos = posMetadata.position.flatListPos;
                int shiftedGroupPosition = groupFlatPos + this.getHeaderViewsCount();
                this.smoothScrollToPosition(shiftedGroupPosition + this.mAdapter.getChildrenCount(groupPos), shiftedGroupPosition);
            }
            returnValue = true;
        } else {
            if (this.mOnChildClickListener != null) {
                this.playSoundEffect(0);
                return this.mOnChildClickListener.onChildClick(this, v, posMetadata.position.groupPos, posMetadata.position.childPos, id2);
            }
            returnValue = false;
        }
        posMetadata.recycle();
        return returnValue;
    }

    public boolean expandGroup(int groupPos) {
        return this.expandGroup(groupPos, false);
    }

    public boolean expandGroup(int groupPos, boolean animate) {
        ExpandableListPosition elGroupPos = ExpandableListPosition.obtain(2, groupPos, -1, -1);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elGroupPos);
        elGroupPos.recycle();
        boolean retValue = this.mConnector.expandGroup(pm);
        if (this.mOnGroupExpandListener != null) {
            this.mOnGroupExpandListener.onGroupExpand(groupPos);
        }
        if (animate) {
            int groupFlatPos = pm.position.flatListPos;
            int shiftedGroupPosition = groupFlatPos + this.getHeaderViewsCount();
            this.smoothScrollToPosition(shiftedGroupPosition + this.mAdapter.getChildrenCount(groupPos), shiftedGroupPosition);
        }
        pm.recycle();
        return retValue;
    }

    public boolean collapseGroup(int groupPos) {
        boolean retValue = this.mConnector.collapseGroup(groupPos);
        if (this.mOnGroupCollapseListener != null) {
            this.mOnGroupCollapseListener.onGroupCollapse(groupPos);
        }
        return retValue;
    }

    public void setOnGroupCollapseListener(OnGroupCollapseListener onGroupCollapseListener) {
        this.mOnGroupCollapseListener = onGroupCollapseListener;
    }

    public void setOnGroupExpandListener(OnGroupExpandListener onGroupExpandListener) {
        this.mOnGroupExpandListener = onGroupExpandListener;
    }

    public void setOnGroupClickListener(OnGroupClickListener onGroupClickListener) {
        this.mOnGroupClickListener = onGroupClickListener;
    }

    public void setOnChildClickListener(OnChildClickListener onChildClickListener) {
        this.mOnChildClickListener = onChildClickListener;
    }

    public long getExpandableListPosition(int flatListPosition) {
        if (this.isHeaderOrFooterPosition(flatListPosition)) {
            return 0xFFFFFFFFL;
        }
        int adjustedPosition = this.getFlatPositionForConnector(flatListPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getUnflattenedPos(adjustedPosition);
        long packedPos = pm.position.getPackedPosition();
        pm.recycle();
        return packedPos;
    }

    public int getFlatListPosition(long packedPosition) {
        ExpandableListPosition elPackedPos = ExpandableListPosition.obtainPosition(packedPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elPackedPos);
        elPackedPos.recycle();
        int flatListPosition = pm.position.flatListPos;
        pm.recycle();
        return this.getAbsoluteFlatPosition(flatListPosition);
    }

    public long getSelectedPosition() {
        int selectedPos = this.getSelectedItemPosition();
        return this.getExpandableListPosition(selectedPos);
    }

    public long getSelectedId() {
        long packedPos = this.getSelectedPosition();
        if (packedPos == 0xFFFFFFFFL) {
            return -1L;
        }
        int groupPos = ExpandableListView.getPackedPositionGroup(packedPos);
        if (ExpandableListView.getPackedPositionType(packedPos) == 0) {
            return this.mAdapter.getGroupId(groupPos);
        }
        return this.mAdapter.getChildId(groupPos, ExpandableListView.getPackedPositionChild(packedPos));
    }

    public void setSelectedGroup(int groupPosition) {
        ExpandableListPosition elGroupPos = ExpandableListPosition.obtainGroupPosition(groupPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elGroupPos);
        elGroupPos.recycle();
        int absoluteFlatPosition = this.getAbsoluteFlatPosition(pm.position.flatListPos);
        super.setSelection(absoluteFlatPosition);
        pm.recycle();
    }

    public boolean setSelectedChild(int groupPosition, int childPosition, boolean shouldExpandGroup) {
        ExpandableListPosition elChildPos = ExpandableListPosition.obtainChildPosition(groupPosition, childPosition);
        ExpandableListConnector.PositionMetadata flatChildPos = this.mConnector.getFlattenedPos(elChildPos);
        if (flatChildPos == null) {
            if (!shouldExpandGroup) {
                return false;
            }
            this.expandGroup(groupPosition);
            flatChildPos = this.mConnector.getFlattenedPos(elChildPos);
            if (flatChildPos == null) {
                throw new IllegalStateException("Could not find child");
            }
        }
        int absoluteFlatPosition = this.getAbsoluteFlatPosition(flatChildPos.position.flatListPos);
        super.setSelection(absoluteFlatPosition);
        elChildPos.recycle();
        flatChildPos.recycle();
        return true;
    }

    public boolean isGroupExpanded(int groupPosition) {
        return this.mConnector.isGroupExpanded(groupPosition);
    }

    public static int getPackedPositionType(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return 2;
        }
        return (packedPosition & Long.MIN_VALUE) == Long.MIN_VALUE ? 1 : 0;
    }

    public static int getPackedPositionGroup(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return -1;
        }
        return (int)((packedPosition & 0x7FFFFFFF00000000L) >> 32);
    }

    public static int getPackedPositionChild(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return -1;
        }
        if ((packedPosition & Long.MIN_VALUE) != Long.MIN_VALUE) {
            return -1;
        }
        return (int)(packedPosition & 0xFFFFFFFFL);
    }

    public static long getPackedPositionForChild(int groupPosition, int childPosition) {
        return Long.MIN_VALUE | ((long)groupPosition & Integer.MAX_VALUE) << 32 | (long)childPosition & 0xFFFFFFFFL;
    }

    public static long getPackedPositionForGroup(int groupPosition) {
        return ((long)groupPosition & Integer.MAX_VALUE) << 32;
    }

    @Override
    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int flatListPosition, long id2) {
        if (this.isHeaderOrFooterPosition(flatListPosition)) {
            return new AdapterView.AdapterContextMenuInfo(view, flatListPosition, id2);
        }
        int adjustedPosition = this.getFlatPositionForConnector(flatListPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getUnflattenedPos(adjustedPosition);
        ExpandableListPosition pos = pm.position;
        id2 = this.getChildOrGroupId(pos);
        long packedPosition = pos.getPackedPosition();
        pm.recycle();
        return new ExpandableListContextMenuInfo(view, packedPosition, id2);
    }

    private long getChildOrGroupId(ExpandableListPosition position) {
        if (position.type == 1) {
            return this.mAdapter.getChildId(position.groupPos, position.childPos);
        }
        return this.mAdapter.getGroupId(position.groupPos);
    }

    public void setChildIndicator(Drawable childIndicator) {
        this.mChildIndicator = childIndicator;
    }

    public void setChildIndicatorBounds(int left, int right) {
        this.mChildIndicatorLeft = left;
        this.mChildIndicatorRight = right;
        this.resolveChildIndicator();
    }

    public void setChildIndicatorBoundsRelative(int start, int end) {
        this.mChildIndicatorStart = start;
        this.mChildIndicatorEnd = end;
        this.resolveChildIndicator();
    }

    public void setGroupIndicator(Drawable groupIndicator) {
        this.mGroupIndicator = groupIndicator;
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
    }

    public void setIndicatorBounds(int left, int right) {
        this.mIndicatorLeft = left;
        this.mIndicatorRight = right;
        this.resolveIndicator();
    }

    public void setIndicatorBoundsRelative(int start, int end) {
        this.mIndicatorStart = start;
        this.mIndicatorEnd = end;
        this.resolveIndicator();
    }

    private static class DefaultGroupIndicator
    extends MaterialDrawable {
        private final boolean mDown;
        private final int mSize;
        private final FloatBuffer mPoints;

        public DefaultGroupIndicator(Context context, boolean down) {
            this.mDown = down;
            this.mSize = (int)TypedValue.applyDimension(1, 24.0f, context.getResources().getDisplayMetrics());
            this.mPoints = FloatBuffer.allocate(6);
        }

        @Override
        public void draw(@NonNull Canvas canvas) {
            Paint paint = Paint.obtain();
            paint.setColor(this.mColor);
            paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
            if (paint.getAlpha() != 0) {
                Rect bounds = this.getBounds();
                canvas.translate(bounds.x(), bounds.y());
                canvas.drawTriangleListMesh(this.mPoints, null, paint);
                canvas.translate(-bounds.x(), -bounds.y());
            }
            paint.recycle();
        }

        @Override
        protected void onBoundsChange(@NonNull Rect bounds) {
            this.buildArrowPoints(bounds.width(), bounds.height());
        }

        private void buildArrowPoints(float w, float h2) {
            if (this.mDown) {
                this.mPoints.put(0.75f * w).put(0.33333334f * h2).put(0.25f * w).put(0.33333334f * h2).put(0.5f * w).put(0.6666667f * h2).flip();
            } else {
                this.mPoints.put(0.75f * w).put(0.6666667f * h2).put(0.5f * w).put(0.33333334f * h2).put(0.25f * w).put(0.6666667f * h2).flip();
            }
        }

        @Override
        public int getIntrinsicWidth() {
            return this.mSize;
        }

        @Override
        public int getIntrinsicHeight() {
            return this.mSize;
        }
    }

    public static interface OnGroupClickListener {
        public boolean onGroupClick(ExpandableListView var1, View var2, int var3, long var4);
    }

    public static interface OnGroupCollapseListener {
        public void onGroupCollapse(int var1);
    }

    public static interface OnGroupExpandListener {
        public void onGroupExpand(int var1);
    }

    public static interface OnChildClickListener {
        public boolean onChildClick(ExpandableListView var1, View var2, int var3, int var4, long var5);
    }

    public static class ExpandableListContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public View targetView;
        public long packedPosition;
        public long id;

        public ExpandableListContextMenuInfo(View targetView, long packedPosition, long id2) {
            this.targetView = targetView;
            this.packedPosition = packedPosition;
            this.id = id2;
        }
    }
}

