/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import javax.annotation.Nonnull;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.core.Handler;
import yslelf.cloudpick.graphics.core.HandlerThread;
import yslelf.cloudpick.graphics.core.Looper;
import yslelf.cloudpick.graphics.core.Message;

public abstract class Filter {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Filter");
    private static final String THREAD_NAME = "Filter";
    private static final int FILTER_TOKEN = -791613427;
    private static final int FINISH_TOKEN = -559038737;
    private Handler mThreadHandler;
    private HandlerThread mHandlerThread;
    private final Handler mResultHandler;
    private Delayer mDelayer;
    private final Object mLock = new Object();

    public Filter() {
        this.mResultHandler = new ResultsHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelayer(Delayer delayer) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDelayer = delayer;
        }
    }

    public final void filter(CharSequence constraint) {
        this.filter(constraint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void filter(CharSequence constraint, FilterListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mThreadHandler == null) {
                this.mHandlerThread = new HandlerThread(THREAD_NAME);
                this.mHandlerThread.start();
                this.mThreadHandler = new RequestHandler(this.mHandlerThread.getLooper());
            }
            long delay = this.mDelayer == null ? 0L : this.mDelayer.getPostingDelay(constraint);
            Message message = this.mThreadHandler.obtainMessage(-791613427);
            RequestArguments args = new RequestArguments();
            args.constraint = constraint != null ? constraint.toString() : null;
            args.listener = listener;
            message.obj = args;
            this.mThreadHandler.removeMessages(-791613427);
            this.mThreadHandler.removeMessages(-559038737);
            this.mThreadHandler.sendMessageDelayed(message, delay);
        }
    }

    protected abstract FilterResults performFiltering(CharSequence var1);

    protected abstract void publishResults(CharSequence var1, FilterResults var2);

    public CharSequence convertResultToString(Object resultValue) {
        return resultValue == null ? "" : resultValue.toString();
    }

    private class ResultsHandler
    extends Handler {
        public ResultsHandler() {
            super(Looper.myLooper());
        }

        @Override
        public void handleMessage(@Nonnull Message msg) {
            RequestArguments args = (RequestArguments)msg.obj;
            Filter.this.publishResults(args.constraint, args.results);
            if (args.listener != null) {
                int count = args.results != null ? args.results.count : -1;
                args.listener.onFilterComplete(count);
            }
        }
    }

    @ApiStatus.Internal
    public static interface Delayer {
        public long getPostingDelay(CharSequence var1);
    }

    @FunctionalInterface
    public static interface FilterListener {
        public void onFilterComplete(int var1);
    }

    private class RequestHandler
    extends Handler {
        public RequestHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(@Nonnull Message msg) {
            int what = msg.what;
            switch (what) {
                case -791613427: {
                    RequestArguments args = (RequestArguments)msg.obj;
                    try {
                        args.results = Filter.this.performFiltering(args.constraint);
                        Message message = Filter.this.mResultHandler.obtainMessage(what);
                        message.obj = args;
                        message.sendToTarget();
                    }
                    catch (Exception e) {
                        try {
                            args.results = new FilterResults();
                            CloudPick.LOGGER.warn(MARKER, "An exception occurred during performFiltering()!", (Throwable)e);
                            Message message = Filter.this.mResultHandler.obtainMessage(what);
                            message.obj = args;
                            message.sendToTarget();
                        }
                        catch (Throwable throwable) {
                            Message message = Filter.this.mResultHandler.obtainMessage(what);
                            message.obj = args;
                            message.sendToTarget();
                            throw throwable;
                        }
                    }
                    Object object = Filter.this.mLock;
                    synchronized (object) {
                        if (Filter.this.mThreadHandler != null) {
                            Message finishMessage = Filter.this.mThreadHandler.obtainMessage(-559038737);
                            Filter.this.mThreadHandler.sendMessageDelayed(finishMessage, 3000L);
                        }
                        break;
                    }
                }
                case -559038737: {
                    Object object = Filter.this.mLock;
                    synchronized (object) {
                        if (Filter.this.mThreadHandler != null) {
                            Filter.this.mHandlerThread.quit();
                            Filter.this.mThreadHandler = null;
                            Filter.this.mHandlerThread = null;
                        }
                        break;
                    }
                }
            }
        }
    }

    private static class RequestArguments {
        CharSequence constraint;
        FilterListener listener;
        FilterResults results;

        private RequestArguments() {
        }
    }

    protected static class FilterResults {
        public Object values;
        public int count;
    }
}

