/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import java.util.ArrayList;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.util.AttributeSet;
import yslelf.cloudpick.graphics.view.Gravity;
import yslelf.cloudpick.graphics.view.MeasureSpec;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;

public class FrameLayout
extends ViewGroup {
    private static final int DEFAULT_CHILD_GRAVITY = 0x800033;
    boolean mMeasureAllChildren = false;
    private int mForegroundPaddingLeft = 0;
    private int mForegroundPaddingTop = 0;
    private int mForegroundPaddingRight = 0;
    private int mForegroundPaddingBottom = 0;
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);

    public FrameLayout(@NonNull Context context) {
        super(context);
    }

    public FrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, null);
    }

    public FrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr) {
        this(context, attrs, defStyleAttr, null);
    }

    public FrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr, @Nullable ResourceId defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void setForegroundGravity(int foregroundGravity) {
        if (this.getForegroundGravity() != foregroundGravity) {
            super.setForegroundGravity(foregroundGravity);
            Drawable foreground = this.getForeground();
            if (this.getForegroundGravity() == 119 && foreground != null) {
                Rect padding = new Rect();
                if (foreground.getPadding(padding)) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.mForegroundPaddingLeft = 0;
                this.mForegroundPaddingTop = 0;
                this.mForegroundPaddingRight = 0;
                this.mForegroundPaddingBottom = 0;
            }
            this.requestLayout();
        }
    }

    int getPaddingLeftWithForeground() {
        return this.isForegroundInsidePadding() ? Math.max(this.mPaddingLeft, this.mForegroundPaddingLeft) : this.mPaddingLeft + this.mForegroundPaddingLeft;
    }

    int getPaddingRightWithForeground() {
        return this.isForegroundInsidePadding() ? Math.max(this.mPaddingRight, this.mForegroundPaddingRight) : this.mPaddingRight + this.mForegroundPaddingRight;
    }

    private int getPaddingTopWithForeground() {
        return this.isForegroundInsidePadding() ? Math.max(this.mPaddingTop, this.mForegroundPaddingTop) : this.mPaddingTop + this.mForegroundPaddingTop;
    }

    private int getPaddingBottomWithForeground() {
        return this.isForegroundInsidePadding() ? Math.max(this.mPaddingBottom, this.mForegroundPaddingBottom) : this.mPaddingBottom + this.mForegroundPaddingBottom;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        boolean measureMatchParentChildren = MeasureSpec.getMode(widthMeasureSpec) != 0x40000000 || MeasureSpec.getMode(heightMeasureSpec) != 0x40000000;
        this.mMatchParentChildren.clear();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!this.mMeasureAllChildren && child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = FrameLayout.combineMeasuredStates(childState, child.getMeasuredState());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground();
        maxHeight += this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable = this.getForeground();
        if (drawable != null) {
            maxHeight = Math.max(maxHeight, drawable.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable.getMinimumWidth());
        }
        this.setMeasuredDimension(FrameLayout.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), FrameLayout.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                int childHeightMeasureSpec;
                int childWidthMeasureSpec;
                View child = this.mMatchParentChildren.get(i);
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                if (lp.width == -1) {
                    int width = Math.max(0, this.getMeasuredWidth() - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - lp.leftMargin - lp.rightMargin);
                    childWidthMeasureSpec = MeasureSpec.makeMeasureSpec(width, 0x40000000);
                } else {
                    childWidthMeasureSpec = FrameLayout.getChildMeasureSpec(widthMeasureSpec, this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground() + lp.leftMargin + lp.rightMargin, lp.width);
                }
                if (lp.height == -1) {
                    int height = Math.max(0, this.getMeasuredHeight() - this.getPaddingTopWithForeground() - this.getPaddingBottomWithForeground() - lp.topMargin - lp.bottomMargin);
                    childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(height, 0x40000000);
                } else {
                    childHeightMeasureSpec = FrameLayout.getChildMeasureSpec(heightMeasureSpec, this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground() + lp.topMargin + lp.bottomMargin, lp.height);
                }
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren(left, top, right, bottom, false);
    }

    void layoutChildren(int left, int top, int right, int bottom, boolean forceLeftGravity) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeftWithForeground();
        int parentRight = right - left - this.getPaddingRightWithForeground();
        int parentTop = this.getPaddingTopWithForeground();
        int parentBottom = bottom - top - this.getPaddingBottomWithForeground();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity == -1) {
                gravity = 0x800033;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
            int verticalGravity = gravity & 0x70;
            int childTop = switch (verticalGravity) {
                case 16 -> parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                case 80 -> parentBottom - height - lp.bottomMargin;
                default -> parentTop + lp.topMargin;
            };
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    public void setMeasureAllChildren(boolean measureAll) {
        this.mMeasureAllChildren = measureAll;
    }

    public boolean getMeasureAllChildren() {
        return this.mMeasureAllChildren;
    }

    @Override
    @NonNull
    protected ViewGroup.LayoutParams generateLayoutParams(@NonNull ViewGroup.LayoutParams params) {
        if (params instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)params);
        }
        if (params instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)params);
        }
        return new LayoutParams(params);
    }

    @Override
    @NonNull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    protected boolean checkLayoutParams(@Nullable ViewGroup.LayoutParams params) {
        return params instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public static final int UNSPECIFIED_GRAVITY = -1;
        public int gravity = -1;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height);
            this.gravity = gravity;
        }

        public LayoutParams(@NonNull ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull LayoutParams source) {
            super(source);
            this.gravity = source.gravity;
        }
    }
}

