/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import java.util.ArrayList;
import yslelf.cloudpick.graphics.annotation.ColorInt;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.BlendMode;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.util.ColorStateList;
import yslelf.cloudpick.graphics.view.FocusFinder;
import yslelf.cloudpick.graphics.view.KeyEvent;
import yslelf.cloudpick.graphics.view.MeasureSpec;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.view.VelocityTracker;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewConfiguration;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.view.ViewParent;
import yslelf.cloudpick.graphics.widget.EdgeEffect;
import yslelf.cloudpick.graphics.widget.FrameLayout;
import yslelf.cloudpick.graphics.widget.OverScroller;

public class HorizontalScrollView
extends FrameLayout {
    private static final float FLING_DESTRETCH_FACTOR = 4.0f;
    private final Rect mTempRect = new Rect();
    private final OverScroller mScroller = new OverScroller();
    private final EdgeEffect mEdgeGlowLeft;
    private final EdgeEffect mEdgeGlowRight;
    private int mLastMotionX;
    private boolean mIsLayoutDirty = true;
    private View mChildToScrollTo = null;
    private boolean mIsBeingDragged = false;
    private VelocityTracker mVelocityTracker;
    private boolean mFillViewport;
    private boolean mSmoothScrollingEnabled = true;
    private final int mTouchSlop;
    private final int mMinimumVelocity;
    private final int mMaximumVelocity;
    private final int mOverscrollDistance;
    private final int mOverflingDistance;
    private final float mHorizontalScrollFactor;
    private int mActivePointerId = -1;

    public HorizontalScrollView(Context context) {
        super(context);
        this.mEdgeGlowLeft = new EdgeEffect(context);
        this.mEdgeGlowRight = new EdgeEffect(context);
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration configuration = ViewConfiguration.get(context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
        this.mHorizontalScrollFactor = configuration.getScaledHorizontalScrollFactor();
        ColorStateList tint = null;
        TypedValue value = new TypedValue();
        if (context.getTheme().resolveAttribute("modernui", "colorControlNormal", value, true)) {
            tint = context.getResources().loadColorStateList(value, context.getTheme());
        }
        this.setHorizontalScrollBarEnabled(true);
        ShapeDrawable thumb = new ShapeDrawable();
        thumb.setShape(3);
        thumb.setStroke(this.dp(4.0f), -2063597569);
        thumb.setCornerRadius(1.0f);
        thumb.setTintList(tint);
        this.setHorizontalScrollbarThumbDrawable(thumb);
        ShapeDrawable track = new ShapeDrawable();
        track.setShape(3);
        track.setStroke(this.dp(4.0f), 0x39FFFFFF);
        track.setSize(this.dp(4.0f), -1);
        track.setCornerRadius(1.0f);
        track.setTintList(tint);
        this.setHorizontalScrollbarTrackDrawable(track);
    }

    public void setEdgeEffectColor(@ColorInt int color) {
        this.setLeftEdgeEffectColor(color);
        this.setRightEdgeEffectColor(color);
    }

    public void setRightEdgeEffectColor(@ColorInt int color) {
        this.mEdgeGlowRight.setColor(color);
    }

    public void setLeftEdgeEffectColor(@ColorInt int color) {
        this.mEdgeGlowLeft.setColor(color);
    }

    @ColorInt
    public int getLeftEdgeEffectColor() {
        return this.mEdgeGlowLeft.getColor();
    }

    @ColorInt
    public int getRightEdgeEffectColor() {
        return this.mEdgeGlowRight.getColor();
    }

    public void setLeftEdgeEffectBlendMode(@Nullable BlendMode blendMode) {
        this.mEdgeGlowLeft.setBlendMode(blendMode);
    }

    public void setRightEdgeEffectBlendMode(@Nullable BlendMode blendMode) {
        this.mEdgeGlowRight.setBlendMode(blendMode);
    }

    @Nullable
    public BlendMode getLeftEdgeEffectBlendMode() {
        return this.mEdgeGlowLeft.getBlendMode();
    }

    @Nullable
    public BlendMode getRightEdgeEffectBlendMode() {
        return this.mEdgeGlowRight.getBlendMode();
    }

    @Override
    public void addView(@NonNull View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(child);
    }

    @Override
    public void addView(@NonNull View child, int index) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(child, index);
    }

    @Override
    public void addView(@NonNull View child, @NonNull ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(child, params);
    }

    @Override
    public void addView(@NonNull View child, int index, @NonNull ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(child, index, params);
    }

    private boolean canScroll() {
        View child = this.getChildAt(0);
        if (child != null) {
            int childWidth = child.getWidth();
            return this.getWidth() < childWidth + this.mPaddingLeft + this.mPaddingRight;
        }
        return false;
    }

    public boolean isFillViewport() {
        return this.mFillViewport;
    }

    public void setFillViewport(boolean fillViewport) {
        if (fillViewport != this.mFillViewport) {
            this.mFillViewport = fillViewport;
            this.requestLayout();
        }
    }

    public boolean isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    public void setSmoothScrollingEnabled(boolean smoothScrollingEnabled) {
        this.mSmoothScrollingEnabled = smoothScrollingEnabled;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.mFillViewport) {
            return;
        }
        int widthMode = MeasureSpec.getMode(widthMeasureSpec);
        if (widthMode == 0) {
            return;
        }
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            int widthPadding = this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin;
            int heightPadding = this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin;
            int desiredWidth = this.getMeasuredWidth() - widthPadding;
            if (child.getMeasuredWidth() < desiredWidth) {
                int childWidthMeasureSpec = MeasureSpec.makeMeasureSpec(desiredWidth, 0x40000000);
                int childHeightMeasureSpec = HorizontalScrollView.getChildMeasureSpec(heightMeasureSpec, heightPadding, lp.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        this.mTempRect.setEmpty();
        if (!this.canScroll()) {
            if (this.isFocused()) {
                View nextFocused;
                View currentFocused = this.findFocus();
                if (currentFocused == this) {
                    currentFocused = null;
                }
                return (nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, 66)) != null && nextFocused != this && nextFocused.requestFocus(66);
            }
            return false;
        }
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 263: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(17);
                        break;
                    }
                    handled = this.fullScroll(17);
                    break;
                }
                case 262: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(66);
                        break;
                    }
                    handled = this.fullScroll(66);
                    break;
                }
                case 32: {
                    handled = this.pageScroll(event.isShiftPressed() ? 17 : 66);
                }
            }
        }
        return handled;
    }

    private boolean inChild(int x, int y) {
        if (this.getChildCount() > 0) {
            int scrollX = this.mScrollX;
            View child = this.getChildAt(0);
            return y >= child.getTop() && y < child.getBottom() && x >= child.getLeft() - scrollX && x < child.getRight() - scrollX;
        }
        return false;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mIsBeingDragged) {
            return true;
        }
        if (super.onInterceptTouchEvent(ev)) {
            return true;
        }
        switch (action) {
            case 2: {
                int x;
                int xDiff;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1 || (xDiff = Math.abs((x = (int)ev.getX()) - this.mLastMotionX)) <= this.mTouchSlop) break;
                this.mIsBeingDragged = true;
                this.mLastMotionX = x;
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(ev);
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 0: {
                int x = (int)ev.getX();
                if (!this.inChild(x, (int)ev.getY())) {
                    this.mIsBeingDragged = false;
                    this.recycleVelocityTracker();
                    break;
                }
                this.mLastMotionX = x;
                this.mActivePointerId = ev.getPointerId(0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                boolean bl = this.mIsBeingDragged = !this.mScroller.isFinished();
                if (!this.mEdgeGlowLeft.isFinished()) {
                    this.mEdgeGlowLeft.onPullDistance(0.0f, 1.0f - ev.getY() / (float)this.getHeight());
                }
                if (this.mEdgeGlowRight.isFinished()) break;
                this.mEdgeGlowRight.onPullDistance(0.0f, ev.getY() / (float)this.getHeight());
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                if (!this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0)) break;
                this.postInvalidateOnAnimation();
            }
        }
        return this.mIsBeingDragged;
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        this.initVelocityTrackerIfNotExists();
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                ViewParent parent;
                if (this.getChildCount() == 0) {
                    return false;
                }
                if (!this.mScroller.isFinished() && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionX = (int)ev.getX();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) break;
                int x = (int)ev.getX();
                int deltaX = this.mLastMotionX - x;
                if (!this.mIsBeingDragged && Math.abs(deltaX) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    deltaX = deltaX > 0 ? (deltaX -= this.mTouchSlop) : (deltaX += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionX = x;
                int oldX = this.mScrollX;
                int range = this.getScrollRange();
                int overscrollMode = this.getOverScrollMode();
                boolean canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                float displacement = ev.getY() / (float)this.getHeight();
                if (canOverscroll) {
                    int consumed = 0;
                    if (deltaX < 0 && this.mEdgeGlowRight.getDistance() != 0.0f) {
                        consumed = Math.round((float)this.getWidth() * this.mEdgeGlowRight.onPullDistance((float)deltaX / (float)this.getWidth(), displacement));
                    } else if (deltaX > 0 && this.mEdgeGlowLeft.getDistance() != 0.0f) {
                        consumed = Math.round((float)(-this.getWidth()) * this.mEdgeGlowLeft.onPullDistance((float)(-deltaX) / (float)this.getWidth(), 1.0f - displacement));
                    }
                    deltaX -= consumed;
                }
                this.overScrollBy(deltaX, 0, this.mScrollX, 0, range, 0, this.mOverscrollDistance, 0, true);
                if (!canOverscroll || (float)deltaX == 0.0f) break;
                int pulledToX = oldX + deltaX;
                if (pulledToX < 0) {
                    this.mEdgeGlowLeft.onPullDistance((float)(-deltaX) / (float)this.getWidth(), 1.0f - displacement);
                    if (!this.mEdgeGlowRight.isFinished()) {
                        this.mEdgeGlowRight.onRelease();
                    }
                } else if (pulledToX > range) {
                    this.mEdgeGlowRight.onPullDistance((float)deltaX / (float)this.getWidth(), displacement);
                    if (!this.mEdgeGlowLeft.isFinished()) {
                        this.mEdgeGlowLeft.onRelease();
                    }
                }
                if (!this.shouldDisplayEdgeEffects() || this.mEdgeGlowLeft.isFinished() && this.mEdgeGlowRight.isFinished()) break;
                this.postInvalidateOnAnimation();
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getXVelocity();
                if (this.getChildCount() > 0) {
                    if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                        this.fling(-initialVelocity);
                    } else if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0)) {
                        this.postInvalidateOnAnimation();
                    }
                }
                this.mActivePointerId = -1;
                this.mIsBeingDragged = false;
                this.recycleVelocityTracker();
                if (!this.shouldDisplayEdgeEffects()) break;
                this.mEdgeGlowLeft.onRelease();
                this.mEdgeGlowRight.onRelease();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged || this.getChildCount() <= 0) break;
                if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0)) {
                    this.postInvalidateOnAnimation();
                }
                this.mActivePointerId = -1;
                this.mIsBeingDragged = false;
                this.recycleVelocityTracker();
                if (!this.shouldDisplayEdgeEffects()) break;
                this.mEdgeGlowLeft.onRelease();
                this.mEdgeGlowRight.onRelease();
            }
        }
        return true;
    }

    @Override
    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 8 && !this.mIsBeingDragged) {
            float axisValue = event.isShiftPressed() ? event.getAxisValue(9) : event.getAxisValue(10);
            int delta = Math.round(axisValue * this.mHorizontalScrollFactor);
            if ((double)Math.abs(axisValue) > 0.9 && Math.abs(delta) * 6 > this.mMinimumVelocity) {
                int deltaX = MathUtil.clamp(delta * 6, -this.mMaximumVelocity, this.mMaximumVelocity);
                this.fling(-deltaX);
                return true;
            }
            if (this.smoothScrollBy(-delta)) {
                return true;
            }
        }
        return super.onGenericMotionEvent(event);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return true;
    }

    @Override
    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (!this.mScroller.isFinished()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            this.mScrollX = scrollX;
            this.mScrollY = scrollY;
            this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
            if (clampedX) {
                this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0);
            }
        } else {
            super.scrollTo(scrollX, scrollY);
        }
        this.awakenScrollBars();
    }

    private int getScrollRange() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            scrollRange = Math.max(0, child.getWidth() - (this.getWidth() - this.mPaddingLeft - this.mPaddingRight));
        }
        return scrollRange;
    }

    private View findFocusableViewInMyBounds(boolean leftFocus, int left, View preferredFocusable) {
        boolean fadingEdgeLength = false;
        int leftWithoutFadingEdge = left + 0;
        int rightWithoutFadingEdge = left + this.getWidth() - 0;
        if (preferredFocusable != null && preferredFocusable.getLeft() < rightWithoutFadingEdge && preferredFocusable.getRight() > leftWithoutFadingEdge) {
            return preferredFocusable;
        }
        return this.findFocusableViewInBounds(leftFocus, leftWithoutFadingEdge, rightWithoutFadingEdge);
    }

    private View findFocusableViewInBounds(boolean leftFocus, int left, int right) {
        ArrayList<View> focusables = this.getFocusables(2);
        View focusCandidate = null;
        boolean foundFullyContainedFocusable = false;
        for (View view : focusables) {
            boolean viewIsCloserToBoundary;
            boolean viewIsFullyContained;
            int viewLeft = view.getLeft();
            int viewRight = view.getRight();
            if (left >= viewRight || viewLeft >= right) continue;
            boolean bl = viewIsFullyContained = left < viewLeft && viewRight < right;
            if (focusCandidate == null) {
                focusCandidate = view;
                foundFullyContainedFocusable = viewIsFullyContained;
                continue;
            }
            boolean bl2 = viewIsCloserToBoundary = leftFocus && viewLeft < focusCandidate.getLeft() || !leftFocus && viewRight > focusCandidate.getRight();
            if (foundFullyContainedFocusable) {
                if (!viewIsFullyContained || !viewIsCloserToBoundary) continue;
                focusCandidate = view;
                continue;
            }
            if (viewIsFullyContained) {
                focusCandidate = view;
                foundFullyContainedFocusable = true;
                continue;
            }
            if (!viewIsCloserToBoundary) continue;
            focusCandidate = view;
        }
        return focusCandidate;
    }

    public boolean pageScroll(int direction) {
        boolean right = direction == 66;
        int width = this.getWidth();
        if (right) {
            View view;
            this.mTempRect.left = this.getScrollX() + width;
            int count = this.getChildCount();
            if (count > 0 && this.mTempRect.left + width > (view = this.getChildAt(0)).getRight()) {
                this.mTempRect.left = view.getRight() - width;
            }
        } else {
            this.mTempRect.left = this.getScrollX() - width;
            if (this.mTempRect.left < 0) {
                this.mTempRect.left = 0;
            }
        }
        this.mTempRect.right = this.mTempRect.left + width;
        return this.scrollAndFocus(direction, this.mTempRect.left, this.mTempRect.right);
    }

    public boolean fullScroll(int direction) {
        int count;
        boolean right = direction == 66;
        int width = this.getWidth();
        this.mTempRect.left = 0;
        this.mTempRect.right = width;
        if (right && (count = this.getChildCount()) > 0) {
            View view = this.getChildAt(0);
            this.mTempRect.right = view.getRight();
            this.mTempRect.left = this.mTempRect.right - width;
        }
        return this.scrollAndFocus(direction, this.mTempRect.left, this.mTempRect.right);
    }

    private boolean scrollAndFocus(int direction, int left, int right) {
        boolean handled = true;
        int width = this.getWidth();
        int containerLeft = this.getScrollX();
        int containerRight = containerLeft + width;
        boolean goLeft = direction == 17;
        View newFocused = this.findFocusableViewInBounds(goLeft, left, right);
        if (newFocused == null) {
            newFocused = this;
        }
        if (left >= containerLeft && right <= containerRight) {
            handled = false;
        } else {
            int delta = goLeft ? left - containerLeft : right - containerRight;
            this.doScrollX(delta);
        }
        if (newFocused != this.findFocus()) {
            newFocused.requestFocus(direction);
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        View nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, direction);
        int maxJump = (int)((float)this.getWidth() * 0.5f);
        if (nextFocused != null && this.isWithinDeltaOfScreen(nextFocused, maxJump)) {
            nextFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(nextFocused, this.mTempRect);
            scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollX(scrollDelta);
            nextFocused.requestFocus(direction);
        } else {
            int screenRight;
            int daRight;
            scrollDelta = maxJump;
            if (direction == 17 && this.getScrollX() < scrollDelta) {
                scrollDelta = this.getScrollX();
            } else if (direction == 66 && this.getChildCount() > 0 && (daRight = this.getChildAt(0).getRight()) - (screenRight = this.getScrollX() + this.getWidth()) < maxJump) {
                scrollDelta = daRight - screenRight;
            }
            if (scrollDelta == 0) {
                return false;
            }
            this.doScrollX(direction == 66 ? scrollDelta : -scrollDelta);
        }
        if (currentFocused != null && currentFocused.isFocused() && this.isOffScreen(currentFocused)) {
            int descendantFocusability = this.getDescendantFocusability();
            this.setDescendantFocusability(131072);
            this.requestFocus();
            this.setDescendantFocusability(descendantFocusability);
        }
        return true;
    }

    private boolean isOffScreen(View descendant) {
        return !this.isWithinDeltaOfScreen(descendant, 0);
    }

    private boolean isWithinDeltaOfScreen(View descendant, int delta) {
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        return this.mTempRect.right + delta >= this.getScrollX() && this.mTempRect.left - delta <= this.getScrollX() + this.getWidth();
    }

    private void doScrollX(int delta) {
        if (delta != 0) {
            if (this.mSmoothScrollingEnabled) {
                this.smoothScrollBy(delta);
            } else {
                this.scrollBy(delta, 0);
            }
        }
    }

    public final boolean smoothScrollBy(int delta) {
        if (this.getChildCount() == 0) {
            return false;
        }
        int scrollX = this.mScrollX;
        if ((delta = Math.max(0, Math.min(scrollX + delta, this.getScrollRange())) - scrollX) != 0) {
            this.mScroller.startScroll(scrollX, this.mScrollY, delta, 0);
            this.postInvalidateOnAnimation();
            return true;
        }
        return false;
    }

    public final void smoothScrollTo(int x) {
        this.smoothScrollBy(x - this.mScrollX);
    }

    @Override
    protected int computeHorizontalScrollRange() {
        int count = this.getChildCount();
        int contentWidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        if (count == 0) {
            return contentWidth;
        }
        int scrollRange = this.getChildAt(0).getRight();
        int scrollX = this.mScrollX;
        int overscrollRight = Math.max(0, scrollRange - contentWidth);
        if (scrollX < 0) {
            scrollRange -= scrollX;
        } else if (scrollX > overscrollRight) {
            scrollRange += scrollX - overscrollRight;
        }
        return scrollRange;
    }

    @Override
    protected int computeHorizontalScrollOffset() {
        return Math.max(0, super.computeHorizontalScrollOffset());
    }

    @Override
    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int horizontalPadding = this.mPaddingLeft + this.mPaddingRight;
        int childWidthMeasureSpec = MeasureSpec.makeMeasureSpec(Math.max(0, MeasureSpec.getSize(parentWidthMeasureSpec) - horizontalPadding), 0);
        int childHeightMeasureSpec = HorizontalScrollView.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    @Override
    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childHeightMeasureSpec = HorizontalScrollView.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        int usedTotal = this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin + widthUsed;
        int childWidthMeasureSpec = MeasureSpec.makeMeasureSpec(Math.max(0, MeasureSpec.getSize(parentWidthMeasureSpec) - usedTotal), 0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    @Override
    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            int deltaX = this.consumeFlingInStretch(x - oldX);
            if (deltaX != 0 || oldY != y) {
                int range = this.getScrollRange();
                int overscrollMode = this.getOverScrollMode();
                boolean canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                this.overScrollBy(deltaX, y - oldY, oldX, oldY, range, 0, this.mOverflingDistance, 0, false);
                this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
                if (canOverscroll && deltaX != 0) {
                    if (x < 0 && oldX >= 0) {
                        this.mEdgeGlowLeft.onAbsorb((int)this.mScroller.getCurrVelocity());
                    } else if (x > range && oldX <= range) {
                        this.mEdgeGlowRight.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                }
            }
            if (!this.awakenScrollBars()) {
                this.postInvalidateOnAnimation();
            }
        }
    }

    private int consumeFlingInStretch(int unconsumed) {
        if (unconsumed > 0 && this.mEdgeGlowLeft != null && this.mEdgeGlowLeft.getDistance() != 0.0f) {
            float deltaDistance;
            int size = this.getWidth();
            int consumed = Math.round((float)(-size) / 4.0f * this.mEdgeGlowLeft.onPullDistance(deltaDistance = (float)(-unconsumed) * 4.0f / (float)size, 0.5f));
            if (consumed != unconsumed) {
                this.mEdgeGlowLeft.finish();
            }
            return unconsumed - consumed;
        }
        if (unconsumed < 0 && this.mEdgeGlowRight != null && this.mEdgeGlowRight.getDistance() != 0.0f) {
            float deltaDistance;
            int size = this.getWidth();
            int consumed = Math.round((float)size / 4.0f * this.mEdgeGlowRight.onPullDistance(deltaDistance = (float)unconsumed * 4.0f / (float)size, 0.5f));
            if (consumed != unconsumed) {
                this.mEdgeGlowRight.finish();
            }
            return unconsumed - consumed;
        }
        return unconsumed;
    }

    private void scrollToChild(View child) {
        child.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(child, this.mTempRect);
        int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
        if (scrollDelta != 0) {
            this.scrollBy(scrollDelta, 0);
        }
    }

    private boolean scrollToChildRect(Rect rect, boolean immediate) {
        boolean scroll;
        int delta = this.computeScrollDeltaToGetChildRectOnScreen(rect);
        boolean bl = scroll = delta != 0;
        if (scroll) {
            if (immediate) {
                this.scrollBy(delta, 0);
            } else {
                this.smoothScrollBy(delta);
            }
        }
        return scroll;
    }

    protected int computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int width = this.getWidth();
        int screenLeft = this.getScrollX();
        int screenRight = screenLeft + width;
        int scrollXDelta = 0;
        if (rect.right > screenRight && rect.left > screenLeft) {
            scrollXDelta = rect.width() > width ? (scrollXDelta += rect.left - screenLeft) : (scrollXDelta += rect.right - screenRight);
            int right = this.getChildAt(0).getRight();
            int distanceToRight = right - screenRight;
            scrollXDelta = Math.min(scrollXDelta, distanceToRight);
        } else if (rect.left < screenLeft && rect.right < screenRight) {
            scrollXDelta = rect.width() > width ? (scrollXDelta -= screenRight - rect.right) : (scrollXDelta -= screenLeft - rect.left);
            scrollXDelta = Math.max(scrollXDelta, -this.getScrollX());
        }
        return scrollXDelta;
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        if (focused != null && focused.getRevealOnFocusHint()) {
            if (!this.mIsLayoutDirty) {
                this.scrollToChild(focused);
            } else {
                this.mChildToScrollTo = focused;
            }
        }
        super.requestChildFocus(child, focused);
    }

    @Override
    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        View nextFocus;
        if (direction == 2) {
            direction = 66;
        } else if (direction == 1) {
            direction = 17;
        }
        View view = nextFocus = previouslyFocusedRect == null ? FocusFinder.getInstance().findNextFocus(this, null, direction) : FocusFinder.getInstance().findNextFocusFromRect(this, previouslyFocusedRect, direction);
        if (nextFocus == null) {
            return false;
        }
        if (this.isOffScreen(nextFocus)) {
            return false;
        }
        return nextFocus.requestFocus(direction, previouslyFocusedRect);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        rectangle.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        return this.scrollToChildRect(rectangle, immediate);
    }

    @Override
    public void requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    @Override
    protected void onLayout(boolean changed, int l2, int t2, int r, int b) {
        int available;
        int childWidth = 0;
        int childMargins = 0;
        if (this.getChildCount() > 0) {
            childWidth = this.getChildAt(0).getMeasuredWidth();
            FrameLayout.LayoutParams childParams = (FrameLayout.LayoutParams)this.getChildAt(0).getLayoutParams();
            childMargins = childParams.leftMargin + childParams.rightMargin;
        }
        boolean forceLeftGravity = childWidth > (available = r - l2 - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - childMargins);
        this.layoutChildren(l2, t2, r, b, forceLeftGravity);
        this.mIsLayoutDirty = false;
        if (this.mChildToScrollTo != null && HorizontalScrollView.isViewDescendantOf(this.mChildToScrollTo, this)) {
            this.scrollToChild(this.mChildToScrollTo);
        }
        this.mChildToScrollTo = null;
        if (!this.isLaidOut()) {
            int scrollRange = Math.max(0, childWidth - (r - l2 - this.mPaddingLeft - this.mPaddingRight));
            if (this.isLayoutRtl()) {
                this.mScrollX = scrollRange - this.mScrollX;
            }
            if (this.mScrollX > scrollRange) {
                this.mScrollX = scrollRange;
            } else if (this.mScrollX < 0) {
                this.mScrollX = 0;
            }
        }
        this.scrollTo(this.mScrollX, this.mScrollY);
    }

    @Override
    protected void onSizeChanged(int w, int h2, int oldw, int oldh) {
        super.onSizeChanged(w, h2, oldw, oldh);
        View currentFocused = this.findFocus();
        if (null == currentFocused || this == currentFocused) {
            return;
        }
        int maxJump = this.getWidth();
        if (this.isWithinDeltaOfScreen(currentFocused, maxJump)) {
            currentFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(currentFocused, this.mTempRect);
            int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollX(scrollDelta);
        }
    }

    private static boolean isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && HorizontalScrollView.isViewDescendantOf((View)((Object)theParent), parent);
    }

    public void fling(int velocityX) {
        if (this.getChildCount() > 0) {
            int width = this.getWidth() - this.mPaddingRight - this.mPaddingLeft;
            int right = this.getChildAt(0).getRight() - this.mPaddingLeft;
            int maxScroll = Math.max(0, right - width);
            boolean shouldFling = false;
            if (this.mScrollX == 0 && !this.mEdgeGlowLeft.isFinished()) {
                if (this.shouldAbsorb(this.mEdgeGlowLeft, -velocityX)) {
                    this.mEdgeGlowLeft.onAbsorb(-velocityX);
                } else {
                    shouldFling = true;
                }
            } else if (this.mScrollX == maxScroll && !this.mEdgeGlowRight.isFinished()) {
                if (this.shouldAbsorb(this.mEdgeGlowRight, velocityX)) {
                    this.mEdgeGlowRight.onAbsorb(velocityX);
                } else {
                    shouldFling = true;
                }
            } else {
                shouldFling = true;
            }
            if (shouldFling) {
                this.mScroller.fling(this.mScrollX, this.mScrollY, velocityX, 0, 0, maxScroll, 0, 0, width / 2, 0);
                boolean movingRight = velocityX > 0;
                View currentFocused = this.findFocus();
                View newFocused = this.findFocusableViewInMyBounds(movingRight, this.mScroller.getFinalX(), currentFocused);
                if (newFocused == null) {
                    newFocused = this;
                }
                if (newFocused != currentFocused) {
                    newFocused.requestFocus(movingRight ? 66 : 17);
                }
            }
            this.postInvalidateOnAnimation();
        }
    }

    private boolean shouldAbsorb(EdgeEffect edgeEffect, int velocity) {
        if (velocity > 0) {
            return true;
        }
        float distance = edgeEffect.getDistance() * (float)this.getWidth();
        float flingDistance = (float)this.mScroller.getSplineFlingDistance(-velocity);
        return flingDistance < distance;
    }

    @Override
    public void scrollTo(int x, int y) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            x = HorizontalScrollView.clamp(x, this.getWidth() - this.mPaddingRight - this.mPaddingLeft, child.getWidth());
            y = HorizontalScrollView.clamp(y, this.getHeight() - this.mPaddingBottom - this.mPaddingTop, child.getHeight());
            if (x != this.mScrollX || y != this.mScrollY) {
                super.scrollTo(x, y);
            }
        }
    }

    private boolean shouldDisplayEdgeEffects() {
        return this.getOverScrollMode() != 2;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.shouldDisplayEdgeEffects()) {
            int restoreCount;
            int scrollX = this.mScrollX;
            if (!this.mEdgeGlowLeft.isFinished()) {
                restoreCount = canvas.save();
                int height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                canvas.rotate(270.0f);
                canvas.translate(-height + this.mPaddingTop, Math.min(0, scrollX));
                this.mEdgeGlowLeft.setSize(height, this.getWidth());
                if (this.mEdgeGlowLeft.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowRight.isFinished()) {
                restoreCount = canvas.save();
                int width = this.getWidth();
                int height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                canvas.rotate(90.0f);
                canvas.translate(-this.mPaddingTop, -(Math.max(this.getScrollRange(), scrollX) + width));
                this.mEdgeGlowRight.setSize(height, width);
                if (this.mEdgeGlowRight.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    private static int clamp(int n2, int my, int child) {
        if (my >= child || n2 < 0) {
            return 0;
        }
        if (my + n2 > child) {
            return child - my;
        }
        return n2;
    }
}

