/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.transition.Transition;
import yslelf.cloudpick.graphics.util.AttributeSet;
import yslelf.cloudpick.graphics.view.KeyEvent;
import yslelf.cloudpick.graphics.view.MenuItem;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.view.menu.ListMenuItemView;
import yslelf.cloudpick.graphics.view.menu.MenuAdapter;
import yslelf.cloudpick.graphics.view.menu.MenuBuilder;
import yslelf.cloudpick.graphics.view.menu.MenuItemImpl;
import yslelf.cloudpick.graphics.widget.DropDownListView;
import yslelf.cloudpick.graphics.widget.HeaderViewListAdapter;
import yslelf.cloudpick.graphics.widget.ListAdapter;
import yslelf.cloudpick.graphics.widget.ListPopupWindow;
import yslelf.cloudpick.graphics.widget.MenuItemHoverListener;

@ApiStatus.Internal
public class MenuPopupWindow
extends ListPopupWindow
implements MenuItemHoverListener {
    private MenuItemHoverListener mHoverListener;

    public MenuPopupWindow(@NonNull Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr, @Nullable ResourceId defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    @Nonnull
    DropDownListView createDropDownListView(Context context, boolean hijackFocus) {
        MenuDropDownListView view = new MenuDropDownListView(context, hijackFocus);
        view.setHoverListener(this);
        view.setPadding(0, view.dp(2.0f), 0, view.dp(2.0f));
        return view;
    }

    public void setEnterTransition(Transition enterTransition) {
        this.mPopup.setEnterTransition(enterTransition);
    }

    public void setExitTransition(Transition exitTransition) {
        this.mPopup.setExitTransition(exitTransition);
    }

    public void setHoverListener(MenuItemHoverListener hoverListener) {
        this.mHoverListener = hoverListener;
    }

    public void setTouchModal(boolean touchModal) {
        this.mPopup.setTouchModal(touchModal);
    }

    @Override
    public void onItemHoverEnter(@Nonnull MenuBuilder menu, @Nonnull MenuItem item) {
        if (this.mHoverListener != null) {
            this.mHoverListener.onItemHoverEnter(menu, item);
        }
    }

    @Override
    public void onItemHoverExit(@Nonnull MenuBuilder menu, @Nonnull MenuItem item) {
        if (this.mHoverListener != null) {
            this.mHoverListener.onItemHoverExit(menu, item);
        }
    }

    public static class MenuDropDownListView
    extends DropDownListView {
        final int mAdvanceKey;
        final int mRetreatKey;
        private MenuItemHoverListener mHoverListener;
        private MenuItem mHoveredMenuItem;

        public MenuDropDownListView(Context context, boolean hijackFocus) {
            super(context, hijackFocus);
            this.mAdvanceKey = 262;
            this.mRetreatKey = 263;
        }

        public void setHoverListener(MenuItemHoverListener hoverListener) {
            this.mHoverListener = hoverListener;
        }

        public void clearSelection() {
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
        }

        @Override
        public boolean onKeyDown(int keyCode, @Nonnull KeyEvent event) {
            ListMenuItemView selectedItem = (ListMenuItemView)this.getSelectedView();
            if (selectedItem != null && keyCode == this.mAdvanceKey) {
                if (selectedItem.isEnabled() && selectedItem.getItemData().hasSubMenu()) {
                    this.performItemClick(selectedItem, this.getSelectedItemPosition(), this.getSelectedItemId());
                }
                return true;
            }
            if (selectedItem != null && keyCode == this.mRetreatKey) {
                this.setSelectedPositionInt(-1);
                this.setNextSelectedPositionInt(-1);
                ((MenuAdapter)this.getAdapter()).getAdapterMenu().close(false);
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }

        @Override
        public boolean onHoverEvent(@Nonnull MotionEvent ev) {
            if (this.mHoverListener != null) {
                MenuItem oldMenuItem;
                int itemPosition;
                int position;
                MenuAdapter menuAdapter;
                int headersCount;
                ListAdapter adapter = this.getAdapter();
                if (adapter instanceof HeaderViewListAdapter) {
                    HeaderViewListAdapter headerAdapter = (HeaderViewListAdapter)adapter;
                    headersCount = headerAdapter.getHeadersCount();
                    menuAdapter = (MenuAdapter)headerAdapter.getWrappedAdapter();
                } else {
                    headersCount = 0;
                    menuAdapter = (MenuAdapter)adapter;
                }
                MenuItemImpl menuItem = null;
                if (ev.getAction() != 10 && (position = this.pointToPosition((int)ev.getX(), (int)ev.getY())) != -1 && (itemPosition = position - headersCount) >= 0 && itemPosition < menuAdapter.getCount()) {
                    menuItem = menuAdapter.getItem(itemPosition);
                }
                if ((oldMenuItem = this.mHoveredMenuItem) != menuItem) {
                    MenuBuilder menu = menuAdapter.getAdapterMenu();
                    if (oldMenuItem != null) {
                        this.mHoverListener.onItemHoverExit(menu, oldMenuItem);
                    }
                    this.mHoveredMenuItem = menuItem;
                    if (menuItem != null) {
                        this.mHoverListener.onItemHoverEnter(menu, menuItem);
                    }
                }
            }
            return super.onHoverEvent(ev);
        }
    }
}

