/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import java.lang.ref.WeakReference;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.StateListDrawable;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.resources.TypedArray;
import yslelf.cloudpick.graphics.transition.Transition;
import yslelf.cloudpick.graphics.transition.TransitionListener;
import yslelf.cloudpick.graphics.transition.TransitionManager;
import yslelf.cloudpick.graphics.util.AttributeSet;
import yslelf.cloudpick.graphics.view.Gravity;
import yslelf.cloudpick.graphics.view.KeyEvent;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.view.ViewParent;
import yslelf.cloudpick.graphics.view.ViewTreeObserver;
import yslelf.cloudpick.graphics.view.WindowManager;
import yslelf.cloudpick.graphics.widget.FrameLayout;

public class PopupWindow {
    private static final int DEFAULT_ANCHORED_GRAVITY = 0x800033;
    private final int[] mTmpDrawingLocation = new int[2];
    private final int[] mTmpScreenLocation = new int[2];
    private final int[] mTmpAppLocation = new int[2];
    private final Rect mTempRect = new Rect();
    private Context mContext;
    private WindowManager mWindowManager;
    boolean mIsShowing;
    boolean mIsTransitioningToDismiss;
    boolean mIsDropdown;
    private DecorView mDecorView;
    private View mBackgroundView;
    private View mContentView;
    private boolean mFocusable;
    private boolean mTouchable = true;
    private boolean mOutsideTouchable = false;
    private boolean mClippingEnabled = true;
    private boolean mClipToScreen;
    private boolean mNotTouchModal;
    private View.OnTouchListener mTouchInterceptor;
    private int mWidth = -2;
    private int mHeight = -2;
    private float mElevation;
    private Drawable mBackground;
    private Drawable mAboveAnchorBackgroundDrawable;
    private Drawable mBelowAnchorBackgroundDrawable;
    private Transition mEnterTransition;
    private Transition mExitTransition;
    private Rect mEpicenterBounds;
    private boolean mAboveAnchor;
    private int mWindowLayoutType = 1000;
    private OnDismissListener mOnDismissListener;
    private int mGravity = 0;
    private static final int[] ABOVE_ANCHOR_STATE_SET = new int[]{0x10100AA};
    private final View.OnAttachStateChangeListener mOnAnchorDetachedListener = new View.OnAttachStateChangeListener(){

        @Override
        public void onViewAttachedToWindow(View v) {
            PopupWindow.this.alignToAnchor();
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
        }
    };
    private final View.OnAttachStateChangeListener mOnAnchorRootDetachedListener = new View.OnAttachStateChangeListener(){

        @Override
        public void onViewAttachedToWindow(View v) {
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
            PopupWindow.this.mIsAnchorRootAttached = false;
        }
    };
    private WeakReference<View> mAnchor;
    private WeakReference<View> mAnchorRoot;
    private boolean mIsAnchorRootAttached;
    private final ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener;
    private final View.OnLayoutChangeListener mOnLayoutChangeListener;
    private int mAnchorXOff;
    private int mAnchorYOff;
    private int mAnchoredGravity;
    private boolean mOverlapAnchor;
    private boolean mPopupViewInitialLayoutDirectionInherited;
    private static final String[] STYLEABLE = new String[]{"modernui", "overlapAnchor", "modernui", "popupBackground", "modernui", "popupElevation", "modernui", "popupEnterTransition", "modernui", "popupExitTransition"};

    public PopupWindow(Context context) {
        this(context, null);
    }

    public PopupWindow(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, null);
    }

    public PopupWindow(Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr) {
        this(context, attrs, defStyleAttr, null);
    }

    public PopupWindow(Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr, @Nullable ResourceId defStyleRes) {
        this.mOnScrollChangedListener = () -> {};
        this.mOnLayoutChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {};
        this.mContext = context;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, defStyleAttr, defStyleRes, STYLEABLE);
        Drawable bg = a.getDrawable(1);
        this.mElevation = a.getDimension(2, 0.0f);
        this.mOverlapAnchor = a.getBoolean(0, false);
        a.recycle();
        this.setBackgroundDrawable(bg);
    }

    public PopupWindow() {
        this(null, 0, 0);
    }

    public PopupWindow(View contentView) {
        this(contentView, 0, 0);
    }

    public PopupWindow(int width, int height) {
        this(null, width, height);
    }

    public PopupWindow(View contentView, int width, int height) {
        this(contentView, width, height, false);
    }

    public PopupWindow(View contentView, int width, int height, boolean focusable) {
        this.mOnScrollChangedListener = () -> {};
        this.mOnLayoutChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {};
        if (contentView != null) {
            this.mContext = contentView.getContext();
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
        this.setContentView(contentView);
        this.setWidth(width);
        this.setHeight(height);
        this.setFocusable(focusable);
    }

    public void setEnterTransition(@Nullable Transition enterTransition) {
        this.mEnterTransition = enterTransition;
    }

    @Nullable
    public Transition getEnterTransition() {
        return this.mEnterTransition;
    }

    public void setExitTransition(@Nullable Transition exitTransition) {
        this.mExitTransition = exitTransition;
    }

    @Nullable
    public Transition getExitTransition() {
        return this.mExitTransition;
    }

    @Nullable
    public Rect getEpicenterBounds() {
        return this.mEpicenterBounds != null ? this.mEpicenterBounds.copy() : null;
    }

    public void setEpicenterBounds(@Nullable Rect bounds) {
        this.mEpicenterBounds = bounds != null ? bounds.copy() : null;
    }

    @Nullable
    public Drawable getBackground() {
        return this.mBackground;
    }

    public void setBackgroundDrawable(@Nullable Drawable background) {
        this.mBackground = background;
        Drawable drawable = this.mBackground;
        if (drawable instanceof StateListDrawable) {
            StateListDrawable stateList = (StateListDrawable)drawable;
            int aboveAnchorStateIndex = stateList.findStateDrawableIndex(ABOVE_ANCHOR_STATE_SET);
            int count = stateList.getStateCount();
            int belowAnchorStateIndex = -1;
            for (int i = 0; i < count; ++i) {
                if (i == aboveAnchorStateIndex) continue;
                belowAnchorStateIndex = i;
                break;
            }
            if (aboveAnchorStateIndex != -1 && belowAnchorStateIndex != -1) {
                this.mAboveAnchorBackgroundDrawable = stateList.getStateDrawable(aboveAnchorStateIndex);
                this.mBelowAnchorBackgroundDrawable = stateList.getStateDrawable(belowAnchorStateIndex);
            } else {
                this.mBelowAnchorBackgroundDrawable = null;
                this.mAboveAnchorBackgroundDrawable = null;
            }
        }
    }

    public float getElevation() {
        return this.mElevation;
    }

    public void setElevation(float elevation) {
        this.mElevation = elevation;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setContentView(View contentView) {
        if (this.mIsShowing) {
            return;
        }
        this.mContentView = contentView;
        if (this.mContext == null && this.mContentView != null) {
            this.mContext = this.mContentView.getContext();
        }
        if (this.mWindowManager == null && this.mContentView != null) {
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
    }

    public void setTouchInterceptor(@Nullable View.OnTouchListener l2) {
        this.mTouchInterceptor = l2;
    }

    public boolean isFocusable() {
        return this.mFocusable;
    }

    public void setFocusable(boolean focusable) {
        this.mFocusable = focusable;
    }

    public boolean isTouchable() {
        return this.mTouchable;
    }

    public void setTouchable(boolean touchable) {
        this.mTouchable = touchable;
    }

    public boolean isOutsideTouchable() {
        return this.mOutsideTouchable;
    }

    public void setOutsideTouchable(boolean touchable) {
        this.mOutsideTouchable = touchable;
    }

    public boolean isClippingEnabled() {
        return this.mClippingEnabled;
    }

    public void setClippingEnabled(boolean enabled) {
        this.mClippingEnabled = enabled;
    }

    public boolean isClippedToScreen() {
        return this.mClipToScreen;
    }

    public void setIsClippedToScreen(boolean enabled) {
        this.mClipToScreen = enabled;
    }

    public void setWindowLayoutType(int layoutType) {
        this.mWindowLayoutType = layoutType;
    }

    public int getWindowLayoutType() {
        return this.mWindowLayoutType;
    }

    public boolean isTouchModal() {
        return !this.mNotTouchModal;
    }

    public void setTouchModal(boolean touchModal) {
        this.mNotTouchModal = !touchModal;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public void setOverlapAnchor(boolean overlapAnchor) {
        this.mOverlapAnchor = overlapAnchor;
    }

    public boolean getOverlapAnchor() {
        return this.mOverlapAnchor;
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public void showAtLocation(@NonNull View parent, int gravity, int x, int y) {
        if (this.mIsShowing || this.mContentView == null) {
            return;
        }
        TransitionManager.endTransitions(this.mDecorView);
        this.detachFromAnchor();
        this.mIsShowing = true;
        this.mIsDropdown = false;
        this.mGravity = gravity;
        WindowManager.LayoutParams p2 = this.createPopupLayoutParams();
        p2.gravity = gravity;
        p2.x = x;
        p2.y = y;
        this.preparePopup();
        this.invokePopup(p2);
    }

    public final void showAsDropDown(@NonNull View anchor) {
        this.showAsDropDown(anchor, 0, 0, 0x800033);
    }

    public final void showAsDropDown(@NonNull View anchor, int xOff, int yOff) {
        this.showAsDropDown(anchor, xOff, yOff, 0x800033);
    }

    public void showAsDropDown(@NonNull View anchor, int xOff, int yOff, int gravity) {
        if (this.mIsShowing || this.mContentView == null) {
            return;
        }
        TransitionManager.endTransitions(this.mDecorView);
        this.attachToAnchor(anchor, xOff, yOff, gravity);
        this.mIsShowing = true;
        this.mIsDropdown = true;
        WindowManager.LayoutParams p2 = this.createPopupLayoutParams();
        this.preparePopup();
        boolean aboveAnchor = this.findDropDownPosition(anchor, p2, xOff, yOff, p2.width, p2.height, gravity, true);
        this.updateAboveAnchor(aboveAnchor);
        this.invokePopup(p2);
    }

    final void updateAboveAnchor(boolean aboveAnchor) {
        if (aboveAnchor != this.mAboveAnchor) {
            this.mAboveAnchor = aboveAnchor;
            if (this.mBackground != null && this.mBackgroundView != null) {
                if (this.mAboveAnchorBackgroundDrawable != null) {
                    if (this.mAboveAnchor) {
                        this.mBackgroundView.setBackground(this.mAboveAnchorBackgroundDrawable);
                    } else {
                        this.mBackgroundView.setBackground(this.mBelowAnchorBackgroundDrawable);
                    }
                } else {
                    this.mBackgroundView.refreshDrawableState();
                }
            }
        }
    }

    public boolean isAboveAnchor() {
        return this.mAboveAnchor;
    }

    private void preparePopup() {
        if (this.mDecorView != null) {
            this.mDecorView.cancelTransitions();
        }
        if (this.mBackground != null) {
            this.mBackgroundView = this.createBackgroundView(this.mContentView);
            this.mBackgroundView.setBackground(this.mBackground);
        } else {
            this.mBackgroundView = this.mContentView;
        }
        this.mDecorView = this.createDecorView(this.mBackgroundView);
        this.mDecorView.setIsRootNamespace(true);
        this.mBackgroundView.setElevation(this.mElevation);
        this.mDecorView.setFocusable(this.mFocusable);
        this.mPopupViewInitialLayoutDirectionInherited = this.mContentView.getRawLayoutDirection() == 2;
    }

    @NonNull
    private BackgroundView createBackgroundView(@NonNull View contentView) {
        ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
        int height = layoutParams != null && layoutParams.height == -2 ? -2 : -1;
        BackgroundView backgroundView = new BackgroundView(this.mContext);
        backgroundView.addView(contentView, -1, height);
        return backgroundView;
    }

    @NonNull
    private DecorView createDecorView(View contentView) {
        ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
        int height = layoutParams != null && layoutParams.height == -2 ? -2 : -1;
        DecorView decorView = new DecorView(this.mContext);
        decorView.addView(contentView, -1, height);
        decorView.setClipChildren(false);
        decorView.setClipToPadding(false);
        return decorView;
    }

    private void invokePopup(@NonNull WindowManager.LayoutParams p2) {
        DecorView decorView = this.mDecorView;
        this.setLayoutDirectionFromAnchor();
        this.mWindowManager.addView(decorView, p2);
        if (this.mEnterTransition != null) {
            decorView.requestEnterTransition(this.mEnterTransition);
        }
    }

    private void setLayoutDirectionFromAnchor() {
        View anchor;
        if (this.mAnchor != null && (anchor = (View)this.mAnchor.get()) != null && this.mPopupViewInitialLayoutDirectionInherited) {
            this.mDecorView.setLayoutDirection(anchor.getLayoutDirection());
        }
    }

    private int computeGravity() {
        int gravity;
        int n2 = gravity = this.mGravity == 0 ? 0x800033 : this.mGravity;
        if (this.mIsDropdown && (this.mClipToScreen || this.mClippingEnabled)) {
            gravity |= 0x10000000;
        }
        return gravity;
    }

    @NonNull
    final WindowManager.LayoutParams createPopupLayoutParams() {
        WindowManager.LayoutParams p2 = new WindowManager.LayoutParams();
        p2.gravity = this.computeGravity();
        p2.flags = this.computeFlags(p2.flags);
        p2.type = this.mWindowLayoutType;
        p2.height = this.mHeight;
        p2.width = this.mWidth;
        return p2;
    }

    private int computeFlags(int curFlags) {
        curFlags &= 0xFFFFFFF7;
        if (!this.mFocusable) {
            curFlags |= 8;
        }
        if (this.mNotTouchModal) {
            curFlags |= 0x20;
        }
        return curFlags;
    }

    boolean findDropDownPosition(@NonNull View anchor, WindowManager.LayoutParams outParams, int xOffset, int yOffset, int width, int height, int gravity, boolean allowScroll) {
        int anchorHeight = anchor.getHeight();
        int anchorWidth = anchor.getWidth();
        if (this.mOverlapAnchor) {
            yOffset -= anchorHeight;
        }
        int[] appScreenLocation = this.mTmpAppLocation;
        View appRootView = anchor.getRootView();
        appRootView.getLocationInWindow(appScreenLocation);
        int[] screenLocation = this.mTmpScreenLocation;
        anchor.getLocationInWindow(screenLocation);
        int[] drawingLocation = this.mTmpDrawingLocation;
        drawingLocation[0] = screenLocation[0] - appScreenLocation[0];
        drawingLocation[1] = screenLocation[1] - appScreenLocation[1];
        outParams.x = drawingLocation[0] + xOffset;
        outParams.y = drawingLocation[1] + anchorHeight + yOffset;
        outParams.gravity = this.computeGravity();
        outParams.width = width;
        outParams.height = height;
        int hGrav = Gravity.getAbsoluteGravity(gravity, anchor.getLayoutDirection()) & 7;
        if (hGrav == 5) {
            outParams.x -= width - anchorWidth;
        }
        boolean fitsVertical = this.tryFitVertical(outParams, yOffset, height, anchorHeight, drawingLocation[1], screenLocation[1], appScreenLocation[1], appScreenLocation[1] + appRootView.getHeight(), false);
        boolean fitsHorizontal = this.tryFitHorizontal(outParams, width, drawingLocation[0], screenLocation[0], appScreenLocation[0], appScreenLocation[0] + appRootView.getWidth(), false);
        if (!fitsVertical || !fitsHorizontal) {
            int scrollX = anchor.getScrollX();
            int scrollY = anchor.getScrollY();
            Rect r = new Rect(scrollX, scrollY, scrollX + width + xOffset, scrollY + height + anchorHeight + yOffset);
            if (allowScroll && anchor.requestRectangleOnScreen(r, true)) {
                anchor.getLocationInWindow(screenLocation);
                drawingLocation[0] = screenLocation[0] - appScreenLocation[0];
                drawingLocation[1] = screenLocation[1] - appScreenLocation[1];
                outParams.x = drawingLocation[0] + xOffset;
                outParams.y = drawingLocation[1] + anchorHeight + yOffset;
                if (hGrav == 5) {
                    outParams.x -= width - anchorWidth;
                }
            }
            this.tryFitVertical(outParams, yOffset, height, anchorHeight, drawingLocation[1], screenLocation[1], appScreenLocation[1], appScreenLocation[1] + appRootView.getHeight(), this.mClipToScreen);
            this.tryFitHorizontal(outParams, width, drawingLocation[0], screenLocation[0], appScreenLocation[0], appScreenLocation[0] + appRootView.getWidth(), this.mClipToScreen);
        }
        return outParams.y < drawingLocation[1];
    }

    private boolean tryFitVertical(@NonNull WindowManager.LayoutParams outParams, int yOffset, int height, int anchorHeight, int drawingLocationY, int screenLocationY, int displayFrameTop, int displayFrameBottom, boolean allowResize) {
        int winOffsetY = screenLocationY - drawingLocationY;
        int anchorTopInScreen = outParams.y + winOffsetY;
        int spaceBelow = displayFrameBottom - anchorTopInScreen;
        if (anchorTopInScreen >= displayFrameTop && height <= spaceBelow) {
            return true;
        }
        int spaceAbove = anchorTopInScreen - anchorHeight - displayFrameTop;
        if (height <= spaceAbove) {
            if (this.mOverlapAnchor) {
                yOffset += anchorHeight;
            }
            outParams.y = drawingLocationY - height + yOffset;
            return true;
        }
        return this.positionInDisplayVertical(outParams, height, drawingLocationY, screenLocationY, displayFrameTop, displayFrameBottom, allowResize);
    }

    private boolean positionInDisplayVertical(@NonNull WindowManager.LayoutParams outParams, int height, int drawingLocationY, int screenLocationY, int displayFrameTop, int displayFrameBottom, boolean canResize) {
        boolean fitsInDisplay = true;
        int winOffsetY = screenLocationY - drawingLocationY;
        outParams.y += winOffsetY;
        outParams.height = height;
        int bottom = outParams.y + height;
        if (bottom > displayFrameBottom) {
            outParams.y -= bottom - displayFrameBottom;
        }
        if (outParams.y < displayFrameTop) {
            outParams.y = displayFrameTop;
            int displayFrameHeight = displayFrameBottom - displayFrameTop;
            if (canResize && height > displayFrameHeight) {
                outParams.height = displayFrameHeight;
            } else {
                fitsInDisplay = false;
            }
        }
        outParams.y -= winOffsetY;
        return fitsInDisplay;
    }

    private boolean tryFitHorizontal(@NonNull WindowManager.LayoutParams outParams, int width, int drawingLocationX, int screenLocationX, int displayFrameLeft, int displayFrameRight, boolean allowResize) {
        int winOffsetX = screenLocationX - drawingLocationX;
        int anchorLeftInScreen = outParams.x + winOffsetX;
        int spaceRight = displayFrameRight - anchorLeftInScreen;
        if (anchorLeftInScreen >= displayFrameLeft && width <= spaceRight) {
            return true;
        }
        return this.positionInDisplayHorizontal(outParams, width, drawingLocationX, screenLocationX, displayFrameLeft, displayFrameRight, allowResize);
    }

    private boolean positionInDisplayHorizontal(@NonNull WindowManager.LayoutParams outParams, int width, int drawingLocationX, int screenLocationX, int displayFrameLeft, int displayFrameRight, boolean canResize) {
        boolean fitsInDisplay = true;
        int winOffsetX = screenLocationX - drawingLocationX;
        outParams.x += winOffsetX;
        int right = outParams.x + width;
        if (right > displayFrameRight) {
            outParams.x -= right - displayFrameRight;
        }
        if (outParams.x < displayFrameLeft) {
            outParams.x = displayFrameLeft;
            int displayFrameWidth = displayFrameRight - displayFrameLeft;
            if (canResize && width > displayFrameWidth) {
                outParams.width = displayFrameWidth;
            } else {
                fitsInDisplay = false;
            }
        }
        outParams.x -= winOffsetX;
        return fitsInDisplay;
    }

    public int getMaxAvailableHeight(@NonNull View anchor) {
        return this.getMaxAvailableHeight(anchor, 0);
    }

    public int getMaxAvailableHeight(@NonNull View anchor, int yOffset) {
        View appView = anchor.getRootView();
        int[] anchorPos = this.mTmpDrawingLocation;
        anchor.getLocationInWindow(anchorPos);
        int bottomEdge = appView.getBottom();
        int distanceToBottom = this.mOverlapAnchor ? bottomEdge - anchorPos[1] - yOffset : bottomEdge - (anchorPos[1] + anchor.getHeight()) - yOffset;
        int distanceToTop = anchorPos[1] - appView.getTop() + yOffset;
        int returnedHeight = Math.max(distanceToBottom, distanceToTop);
        if (this.mBackground != null) {
            this.mBackground.getPadding(this.mTempRect);
            returnedHeight -= this.mTempRect.top + this.mTempRect.bottom;
        }
        return returnedHeight;
    }

    public void dismiss() {
        if (!this.mIsShowing || this.mIsTransitioningToDismiss) {
            return;
        }
        final DecorView decorView = this.mDecorView;
        final View contentView = this.mContentView;
        ViewParent contentParent = contentView.getParent();
        final ViewGroup contentHolder = contentParent instanceof ViewGroup ? (ViewGroup)contentParent : null;
        decorView.cancelTransitions();
        this.mIsShowing = false;
        this.mIsTransitioningToDismiss = true;
        Transition exitTransition = this.mExitTransition;
        if (exitTransition != null && decorView.isLaidOut() && (this.mIsAnchorRootAttached || this.mAnchorRoot == null)) {
            decorView.setFocusable(false);
            View anchorRoot = this.mAnchorRoot != null ? (View)this.mAnchorRoot.get() : null;
            Rect epicenter = this.getTransitionEpicenter();
            decorView.startExitTransition(exitTransition, anchorRoot, epicenter, new TransitionListener(){

                @Override
                public void onTransitionEnd(@NonNull Transition transition) {
                    PopupWindow.this.dismissImmediate(decorView, contentHolder, contentView);
                }
            });
        } else {
            this.dismissImmediate(decorView, contentHolder, contentView);
        }
        this.detachFromAnchor();
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
    }

    @Nullable
    protected final Rect getTransitionEpicenter() {
        View anchor = this.mAnchor != null ? (View)this.mAnchor.get() : null;
        DecorView decor = this.mDecorView;
        if (anchor == null || decor == null) {
            return null;
        }
        int[] anchorLocation = this.mTmpScreenLocation;
        anchor.getLocationInWindow(anchorLocation);
        int[] popupLocation = this.mTmpAppLocation;
        this.mDecorView.getLocationInWindow(popupLocation);
        Rect bounds = new Rect(0, 0, anchor.getWidth(), anchor.getHeight());
        bounds.offset(anchorLocation[0] - popupLocation[0], anchorLocation[1] - popupLocation[1]);
        if (this.mEpicenterBounds != null) {
            int offsetX = bounds.left;
            int offsetY = bounds.top;
            bounds.set(this.mEpicenterBounds);
            bounds.offset(offsetX, offsetY);
        }
        return null;
    }

    private void dismissImmediate(@NonNull View decorView, @Nullable ViewGroup contentHolder, View contentView) {
        if (decorView.getParent() != null) {
            this.mWindowManager.removeView(decorView);
        }
        if (contentHolder != null) {
            contentHolder.removeView(contentView);
        }
        this.mDecorView = null;
        this.mBackgroundView = null;
        this.mIsTransitioningToDismiss = false;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    protected final OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public void update() {
        int newGravity;
        if (!this.mIsShowing || this.mContentView == null) {
            return;
        }
        WindowManager.LayoutParams p2 = this.getDecorViewLayoutParams();
        boolean update = false;
        int newFlags = this.computeFlags(p2.flags);
        if (newFlags != p2.flags) {
            p2.flags = newFlags;
            update = true;
        }
        if ((newGravity = this.computeGravity()) != p2.gravity) {
            p2.gravity = newGravity;
            update = true;
        }
        if (update) {
            this.update(this.mAnchor != null ? (View)this.mAnchor.get() : null, p2);
        }
    }

    protected void update(View anchor, ViewGroup.LayoutParams params) {
        this.setLayoutDirectionFromAnchor();
        this.mWindowManager.updateViewLayout(this.mDecorView, params);
    }

    public void update(int width, int height) {
        WindowManager.LayoutParams p2 = this.getDecorViewLayoutParams();
        this.update(p2.x, p2.y, width, height, false);
    }

    public void update(int x, int y, int width, int height) {
        this.update(x, y, width, height, false);
    }

    public void update(int x, int y, int width, int height, boolean force) {
        int newGravity;
        int newFlags;
        if (width >= 0) {
            this.setWidth(width);
        }
        if (height >= 0) {
            this.setHeight(height);
        }
        if (!this.mIsShowing || this.mContentView == null) {
            return;
        }
        WindowManager.LayoutParams p2 = this.getDecorViewLayoutParams();
        boolean update = force;
        if (width != -1 && p2.width != this.mWidth) {
            p2.width = this.mWidth;
            update = true;
        }
        if (height != -1 && p2.height != this.mHeight) {
            p2.height = this.mHeight;
            update = true;
        }
        if (p2.x != x) {
            p2.x = x;
            update = true;
        }
        if (p2.y != y) {
            p2.y = y;
            update = true;
        }
        if ((newFlags = this.computeFlags(p2.flags)) != p2.flags) {
            p2.flags = newFlags;
            update = true;
        }
        if ((newGravity = this.computeGravity()) != p2.gravity) {
            p2.gravity = newGravity;
            update = true;
        }
        View anchor = null;
        if (this.mAnchor != null && this.mAnchor.get() != null) {
            anchor = (View)this.mAnchor.get();
        }
        if (update) {
            this.update(anchor, p2);
        }
    }

    protected boolean hasContentView() {
        return this.mContentView != null;
    }

    protected boolean hasDecorView() {
        return this.mDecorView != null;
    }

    protected WindowManager.LayoutParams getDecorViewLayoutParams() {
        return (WindowManager.LayoutParams)this.mDecorView.getLayoutParams();
    }

    public void update(View anchor, int width, int height) {
        this.update(anchor, false, 0, 0, width, height);
    }

    public void update(View anchor, int xoff, int yoff, int width, int height) {
        this.update(anchor, true, xoff, yoff, width, height);
    }

    private void update(View anchor, boolean updateLocation, int xoff, int yoff, int width, int height) {
        boolean needsUpdate;
        if (!this.isShowing() || !this.hasContentView()) {
            return;
        }
        WeakReference<View> oldAnchor = this.mAnchor;
        int gravity = this.mAnchoredGravity;
        boolean bl = needsUpdate = updateLocation && (this.mAnchorXOff != xoff || this.mAnchorYOff != yoff);
        if (oldAnchor == null || oldAnchor.get() != anchor || needsUpdate && !this.mIsDropdown) {
            this.attachToAnchor(anchor, xoff, yoff, gravity);
        } else if (needsUpdate) {
            this.mAnchorXOff = xoff;
            this.mAnchorYOff = yoff;
        }
        WindowManager.LayoutParams p2 = this.getDecorViewLayoutParams();
        int oldGravity = p2.gravity;
        int oldWidth = p2.width;
        int oldHeight = p2.height;
        int oldX = p2.x;
        int oldY = p2.y;
        if (width < 0) {
            width = this.mWidth;
        }
        if (height < 0) {
            height = this.mHeight;
        }
        boolean aboveAnchor = this.findDropDownPosition(anchor, p2, this.mAnchorXOff, this.mAnchorYOff, width, height, gravity, true);
        this.updateAboveAnchor(aboveAnchor);
        boolean paramsChanged = oldGravity != p2.gravity || oldX != p2.x || oldY != p2.y || oldWidth != p2.width || oldHeight != p2.height;
        int newWidth = width < 0 ? width : p2.width;
        int newHeight = height < 0 ? height : p2.height;
        this.update(p2.x, p2.y, newWidth, newHeight, paramsChanged);
    }

    void detachFromAnchor() {
        View anchorRoot;
        View anchor = this.getAnchor();
        if (anchor != null) {
            ViewTreeObserver treeObserver = anchor.getViewTreeObserver();
            treeObserver.removeOnScrollChangedListener(this.mOnScrollChangedListener);
            anchor.removeOnAttachStateChangeListener(this.mOnAnchorDetachedListener);
        }
        View view = anchorRoot = this.mAnchorRoot != null ? (View)this.mAnchorRoot.get() : null;
        if (anchorRoot != null) {
            anchorRoot.removeOnAttachStateChangeListener(this.mOnAnchorRootDetachedListener);
            anchorRoot.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
        }
        this.mAnchor = null;
        this.mAnchorRoot = null;
        this.mIsAnchorRootAttached = false;
    }

    void attachToAnchor(@NonNull View anchor, int xOff, int yOff, int gravity) {
        this.detachFromAnchor();
        ViewTreeObserver treeObserver = anchor.getViewTreeObserver();
        treeObserver.addOnScrollChangedListener(this.mOnScrollChangedListener);
        anchor.addOnAttachStateChangeListener(this.mOnAnchorDetachedListener);
        View anchorRoot = anchor.getRootView();
        anchorRoot.addOnAttachStateChangeListener(this.mOnAnchorRootDetachedListener);
        anchorRoot.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        this.mAnchor = new WeakReference<View>(anchor);
        this.mAnchorRoot = new WeakReference<View>(anchorRoot);
        this.mIsAnchorRootAttached = anchorRoot.isAttachedToWindow();
        this.mAnchorXOff = xOff;
        this.mAnchorYOff = yOff;
        this.mAnchoredGravity = gravity;
    }

    @Nullable
    protected View getAnchor() {
        return this.mAnchor != null ? (View)this.mAnchor.get() : null;
    }

    private void alignToAnchor() {
        View anchor;
        View view = anchor = this.mAnchor != null ? (View)this.mAnchor.get() : null;
        if (anchor != null && anchor.isAttachedToWindow() && this.hasDecorView()) {
            WindowManager.LayoutParams p2 = this.getDecorViewLayoutParams();
            this.updateAboveAnchor(this.findDropDownPosition(anchor, p2, this.mAnchorXOff, this.mAnchorYOff, p2.width, p2.height, this.mAnchoredGravity, false));
            this.update(p2.x, p2.y, -1, -1, true);
        }
    }

    private class DecorView
    extends FrameLayout {
        private final View.OnAttachStateChangeListener mOnAnchorRootDetachedListener;
        private Runnable mCleanupAfterExit;

        public DecorView(Context context) {
            super(context);
            this.mOnAnchorRootDetachedListener = new View.OnAttachStateChangeListener(){

                @Override
                public void onViewAttachedToWindow(View v) {
                }

                @Override
                public void onViewDetachedFromWindow(@NonNull View v) {
                    v.removeOnAttachStateChangeListener(this);
                    if (DecorView.this.isAttachedToWindow()) {
                        TransitionManager.endTransitions(DecorView.this);
                    }
                }
            };
        }

        @Override
        public boolean onInterceptTouchEvent(@NonNull MotionEvent ev) {
            if (PopupWindow.this.mTouchInterceptor != null && PopupWindow.this.mTouchInterceptor.onTouch(this, ev)) {
                return true;
            }
            return super.onInterceptTouchEvent(ev);
        }

        @Override
        public boolean onTouchEvent(@NonNull MotionEvent event) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
                PopupWindow.this.dismiss();
                return true;
            }
            if (event.getAction() == 4) {
                PopupWindow.this.dismiss();
                return true;
            }
            return super.onTouchEvent(event);
        }

        @Override
        public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
            if (event.getKeyCode() == 256) {
                KeyEvent.DispatcherState state;
                if (this.getKeyDispatcherState() == null) {
                    return super.dispatchKeyEvent(event);
                }
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                    state2.startTracking(event, this);
                    return true;
                }
                if (event.getAction() == 1 && (state = this.getKeyDispatcherState()).isTracking(event) && !event.isCanceled()) {
                    PopupWindow.this.dismiss();
                    return true;
                }
            }
            return super.dispatchKeyEvent(event);
        }

        public void requestEnterTransition(@Nullable Transition transition) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            if (transition != null) {
                final Transition enterTransition = transition.clone();
                observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    @Override
                    public void onGlobalLayout() {
                        ViewTreeObserver observer = DecorView.this.getViewTreeObserver();
                        observer.removeOnGlobalLayoutListener(this);
                        Rect epicenter = PopupWindow.this.getTransitionEpicenter();
                        enterTransition.setEpicenterCallback(t2 -> epicenter);
                        DecorView.this.startEnterTransition(enterTransition);
                    }
                });
            }
        }

        private void startEnterTransition(@NonNull Transition enterTransition) {
            View child;
            int i;
            int count = this.getChildCount();
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                enterTransition.addTarget(child);
                child.setTransitionVisibility(4);
            }
            TransitionManager.beginDelayedTransition(this, enterTransition);
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                child.setTransitionVisibility(0);
            }
        }

        public void startExitTransition(@NonNull Transition transition, @Nullable View anchorRoot, @Nullable Rect epicenter, @NonNull TransitionListener listener) {
            View child;
            int i;
            if (anchorRoot != null) {
                anchorRoot.addOnAttachStateChangeListener(this.mOnAnchorRootDetachedListener);
            }
            this.mCleanupAfterExit = () -> {
                listener.onTransitionEnd(transition);
                if (anchorRoot != null) {
                    anchorRoot.removeOnAttachStateChangeListener(this.mOnAnchorRootDetachedListener);
                }
                this.mCleanupAfterExit = null;
            };
            Transition exitTransition = transition.clone();
            exitTransition.addListener(new TransitionListener(){

                @Override
                public void onTransitionEnd(@NonNull Transition t2) {
                    t2.removeListener(this);
                    if (DecorView.this.mCleanupAfterExit != null) {
                        DecorView.this.mCleanupAfterExit.run();
                    }
                }
            });
            exitTransition.setEpicenterCallback(t2 -> epicenter);
            int count = this.getChildCount();
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                exitTransition.addTarget(child);
            }
            TransitionManager.beginDelayedTransition(this, exitTransition);
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                child.setVisibility(4);
            }
        }

        public void cancelTransitions() {
            TransitionManager.endTransitions(this);
            if (this.mCleanupAfterExit != null) {
                this.mCleanupAfterExit.run();
            }
        }
    }

    private class BackgroundView
    extends FrameLayout {
        public BackgroundView(Context context) {
            super(context);
        }

        @Override
        @NonNull
        protected int[] onCreateDrawableState(int extraSpace) {
            if (PopupWindow.this.mAboveAnchor) {
                int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
                View.mergeDrawableStates(drawableState, ABOVE_ANCHOR_STATE_SET);
                return drawableState;
            }
            return super.onCreateDrawableState(extraSpace);
        }
    }

    @FunctionalInterface
    public static interface OnDismissListener {
        public void onDismiss();
    }
}

