/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.widget.Checkable;
import yslelf.cloudpick.graphics.widget.LinearLayout;
import yslelf.cloudpick.graphics.widget.RadioButton;

public class RadioGroup
extends LinearLayout {
    private int mCheckedId = -1;
    private final Checkable.OnCheckedChangeListener mChildOnCheckedChangeListener = new CheckedStateTracker();
    private boolean mProtectFromCheckedChange = false;
    @Nullable
    private OnCheckedChangeListener mOnCheckedChangeListener;

    public RadioGroup(Context context) {
        super(context);
        this.setOrientation(1);
    }

    @Override
    protected void onViewAdded(View child) {
        super.onViewAdded(child);
        if (child instanceof RadioButton) {
            RadioButton button = (RadioButton)child;
            if (child.getId() == -1) {
                child.setId(RadioGroup.generateViewId());
            }
            if (button.isChecked()) {
                this.setCheckedStateForView(this.mCheckedId, false);
                this.setCheckedId(button.getId());
            }
            button.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
        }
    }

    @Override
    protected void onViewRemoved(View child) {
        super.onViewRemoved(child);
        if (child instanceof RadioButton) {
            ((RadioButton)child).setOnCheckedChangeListener(null);
        }
    }

    public void check(int id2) {
        if (id2 != -1 && id2 == this.mCheckedId) {
            return;
        }
        this.setCheckedStateForView(this.mCheckedId, false);
        this.setCheckedStateForView(id2, true);
        this.setCheckedId(id2);
    }

    private void setCheckedId(int id2) {
        this.mCheckedId = id2;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        if (viewId == -1) {
            return;
        }
        Object checkedView = this.findViewById(viewId);
        if (checkedView instanceof RadioButton) {
            this.mProtectFromCheckedChange = true;
            ((RadioButton)checkedView).setChecked(checked);
            this.mProtectFromCheckedChange = false;
        }
    }

    public final int getCheckedId() {
        return this.mCheckedId;
    }

    public final void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LinearLayout.LayoutParams(-2, -2);
    }

    private class CheckedStateTracker
    implements Checkable.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        @Override
        public void onCheckedChanged(View buttonView, boolean isChecked) {
            if (!RadioGroup.this.mProtectFromCheckedChange) {
                RadioGroup.this.setCheckedStateForView(RadioGroup.this.mCheckedId, false);
                RadioGroup.this.setCheckedId(buttonView.getId());
            }
        }
    }

    @FunctionalInterface
    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RadioGroup var1, int var2);
    }
}

