/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.util.AttributeSet;
import yslelf.cloudpick.graphics.widget.AbsSeekBar;

public class SeekBar
extends AbsSeekBar {
    private OnSeekBarChangeListener mOnSeekBarChangeListener;
    private static final ResourceId DEF_STYLE_ATTR = ResourceId.attr("modernui", "seekBarStyle");

    public SeekBar(Context context) {
        this(context, null);
    }

    public SeekBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, DEF_STYLE_ATTR);
    }

    public SeekBar(Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr) {
        this(context, attrs, defStyleAttr, null);
    }

    public SeekBar(Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr, @Nullable ResourceId defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    void onProgressRefresh(float scale, boolean fromUser, int progress) {
        super.onProgressRefresh(scale, fromUser, progress);
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onProgressChanged(this, progress, fromUser);
        }
    }

    public void setOnSeekBarChangeListener(OnSeekBarChangeListener l2) {
        this.mOnSeekBarChangeListener = l2;
    }

    @Override
    void onStartTrackingTouch() {
        super.onStartTrackingTouch();
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStartTrackingTouch(this);
        }
    }

    @Override
    void onStopTrackingTouch() {
        super.onStopTrackingTouch();
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStopTrackingTouch(this);
        }
    }

    public static interface OnSeekBarChangeListener {
        default public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        }

        default public void onStartTrackingTouch(SeekBar seekBar) {
        }

        default public void onStopTrackingTouch(SeekBar seekBar) {
        }
    }
}

