/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.resources.TypedArray;
import yslelf.cloudpick.graphics.transition.EpicenterTranslateClipReveal;
import yslelf.cloudpick.graphics.transition.Fade;
import yslelf.cloudpick.graphics.transition.TransitionSet;
import yslelf.cloudpick.graphics.util.AttributeSet;
import yslelf.cloudpick.graphics.util.DataSetObserver;
import yslelf.cloudpick.graphics.view.Gravity;
import yslelf.cloudpick.graphics.view.MeasureSpec;
import yslelf.cloudpick.graphics.view.MotionEvent;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.view.menu.ShowableListMenu;
import yslelf.cloudpick.graphics.widget.AbsSpinner;
import yslelf.cloudpick.graphics.widget.AdapterView;
import yslelf.cloudpick.graphics.widget.ForwardingListener;
import yslelf.cloudpick.graphics.widget.ListAdapter;
import yslelf.cloudpick.graphics.widget.ListPopupWindow;
import yslelf.cloudpick.graphics.widget.ListView;
import yslelf.cloudpick.graphics.widget.SpinnerAdapter;

public class Spinner
extends AbsSpinner {
    private static final int MAX_ITEMS_MEASURED = 15;
    private final Rect mTempRect = new Rect();
    private final DropDownPopupWindow mPopup;
    int mDropDownWidth;
    private final ForwardingListener mForwardingListener;
    private int mGravity;
    private static final String[] STYLEABLE = new String[]{"modernui", "dropDownSelector", "modernui", "dropDownWidth", "modernui", "gravity", "modernui", "overlapAnchor", "modernui", "popupBackground", "modernui", "popupElevation"};
    private static final ResourceId DEF_STYLE_ATTR = ResourceId.attr("modernui", "spinnerStyle");

    public Spinner(Context context) {
        this(context, null);
    }

    public Spinner(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, DEF_STYLE_ATTR);
    }

    public Spinner(Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr) {
        this(context, attrs, defStyleAttr, null);
    }

    public Spinner(Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr, @Nullable ResourceId defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, defStyleAttr, defStyleRes, STYLEABLE);
        this.mPopup = new DropDownPopupWindow(context, attrs, defStyleAttr, defStyleRes);
        this.mDropDownWidth = a.getLayoutDimension(1, -2);
        if (a.hasValueOrEmpty(0)) {
            this.mPopup.setListSelector(a.getDrawable(0));
        }
        this.mForwardingListener = new ForwardingListener(this){

            @Override
            public ShowableListMenu getPopup() {
                return Spinner.this.mPopup;
            }

            @Override
            public boolean onForwardingStarted() {
                if (!Spinner.this.mPopup.isShowing()) {
                    Spinner.this.mPopup.show(Spinner.this.getTextDirection(), Spinner.this.getTextAlignment());
                }
                return true;
            }
        };
        this.mGravity = a.getInt(2, 8388627);
        a.recycle();
    }

    public void setPopupBackgroundDrawable(@Nullable Drawable background) {
        this.mPopup.setBackgroundDrawable(background);
    }

    @Nullable
    public Drawable getPopupBackground() {
        return this.mPopup.getBackground();
    }

    public void setDropDownVerticalOffset(int pixels) {
        this.mPopup.setVerticalOffset(pixels);
    }

    public int getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    public void setDropDownHorizontalOffset(int pixels) {
        this.mPopup.setHorizontalOffset(pixels);
    }

    public int getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    public void setDropDownWidth(int pixels) {
        this.mDropDownWidth = pixels;
    }

    public int getDropDownWidth() {
        return this.mDropDownWidth;
    }

    public void setDropDownSelector(Drawable selector) {
        this.mPopup.setListSelector(selector);
    }

    public void setDropDownOverlapAnchor(boolean overlapAnchor) {
        this.mPopup.setOverlapAnchor(overlapAnchor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.getChildAt(i).setEnabled(enabled);
        }
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 0x800003;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    @Override
    public void setAdapter(@Nullable SpinnerAdapter adapter) {
        super.setAdapter(adapter);
        this.mRecycler.clear();
        if (adapter != null && adapter.getViewTypeCount() != 1) {
            throw new IllegalArgumentException("Spinner adapter view type count must be 1");
        }
        this.mPopup.setAdapter(new DropDownAdapter(adapter));
    }

    @Override
    public int getBaseline() {
        View child = null;
        if (this.getChildCount() > 0) {
            child = this.getChildAt(0);
        } else if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            child = this.makeView(0, false);
            this.mRecycler.put(0, child);
        }
        if (child != null) {
            int childBaseline = child.getBaseline();
            return childBaseline >= 0 ? child.getTop() + childBaseline : -1;
        }
        return -1;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    @Override
    public void setOnItemClickListener(@Nullable AdapterView.OnItemClickListener l2) {
        throw new UnsupportedOperationException("setOnItemClickListener cannot be used with a spinner.");
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.mForwardingListener != null && this.mForwardingListener.onTouch(this, event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mPopup != null && MeasureSpec.getMode(widthMeasureSpec) == Integer.MIN_VALUE) {
            int measuredWidth = this.getMeasuredWidth();
            this.setMeasuredDimension(Math.min(Math.max(measuredWidth, this.measureContentWidth(this.getAdapter(), this.getBackground())), MeasureSpec.getSize(widthMeasureSpec)), this.getMeasuredHeight());
        }
    }

    @Override
    protected void onLayout(boolean changed, int l2, int t2, int r, int b) {
        super.onLayout(changed, l2, t2, r, b);
        this.mInLayout = true;
        this.positionViews(0, false);
        this.mInLayout = false;
    }

    @Override
    void positionViews(int delta, boolean animate) {
        int childrenLeft = this.mSpinnerPaddingLeft;
        int childrenWidth = this.getWidth() - this.mSpinnerPaddingLeft - this.mSpinnerPaddingRight;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.removeAllViewsInLayout();
        this.mFirstPosition = this.mSelectedPosition;
        if (this.mAdapter != null) {
            View sel = this.makeView(this.mSelectedPosition, true);
            int width = sel.getMeasuredWidth();
            int selectedOffset = childrenLeft;
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
            switch (absoluteGravity & 7) {
                case 1: {
                    selectedOffset = childrenLeft + childrenWidth / 2 - width / 2;
                    break;
                }
                case 5: {
                    selectedOffset = childrenLeft + childrenWidth - width;
                }
            }
            sel.offsetLeftAndRight(selectedOffset);
        }
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
    }

    private View makeView(int position, boolean addChild) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.get(position)) != null) {
            this.setUpChild(child, addChild);
            return child;
        }
        child = this.mAdapter.getView(position, null, this);
        this.setUpChild(child, addChild);
        return child;
    }

    private void setUpChild(@NonNull View child, boolean addChild) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(child, 0, lp);
        child.setSelected(this.hasFocus());
        child.setEnabled(this.isEnabled());
        int childHeightSpec = ViewGroup.getChildMeasureSpec(this.mHeightMeasureSpec, this.mSpinnerPaddingTop + this.mSpinnerPaddingBottom, lp.height);
        int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mSpinnerPaddingLeft + this.mSpinnerPaddingRight, lp.width);
        child.measure(childWidthSpec, childHeightSpec);
        int childTop = this.mSpinnerPaddingTop + (this.getMeasuredHeight() - this.mSpinnerPaddingBottom - this.mSpinnerPaddingTop - child.getMeasuredHeight()) / 2;
        int childBottom = childTop + child.getMeasuredHeight();
        int width = child.getMeasuredWidth();
        int childLeft = 0;
        int childRight = childLeft + width;
        child.layout(childLeft, childTop, childRight, childBottom);
        if (!addChild) {
            this.removeViewInLayout(child);
        }
    }

    @Override
    public boolean performClick() {
        boolean handled = super.performClick();
        if (!handled && !this.mPopup.isShowing()) {
            this.mPopup.show(this.getTextDirection(), this.getTextAlignment());
        }
        return true;
    }

    int measureContentWidth(@Nullable SpinnerAdapter adapter, @Nullable Drawable background) {
        if (adapter == null) {
            return 0;
        }
        int width = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0);
        int heightMeasureSpec = MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0);
        int start = Math.max(0, this.getSelectedItemPosition());
        int end = Math.min(adapter.getCount(), start + 15);
        int count = end - start;
        for (int i = start = Math.max(0, start - (15 - count)); i < end; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if ((itemView = adapter.getView(i, itemView, this)).getLayoutParams() == null) {
                itemView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            width = Math.max(width, itemView.getMeasuredWidth());
        }
        if (background != null) {
            background.getPadding(this.mTempRect);
            width += this.mTempRect.left + this.mTempRect.right;
        }
        return width;
    }

    private class DropDownPopupWindow
    extends ListPopupWindow {
        private ListAdapter mAdapter;

        public DropDownPopupWindow(@Nullable Context context, @Nullable AttributeSet attrs, @Nullable ResourceId defStyleAttr, ResourceId defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
            this.setAnchorView(Spinner.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnItemClickListener((parent, v, position, id2) -> {
                Spinner.this.setSelection(position);
                if (Spinner.this.mOnItemClickListener != null) {
                    Spinner.this.performItemClick(v, position, this.mAdapter.getItemId(position));
                }
                this.dismiss();
            });
            EpicenterTranslateClipReveal enter1 = new EpicenterTranslateClipReveal();
            enter1.setDuration(250L);
            Fade enter2 = new Fade();
            enter2.setDuration(100L);
            TransitionSet enterAnim = new TransitionSet();
            enterAnim.addTransition(enter1);
            enterAnim.addTransition(enter2);
            enterAnim.setOrdering(0);
            this.mPopup.setEnterTransition(enterAnim);
            Fade exitAnim = new Fade();
            exitAnim.setDuration(300L);
            this.mPopup.setExitTransition(exitAnim);
        }

        @Override
        public void setAdapter(@Nullable ListAdapter adapter) {
            super.setAdapter(adapter);
            this.mAdapter = adapter;
        }

        void computeContentWidth() {
            Drawable background = this.getBackground();
            int hOffset = 0;
            if (background != null) {
                background.getPadding(Spinner.this.mTempRect);
                hOffset = Spinner.this.isLayoutRtl() ? Spinner.this.mTempRect.right : -Spinner.this.mTempRect.left;
            } else {
                Spinner.this.mTempRect.right = 0;
                Spinner.this.mTempRect.left = 0;
            }
            int spinnerPaddingLeft = Spinner.this.getPaddingLeft();
            int spinnerPaddingRight = Spinner.this.getPaddingRight();
            int spinnerWidth = Spinner.this.getWidth();
            if (Spinner.this.mDropDownWidth == -2) {
                int contentWidthLimit;
                int contentWidth = Spinner.this.measureContentWidth((SpinnerAdapter)((Object)this.mAdapter), this.getBackground());
                if (contentWidth > (contentWidthLimit = Spinner.this.getRootView().getMeasuredWidth() - Spinner.this.mTempRect.left - Spinner.this.mTempRect.right)) {
                    contentWidth = contentWidthLimit;
                }
                this.setContentWidth(Math.max(contentWidth, spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight));
            } else if (Spinner.this.mDropDownWidth == -1) {
                this.setContentWidth(spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight);
            } else {
                this.setContentWidth(Spinner.this.mDropDownWidth);
            }
            hOffset = Spinner.this.isLayoutRtl() ? (hOffset += spinnerWidth - spinnerPaddingRight - this.getWidth()) : (hOffset += spinnerPaddingLeft);
            this.setHorizontalOffset(hOffset);
        }

        public void show(int textDirection, int textAlignment) {
            this.computeContentWidth();
            super.show();
            ListView listView = this.getListView();
            assert (listView != null);
            listView.setChoiceMode(1);
            listView.setTextDirection(textDirection);
            listView.setTextAlignment(textAlignment);
            this.setSelection(Spinner.this.getSelectedItemPosition());
        }
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter {
        private final SpinnerAdapter mAdapter;
        private final ListAdapter mListAdapter;

        public DropDownAdapter(@Nullable SpinnerAdapter adapter) {
            this.mAdapter = adapter;
            this.mListAdapter = adapter instanceof ListAdapter ? (ListAdapter)((Object)adapter) : null;
        }

        @Override
        public int getCount() {
            return this.mAdapter == null ? 0 : this.mAdapter.getCount();
        }

        @Override
        public Object getItem(int position) {
            return this.mAdapter == null ? null : this.mAdapter.getItem(position);
        }

        @Override
        public long getItemId(int position) {
            return this.mAdapter == null ? -1L : this.mAdapter.getItemId(position);
        }

        @Override
        @Nullable
        public View getView(int position, View convertView, @NonNull ViewGroup parent) {
            return this.getDropDownView(position, convertView, parent);
        }

        @Override
        @Nullable
        public View getDropDownView(int position, View convertView, @NonNull ViewGroup parent) {
            return this.mAdapter == null ? null : this.mAdapter.getDropDownView(position, convertView, parent);
        }

        @Override
        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        @Override
        public void registerDataSetObserver(@NonNull DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        @Override
        public void unregisterDataSetObserver(@NonNull DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }

        @Override
        public boolean areAllItemsEnabled() {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.areAllItemsEnabled();
            }
            return true;
        }

        @Override
        public boolean isEnabled(int position) {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.isEnabled(position);
            }
            return true;
        }

        @Override
        public int getItemViewType(int position) {
            return 0;
        }

        @Override
        public int getViewTypeCount() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return this.mAdapter == null || this.mAdapter.isEmpty();
        }
    }
}

