/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.widget;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.view.Gravity;
import yslelf.cloudpick.graphics.view.MeasureSpec;
import yslelf.cloudpick.graphics.view.View;
import yslelf.cloudpick.graphics.view.ViewGroup;
import yslelf.cloudpick.graphics.widget.LinearLayout;

public class TableRow
extends LinearLayout {
    private int mNumColumns = 0;
    private int[] mColumnWidths;
    private int[] mConstrainedColumnWidths;
    private Int2IntOpenHashMap mColumnToChildIndex;

    public TableRow(Context context) {
        super(context);
    }

    void setColumnCollapsed(int columnIndex, boolean collapsed) {
        View child = this.getVirtualChildAt(columnIndex);
        if (child != null) {
            child.setVisibility(collapsed ? 8 : 0);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    protected void onLayout(boolean changed, int l2, int t2, int r, int b) {
        this.layoutHorizontal(l2, t2, r, b);
    }

    @Override
    public View getVirtualChildAt(int i) {
        int deflectedIndex;
        if (this.mColumnToChildIndex == null) {
            this.mapIndexAndColumns();
        }
        if ((deflectedIndex = this.mColumnToChildIndex.getOrDefault(i, -1)) != -1) {
            return this.getChildAt(deflectedIndex);
        }
        return null;
    }

    @Override
    public int getVirtualChildCount() {
        if (this.mColumnToChildIndex == null) {
            this.mapIndexAndColumns();
        }
        return this.mNumColumns;
    }

    private void mapIndexAndColumns() {
        if (this.mColumnToChildIndex == null) {
            int virtualCount = 0;
            int count = this.getChildCount();
            Int2IntOpenHashMap columnToChild = this.mColumnToChildIndex = new Int2IntOpenHashMap();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
                if (layoutParams.column >= virtualCount) {
                    virtualCount = layoutParams.column;
                }
                for (int j = 0; j < layoutParams.span; ++j) {
                    columnToChild.put(virtualCount++, i);
                }
            }
            this.mNumColumns = virtualCount;
        }
    }

    @Override
    int measureNullChild(int childIndex) {
        return this.mConstrainedColumnWidths[childIndex];
    }

    @Override
    void measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        if (this.mConstrainedColumnWidths != null) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int measureMode = 0x40000000;
            int columnWidth = 0;
            int span = lp.span;
            int[] constrainedColumnWidths = this.mConstrainedColumnWidths;
            for (int i = 0; i < span; ++i) {
                columnWidth += constrainedColumnWidths[childIndex + i];
            }
            int gravity = lp.gravity;
            boolean isHorizontalGravity = Gravity.isHorizontal(gravity);
            if (isHorizontalGravity) {
                measureMode = Integer.MIN_VALUE;
            }
            int childWidthMeasureSpec = MeasureSpec.makeMeasureSpec(Math.max(0, columnWidth - lp.leftMargin - lp.rightMargin), measureMode);
            int childHeightMeasureSpec = TableRow.getChildMeasureSpec(heightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + totalHeight, lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            if (isHorizontalGravity) {
                int childWidth = child.getMeasuredWidth();
                lp.mOffset[1] = columnWidth - childWidth;
                int layoutDirection = this.getLayoutDirection();
                int absoluteGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
                switch (absoluteGravity & 7) {
                    case 3: {
                        break;
                    }
                    case 5: {
                        lp.mOffset[0] = lp.mOffset[1];
                        break;
                    }
                    case 1: {
                        lp.mOffset[0] = lp.mOffset[1] / 2;
                    }
                }
            } else {
                lp.mOffset[1] = 0;
                lp.mOffset[0] = 0;
            }
        } else {
            super.measureChildBeforeLayout(child, childIndex, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
        }
    }

    @Override
    int getChildrenSkipCount(View child, int index) {
        LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
        return layoutParams.span - 1;
    }

    @Override
    int getLocationOffset(View child) {
        return ((LayoutParams)child.getLayoutParams()).mOffset[0];
    }

    @Override
    int getNextLocationOffset(View child) {
        return ((LayoutParams)child.getLayoutParams()).mOffset[1];
    }

    int[] getColumnsWidths(int widthMeasureSpec, int heightMeasureSpec) {
        int numColumns = this.getVirtualChildCount();
        if (this.mColumnWidths == null || numColumns != this.mColumnWidths.length) {
            this.mColumnWidths = new int[numColumns];
        }
        int[] columnWidths = this.mColumnWidths;
        for (int i = 0; i < numColumns; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child != null && child.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
                if (layoutParams.span == 1) {
                    int width;
                    int spec = switch (layoutParams.width) {
                        case -2 -> TableRow.getChildMeasureSpec(widthMeasureSpec, 0, -2);
                        case -1 -> MeasureSpec.makeMeasureSpec(MeasureSpec.getSize(heightMeasureSpec), 0);
                        default -> MeasureSpec.makeMeasureSpec(layoutParams.width, 0x40000000);
                    };
                    child.measure(spec, spec);
                    columnWidths[i] = width = child.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
                    continue;
                }
                columnWidths[i] = 0;
                continue;
            }
            columnWidths[i] = 0;
        }
        return columnWidths;
    }

    void setColumnsWidthConstraints(int[] columnWidths) {
        if (columnWidths == null || columnWidths.length < this.getVirtualChildCount()) {
            throw new IllegalArgumentException("columnWidths should be >= getVirtualChildCount()");
        }
        this.mConstrainedColumnWidths = columnWidths;
    }

    @Override
    @NonNull
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p2) {
        return p2 instanceof LayoutParams;
    }

    @Override
    @NonNull
    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p2) {
        return new LayoutParams(p2);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public int column;
        public int span;
        private static final int LOCATION = 0;
        private static final int LOCATION_NEXT = 1;
        private int[] mOffset = new int[2];

        public LayoutParams(int w, int h2) {
            super(w, h2);
            this.column = -1;
            this.span = 1;
        }

        public LayoutParams(int w, int h2, float initWeight) {
            super(w, h2, initWeight);
            this.column = -1;
            this.span = 1;
        }

        public LayoutParams() {
            super(-1, -2);
            this.column = -1;
            this.span = 1;
        }

        public LayoutParams(int column) {
            this();
            this.column = column;
        }

        public LayoutParams(ViewGroup.LayoutParams p2) {
            super(p2);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }
}

