/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.natives;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import dev.jnic.gPScUN.JNICLoader;
import java.awt.Color;
import org.lwjgl.system.NativeType;

public interface DwmApiLib
extends Library {
    public static final DwmApiLib INSTANCE = (DwmApiLib)Native.load((String)"dwmapi", DwmApiLib.class);
    public static final int INT_SIZE = 4;
    public static final int BOOL_FALSE = 0;
    public static final int BOOL_TRUE = 1;
    public static final int DWMWA_COLOR_DEFAULT = -1;
    public static final int DWMWA_COLOR_NONE = -2;
    public static final Color COLOR_BLACK = new Color(0);
    public static final Color COLOR_WHITE = new Color(0xFFFFFF);

    public static void setBoolWA(long handle, DWM_BOOL_WA attribute, boolean value) {
        WinDef.HWND hwnd = new WinDef.HWND(Pointer.createConstant((long)handle));
        INSTANCE.DwmSetWindowAttribute(hwnd, attribute.key, (PointerType)new IntByReference(value ? 1 : 0), 4);
    }

    public static <T extends EnumWAValue<T>> void setEnumWA(long handle, DWM_ENUM_WA attribute, T value) {
        WinDef.HWND hwnd = new WinDef.HWND(Pointer.createConstant((long)handle));
        INSTANCE.DwmSetWindowAttribute(hwnd, attribute.key, (PointerType)new IntByReference(value.getValue()), 4);
    }

    public static int rgb2ColorRef(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
    }

    public static int colorRef2Rgb(int colorRef, int defaultRgb) {
        if ((colorRef & 0xFF000000) == -16777216) {
            return defaultRgb;
        }
        int b = colorRef >> 16 & 0xFF;
        int g = colorRef >> 8 & 0xFF;
        int r = colorRef & 0xFF;
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static void setIntWA(long handle, DWM_INT_WA attribute, int value) {
        WinDef.HWND hwnd = new WinDef.HWND(Pointer.createConstant((long)handle));
        INSTANCE.DwmSetWindowAttribute(hwnd, attribute.key, (PointerType)new IntByReference(value), 4);
    }

    @NativeType(value="HRESULT")
    public int DwmSetWindowAttribute(WinDef.HWND var1, int var2, PointerType var3, int var4);

    public static final class DWM_BOOL_WA
    extends Enum<DWM_BOOL_WA> {
        public static final /* enum */ DWM_BOOL_WA DWMWA_USE_IMMERSIVE_DARK_MODE;
        public final int key;
        private static final /* synthetic */ DWM_BOOL_WA[] $VALUES;

        public static DWM_BOOL_WA[] values() {
            return (DWM_BOOL_WA[])$VALUES.clone();
        }

        public static native DWM_BOOL_WA valueOf(String var0);

        private DWM_BOOL_WA(int key) {
            this.key = key;
        }

        private static native /* synthetic */ DWM_BOOL_WA[] $values();

        static native /* synthetic */ void $jnicClinit();

        public static native /* synthetic */ void $jnicLoader();

        static {
            JNICLoader.init();
            DWM_BOOL_WA.$jnicLoader();
            DWM_BOOL_WA.$jnicClinit();
        }
    }

    public static final class DWM_ENUM_WA
    extends Enum<DWM_ENUM_WA> {
        public static final /* enum */ DWM_ENUM_WA DWMWA_WINDOW_CORNER_PREFERENCE;
        public static final /* enum */ DWM_ENUM_WA DWMWA_SYSTEMBACKDROP_TYPE;
        public final int key;
        private static final /* synthetic */ DWM_ENUM_WA[] $VALUES;

        public static DWM_ENUM_WA[] values() {
            return (DWM_ENUM_WA[])$VALUES.clone();
        }

        public static native DWM_ENUM_WA valueOf(String var0);

        private DWM_ENUM_WA(int key) {
            this.key = key;
        }

        private static native /* synthetic */ DWM_ENUM_WA[] $values();

        static native /* synthetic */ void $jnicClinit();

        public static native /* synthetic */ void $jnicLoader();

        static {
            JNICLoader.init();
            DWM_ENUM_WA.$jnicLoader();
            DWM_ENUM_WA.$jnicClinit();
        }
    }

    public static interface EnumWAValue<T> {
        public int getValue();

        public String getTranslation();
    }

    public static final class DWM_INT_WA
    extends Enum<DWM_INT_WA> {
        public static final /* enum */ DWM_INT_WA DWMWA_BORDER_COLOR;
        public static final /* enum */ DWM_INT_WA DWMWA_CAPTION_COLOR;
        public static final /* enum */ DWM_INT_WA DWMWA_TEXT_COLOR;
        public final int key;
        private static final /* synthetic */ DWM_INT_WA[] $VALUES;

        public static DWM_INT_WA[] values() {
            return (DWM_INT_WA[])$VALUES.clone();
        }

        public static native DWM_INT_WA valueOf(String var0);

        private DWM_INT_WA(int key) {
            this.key = key;
        }

        private static native /* synthetic */ DWM_INT_WA[] $values();

        static native /* synthetic */ void $jnicClinit();

        public static native /* synthetic */ void $jnicLoader();

        static {
            JNICLoader.init();
            DWM_INT_WA.$jnicLoader();
            DWM_INT_WA.$jnicClinit();
        }
    }

    public static final class DWM_WINDOW_CORNER_PREFERENCE
    extends Enum<DWM_WINDOW_CORNER_PREFERENCE>
    implements EnumWAValue<DWM_WINDOW_CORNER_PREFERENCE> {
        public static final /* enum */ DWM_WINDOW_CORNER_PREFERENCE DWMWCP_DEFAULT;
        public static final /* enum */ DWM_WINDOW_CORNER_PREFERENCE DWMWCP_DONOTROUND;
        public static final /* enum */ DWM_WINDOW_CORNER_PREFERENCE DWMWCP_ROUND;
        public static final /* enum */ DWM_WINDOW_CORNER_PREFERENCE DWMWCP_ROUNDSMALL;
        public final String translate;
        private static final /* synthetic */ DWM_WINDOW_CORNER_PREFERENCE[] $VALUES;

        public static DWM_WINDOW_CORNER_PREFERENCE[] values() {
            return (DWM_WINDOW_CORNER_PREFERENCE[])$VALUES.clone();
        }

        public static native DWM_WINDOW_CORNER_PREFERENCE valueOf(String var0);

        @Override
        public native int getValue();

        @Override
        public native String getTranslation();

        private DWM_WINDOW_CORNER_PREFERENCE(String translate) {
            this.translate = translate;
        }

        private static native /* synthetic */ DWM_WINDOW_CORNER_PREFERENCE[] $values();

        static native /* synthetic */ void $jnicClinit();

        public static native /* synthetic */ void $jnicLoader();

        static {
            JNICLoader.init();
            DWM_WINDOW_CORNER_PREFERENCE.$jnicLoader();
            DWM_WINDOW_CORNER_PREFERENCE.$jnicClinit();
        }
    }

    public static final class DWM_SYSTEMBACKDROP_TYPE
    extends Enum<DWM_SYSTEMBACKDROP_TYPE>
    implements EnumWAValue<DWM_SYSTEMBACKDROP_TYPE> {
        public static final /* enum */ DWM_SYSTEMBACKDROP_TYPE DWMSBT_AUTO;
        public static final /* enum */ DWM_SYSTEMBACKDROP_TYPE DWMSBT_NONE;
        public static final /* enum */ DWM_SYSTEMBACKDROP_TYPE DWMSBT_MAINWINDOW;
        public static final /* enum */ DWM_SYSTEMBACKDROP_TYPE DWMSBT_TRANSIENTWINDOW;
        public static final /* enum */ DWM_SYSTEMBACKDROP_TYPE DWMSBT_TABBEDWINDOW;
        public final String translate;
        private static final /* synthetic */ DWM_SYSTEMBACKDROP_TYPE[] $VALUES;

        public static DWM_SYSTEMBACKDROP_TYPE[] values() {
            return (DWM_SYSTEMBACKDROP_TYPE[])$VALUES.clone();
        }

        public static native DWM_SYSTEMBACKDROP_TYPE valueOf(String var0);

        @Override
        public native int getValue();

        @Override
        public native String getTranslation();

        private DWM_SYSTEMBACKDROP_TYPE(String translate) {
            this.translate = translate;
        }

        private static native /* synthetic */ DWM_SYSTEMBACKDROP_TYPE[] $values();

        static native /* synthetic */ void $jnicClinit();

        public static native /* synthetic */ void $jnicLoader();

        static {
            JNICLoader.init();
            DWM_SYSTEMBACKDROP_TYPE.$jnicLoader();
            DWM_SYSTEMBACKDROP_TYPE.$jnicClinit();
        }
    }
}

