/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler;

import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.Operator;
import yslelf.cloudpick.render.compiler.analysis.Analysis;
import yslelf.cloudpick.render.compiler.tree.ConstructorArray;
import yslelf.cloudpick.render.compiler.tree.ConstructorCompound;
import yslelf.cloudpick.render.compiler.tree.ConstructorDiagonalMatrix;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Literal;
import yslelf.cloudpick.render.compiler.tree.PrefixExpression;
import yslelf.cloudpick.render.compiler.tree.Type;
import yslelf.cloudpick.render.compiler.tree.Variable;
import yslelf.cloudpick.render.compiler.tree.VariableReference;

public class ConstantFolder {
    public static OptionalLong getConstantInt(Expression value) {
        Expression expr = ConstantFolder.getConstantValueForVariable(value);
        if (expr.isIntLiteral()) {
            return OptionalLong.of(((Literal)expr).getIntegerValue());
        }
        return OptionalLong.empty();
    }

    public static Expression getConstantValueForVariable(Expression value) {
        Expression expr = ConstantFolder.getConstantValueOrNullForVariable(value);
        return expr != null ? expr : value;
    }

    public static Expression makeConstantValueForVariable(int pos, Expression value) {
        Expression expr = ConstantFolder.getConstantValueOrNullForVariable(value);
        return expr != null ? expr.clone(pos) : value;
    }

    @Nullable
    public static Expression getConstantValueOrNullForVariable(Expression value) {
        Variable variable;
        VariableReference r;
        while (value instanceof VariableReference && (r = (VariableReference)value).getReferenceKind() == 0 && (variable = r.getVariable()).getModifiers().isConst() && (value = variable.initialValue()) != null) {
            if (!Analysis.isCompileTimeConstant(value)) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public static Expression fold(@Nonnull Context context, int pos, Expression left, Operator op, Expression right, Type resultType) {
        left = ConstantFolder.getConstantValueForVariable(left);
        right = ConstantFolder.getConstantValueForVariable(right);
        if (op == Operator.ASSIGN && Analysis.isSameExpressionTree(left, right)) {
            return right.clone(pos);
        }
        if (left.isBooleanLiteral() && right.isBooleanLiteral()) {
            boolean result;
            boolean leftVal = ((Literal)left).getBooleanValue();
            boolean rightVal = ((Literal)right).getBooleanValue();
            switch (op) {
                case LOGICAL_AND: {
                    result = leftVal & rightVal;
                    break;
                }
                case LOGICAL_OR: {
                    result = leftVal | rightVal;
                    break;
                }
                case LOGICAL_XOR: {
                    result = leftVal ^ rightVal;
                    break;
                }
                case EQ: {
                    result = leftVal == rightVal;
                    break;
                }
                case NE: {
                    result = leftVal != rightVal;
                    break;
                }
                default: {
                    return null;
                }
            }
            return Literal.makeBoolean(context, pos, result);
        }
        if (left.isBooleanLiteral()) {
            boolean leftVal = ((Literal)left).getBooleanValue();
            if (op == Operator.LOGICAL_AND && !leftVal || op == Operator.LOGICAL_OR && leftVal) {
                return left.clone(pos);
            }
            if (op == Operator.LOGICAL_AND || op == Operator.LOGICAL_OR || op == Operator.LOGICAL_XOR && !leftVal || op == Operator.EQ && leftVal || op == Operator.NE && !leftVal) {
                return right.clone(pos);
            }
            return null;
        }
        if (right.isBooleanLiteral()) {
            boolean rightVal = ((Literal)right).getBooleanValue();
            if (!Analysis.hasSideEffects(left) && (op == Operator.LOGICAL_AND && !rightVal || op == Operator.LOGICAL_OR && rightVal)) {
                return right.clone(pos);
            }
            if (op == Operator.LOGICAL_AND && rightVal || op == Operator.LOGICAL_OR && !rightVal || op == Operator.LOGICAL_XOR && !rightVal || op == Operator.EQ && rightVal || op == Operator.NE && !rightVal) {
                return left.clone(pos);
            }
            return null;
        }
        if (op == Operator.EQ && Analysis.isSameExpressionTree(left, right)) {
            return Literal.makeBoolean(context, pos, true);
        }
        if (op == Operator.NE && Analysis.isSameExpressionTree(left, right)) {
            return Literal.makeBoolean(context, pos, false);
        }
        Type leftType = left.getType();
        Type rightType = right.getType();
        switch (op) {
            case DIV: 
            case DIV_ASSIGN: 
            case MOD: 
            case MOD_ASSIGN: {
                int components = rightType.getComponents();
                for (int i = 0; i < components; ++i) {
                    OptionalDouble value = right.getConstantValue(i);
                    if (!value.isPresent() || value.getAsDouble() != 0.0) continue;
                    context.error(pos, "division by zero");
                    return null;
                }
                break;
            }
        }
        boolean leftSideIsConstant = Analysis.isCompileTimeConstant(left);
        boolean rightSideIsConstant = Analysis.isCompileTimeConstant(right);
        if (leftSideIsConstant && rightSideIsConstant && left.isIntLiteral() && right.isIntLiteral()) {
            long resultVal;
            long leftVal = ((Literal)left).getIntegerValue();
            long rightVal = ((Literal)right).getIntegerValue();
            switch (op) {
                case ADD: {
                    resultVal = leftVal + rightVal;
                    break;
                }
                case SUB: {
                    resultVal = leftVal - rightVal;
                    break;
                }
                case MUL: {
                    resultVal = leftVal * rightVal;
                    break;
                }
                case DIV: {
                    resultVal = leftVal / rightVal;
                    break;
                }
                case MOD: {
                    resultVal = leftVal % rightVal;
                    break;
                }
                case BITWISE_AND: {
                    resultVal = leftVal & rightVal;
                    break;
                }
                case BITWISE_OR: {
                    resultVal = leftVal | rightVal;
                    break;
                }
                case BITWISE_XOR: {
                    resultVal = leftVal ^ rightVal;
                    break;
                }
                case EQ: {
                    resultVal = leftVal == rightVal ? 1L : 0L;
                    break;
                }
                case NE: {
                    resultVal = leftVal != rightVal ? 1L : 0L;
                    break;
                }
                case GT: {
                    resultVal = leftVal > rightVal ? 1L : 0L;
                    break;
                }
                case GE: {
                    resultVal = leftVal >= rightVal ? 1L : 0L;
                    break;
                }
                case LT: {
                    resultVal = leftVal < rightVal ? 1L : 0L;
                    break;
                }
                case LE: {
                    resultVal = leftVal <= rightVal ? 1L : 0L;
                    break;
                }
                case SHL: {
                    if (rightVal >= 0L && rightVal < (long)leftType.getWidth()) {
                        resultVal = leftVal << (int)rightVal;
                        break;
                    }
                    context.warning(pos, "shift value out of range");
                    return null;
                }
                case SHR: {
                    if (rightVal >= 0L && rightVal < (long)leftType.getWidth()) {
                        resultVal = leftVal >> (int)rightVal;
                        break;
                    }
                    context.warning(pos, "shift value out of range");
                    return null;
                }
                default: {
                    return null;
                }
            }
            return ConstantFolder.makeConstant(pos, resultVal, resultType);
        }
        return null;
    }

    @Nullable
    private static Expression makeConstant(int pos, double result, Type resultType) {
        if (!(!resultType.isNumeric() || result >= resultType.getMinValue() && result <= resultType.getMaxValue())) {
            return null;
        }
        return Literal.make(pos, result, resultType);
    }

    @Nullable
    public static Expression fold(@Nonnull Context context, int pos, @Nonnull Operator op, Expression base) {
        Expression value = ConstantFolder.getConstantValueForVariable(base);
        Type type = value.getType();
        block0 : switch (op) {
            case ADD: {
                assert (!type.isArray());
                assert (type.getComponentType().isNumeric());
                value.mPosition = pos;
                return value;
            }
            case SUB: {
                assert (!type.isArray());
                assert (type.getComponentType().isNumeric());
                return ConstantFolder.fold_negation(context, pos, value);
            }
            case LOGICAL_NOT: {
                assert (type.isBoolean());
                switch (value.getKind()) {
                    case LITERAL: {
                        Literal literal = (Literal)value;
                        return Literal.makeBoolean(pos, !literal.getBooleanValue(), value.getType());
                    }
                    case PREFIX: {
                        PrefixExpression prefix = (PrefixExpression)value;
                        if (prefix.getOperator() != Operator.LOGICAL_NOT) break;
                        prefix.getOperand().mPosition = pos;
                        return prefix.getOperand();
                    }
                }
                break;
            }
            case BITWISE_NOT: {
                assert (!type.isArray());
                assert (type.getComponentType().isInteger());
                switch (value.getKind()) {
                    case LITERAL: 
                    case CONSTRUCTOR_VECTOR_SPLAT: 
                    case CONSTRUCTOR_COMPOUND: {
                        Expression expr = ConstantFolder.apply_to_components(context, pos, value, v -> (long)v ^ 0xFFFFFFFFFFFFFFFFL);
                        if (expr == null) break block0;
                        return expr;
                    }
                    case PREFIX: {
                        PrefixExpression prefix = (PrefixExpression)value;
                        if (prefix.getOperator() == Operator.BITWISE_NOT) {
                            prefix.getOperand().mPosition = pos;
                            return prefix.getOperand();
                        } else {
                            break;
                        }
                    }
                }
                break;
            }
            case INC: 
            case DEC: {
                assert (type.isNumeric());
                break;
            }
            default: {
                throw new AssertionError((Object)op);
            }
        }
        return null;
    }

    @Nullable
    private static Expression fold_negation(Context context, int pos, Expression base) {
        Expression value = ConstantFolder.getConstantValueForVariable(base);
        switch (value.getKind()) {
            case LITERAL: 
            case CONSTRUCTOR_VECTOR_SPLAT: 
            case CONSTRUCTOR_COMPOUND: {
                Expression expr = ConstantFolder.apply_to_components(context, pos, value, v -> -v);
                if (expr == null) break;
                return expr;
            }
            case PREFIX: {
                PrefixExpression prefix = (PrefixExpression)value;
                if (prefix.getOperator() != Operator.SUB) break;
                return prefix.getOperand().clone(pos);
            }
            case CONSTRUCTOR_ARRAY: {
                if (!Analysis.isCompileTimeConstant(value)) break;
                ConstructorArray ctor = (ConstructorArray)value;
                Expression[] ctorArgs = ctor.getArguments();
                Expression[] newArgs = new Expression[ctorArgs.length];
                for (int i = 0; i < ctorArgs.length; ++i) {
                    Expression arg = ctorArgs[i];
                    Expression folded = ConstantFolder.fold_negation(context, pos, arg);
                    if (folded == null) {
                        folded = new PrefixExpression(pos, Operator.SUB, arg.clone());
                    }
                    newArgs[i] = folded;
                }
                return ConstructorArray.make(pos, ctor.getType(), newArgs);
            }
            case CONSTRUCTOR_DIAGONAL_MATRIX: {
                ConstructorDiagonalMatrix ctor;
                Expression folded;
                if (!Analysis.isCompileTimeConstant(value) || (folded = ConstantFolder.fold_negation(context, pos, (ctor = (ConstructorDiagonalMatrix)value).getArgument())) == null) break;
                return ConstructorDiagonalMatrix.make(pos, ctor.getType(), folded);
            }
        }
        return null;
    }

    private static Expression apply_to_components(Context context, int pos, Expression expr, DoubleUnaryOperator op) {
        int components = expr.getType().getComponents();
        if (components > 16) {
            return null;
        }
        double[] values = new double[components];
        Type componentType = expr.getType().getComponentType();
        for (int index = 0; index < components; ++index) {
            OptionalDouble value = expr.getConstantValue(index);
            if (value.isPresent()) {
                values[index] = op.applyAsDouble(value.getAsDouble());
                if (!componentType.checkLiteralOutOfRange(context, pos, values[index])) continue;
                return null;
            }
            return null;
        }
        return ConstructorCompound.makeFromConstants(context, pos, expr.getType(), values);
    }
}

