/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler;

import java.util.Objects;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.BuiltinTypes;
import yslelf.cloudpick.render.compiler.CompileOptions;
import yslelf.cloudpick.render.compiler.ErrorHandler;
import yslelf.cloudpick.render.compiler.ModuleLoader;
import yslelf.cloudpick.render.compiler.ModuleUnit;
import yslelf.cloudpick.render.compiler.ShaderKind;
import yslelf.cloudpick.render.compiler.SymbolTable;
import yslelf.cloudpick.render.compiler.tree.AnonymousField;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.FieldAccess;
import yslelf.cloudpick.render.compiler.tree.FunctionDecl;
import yslelf.cloudpick.render.compiler.tree.FunctionReference;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Symbol;
import yslelf.cloudpick.render.compiler.tree.Type;
import yslelf.cloudpick.render.compiler.tree.TypeReference;
import yslelf.cloudpick.render.compiler.tree.Variable;
import yslelf.cloudpick.render.compiler.tree.VariableReference;

public final class Context {
    private ShaderKind mKind;
    private CompileOptions mOptions;
    private boolean mIsBuiltin;
    private boolean mIsModule;
    private final BuiltinTypes mTypes = ModuleLoader.getInstance().getBuiltinTypes();
    private SymbolTable mSymbolTable;
    ErrorHandler mErrorHandler;
    private boolean mActive;

    Context(ErrorHandler errorHandler) {
        this.mErrorHandler = errorHandler;
    }

    void start(ShaderKind kind, CompileOptions options, ModuleUnit parent, boolean isBuiltin, boolean isModule) {
        if (this.isActive()) {
            throw new IllegalStateException("DSL is already started");
        }
        this.mKind = Objects.requireNonNull(kind);
        this.mOptions = Objects.requireNonNull(options);
        this.mIsBuiltin = isBuiltin;
        this.mIsModule = isModule;
        if (parent != null) {
            this.mSymbolTable = parent.mSymbols.enterModule(isBuiltin);
        }
        this.mActive = true;
    }

    void end() {
        this.mKind = null;
        this.mOptions = null;
        this.mSymbolTable = null;
        this.mActive = false;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public ShaderKind getKind() {
        return this.mKind;
    }

    public CompileOptions getOptions() {
        return this.mOptions;
    }

    public boolean isBuiltin() {
        return this.mIsBuiltin;
    }

    public boolean isModule() {
        return this.mIsModule;
    }

    public BuiltinTypes getTypes() {
        return this.mTypes;
    }

    public SymbolTable getSymbolTable() {
        return this.mSymbolTable;
    }

    public void enterScope() {
        this.mSymbolTable = this.mSymbolTable.enterScope();
    }

    public void leaveScope() {
        this.mSymbolTable = this.mSymbolTable.leaveScope();
    }

    public void error(int position, String msg) {
        this.mErrorHandler.error(position, msg);
    }

    public void error(int start, int end, String msg) {
        this.mErrorHandler.error(start, end, msg);
    }

    public void warning(int position, String msg) {
        this.mErrorHandler.warning(position, msg);
    }

    public void warning(int start, int end, String msg) {
        this.mErrorHandler.warning(start, end, msg);
    }

    public ErrorHandler getErrorHandler() {
        return this.mErrorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.mErrorHandler = Objects.requireNonNull(errorHandler);
    }

    @Nullable
    public Expression convertIdentifier(int position, String name) {
        Symbol result = this.mSymbolTable.find(name);
        if (result == null) {
            this.error(position, "identifier '" + name + "' is undefined");
            return null;
        }
        return switch (result.getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case Node.SymbolKind.FUNCTION_DECL -> {
                FunctionDecl overloadChain = (FunctionDecl)result;
                yield FunctionReference.make(this, position, overloadChain);
            }
            case Node.SymbolKind.VARIABLE -> {
                Variable variable = (Variable)result;
                yield VariableReference.make(position, variable, 0);
            }
            case Node.SymbolKind.ANONYMOUS_FIELD -> {
                AnonymousField field = (AnonymousField)result;
                Expression base = VariableReference.make(position, field.getContainer(), 0);
                yield FieldAccess.make(position, base, field.getFieldIndex(), true);
            }
            case Node.SymbolKind.TYPE -> {
                Type type = (Type)result;
                if (!this.mIsBuiltin && type.isGeneric()) {
                    this.error(position, "type '" + type.getName() + "' is generic");
                    type = this.getTypes().mPoison;
                }
                yield TypeReference.make(this, position, type);
            }
        };
    }
}

