/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongStack;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.CompileOptions;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.FatalError;
import yslelf.cloudpick.render.compiler.ModuleUnit;
import yslelf.cloudpick.render.compiler.Operator;
import yslelf.cloudpick.render.compiler.Position;
import yslelf.cloudpick.render.compiler.ShaderCompiler;
import yslelf.cloudpick.render.compiler.ShaderKind;
import yslelf.cloudpick.render.compiler.TranslationUnit;
import yslelf.cloudpick.render.compiler.lex.Lexer;
import yslelf.cloudpick.render.compiler.lex.Token;
import yslelf.cloudpick.render.compiler.tree.BinaryExpression;
import yslelf.cloudpick.render.compiler.tree.BlockStatement;
import yslelf.cloudpick.render.compiler.tree.BreakStatement;
import yslelf.cloudpick.render.compiler.tree.ConditionalExpression;
import yslelf.cloudpick.render.compiler.tree.ConstructorArray;
import yslelf.cloudpick.render.compiler.tree.ConstructorCall;
import yslelf.cloudpick.render.compiler.tree.ConstructorStruct;
import yslelf.cloudpick.render.compiler.tree.ContinueStatement;
import yslelf.cloudpick.render.compiler.tree.DiscardStatement;
import yslelf.cloudpick.render.compiler.tree.EmptyStatement;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.ExpressionStatement;
import yslelf.cloudpick.render.compiler.tree.FieldAccess;
import yslelf.cloudpick.render.compiler.tree.ForLoop;
import yslelf.cloudpick.render.compiler.tree.FunctionCall;
import yslelf.cloudpick.render.compiler.tree.FunctionDecl;
import yslelf.cloudpick.render.compiler.tree.FunctionDefinition;
import yslelf.cloudpick.render.compiler.tree.FunctionPrototype;
import yslelf.cloudpick.render.compiler.tree.GlobalVariableDecl;
import yslelf.cloudpick.render.compiler.tree.IfStatement;
import yslelf.cloudpick.render.compiler.tree.IndexExpression;
import yslelf.cloudpick.render.compiler.tree.InterfaceBlock;
import yslelf.cloudpick.render.compiler.tree.Layout;
import yslelf.cloudpick.render.compiler.tree.Literal;
import yslelf.cloudpick.render.compiler.tree.Modifiers;
import yslelf.cloudpick.render.compiler.tree.Poison;
import yslelf.cloudpick.render.compiler.tree.PostfixExpression;
import yslelf.cloudpick.render.compiler.tree.PrefixExpression;
import yslelf.cloudpick.render.compiler.tree.ReturnStatement;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.StructDefinition;
import yslelf.cloudpick.render.compiler.tree.SwitchStatement;
import yslelf.cloudpick.render.compiler.tree.Symbol;
import yslelf.cloudpick.render.compiler.tree.TopLevelElement;
import yslelf.cloudpick.render.compiler.tree.Type;
import yslelf.cloudpick.render.compiler.tree.Variable;
import yslelf.cloudpick.render.compiler.tree.VariableDecl;

public class Parser {
    private final ShaderCompiler mCompiler;
    private final ShaderKind mKind;
    private final CompileOptions mOptions;
    private final char[] mSource;
    private final int mSourceOffset;
    private final int mSourceLength;
    private final Lexer mLexer;
    private final LongStack mPushback = new LongArrayList(1);
    private LinkedHashMap<String, String> mExtensions;
    private ArrayList<Map.Entry<String, Boolean>> mIncludes;
    private ArrayList<TopLevelElement> mUniqueElements;

    public Parser(ShaderCompiler compiler, ShaderKind kind, CompileOptions options, char[] source, int offset, int length) {
        this.mCompiler = Objects.requireNonNull(compiler);
        this.mOptions = Objects.requireNonNull(options);
        this.mKind = Objects.requireNonNull(kind);
        this.mSource = source;
        this.mSourceOffset = offset;
        this.mSourceLength = length;
        this.mLexer = new Lexer(source, offset, length);
        if (options.mExtensions != null && !options.mExtensions.isEmpty()) {
            this.mExtensions = new LinkedHashMap<String, String>(options.mExtensions);
        }
    }

    @Nullable
    public List<Map.Entry<String, Boolean>> preprocess() {
        this.mIncludes = new ArrayList();
        this.Directives();
        Context context = this.mCompiler.getContext();
        if (context.getErrorHandler().errorCount() == 0) {
            return this.mIncludes;
        }
        return null;
    }

    @Nullable
    public TranslationUnit parse(ModuleUnit parent) {
        Objects.requireNonNull(parent);
        this.mUniqueElements = new ArrayList();
        this.CompilationUnit();
        Context context = this.mCompiler.getContext();
        assert (!context.isModule());
        assert (!context.isBuiltin());
        TranslationUnit result = context.getErrorHandler().errorCount() == 0 ? new TranslationUnit(this.mSource, this.mSourceOffset, this.mSourceLength, this.mKind, this.mOptions, context.getTypes(), context.getSymbolTable(), this.mUniqueElements, (List<Map.Entry<String, String>>)(this.mExtensions != null ? new ArrayList<Map.Entry<String, String>>(this.mExtensions.entrySet()) : new ArrayList())) : null;
        this.mUniqueElements = null;
        return result;
    }

    @Nullable
    public ModuleUnit parseModule(ModuleUnit parent) {
        ModuleUnit result;
        Objects.requireNonNull(parent);
        this.mUniqueElements = new ArrayList();
        this.CompilationUnit();
        Context context = this.mCompiler.getContext();
        assert (context.isModule());
        if (context.getErrorHandler().errorCount() == 0) {
            result = new ModuleUnit();
            result.mParent = parent;
            result.mSymbols = context.getSymbolTable();
            result.mElements = this.mUniqueElements;
        } else {
            result = null;
        }
        this.mUniqueElements = null;
        return result;
    }

    private long nextRawToken() {
        long token;
        if (!this.mPushback.isEmpty()) {
            token = this.mPushback.popLong();
        } else {
            token = this.mLexer.next();
            if (Token.kind(token) == 40) {
                this.error(token, "'" + this.text(token) + "' is a reserved keyword");
                return Token.replace(token, 41);
            }
        }
        return token;
    }

    private long nextPpToken() {
        long token;
        block3: while (true) {
            token = this.nextRawToken();
            switch (Token.kind(token)) {
                case 89: 
                case 90: 
                case 91: {
                    continue block3;
                }
            }
            break;
        }
        return token;
    }

    private long nextToken() {
        long token;
        block3: while (true) {
            token = this.nextRawToken();
            switch (Token.kind(token)) {
                case 88: 
                case 89: 
                case 90: 
                case 91: {
                    continue block3;
                }
            }
            break;
        }
        return token;
    }

    private void pushback(long token) {
        this.mPushback.push(token);
    }

    private long peek() {
        if (this.mPushback.isEmpty()) {
            long token = this.nextToken();
            this.mPushback.push(token);
            return token;
        }
        return this.mPushback.topLong();
    }

    private boolean peek(int kind) {
        return Token.kind(this.peek()) == kind;
    }

    @Nonnull
    private String text(long token) {
        int offset = Token.offset(token);
        int length = Token.length(token);
        return this.text(offset, length);
    }

    @Nonnull
    private String text(int offset, int length) {
        if (length == 0) {
            return "EOF";
        }
        return new String(this.mSource, offset + this.mSourceOffset, length);
    }

    private int position(long token) {
        int offset = Token.offset(token);
        return Position.range(offset, offset + Token.length(token));
    }

    private void error(long token, String msg) {
        int offset = Token.offset(token);
        this.error(offset, offset + Token.length(token), msg);
    }

    private void error(int start, int end, String msg) {
        this.mCompiler.getContext().error(start, end, msg);
    }

    private void warning(long token, String msg) {
        int offset = Token.offset(token);
        this.warning(offset, offset + Token.length(token), msg);
    }

    private void warning(int start, int end, String msg) {
        this.mCompiler.getContext().warning(start, end, msg);
    }

    private int rangeFromOffset(int startOffset) {
        int endOffset = this.mPushback.isEmpty() ? this.mLexer.offset() : Token.offset(this.mPushback.topLong());
        return Position.range(startOffset, endOffset);
    }

    private int rangeFrom(int startPos) {
        return this.rangeFromOffset(Position.getStartOffset(startPos));
    }

    private int rangeFrom(long startToken) {
        return this.rangeFromOffset(Token.offset(startToken));
    }

    private boolean checkNext(int kind) {
        long next = this.peek();
        if (Token.kind(next) == kind) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private long checkIdentifier() {
        long next = this.peek();
        if (Token.kind(next) == 41 && !this.mCompiler.getContext().getSymbolTable().isBuiltinType(this.text(next))) {
            return this.nextToken();
        }
        return -1L;
    }

    private long expect(int kind, String expected) {
        long next = this.nextToken();
        if (Token.kind(next) != kind) {
            String msg = "expected " + expected + ", but found '" + this.text(next) + "'";
            this.error(next, msg);
            throw new FatalError(msg);
        }
        return next;
    }

    private long expectIdentifier() {
        long token = this.expect(41, "an identifier");
        if (this.mCompiler.getContext().getSymbolTable().isBuiltinType(this.text(token))) {
            String msg = "expected an identifier, but found type '" + this.text(token) + "'";
            this.error(token, msg);
            throw new FatalError(msg);
        }
        return token;
    }

    private void Directives() {
        if (this.mSourceLength > 0x7FFFFE) {
            this.mCompiler.getContext().error(-1, "source code is too long, " + this.mSourceLength + " > 8,388,606 chars");
            return;
        }
        boolean first = true;
        block4: while (true) {
            switch (Token.kind(this.peek())) {
                case 92: {
                    this.error(this.peek(), "invalid token");
                    return;
                }
                case 42: {
                    if (!this.Directive(first)) {
                        return;
                    }
                    first = false;
                    continue block4;
                }
            }
            break;
        }
    }

    private boolean Directive(boolean first) {
        long hash = this.nextPpToken();
        long directive = this.nextPpToken();
        if (Token.kind(directive) == 88 || Token.kind(directive) == 0) {
            return true;
        }
        String text = this.text(directive);
        if (Token.kind(directive) != 41) {
            this.error(directive, "expected a directive name, but found '" + text + "'");
            return false;
        }
        block8 : switch (text) {
            case "version": {
                String validProfile;
                int ver;
                long version;
                if (!first) {
                    this.mCompiler.getContext().error(this.rangeFrom(hash), "version directive must appear before anything else");
                }
                if (Token.kind(version = this.nextPpToken()) != 1) {
                    this.error(version, "version must be an integer literal");
                    return false;
                }
                try {
                    ver = Integer.parseInt(this.text(version));
                }
                catch (NumberFormatException e) {
                    this.error(version, "invalid version number");
                    return false;
                }
                switch (ver) {
                    case 300: 
                    case 310: 
                    case 320: {
                        validProfile = "es";
                        break;
                    }
                    case 330: 
                    case 400: 
                    case 410: 
                    case 420: 
                    case 430: 
                    case 440: 
                    case 450: 
                    case 460: {
                        validProfile = "core";
                        break;
                    }
                    default: {
                        this.error(version, "unsupported version number " + ver);
                        return false;
                    }
                }
                long profile = this.nextPpToken();
                if (Token.kind(profile) == 88 || Token.kind(profile) == 0) {
                    if (validProfile.equals("es")) {
                        this.error(profile, "expected the es profile");
                        return false;
                    }
                    return true;
                }
                if (Token.kind(profile) != 41) {
                    this.error(profile, "expected a profile name");
                    return false;
                }
                String profileText = this.text(profile);
                if (validProfile.equals(profileText)) break;
                switch (profileText) {
                    case "es": {
                        this.error(profile, "only version 300, 310, and 320 support the es profile");
                        break block8;
                    }
                    case "core": {
                        this.error(profile, "only version 330, 400, 410, 420, 430, 440, 450, and 460 support the core profile");
                        break block8;
                    }
                }
                this.error(profile, "unsupported profile");
                break;
            }
            case "extension": {
                String behaviorText;
                long extension = this.nextPpToken();
                if (Token.kind(extension) != 41) {
                    this.error(extension, "expected an extension name");
                    return false;
                }
                long colon = this.nextPpToken();
                if (Token.kind(colon) != 57) {
                    this.error(colon, "expected ':'");
                    return false;
                }
                long behavior = this.nextPpToken();
                switch (behaviorText = this.text(behavior)) {
                    case "disable": 
                    case "require": 
                    case "enable": 
                    case "warn": {
                        break;
                    }
                    default: {
                        this.error(behavior, "unsupported behavior");
                        return false;
                    }
                }
                if (!this.mIncludes.isEmpty()) {
                    this.mCompiler.getContext().error(this.rangeFrom(hash), "extension directive must appear before any include directive");
                }
                if (this.mExtensions == null) {
                    this.mExtensions = new LinkedHashMap();
                }
                this.mExtensions.put(this.text(extension), behaviorText);
                break;
            }
            case "include": 
            case "import": {
                long left = this.nextPpToken();
                if (Token.kind(left) == 3) {
                    int offset = Token.offset(left);
                    int length = Token.length(left);
                    String file = this.text(offset + 1, length - 2);
                    this.mIncludes.add(Map.entry(file, Boolean.FALSE));
                    break;
                }
                if (Token.kind(left) == 52) {
                    long right;
                    block46: while (true) {
                        right = this.nextPpToken();
                        switch (Token.kind(right)) {
                            case 0: 
                            case 88: {
                                this.error(right, "expected right angle bracket");
                                return false;
                            }
                            case 53: {
                                break block46;
                            }
                            default: {
                                continue block46;
                            }
                        }
                        break;
                    }
                    int offset = Token.offset(left);
                    String file = this.text(offset + 1, Token.offset(right) - offset - 1);
                    this.mIncludes.add(Map.entry(file, Boolean.TRUE));
                    break;
                }
                this.error(left, "expected quoted string or angle-bracketed string");
                return false;
            }
            default: {
                this.mCompiler.getContext().error(this.rangeFrom(hash), "unsupported directive '" + text + "'");
            }
            case "pragma": {
                while (true) {
                    long token = this.nextPpToken();
                    switch (Token.kind(token)) {
                        case 0: 
                        case 88: {
                            return true;
                        }
                    }
                }
            }
        }
        long end = this.nextPpToken();
        return switch (Token.kind(end)) {
            case 0, 88 -> true;
            default -> {
                this.error(end, "a directive must end with newline");
                yield false;
            }
        };
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void CompilationUnit() {
        if (this.mSourceLength > 0x7FFFFE) {
            this.mCompiler.getContext().error(-1, "source code is too long, " + this.mSourceLength + " > 8,388,606 chars");
            return;
        }
        boolean beforeDeclaration = true;
        block8: while (true) {
            switch (Token.kind(this.peek())) {
                case 0: {
                    return;
                }
                case 92: {
                    this.error(this.peek(), "invalid token");
                    return;
                }
                case 42: {
                    this.error(this.peek(), "directive must appear before any declaration");
                    return;
                }
                case 36: {
                    this.UsingDirective(beforeDeclaration);
                    continue block8;
                }
            }
            beforeDeclaration = false;
            if (!this.GlobalDeclaration()) return;
            continue;
            break;
        }
        catch (FatalError e) {
            return;
        }
    }

    private void UsingDirective(boolean beforeDeclaration) {
        Type type;
        long start = this.nextRawToken();
        if (!beforeDeclaration) {
            this.error(start, "'using' directive must appear before any other declaration");
        }
        long left = this.expectIdentifier();
        this.expect(51, "'='");
        long right = this.expect(41, "a type name");
        Context context = this.mCompiler.getContext();
        String name = this.text(right);
        Symbol symbol = context.getSymbolTable().find(name);
        if (symbol instanceof Type) {
            Type existing;
            type = existing = (Type)symbol;
        } else {
            this.error(right, "no type named '" + name + "'");
            type = context.getTypes().mPoison;
        }
        this.expect(87, "';'");
        context.getSymbolTable().insert(context, Type.makeAliasType(this.position(left), this.text(left), type.resolve()));
    }

    private boolean GlobalDeclaration() {
        long start = this.peek();
        if (Token.kind(start) == 87) {
            this.nextToken();
            return true;
        }
        Modifiers modifiers = this.Modifiers();
        long peek = this.peek();
        if (Token.kind(peek) == 41 && !this.mCompiler.getContext().getSymbolTable().isType(this.text(peek))) {
            return this.InterfaceBlock(modifiers);
        }
        if (Token.kind(peek) == 87) {
            this.nextToken();
            return true;
        }
        if (Token.kind(peek) == 35) {
            Type type = this.StructDeclaration();
            if (type != null) {
                long name = this.checkIdentifier();
                if (name != -1L) {
                    this.GlobalVarDeclarationRest(this.rangeFrom(name), modifiers, type, name);
                } else {
                    this.expect(87, "';' to complete structure definition");
                }
            }
            return true;
        }
        Type type = this.TypeSpecifier(modifiers);
        if (type == null) {
            return false;
        }
        long name = this.expectIdentifier();
        if (this.checkNext(43)) {
            return this.FunctionDeclarationRest(this.position(start), modifiers, type, name);
        }
        this.GlobalVarDeclarationRest(this.position(start), modifiers, type, name);
        return true;
    }

    @Nullable
    private Expression Initializer(Type type) {
        if (this.peek(45)) {
            long start = this.nextToken();
            if (type.isStruct()) {
                Type.Field[] fields = type.getFields();
                ArrayList<Expression> args = new ArrayList<Expression>(fields.length);
                for (Type.Field field : fields) {
                    Expression expr = this.Initializer(field.type());
                    if (expr == null) {
                        return null;
                    }
                    args.add(expr);
                    if (!this.checkNext(50)) break;
                }
                this.expect(46, "'}' to complete initializer list");
                int pos = this.rangeFrom(start);
                if (fields.length != args.size() || args.isEmpty()) {
                    this.mCompiler.getContext().error(pos, String.format("invalid arguments to '%s' constructor (expected %d elements, but found %d)", type, fields.length, args.size()));
                }
                return ConstructorStruct.convert(this.mCompiler.getContext(), pos, type, args);
            }
            if (type.isVector() || type.isMatrix() || type.isArray()) {
                if (type.isUnsizedArray()) {
                    ArrayList<Expression> args = new ArrayList<Expression>();
                    do {
                        Expression expr;
                        if ((expr = this.Initializer(type.getElementType())) == null) {
                            return null;
                        }
                        args.add(expr);
                    } while (this.checkNext(50) && !this.peek(46));
                    this.expect(46, "'}' to complete initializer list");
                    int pos = this.rangeFrom(start);
                    return ConstructorArray.convert(this.mCompiler.getContext(), pos, type, args);
                }
                int elements = type.isVector() ? type.getRows() : (type.isMatrix() ? type.getCols() : type.getArraySize());
                ArrayList<Expression> args = new ArrayList<Expression>(elements);
                for (int i = 0; i < elements; ++i) {
                    Expression expr = this.Initializer(type.getElementType());
                    if (expr == null) {
                        return null;
                    }
                    args.add(expr);
                    if (!this.checkNext(50)) break;
                }
                this.expect(46, "'}' to complete initializer list");
                int pos = this.rangeFrom(start);
                if (elements != args.size() || args.isEmpty()) {
                    this.mCompiler.getContext().error(pos, String.format("invalid arguments to '%s' constructor (expected %d elements, but found %d)", type, elements, args.size()));
                }
                return ConstructorCall.convert(this.mCompiler.getContext(), pos, type, args);
            }
            this.error(start, "cannot construct non-composite type '" + type + "'");
            return null;
        }
        return this.AssignmentExpression();
    }

    private boolean InterfaceBlock(@Nonnull Modifiers modifiers) {
        long name = this.expectIdentifier();
        String blockName = this.text(name);
        int pos = this.rangeFrom(modifiers.mPosition);
        if (!this.peek(45)) {
            this.error(name, "no type named '" + blockName + "'");
            return false;
        }
        this.nextToken();
        Context context = this.mCompiler.getContext();
        ArrayList<Type.Field> fields = new ArrayList<Type.Field>();
        do {
            int startPos = this.position(this.peek());
            Modifiers fieldModifiers = this.Modifiers();
            Type baseType = this.TypeSpecifier(fieldModifiers);
            if (baseType == null) {
                return false;
            }
            do {
                long fieldName = this.expectIdentifier();
                Type fieldType = this.ArraySpecifier(startPos, baseType);
                if (fieldType == null) {
                    return false;
                }
                if (this.checkNext(51)) {
                    Expression init = this.Initializer(fieldType);
                    if (init == null) {
                        return false;
                    }
                    context.error(init.mPosition, "initializers are not permitted in interface blocks");
                }
                fields.add(new Type.Field(this.rangeFrom(startPos), fieldModifiers, fieldType, this.text(fieldName)));
            } while (this.checkNext(50));
            this.expect(87, "';' to complete member declaration");
        } while (!this.checkNext(46));
        Type type = Type.makeStructType(context, pos, blockName, fields, true);
        context.getSymbolTable().insert(context, type);
        long instanceName = this.checkIdentifier();
        String instanceNameText = "";
        if (instanceName != -1L) {
            instanceNameText = this.text(instanceName);
            if ((type = this.ArraySpecifier(pos, type)) == null) {
                return false;
            }
        }
        this.expect(87, "';' to complete interface block");
        InterfaceBlock block = InterfaceBlock.convert(context, pos, modifiers, type, instanceNameText);
        if (block != null) {
            this.mUniqueElements.add(block);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean FunctionDeclarationRest(int start, Modifiers modifiers, Type returnType, long name) {
        ArrayList<Variable> parameters = new ArrayList<Variable>();
        if (!this.peek(44)) {
            if (this.peek(41) && "void".equals(this.text(this.peek()))) {
                this.nextToken();
            } else {
                do {
                    Variable parameter;
                    if ((parameter = this.Parameter()) == null) {
                        return false;
                    }
                    parameters.add(parameter);
                } while (this.checkNext(50));
            }
        }
        this.expect(44, "')' to complete parameter list");
        FunctionDecl decl = FunctionDecl.convert(this.mCompiler.getContext(), this.rangeFrom(start), modifiers, this.text(name), parameters, returnType);
        Context context = this.mCompiler.getContext();
        if (this.peek(87)) {
            this.nextToken();
            if (decl == null) {
                return false;
            }
            this.mUniqueElements.add(new FunctionPrototype(decl.mPosition, decl, context.isBuiltin()));
            return true;
        }
        this.mCompiler.getContext().enterScope();
        try {
            if (decl != null) {
                for (Variable param : decl.getParameters()) {
                    context.getSymbolTable().insert(this.mCompiler.getContext(), param);
                }
            }
            long blockStart = this.peek();
            BlockStatement block = this.ScopedBlock();
            if (decl == null) {
                boolean bl = false;
                return bl;
            }
            int pos = this.rangeFrom(blockStart);
            FunctionDefinition function = FunctionDefinition.convert(this.mCompiler.getContext(), pos, decl, false, block);
            if (function == null) {
                boolean bl = false;
                return bl;
            }
            decl.setDefinition(function);
            this.mUniqueElements.add(function);
            boolean bl = true;
            return bl;
        }
        finally {
            this.mCompiler.getContext().leaveScope();
        }
    }

    @Nullable
    private Variable Parameter() {
        int pos = this.position(this.peek());
        Modifiers modifiers = this.Modifiers();
        Type type = this.TypeSpecifier(modifiers);
        if (type == null) {
            return null;
        }
        long name = this.checkIdentifier();
        String nameText = "";
        if (name != -1L) {
            nameText = this.text(name);
            if ((type = this.ArraySpecifier(pos, type)) == null) {
                return null;
            }
        }
        return Variable.convert(this.mCompiler.getContext(), this.rangeFrom(pos), modifiers, type, nameText, (byte)2);
    }

    private BlockStatement ScopedBlock() {
        long start = this.expect(45, "'{'");
        ArrayList<Statement> statements = new ArrayList<Statement>();
        while (true) {
            if (this.checkNext(46)) {
                int pos = this.rangeFrom(start);
                return BlockStatement.makeBlock(pos, statements);
            }
            if (this.peek(0)) {
                this.error(this.peek(), "expected '}', but found end of file");
                return null;
            }
            Statement statement = this.Statement();
            if (statement == null) continue;
            statements.add(statement);
        }
    }

    private void GlobalVarDeclarationRest(int pos, Modifiers modifiers, Type baseType, long name) {
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else {
                name = this.expectIdentifier();
            }
            Type type = this.ArraySpecifier(pos, baseType);
            if (type == null) {
                return;
            }
            Expression init = null;
            if (this.checkNext(51) && (init = this.Initializer(type)) == null) {
                return;
            }
            VariableDecl variableDecl = VariableDecl.convert(this.mCompiler.getContext(), this.rangeFrom(pos), modifiers, type, this.text(name), (byte)1, init);
            if (variableDecl == null) continue;
            this.mUniqueElements.add(new GlobalVariableDecl(variableDecl));
        } while (this.checkNext(50));
        this.expect(87, "';' to complete global variable declaration");
    }

    @Nullable
    private Expression operatorRight(Expression left, Operator op, @Nonnull Function<Parser, Expression> rightFn) {
        this.nextToken();
        Expression right = rightFn.apply(this);
        if (right == null) {
            return null;
        }
        int pos = Position.range(left.getStartOffset(), right.getEndOffset());
        Expression result = BinaryExpression.convert(this.mCompiler.getContext(), pos, left, op, right);
        if (result != null) {
            return result;
        }
        return Poison.make(this.mCompiler.getContext(), pos);
    }

    @Nullable
    private Expression Expression() {
        Expression result = this.AssignmentExpression();
        if (result == null) {
            return null;
        }
        while (this.peek(50)) {
            if ((result = this.operatorRight(result, Operator.COMMA, Parser::AssignmentExpression)) != null) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private Expression AssignmentExpression() {
        Expression result;
        block15: {
            Operator op;
            result = this.ConditionalExpression();
            if (result == null) {
                return null;
            }
            do {
                switch (Token.kind(this.peek())) {
                    case 51: {
                        Operator operator = Operator.ASSIGN;
                        break;
                    }
                    case 77: {
                        Operator operator = Operator.ADD_ASSIGN;
                        break;
                    }
                    case 78: {
                        Operator operator = Operator.SUB_ASSIGN;
                        break;
                    }
                    case 79: {
                        Operator operator = Operator.MUL_ASSIGN;
                        break;
                    }
                    case 80: {
                        Operator operator = Operator.DIV_ASSIGN;
                        break;
                    }
                    case 81: {
                        Operator operator = Operator.MOD_ASSIGN;
                        break;
                    }
                    case 82: {
                        Operator operator = Operator.SHL_ASSIGN;
                        break;
                    }
                    case 83: {
                        Operator operator = Operator.SHR_ASSIGN;
                        break;
                    }
                    case 84: {
                        Operator operator = Operator.AND_ASSIGN;
                        break;
                    }
                    case 85: {
                        Operator operator = Operator.OR_ASSIGN;
                        break;
                    }
                    case 86: {
                        Operator operator = Operator.XOR_ASSIGN;
                        break;
                    }
                    default: {
                        Operator operator = op = null;
                    }
                }
                if (op == null) break block15;
            } while ((result = this.operatorRight(result, op, Parser::AssignmentExpression)) != null);
            return null;
        }
        return result;
    }

    @Nonnull
    private Expression expressionOrPoison(int pos, @Nullable Expression expr) {
        if (expr == null) {
            expr = Poison.make(this.mCompiler.getContext(), pos);
        }
        return expr;
    }

    @Nullable
    private Expression ConditionalExpression() {
        Expression base = this.LogicalOrExpression();
        if (base == null) {
            return null;
        }
        if (!this.peek(56)) {
            return base;
        }
        this.nextToken();
        Expression whenTrue = this.Expression();
        if (whenTrue == null) {
            return null;
        }
        this.expect(57, "':'");
        Expression whenFalse = this.AssignmentExpression();
        if (whenFalse == null) {
            return null;
        }
        int pos = Position.range(base.getStartOffset(), whenFalse.getEndOffset());
        return this.expressionOrPoison(pos, ConditionalExpression.convert(this.mCompiler.getContext(), pos, base, whenTrue, whenFalse));
    }

    @Nullable
    private Expression LogicalOrExpression() {
        Expression result = this.LogicalXorExpression();
        if (result == null) {
            return null;
        }
        while (this.peek(72)) {
            if ((result = this.operatorRight(result, Operator.LOGICAL_OR, Parser::LogicalXorExpression)) != null) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private Expression LogicalXorExpression() {
        Expression result = this.LogicalAndExpression();
        if (result == null) {
            return null;
        }
        while (this.peek(73)) {
            if ((result = this.operatorRight(result, Operator.LOGICAL_XOR, Parser::LogicalAndExpression)) != null) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private Expression LogicalAndExpression() {
        Expression result = this.BitwiseOrExpression();
        if (result == null) {
            return null;
        }
        while (this.peek(71)) {
            if ((result = this.operatorRight(result, Operator.LOGICAL_AND, Parser::BitwiseOrExpression)) != null) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private Expression BitwiseOrExpression() {
        Expression result = this.BitwiseXorExpression();
        if (result == null) {
            return null;
        }
        while (this.peek(75)) {
            if ((result = this.operatorRight(result, Operator.BITWISE_OR, Parser::BitwiseXorExpression)) != null) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private Expression BitwiseXorExpression() {
        Expression result = this.BitwiseAndExpression();
        if (result == null) {
            return null;
        }
        while (this.peek(76)) {
            if ((result = this.operatorRight(result, Operator.BITWISE_XOR, Parser::BitwiseAndExpression)) != null) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private Expression BitwiseAndExpression() {
        Expression result = this.EqualityExpression();
        if (result == null) {
            return null;
        }
        while (this.peek(74)) {
            if ((result = this.operatorRight(result, Operator.BITWISE_AND, Parser::EqualityExpression)) != null) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private Expression EqualityExpression() {
        Expression result;
        block6: {
            Operator op;
            result = this.RelationalExpression();
            if (result == null) {
                return null;
            }
            do {
                switch (Token.kind(this.peek())) {
                    case 58: {
                        Operator operator = Operator.EQ;
                        break;
                    }
                    case 61: {
                        Operator operator = Operator.NE;
                        break;
                    }
                    default: {
                        Operator operator = op = null;
                    }
                }
                if (op == null) break block6;
            } while ((result = this.operatorRight(result, op, Parser::RelationalExpression)) != null);
            return null;
        }
        return result;
    }

    @Nullable
    private Expression RelationalExpression() {
        Expression result;
        block8: {
            Operator op;
            result = this.ShiftExpression();
            if (result == null) {
                return null;
            }
            do {
                switch (Token.kind(this.peek())) {
                    case 52: {
                        Operator operator = Operator.LT;
                        break;
                    }
                    case 53: {
                        Operator operator = Operator.GT;
                        break;
                    }
                    case 59: {
                        Operator operator = Operator.LE;
                        break;
                    }
                    case 60: {
                        Operator operator = Operator.GE;
                        break;
                    }
                    default: {
                        Operator operator = op = null;
                    }
                }
                if (op == null) break block8;
            } while ((result = this.operatorRight(result, op, Parser::ShiftExpression)) != null);
            return null;
        }
        return result;
    }

    @Nullable
    private Expression ShiftExpression() {
        Expression result;
        block6: {
            Operator op;
            result = this.AdditiveExpression();
            if (result == null) {
                return null;
            }
            do {
                switch (Token.kind(this.peek())) {
                    case 69: {
                        Operator operator = Operator.SHL;
                        break;
                    }
                    case 70: {
                        Operator operator = Operator.SHR;
                        break;
                    }
                    default: {
                        Operator operator = op = null;
                    }
                }
                if (op == null) break block6;
            } while ((result = this.operatorRight(result, op, Parser::AdditiveExpression)) != null);
            return null;
        }
        return result;
    }

    @Nullable
    private Expression AdditiveExpression() {
        Expression result;
        block6: {
            Operator op;
            result = this.MultiplicativeExpression();
            if (result == null) {
                return null;
            }
            do {
                switch (Token.kind(this.peek())) {
                    case 64: {
                        Operator operator = Operator.ADD;
                        break;
                    }
                    case 65: {
                        Operator operator = Operator.SUB;
                        break;
                    }
                    default: {
                        Operator operator = op = null;
                    }
                }
                if (op == null) break block6;
            } while ((result = this.operatorRight(result, op, Parser::MultiplicativeExpression)) != null);
            return null;
        }
        return result;
    }

    @Nullable
    private Expression MultiplicativeExpression() {
        Expression result;
        block7: {
            Operator op;
            result = this.UnaryExpression();
            if (result == null) {
                return null;
            }
            do {
                switch (Token.kind(this.peek())) {
                    case 66: {
                        Operator operator = Operator.MUL;
                        break;
                    }
                    case 67: {
                        Operator operator = Operator.DIV;
                        break;
                    }
                    case 68: {
                        Operator operator = Operator.MOD;
                        break;
                    }
                    default: {
                        Operator operator = op = null;
                    }
                }
                if (op == null) break block7;
            } while ((result = this.operatorRight(result, op, Parser::UnaryExpression)) != null);
            return null;
        }
        return result;
    }

    @Nullable
    private Expression UnaryExpression() {
        Operator op;
        long prefix = this.peek();
        switch (Token.kind(prefix)) {
            case 62: {
                Operator operator = Operator.INC;
                break;
            }
            case 63: {
                Operator operator = Operator.DEC;
                break;
            }
            case 64: {
                Operator operator = Operator.ADD;
                break;
            }
            case 65: {
                Operator operator = Operator.SUB;
                break;
            }
            case 54: {
                Operator operator = Operator.LOGICAL_NOT;
                break;
            }
            case 55: {
                Operator operator = Operator.BITWISE_NOT;
                break;
            }
            default: {
                Operator operator = op = null;
            }
        }
        if (op != null) {
            this.nextToken();
            Expression base = this.UnaryExpression();
            if (base == null) {
                return null;
            }
            int pos = Position.range(Token.offset(prefix), base.getEndOffset());
            return this.expressionOrPoison(pos, PrefixExpression.convert(this.mCompiler.getContext(), pos, op, base));
        }
        return this.PostfixExpression();
    }

    @Nullable
    private Expression PostfixExpression() {
        Expression result = this.PrimaryExpression();
        if (result == null) {
            return null;
        }
        block6: while (true) {
            long t2 = this.peek();
            switch (Token.kind(t2)) {
                case 47: {
                    this.nextToken();
                    Expression index = null;
                    if (!this.peek(48) && (index = this.Expression()) == null) {
                        return null;
                    }
                    this.expect(48, "']' to complete array specifier");
                    int pos = this.rangeFrom(result.mPosition);
                    result = this.expressionOrPoison(pos, IndexExpression.convert(this.mCompiler.getContext(), pos, result, index));
                    continue block6;
                }
                case 49: {
                    this.nextToken();
                    long name = this.expect(41, "identifier");
                    String text = this.text(name);
                    int pos = this.rangeFrom(result.mPosition);
                    int namePos = this.rangeFrom(name);
                    result = this.expressionOrPoison(pos, FieldAccess.convert(this.mCompiler.getContext(), pos, result, namePos, text));
                    continue block6;
                }
                case 43: {
                    this.nextToken();
                    ArrayList<Expression> args = new ArrayList<Expression>();
                    if (!this.peek(44)) {
                        if (this.peek(41) && "void".equals(this.text(this.peek()))) {
                            this.nextToken();
                        } else {
                            do {
                                Expression expr;
                                if ((expr = this.AssignmentExpression()) == null) {
                                    return null;
                                }
                                args.add(expr);
                            } while (this.checkNext(50));
                        }
                    }
                    this.expect(44, "')' to complete invocation");
                    int pos = this.rangeFrom(result.mPosition);
                    result = this.expressionOrPoison(pos, FunctionCall.convert(this.mCompiler.getContext(), pos, result, args));
                    continue block6;
                }
                case 62: 
                case 63: {
                    this.nextToken();
                    Operator op = Token.kind(t2) == 62 ? Operator.INC : Operator.DEC;
                    int pos = this.rangeFrom(result.mPosition);
                    result = this.expressionOrPoison(pos, PostfixExpression.convert(this.mCompiler.getContext(), pos, result, op));
                    continue block6;
                }
            }
            break;
        }
        return result;
    }

    @Nullable
    private Expression PrimaryExpression() {
        long t2 = this.peek();
        return switch (Token.kind(t2)) {
            case 41 -> {
                this.nextToken();
                yield this.mCompiler.getContext().convertIdentifier(this.position(t2), this.text(t2));
            }
            case 1 -> this.IntLiteral();
            case 2 -> this.FloatLiteral();
            case 3 -> {
                this.nextToken();
                this.error(t2, "string literal '" + this.text(t2) + "' is not permitted");
                yield null;
            }
            case 4, 5 -> this.BooleanLiteral();
            case 43 -> {
                this.nextToken();
                Expression result = this.Expression();
                if (result != null) {
                    this.expect(44, "')' to complete expression");
                    result.mPosition = this.rangeFrom(t2);
                    yield result;
                }
                yield null;
            }
            default -> {
                this.nextToken();
                this.error(t2, "expected identifier, literal constant or parenthesized expression, but found '" + this.text(t2) + "'");
                throw new FatalError();
            }
        };
    }

    @Nullable
    private Literal IntLiteral() {
        long token = this.expect(1, "integer literal");
        String s = this.text(token);
        if (s.endsWith("u") || s.endsWith("U")) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            long value = Long.decode(s);
            if (value <= 0xFFFFFFFFL) {
                return Literal.makeInteger(this.mCompiler.getContext(), this.position(token), value);
            }
            this.error(token, "integer value is too large: " + s);
            return null;
        }
        catch (NumberFormatException e) {
            this.error(token, "invalid integer value: " + e.getMessage());
            return null;
        }
    }

    @Nullable
    private Literal FloatLiteral() {
        long token = this.expect(2, "float literal");
        String s = this.text(token);
        try {
            float value = Float.parseFloat(s);
            if (Float.isFinite(value)) {
                return Literal.makeFloat(this.mCompiler.getContext(), this.position(token), value);
            }
            this.error(token, "floating-point value is too large: " + s);
            return null;
        }
        catch (NumberFormatException e) {
            this.error(token, "invalid floating-point value: " + e.getMessage());
            return null;
        }
    }

    @Nullable
    private Literal BooleanLiteral() {
        long token = this.nextToken();
        return switch (Token.kind(token)) {
            case 4 -> Literal.makeBoolean(this.mCompiler.getContext(), this.position(token), true);
            case 5 -> Literal.makeBoolean(this.mCompiler.getContext(), this.position(token), false);
            default -> {
                this.error(token, "expected 'true' or 'false', but found '" + this.text(token) + "'");
                yield null;
            }
        };
    }

    @Nonnull
    private Modifiers Modifiers() {
        long start = this.peek();
        Modifiers modifiers = new Modifiers(-1);
        if (this.checkNext(34)) {
            this.Layout(modifiers);
        }
        while (true) {
            int mask;
            switch (Token.kind(this.peek())) {
                case 25: {
                    int n2 = 1;
                    break;
                }
                case 26: {
                    int n2 = 2;
                    break;
                }
                case 27: {
                    int n2 = 4;
                    break;
                }
                case 21: {
                    int n2 = 8;
                    break;
                }
                case 22: {
                    int n2 = 16;
                    break;
                }
                case 18: {
                    int n2 = 32;
                    break;
                }
                case 19: {
                    int n2 = 64;
                    break;
                }
                case 20: {
                    int n2 = 96;
                    break;
                }
                case 28: {
                    int n2 = 128;
                    break;
                }
                case 29: {
                    int n2 = 256;
                    break;
                }
                case 30: {
                    int n2 = 512;
                    break;
                }
                case 31: {
                    int n2 = 1024;
                    break;
                }
                case 32: {
                    int n2 = 2048;
                    break;
                }
                case 23: {
                    int n2 = 4096;
                    break;
                }
                case 24: {
                    int n2 = 8192;
                    break;
                }
                case 33: {
                    int n2 = 16384;
                    break;
                }
                case 39: {
                    int n2 = 32768;
                    break;
                }
                case 37: {
                    int n2 = 65536;
                    break;
                }
                case 38: {
                    int n2 = 131072;
                    break;
                }
                default: {
                    int n2 = mask = 0;
                }
            }
            if (mask == 0) break;
            long token = this.nextToken();
            modifiers.setFlag(this.mCompiler.getContext(), mask, this.position(token));
        }
        modifiers.mPosition = this.rangeFrom(start);
        return modifiers;
    }

    private void Layout(Modifiers modifiers) {
        this.expect(43, "'('");
        do {
            int mask;
            long name = this.expect(41, "identifier");
            String text = this.text(name);
            int pos = this.position(name);
            switch (text) {
                case "origin_upper_left": {
                    int n2 = 1;
                    break;
                }
                case "pixel_center_integer": {
                    int n2 = 2;
                    break;
                }
                case "early_fragment_tests": {
                    int n2 = 4;
                    break;
                }
                case "blend_support_all_equations": {
                    int n2 = 8;
                    break;
                }
                case "push_constant": {
                    int n2 = 16;
                    break;
                }
                case "std140": {
                    int n2 = 32;
                    break;
                }
                case "std430": {
                    int n2 = 64;
                    break;
                }
                case "location": {
                    int n2 = 128;
                    break;
                }
                case "component": {
                    int n2 = 256;
                    break;
                }
                case "index": {
                    int n2 = 512;
                    break;
                }
                case "binding": {
                    int n2 = 1024;
                    break;
                }
                case "offset": {
                    int n2 = 2048;
                    break;
                }
                case "set": {
                    int n2 = 4096;
                    break;
                }
                case "input_attachment_index": {
                    int n2 = 8192;
                    break;
                }
                case "builtin": {
                    int n2 = 16384;
                    break;
                }
                default: {
                    int n2 = mask = 0;
                }
            }
            if (mask != 0) {
                modifiers.setLayoutFlag(this.mCompiler.getContext(), mask, text, pos);
                Layout layout = modifiers.layout();
                switch (mask) {
                    case 128: {
                        layout.mLocation = this.LayoutInt();
                        break;
                    }
                    case 256: {
                        layout.mComponent = this.LayoutInt();
                        break;
                    }
                    case 512: {
                        layout.mIndex = this.LayoutInt();
                        break;
                    }
                    case 1024: {
                        layout.mBinding = this.LayoutInt();
                        break;
                    }
                    case 2048: {
                        layout.mOffset = this.LayoutInt();
                        break;
                    }
                    case 4096: {
                        layout.mSet = this.LayoutInt();
                        break;
                    }
                    case 8192: {
                        layout.mInputAttachmentIndex = this.LayoutInt();
                        break;
                    }
                    case 16384: {
                        layout.mBuiltin = this.LayoutBuiltin();
                    }
                }
                continue;
            }
            int builtin = Parser.findBuiltinValue(text);
            if (builtin != -1) {
                modifiers.setLayoutFlag(this.mCompiler.getContext(), 16384, text, pos);
                modifiers.layout().mBuiltin = builtin;
                continue;
            }
            this.warning(name, "unrecognized layout qualifier '" + text + "'");
            if (!this.checkNext(51)) continue;
            this.nextToken();
        } while (this.checkNext(50));
        this.expect(44, "')'");
    }

    private int LayoutInt() {
        this.expect(51, "'='");
        long token = this.expect(1, "integer literal");
        return this.LayoutIntValue(token);
    }

    private int LayoutBuiltin() {
        this.expect(51, "'='");
        if (this.peek(1)) {
            long token = this.nextToken();
            return this.LayoutIntValue(token);
        }
        long name = this.expectIdentifier();
        String text = this.text(name);
        int builtin = Parser.findBuiltinValue(text);
        if (builtin == -1) {
            this.error(name, "unrecognized built-in name '" + text + "'");
        }
        return builtin;
    }

    private int LayoutIntValue(long token) {
        String s = this.text(token);
        if (s.endsWith("u") || s.endsWith("U")) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            long value = Long.decode(s);
            if (value <= Integer.MAX_VALUE) {
                return (int)value;
            }
            this.error(token, "integer value is too large: " + s);
            return -1;
        }
        catch (NumberFormatException e) {
            this.error(token, "invalid integer value: " + e.getMessage());
            return -1;
        }
    }

    private static int findBuiltinValue(@Nonnull String text) {
        return switch (text) {
            case "position" -> 0;
            case "vertex_id" -> 5;
            case "instance_id" -> 6;
            case "vertex_index" -> 42;
            case "instance_index" -> 43;
            case "frag_coord" -> 15;
            case "front_facing" -> 17;
            case "sample_mask" -> 20;
            case "frag_depth" -> 22;
            case "num_workgroups" -> 24;
            case "workgroup_id" -> 26;
            case "local_invocation_id" -> 27;
            case "global_invocation_id" -> 28;
            case "local_invocation_index" -> 29;
            default -> -1;
        };
    }

    @Nullable
    private Type TypeSpecifier(Modifiers modifiers) {
        long start = this.expect(41, "a type name");
        String name = this.text(start);
        Symbol symbol = this.mCompiler.getContext().getSymbolTable().find(name);
        if (symbol == null) {
            this.error(start, "no type named '" + name + "'");
            return this.mCompiler.getContext().getTypes().mPoison;
        }
        if (!(symbol instanceof Type)) {
            this.error(start, "symbol '" + name + "' is not a type");
            return this.mCompiler.getContext().getTypes().mPoison;
        }
        Type result = (Type)symbol;
        if (result.isInterfaceBlock()) {
            this.error(start, "expected a type, found interface block '" + name + "'");
            return this.mCompiler.getContext().getTypes().mInvalid;
        }
        result = this.ArraySpecifier(this.position(start), result);
        return result;
    }

    @Nullable
    private Type ArraySpecifier(int startPos, Type type) {
        Context context = this.mCompiler.getContext();
        while (this.peek(47)) {
            this.nextToken();
            Expression size = null;
            if (!this.peek(48) && (size = this.Expression()) == null) {
                return null;
            }
            this.expect(48, "']' to complete array specifier");
            int pos = this.rangeFrom(startPos);
            int arraySize = size != null ? type.convertArraySize(this.mCompiler.getContext(), pos, size) : (!type.isUsableInArray(this.mCompiler.getContext(), pos) ? 0 : -1);
            if (arraySize == 0) {
                type = context.getTypes().mPoison;
                continue;
            }
            type = context.getSymbolTable().getArrayType(type, arraySize);
        }
        return type;
    }

    @Nullable
    private Statement VarDeclarationRest(int pos, Modifiers modifiers, Type baseType) {
        long name = this.expectIdentifier();
        Type type = this.ArraySpecifier(pos, baseType);
        if (type == null) {
            return null;
        }
        Expression init = null;
        if (this.checkNext(51) && (init = this.Initializer(type)) == null) {
            return null;
        }
        Statement result = VariableDecl.convert(this.mCompiler.getContext(), this.rangeFrom(name), modifiers, type, this.text(name), (byte)0, init);
        while (this.checkNext(50)) {
            name = this.expectIdentifier();
            type = this.ArraySpecifier(pos, baseType);
            if (type == null) break;
            init = null;
            if (this.checkNext(51) && (init = this.Initializer(type)) == null) break;
            VariableDecl next = VariableDecl.convert(this.mCompiler.getContext(), this.rangeFrom(name), modifiers, type, this.text(name), (byte)0, init);
            result = BlockStatement.makeCompound(result, next);
        }
        this.expect(87, "';' to complete local variable declaration");
        pos = this.rangeFrom(pos);
        return this.statementOrEmpty(pos, result);
    }

    @Nullable
    private Statement VarDeclarationOrExpressionStatement() {
        long peek = this.peek();
        if (Token.kind(peek) == 21) {
            int pos = this.position(peek);
            Modifiers modifiers = this.Modifiers();
            Type type = this.TypeSpecifier(modifiers);
            if (type == null) {
                return null;
            }
            return this.VarDeclarationRest(pos, modifiers, type);
        }
        if (this.mCompiler.getContext().getSymbolTable().isType(this.text(peek))) {
            int pos = this.position(peek);
            Modifiers modifiers = new Modifiers(pos);
            Type type = this.TypeSpecifier(modifiers);
            if (type == null) {
                return null;
            }
            return this.VarDeclarationRest(pos, modifiers, type);
        }
        return this.ExpressionStatement();
    }

    @Nullable
    private Statement ExpressionStatement() {
        Expression expr = this.Expression();
        if (expr == null) {
            return null;
        }
        this.expect(87, "';' to complete expression statement");
        int pos = expr.mPosition;
        return this.statementOrEmpty(pos, ExpressionStatement.convert(this.mCompiler.getContext(), expr));
    }

    private Type StructDeclaration() {
        long start = this.peek();
        this.expect(35, "'struct'");
        long typeName = this.expectIdentifier();
        this.expect(45, "'{'");
        Context context = this.mCompiler.getContext();
        ArrayList<Type.Field> fields = new ArrayList<Type.Field>();
        do {
            int startPos = this.position(this.peek());
            Modifiers fieldModifiers = this.Modifiers();
            Type baseType = this.TypeSpecifier(fieldModifiers);
            if (baseType == null) {
                return null;
            }
            do {
                long fieldName = this.expectIdentifier();
                Type fieldType = this.ArraySpecifier(startPos, baseType);
                if (fieldType == null) {
                    return null;
                }
                if (this.checkNext(51)) {
                    Expression init = this.Initializer(fieldType);
                    if (init == null) {
                        return null;
                    }
                    context.error(init.mPosition, "initializers are not permitted in structures");
                }
                fields.add(new Type.Field(this.rangeFrom(startPos), fieldModifiers, fieldType, this.text(fieldName)));
            } while (this.checkNext(50));
            this.expect(87, "';' to complete member declaration");
        } while (!this.checkNext(46));
        StructDefinition definition = StructDefinition.convert(context, this.rangeFrom(start), this.text(typeName), fields);
        if (definition == null) {
            return null;
        }
        this.mUniqueElements.add(definition);
        return definition.getType();
    }

    @Nonnull
    private Statement statementOrEmpty(int pos, @Nullable Statement stmt) {
        if (stmt == null) {
            stmt = new EmptyStatement(pos);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Statement Statement() {
        Statement statement;
        switch (Token.kind(this.peek())) {
            case 6: {
                Statement statement2;
                long start = this.nextToken();
                this.expect(87, "';' after 'break'");
                statement = statement2 = BreakStatement.make(this.rangeFrom(start));
                break;
            }
            case 7: {
                Statement statement3;
                long start = this.nextToken();
                this.expect(87, "';' after 'continue'");
                statement = statement3 = ContinueStatement.make(this.rangeFrom(start));
                break;
            }
            case 16: {
                Statement statement4;
                long start = this.nextToken();
                this.expect(87, "';' after 'discard'");
                int pos = this.rangeFrom(start);
                statement = statement4 = this.statementOrEmpty(pos, DiscardStatement.convert(this.mCompiler.getContext(), pos));
                break;
            }
            case 17: {
                Statement statement5;
                long start = this.nextToken();
                Expression expression = null;
                if (!this.peek(87) && (expression = this.Expression()) == null) {
                    Object var1_9 = null;
                    statement = var1_9;
                    break;
                }
                this.expect(87, "';' to complete return expression");
                statement = statement5 = ReturnStatement.make(this.rangeFrom(start), expression);
                break;
            }
            case 11: {
                Statement statement6;
                statement = statement6 = this.IfStatement();
                break;
            }
            case 9: {
                Statement statement7;
                statement = statement7 = this.ForStatement();
                break;
            }
            case 13: {
                Statement statement8;
                statement = statement8 = this.SwitchStatement();
                break;
            }
            case 45: {
                this.mCompiler.getContext().enterScope();
                try {
                    BlockStatement blockStatement = this.ScopedBlock();
                    statement = blockStatement;
                    break;
                }
                finally {
                    this.mCompiler.getContext().leaveScope();
                }
            }
            case 87: {
                long t2 = this.nextToken();
                EmptyStatement emptyStatement = new EmptyStatement(this.position(t2));
                statement = emptyStatement;
                break;
            }
            case 21: 
            case 41: {
                Statement statement9;
                statement = statement9 = this.VarDeclarationOrExpressionStatement();
                break;
            }
            default: {
                Statement statement10;
                statement = statement10 = this.ExpressionStatement();
            }
        }
        return statement;
    }

    @Nullable
    private Statement IfStatement() {
        long start = this.expect(11, "'if'");
        this.expect(43, "'('");
        Expression test = this.Expression();
        if (test == null) {
            return null;
        }
        this.expect(44, "')'");
        Statement whenTrue = this.Statement();
        if (whenTrue == null) {
            return null;
        }
        Statement whenFalse = null;
        if (this.checkNext(12) && (whenFalse = this.Statement()) == null) {
            return null;
        }
        int pos = this.rangeFrom(start);
        return this.statementOrEmpty(pos, IfStatement.convert(this.mCompiler.getContext(), pos, test, whenTrue, whenFalse));
    }

    private boolean SwitchCaseBody(List<Expression> values, List<Statement> caseBlocks, Expression caseValue) {
        this.expect(57, "':'");
        ArrayList<Statement> statements = new ArrayList<Statement>();
        while (!(this.peek(46) || this.peek(14) || this.peek(15))) {
            Statement s = this.Statement();
            if (s == null) {
                return false;
            }
            statements.add(s);
        }
        values.add(caseValue);
        caseBlocks.add(BlockStatement.make(-1, statements, false));
        return true;
    }

    private Statement SwitchStatement() {
        long start = this.expect(13, "'switch'");
        this.expect(43, "'('");
        Expression init = this.Expression();
        if (init == null) {
            return null;
        }
        this.expect(44, "')'");
        this.expect(45, "'{'");
        ArrayList<Expression> values = new ArrayList<Expression>();
        ArrayList<Statement> caseBlocks = new ArrayList<Statement>();
        while (this.checkNext(14)) {
            Expression caseValue = this.Expression();
            if (caseValue == null) {
                return null;
            }
            if (this.SwitchCaseBody(values, caseBlocks, caseValue)) continue;
            return null;
        }
        if (this.peek(15)) {
            long defaultToken = this.nextToken();
            if (!this.SwitchCaseBody(values, caseBlocks, null)) {
                return null;
            }
            if (this.peek(14)) {
                this.error(defaultToken, "'default' should be the last case");
                return null;
            }
        }
        this.expect(46, "'}'");
        int pos = this.rangeFrom(start);
        return this.statementOrEmpty(pos, SwitchStatement.convert(this.mCompiler.getContext(), pos, init, values, caseBlocks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Statement ForStatement() {
        long start = this.expect(9, "'for'");
        this.expect(43, "'('");
        this.mCompiler.getContext().enterScope();
        try {
            Statement init = null;
            if (this.peek(87)) {
                this.nextToken();
            } else {
                init = this.VarDeclarationOrExpressionStatement();
                if (init == null) {
                    Statement statement = null;
                    return statement;
                }
            }
            Expression cond = null;
            if (!this.peek(87) && (cond = this.Expression()) == null) {
                Statement statement = null;
                return statement;
            }
            this.expect(87, "';' to complete condition statement");
            Expression step = null;
            if (!this.peek(87) && (step = this.Expression()) == null) {
                Statement statement = null;
                return statement;
            }
            this.expect(44, "')' to complete 'for' statement");
            Statement statement = this.Statement();
            if (statement == null) {
                Statement statement2 = null;
                return statement2;
            }
            int pos = this.rangeFrom(start);
            Statement statement3 = this.statementOrEmpty(pos, ForLoop.convert(this.mCompiler.getContext(), pos, init, cond, step, statement));
            return statement3;
        }
        finally {
            this.mCompiler.getContext().leaveScope();
        }
    }
}

