/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler;

public final class Position {
    public static final int NO_POS = -1;
    public static final int MAX_OFFSET = 0x7FFFFF;

    public static int range(int start, int end) {
        if (start < 0 || start > end || end > 0x7FFFFF) {
            return -1;
        }
        return start | Math.min(end - start, 255) << 24;
    }

    public static int getStartOffset(int pos) {
        if (pos == -1) {
            return -1;
        }
        return pos & 0xFFFFFF;
    }

    public static int getEndOffset(int pos) {
        if (pos == -1) {
            return -1;
        }
        return (pos & 0xFFFFFF) + (pos >>> 24);
    }

    public static int getLine(int pos, char[] source) {
        if (pos == -1 || source == null) {
            return -1;
        }
        int offset = Math.min(pos & 0xFFFFFF, source.length);
        int line = 1;
        for (int i = 0; i < offset; ++i) {
            if (source[i] != '\n') continue;
            ++line;
        }
        return line;
    }

    private Position() {
    }
}

